/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.type;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCollectionTypeNameSpec;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;

public class ExtendedSqlCollectionTypeNameSpec
extends SqlCollectionTypeNameSpec {
    private final boolean elementNullable;
    private final SqlTypeName collectionTypeName;
    private final boolean unparseAsStandard;

    public ExtendedSqlCollectionTypeNameSpec(SqlTypeNameSpec elementTypeName, boolean elementNullable, SqlTypeName collectionTypeName, boolean unparseAsStandard, SqlParserPos pos) {
        super(elementTypeName, collectionTypeName, pos);
        this.elementNullable = elementNullable;
        this.collectionTypeName = collectionTypeName;
        this.unparseAsStandard = unparseAsStandard;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        RelDataType elementType = this.getElementTypeName().deriveType(validator);
        elementType = validator.getTypeFactory().createTypeWithNullability(elementType, this.elementNullable);
        return this.createCollectionType(elementType, validator.getTypeFactory());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.unparseAsStandard) {
            this.getElementTypeName().unparse(writer, leftPrec, rightPrec);
            if (!this.elementNullable) {
                writer.keyword("NOT NULL");
            }
            writer.keyword(this.collectionTypeName.name());
        } else {
            writer.keyword(this.collectionTypeName.name());
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
            this.getElementTypeName().unparse(writer, leftPrec, rightPrec);
            if (!this.elementNullable) {
                writer.keyword("NOT NULL");
            }
            writer.endList(frame);
        }
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        if (!(spec instanceof ExtendedSqlCollectionTypeNameSpec)) {
            return litmus.fail("{} != {}", this, spec);
        }
        ExtendedSqlCollectionTypeNameSpec that = (ExtendedSqlCollectionTypeNameSpec)spec;
        if (this.elementNullable != that.elementNullable) {
            return litmus.fail("{} != {}", this, spec);
        }
        return super.equalsDeep(spec, litmus);
    }

    private RelDataType createCollectionType(RelDataType elementType, RelDataTypeFactory typeFactory) {
        switch (this.collectionTypeName) {
            case MULTISET: {
                return typeFactory.createMultisetType(elementType, -1L);
            }
            case ARRAY: {
                return typeFactory.createArrayType(elementType, -1L);
            }
        }
        throw Util.unexpected(this.collectionTypeName);
    }
}

