/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.util.TimestampString;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.JoinedRow;
import org.apache.flink.table.dataformat.ObjectArrayRow;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.CurrentTimePointCallGen;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TypeInformationRawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.util.TimestampStringUtils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.BigDecimal;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class GenerateUtils$ {
    public static GenerateUtils$ MODULE$;

    static {
        new GenerateUtils$();
    }

    public GeneratedExpression generateCallIfArgsNotNull(CodeGeneratorContext ctx, LogicalType returnType, Seq<GeneratedExpression> operands, boolean resultNullable, Function1<Seq<String>, String> call) {
        return this.generateCallWithStmtIfArgsNotNull(ctx, returnType, operands, resultNullable, (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> new Tuple2((Object)"", call.apply(args)));
    }

    public boolean generateCallIfArgsNotNull$default$4() {
        return false;
    }

    public GeneratedExpression generateCallWithStmtIfArgsNotNull(CodeGeneratorContext ctx, LogicalType returnType, Seq<GeneratedExpression> operands, boolean resultNullable, Function1<Seq<String>, Tuple2<String, String>> call) {
        String resultTypeTerm = resultNullable ? CodeGenUtils$.MODULE$.boxedTypeTermForType(returnType) : CodeGenUtils$.MODULE$.primitiveTypeTermForType(returnType);
        String nullTerm = ctx.addReusableLocalVariable("boolean", "isNull");
        String resultTerm = ctx.addReusableLocalVariable(resultTypeTerm, "result");
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(returnType);
        boolean isResultNullable = resultNullable || TypeCheckUtils.isReference((LogicalType)returnType) && !TypeCheckUtils.isTemporal((LogicalType)returnType);
        String nullTermCode = ctx.nullCheck() && isResultNullable ? new StringBuilder(14).append(nullTerm).append(" = (").append(resultTerm).append(" == null);").toString() : "";
        Tuple2 tuple2 = (Tuple2)call.apply(operands.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.resultTerm(), Seq$.MODULE$.canBuildFrom()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String stmt = (String)tuple2._1();
        String result = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)stmt, (Object)result);
        Tuple2 tuple23 = tuple22;
        String stmt2 = (String)tuple23._1();
        String result2 = (String)tuple23._2();
        String resultCode = ctx.nullCheck() && operands.nonEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(126).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(nullTerm).append(" = ").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(";\n         |").append(resultTerm).append(" = ").append(defaultValue).append(";\n         |if (!").append(nullTerm).append(") {\n         |  ").append(stmt2).append("\n         |  ").append(resultTerm).append(" = ").append(result2).append(";\n         |  ").append(nullTermCode).append("\n         |}\n         |").toString())).stripMargin() : (ctx.nullCheck() && operands.isEmpty() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(79).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(nullTerm).append(" = false;\n         |").append(stmt2).append("\n         |").append(resultTerm).append(" = ").append(result2).append(";\n         |").append(nullTermCode).append("\n         |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(68).append("\n         |").append(nullTerm).append(" = false;\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(stmt2).append("\n         |").append(resultTerm).append(" = ").append(result2).append(";\n         |").toString())).stripMargin());
        return new GeneratedExpression(resultTerm, nullTerm, resultCode, returnType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateCallWithStmtIfArgsNotNull$default$4() {
        return false;
    }

    public GeneratedExpression generateStringResultCallIfArgsNotNull(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Function1<Seq<String>, String> call) {
        return this.generateCallIfArgsNotNull(ctx, (LogicalType)new VarCharType(Integer.MAX_VALUE), operands, this.generateCallIfArgsNotNull$default$4(), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> new StringBuilder(13).append(CodeGenUtils$.MODULE$.BINARY_STRING()).append(".fromString(").append(call.apply(args)).append(")").toString());
    }

    public GeneratedExpression generateStringResultCallWithStmtIfArgsNotNull(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, Function1<Seq<String>, Tuple2<String, String>> call) {
        return this.generateCallWithStmtIfArgsNotNull(ctx, (LogicalType)new VarCharType(Integer.MAX_VALUE), operands, this.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            Tuple2 tuple2 = (Tuple2)call.apply(args);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String stmt = (String)tuple2._1();
            String result = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)stmt, (Object)result);
            Tuple2 tuple23 = tuple22;
            String stmt2 = (String)tuple23._1();
            String result2 = (String)tuple23._2();
            return new Tuple2((Object)stmt2, (Object)new StringBuilder(13).append(CodeGenUtils$.MODULE$.BINARY_STRING()).append(".fromString(").append(result2).append(")").toString());
        });
    }

    public GeneratedExpression generateCallIfArgsNullable(CodeGeneratorContext ctx, LogicalType returnType, Seq<GeneratedExpression> operands, boolean resultNullable, Function1<Seq<String>, String> call) {
        String resultTypeTerm = resultNullable ? CodeGenUtils$.MODULE$.boxedTypeTermForType(returnType) : CodeGenUtils$.MODULE$.primitiveTypeTermForType(returnType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(returnType);
        String nullTerm = ctx.addReusableLocalVariable("boolean", "isNull");
        String resultTerm = ctx.addReusableLocalVariable(resultTypeTerm, "result");
        boolean isResultNullable = resultNullable || TypeCheckUtils.isReference((LogicalType)returnType) && !TypeCheckUtils.isTemporal((LogicalType)returnType);
        String nullTermCode = ctx.nullCheck() && isResultNullable ? new StringBuilder(14).append(nullTerm).append(" = (").append(resultTerm).append(" == null);").toString() : new StringBuilder(9).append(nullTerm).append(" = false;").toString();
        Seq parameters = (Seq)operands.map((Function1 & Serializable & scala.Serializable)x -> TypeCheckUtils.isCharacterString((LogicalType)x.resultType()) ? new StringBuilder(16).append("( ").append(x.nullTerm()).append(" ) ? null : (").append(x.resultTerm()).append(")").toString() : x.resultTerm(), Seq$.MODULE$.canBuildFrom());
        String resultCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTerm).append(" = ").append(call.apply((Object)parameters)).append(";\n         |").append(nullTermCode).append("\n         |if (").append(nullTerm).append(") {\n         |  ").append(resultTerm).append(" = ").append(defaultValue).append(";\n         |}\n       ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(45).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTerm).append(" = ").append(call.apply((Object)parameters)).append(";\n         |").append(nullTermCode).append("\n       ").toString())).stripMargin();
        return new GeneratedExpression(resultTerm, nullTerm, resultCode, returnType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateCallIfArgsNullable$default$4() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generateRecordStatement(LogicalType t, Class<?> clazz, String recordTerm, Option<String> recordWriterTerm) {
        boolean bl = false;
        RowType rowType = null;
        LogicalType logicalType = t;
        if (logicalType instanceof RowType) {
            bl = true;
            rowType = (RowType)logicalType;
            Class<?> clazz2 = clazz;
            Class<BinaryRow> clazz3 = BinaryRow.class;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                String writerTerm = (String)recordWriterTerm.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new CodeGenException("No writer is specified when writing BinaryRow record.");
                });
                String binaryRowWriter = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
                String typeTerm = clazz.getCanonicalName();
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(73).append("\n           |final ").append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("(").append(rowType.getFieldCount()).append(");\n           |final ").append(binaryRowWriter).append(" ").append(writerTerm).append(" = new ").append(binaryRowWriter).append("(").append(recordTerm).append(");\n           |").toString())).stripMargin().trim();
            }
        }
        if (bl && ObjectArrayRow.class.isAssignableFrom(clazz)) {
            String typeTerm = clazz.getCanonicalName();
            return new StringBuilder(17).append("final ").append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("(").append(rowType.getFieldCount()).append(");").toString();
        }
        if (bl) {
            Class<?> clazz4 = clazz;
            Class<JoinedRow> clazz5 = JoinedRow.class;
            if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                String typeTerm = clazz.getCanonicalName();
                return new StringBuilder(17).append("final ").append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("();").toString();
            }
        }
        String typeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(t);
        return new StringBuilder(17).append("final ").append(typeTerm).append(" ").append(recordTerm).append(" = new ").append(typeTerm).append("();").toString();
    }

    public Option<String> generateRecordStatement$default$4() {
        return None$.MODULE$;
    }

    public GeneratedExpression generateNullLiteral(LogicalType resultType, boolean nullCheck) {
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        if (!nullCheck) {
            throw new CodeGenException("Null literals are not allowed if nullCheck is disabled.");
        }
        return new GeneratedExpression(new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append(defaultValue).append(")").toString(), GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), resultType, (Option<Object>)new Some(null));
    }

    public GeneratedExpression generateNonNullLiteral(LogicalType literalType, String literalCode, Object literalValue) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(literalType);
        return new GeneratedExpression(new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append(literalCode).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), literalType, (Option<Object>)new Some(literalValue));
    }

    public GeneratedExpression generateLiteral(CodeGeneratorContext ctx, LogicalType literalType, Object literalValue) {
        GeneratedExpression generatedExpression;
        if (literalValue == null) {
            return this.generateNullLiteral(literalType, ctx.nullCheck());
        }
        LogicalTypeRoot logicalTypeRoot = literalType.getTypeRoot();
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            generatedExpression = this.generateNonNullLiteral(literalType, literalValue.toString(), literalValue);
        } else if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
            generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToByte((byte)decimal.byteValue())).toString(), BoxesRunTime.boxToByte((byte)decimal.byteValue()));
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
            generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToShort((short)decimal.shortValue())).toString(), BoxesRunTime.boxToShort((short)decimal.shortValue()));
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
            generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToInteger((int)decimal.intValue())).toString(), BoxesRunTime.boxToInteger((int)decimal.intValue()));
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
            generatedExpression = this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToLong((long)decimal.longValue())).toString()).append("L").toString(), BoxesRunTime.boxToLong((long)decimal.longValue()));
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            float floatValue = ((java.math.BigDecimal)literalValue).floatValue();
            float f = floatValue;
            GeneratedExpression generatedExpression2 = Float.NEGATIVE_INFINITY == f ? this.generateNonNullLiteral(literalType, "java.lang.Float.NEGATIVE_INFINITY", BoxesRunTime.boxToFloat((float)Float.NEGATIVE_INFINITY)) : (Float.POSITIVE_INFINITY == f ? this.generateNonNullLiteral(literalType, "java.lang.Float.POSITIVE_INFINITY", BoxesRunTime.boxToFloat((float)Float.POSITIVE_INFINITY)) : this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToFloat((float)floatValue)).toString()).append("f").toString(), BoxesRunTime.boxToFloat((float)floatValue)));
            generatedExpression = generatedExpression2;
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            double doubleValue = ((java.math.BigDecimal)literalValue).doubleValue();
            double d = doubleValue;
            GeneratedExpression generatedExpression3 = Double.NEGATIVE_INFINITY == d ? this.generateNonNullLiteral(literalType, "java.lang.Double.NEGATIVE_INFINITY", BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY)) : (Double.POSITIVE_INFINITY == d ? this.generateNonNullLiteral(literalType, "java.lang.Double.POSITIVE_INFINITY", BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY)) : this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToDouble((double)doubleValue)).toString()).append("d").toString(), BoxesRunTime.boxToDouble((double)doubleValue)));
            generatedExpression = generatedExpression3;
        } else if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            DecimalType dt = (DecimalType)literalType;
            int precision = dt.getPrecision();
            int scale = dt.getScale();
            String fieldTerm = CodeGenUtils$.MODULE$.newName("decimal");
            String decimalClass = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Decimal.class));
            String fieldDecimal = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(70).append("\n             |").append(decimalClass).append(" ").append(fieldTerm).append(" =\n             |    ").append(decimalClass).append(".castFrom(\"").append(literalValue.toString()).append("\", ").append(precision).append(", ").append(scale).append(");\n             |").toString())).stripMargin();
            ctx.addReusableMember(fieldDecimal);
            Decimal value = Decimal.fromBigDecimal((java.math.BigDecimal)((java.math.BigDecimal)literalValue), (int)precision, (int)scale);
            generatedExpression = value == null ? this.generateNullLiteral(literalType, ctx.nullCheck()) : this.generateNonNullLiteral(literalType, fieldTerm, value);
        } else {
            boolean bl = LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot);
            if (bl) {
                String escapedValue = StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)literalValue.toString());
                String field = ctx.addReusableStringConstants(escapedValue);
                generatedExpression = this.generateNonNullLiteral(literalType, field, BinaryString.fromString((String)escapedValue));
            } else {
                boolean bl2 = LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot);
                if (bl2) {
                    byte[] bytesVal = ((ByteString)literalValue).getBytes();
                    String fieldTerm = ctx.addReusableObject(bytesVal, "binary", bytesVal.getClass().getCanonicalName());
                    generatedExpression = this.generateNonNullLiteral(literalType, fieldTerm, bytesVal);
                } else if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
                    generatedExpression = this.generateNonNullLiteral(literalType, literalValue.toString(), literalValue);
                } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    generatedExpression = this.generateNonNullLiteral(literalType, literalValue.toString(), literalValue);
                } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
                    String fieldTerm = CodeGenUtils$.MODULE$.newName("timestamp");
                    LocalDateTime ldt = TimestampStringUtils.toLocalDateTime((TimestampString)literalValue);
                    SqlTimestamp ts = SqlTimestamp.fromLocalDateTime((LocalDateTime)ldt);
                    String fieldTimestamp = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(" ").append(fieldTerm).append(" =\n             |  ").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(ts.getMillisecond()).append("L, ").append(ts.getNanoOfMillisecond()).append(");\n           ").toString())).stripMargin();
                    ctx.addReusableMember(fieldTimestamp);
                    generatedExpression = this.generateNonNullLiteral(literalType, fieldTerm, ts);
                } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
                    String fieldTerm = CodeGenUtils$.MODULE$.newName("timestampWithLocalZone");
                    Instant ins = TimestampStringUtils.toLocalDateTime((TimestampString)literalValue).atZone(ctx.tableConfig().getLocalTimeZone()).toInstant();
                    SqlTimestamp ts = SqlTimestamp.fromInstant((Instant)ins);
                    String fieldTimestampWithLocalZone = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(69).append("\n             |").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(" ").append(fieldTerm).append(" =\n             |  ").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(ts.getMillisecond()).append("L, ").append(ts.getNanoOfMillisecond()).append(");\n           ").toString())).stripMargin();
                    ctx.addReusableMember(fieldTimestampWithLocalZone);
                    generatedExpression = this.generateNonNullLiteral(literalType, fieldTerm, literalValue);
                } else if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    if (!decimal.isValidInt()) {
                        throw new CodeGenException(new StringBuilder(54).append("Decimal '").append(decimal).append("' can not be converted to interval of months.").toString());
                    }
                    generatedExpression = this.generateNonNullLiteral(literalType, ((Object)BoxesRunTime.boxToInteger((int)decimal.intValue())).toString(), BoxesRunTime.boxToInteger((int)decimal.intValue()));
                } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
                    BigDecimal decimal = package$.MODULE$.BigDecimal().apply((java.math.BigDecimal)literalValue);
                    if (!decimal.isValidLong()) {
                        throw new CodeGenException(new StringBuilder(60).append("Decimal '").append(decimal).append("' can not be converted to interval of milliseconds.").toString());
                    }
                    generatedExpression = this.generateNonNullLiteral(literalType, new StringBuilder(1).append(((Object)BoxesRunTime.boxToLong((long)decimal.longValue())).toString()).append("L").toString(), BoxesRunTime.boxToLong((long)decimal.longValue()));
                } else if (LogicalTypeRoot.RAW.equals(logicalTypeRoot) && ((TypeInformationRawType)literalType).getTypeInformation().getTypeClass().isAssignableFrom(Enum.class)) {
                    generatedExpression = this.generateSymbol((Enum)literalValue);
                } else {
                    throw new CodeGenException(new StringBuilder(20).append("Type not supported: ").append(logicalTypeRoot).toString());
                }
            }
        }
        return generatedExpression;
    }

    public GeneratedExpression generateSymbol(Enum<?> enum_) {
        return new GeneratedExpression(CodeGenUtils$.MODULE$.qualifyEnum(enum_), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), (LogicalType)new TypeInformationRawType((TypeInformation)new GenericTypeInfo(enum_.getDeclaringClass())), (Option<Object>)new Some(enum_));
    }

    public GeneratedExpression generateNonNullField(LogicalType fieldType, String fieldTerm) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
        return new GeneratedExpression(new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append(fieldTerm).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), fieldType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateProctimeTimestamp(CodeGeneratorContext ctx, String contextTerm) {
        TimestampType resultType = new TimestampType(3);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)resultType);
        String resultTerm = ctx.addReusableLocalVariable(resultTypeTerm, "result");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(96).append("\n         |").append(resultTerm).append(" = ").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(\n         |  ").append(contextTerm).append(".timerService().currentProcessingTime());\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), resultCode, (LogicalType)resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateCurrentTimestamp(CodeGeneratorContext ctx) {
        return new CurrentTimePointCallGen(false).generate(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (LogicalType)new TimestampType(3));
    }

    public GeneratedExpression generateRowtimeAccess(CodeGeneratorContext ctx, String contextTerm) {
        TimestampType resultType = new TimestampType(true, TimestampKind.ROWTIME, 3);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)resultType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(346).append("\n         |").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(contextTerm).append(".timestamp());\n         |if (").append(resultTerm2).append(" == null) {\n         |  throw new RuntimeException(\"Rowtime timestamp is null. Please make sure that a \" +\n         |    \"proper TimestampAssigner is defined and the stream environment uses the EventTime \" +\n         |    \"time characteristic.\");\n         |}\n         |").append(nullTerm2).append(" = false;\n       ").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, (LogicalType)resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateInputAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index, boolean nullableInput, boolean deepCopy) {
        GeneratedExpression generatedExpression;
        Option<GeneratedExpression> option = ctx.getReusableInputUnboxingExprs(inputTerm, index);
        if (option instanceof Some) {
            GeneratedExpression expr;
            Some some = (Some)option;
            generatedExpression = expr = (GeneratedExpression)some.value();
        } else if (None$.MODULE$.equals(option)) {
            GeneratedExpression expr = nullableInput ? this.generateNullableInputFieldAccess(ctx, inputType, inputTerm, index, deepCopy) : this.generateFieldAccess(ctx, inputType, inputTerm, index, deepCopy);
            ctx.addReusableInputUnboxingExprs(inputTerm, index, expr);
            generatedExpression = expr;
        } else {
            throw new MatchError(option);
        }
        GeneratedExpression inputExpr = generatedExpression;
        return new GeneratedExpression(inputExpr.resultTerm(), inputExpr.nullTerm(), "", inputExpr.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateInputAccess$default$6() {
        return false;
    }

    public GeneratedExpression generateNullableInputFieldAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index, boolean deepCopy) {
        LogicalType logicalType;
        LogicalType logicalType2 = inputType;
        if (logicalType2 instanceof RowType) {
            RowType rowType = (RowType)logicalType2;
            logicalType = rowType.getTypeAt(index);
        } else {
            logicalType = inputType;
        }
        LogicalType fieldType = logicalType;
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(fieldType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        GeneratedExpression fieldAccessExpr = this.generateFieldAccess(ctx, inputType, inputTerm, index, deepCopy);
        String inputCheckCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("\n         |").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |").append(nullTerm2).append(" = true;\n         |if (").append(inputTerm).append(" != null) {\n         |  ").append(fieldAccessExpr.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(fieldAccessExpr.resultTerm()).append(";\n         |  ").append(nullTerm2).append(" = ").append(fieldAccessExpr.nullTerm()).append(";\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, inputCheckCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public boolean generateNullableInputFieldAccess$default$5() {
        return false;
    }

    public GeneratedExpression generateInputFieldUnboxing(CodeGeneratorContext ctx, LogicalType fieldType, String fieldTerm) {
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(fieldType);
        Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"result"), new Tuple2((Object)"boolean", (Object)"isNull")}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String wrappedCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("\n         |").append(nullTerm2).append(" = ").append(fieldTerm).append(" == null;\n         |").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |if (!").append(nullTerm2).append(") {\n         |  ").append(resultTerm2).append(" = ").append(fieldTerm).append(";\n         |}\n         |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(26).append("\n         |").append(resultTerm2).append(" = ").append(fieldTerm).append(";\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, wrappedCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateFieldAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index, boolean deepCopy) {
        GeneratedExpression expr = this.generateFieldAccess(ctx, inputType, inputTerm, index);
        return deepCopy ? expr.deepCopy(ctx) : expr;
    }

    public GeneratedExpression generateFieldAccess(CodeGeneratorContext ctx, LogicalType inputType, String inputTerm, int index) {
        GeneratedExpression generatedExpression;
        LogicalType logicalType = inputType;
        if (logicalType instanceof RowType) {
            RowType rowType = (RowType)logicalType;
            LogicalType fieldType = rowType.getTypeAt(index);
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(fieldType);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(fieldType);
            String readCode = CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, ((Object)BoxesRunTime.boxToInteger((int)index)).toString(), inputTerm, fieldType);
            Seq<String> seq = ctx.addReusableLocalVariables((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)resultTypeTerm, (Object)"field"), new Tuple2((Object)"boolean", (Object)"isNull")}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String fieldTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)fieldTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String fieldTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String inputCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("\n             |").append(nullTerm2).append(" = ").append(inputTerm).append(".isNullAt(").append(index).append(");\n             |").append(fieldTerm2).append(" = ").append(defaultValue).append(";\n             |if (!").append(nullTerm2).append(") {\n             |  ").append(fieldTerm2).append(" = ").append(readCode).append(";\n             |}\n           ").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n             |").append(nullTerm2).append(" = false;\n             |").append(fieldTerm2).append(" = ").append(readCode).append(";\n           ").toString())).stripMargin();
            generatedExpression = new GeneratedExpression(fieldTerm2, nullTerm2, inputCode, fieldType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            String fieldTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(inputType);
            String inputCode = new StringBuilder(3).append("(").append(fieldTypeTerm).append(") ").append(inputTerm).toString();
            generatedExpression = this.generateInputFieldUnboxing(ctx, inputType, inputCode);
        }
        return generatedExpression;
    }

    public String generateCompare(CodeGeneratorContext ctx, LogicalType t, boolean nullsIsLast, String leftTerm, String rightTerm) {
        String string;
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = new StringBuilder(24).append("(").append(leftTerm).append(" == ").append(rightTerm).append(" ? 0 : (").append(leftTerm).append(" ? 1 : -1))").toString();
        } else {
            boolean bl = LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot);
            if (bl) {
                string = new StringBuilder(24).append("(").append(leftTerm).append(" > ").append(rightTerm).append(" ? 1 : ").append(leftTerm).append(" < ").append(rightTerm).append(" ? -1 : 0)").toString();
            } else if (PlannerTypeUtils.isPrimitive((LogicalType)t)) {
                string = new StringBuilder(24).append("(").append(leftTerm).append(" > ").append(rightTerm).append(" ? 1 : ").append(leftTerm).append(" < ").append(rightTerm).append(" ? -1 : 0)").toString();
            } else {
                boolean bl2 = LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot);
                if (bl2) {
                    String sortUtil = SortUtil.class.getCanonicalName();
                    string = new StringBuilder(18).append(sortUtil).append(".compareBinary(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                } else if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                    ArrayType at = (ArrayType)t;
                    String compareFunc = CodeGenUtils$.MODULE$.newName("compareArray");
                    String compareCode = this.generateArrayCompare(ctx, SortUtil$.MODULE$.getNullDefaultOrder(true), at, "a", "b");
                    String funcCode = new StringBuilder(88).append("\n          public int ").append(compareFunc).append("(").append(CodeGenUtils$.MODULE$.BASE_ARRAY()).append(" a, ").append(CodeGenUtils$.MODULE$.BASE_ARRAY()).append(" b) {\n            ").append(compareCode).append("\n            return 0;\n          }\n        ").toString();
                    ctx.addReusableMember(funcCode);
                    string = new StringBuilder(4).append(compareFunc).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                } else if (LogicalTypeRoot.ROW.equals(logicalTypeRoot)) {
                    RowType rowType = (RowType)t;
                    boolean[] orders = (boolean[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rowType.getFieldCount()).map((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$14 -> true, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean());
                    String comparisons = this.generateRowCompare(ctx, (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), rowType.getFieldCount()).toArray(ClassTag$.MODULE$.Int()), (LogicalType[])rowType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), orders, SortUtil$.MODULE$.getNullDefaultOrders(orders), "a", "b");
                    String compareFunc = CodeGenUtils$.MODULE$.newName("compareRow");
                    String funcCode = new StringBuilder(88).append("\n          public int ").append(compareFunc).append("(").append(CodeGenUtils$.MODULE$.BASE_ROW()).append(" a, ").append(CodeGenUtils$.MODULE$.BASE_ROW()).append(" b) {\n            ").append(comparisons).append("\n            return 0;\n          }\n        ").toString();
                    ctx.addReusableMember(funcCode);
                    string = new StringBuilder(4).append(compareFunc).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
                } else if (LogicalTypeRoot.RAW.equals(logicalTypeRoot)) {
                    TypeInformationRawType rawType = (TypeInformationRawType)t;
                    String ser = ctx.addReusableObject(rawType.getTypeInformation().createSerializer(new ExecutionConfig()), "serializer", ctx.addReusableObject$default$3());
                    String comp = ctx.addReusableObject(((AtomicType)rawType.getTypeInformation()).createComparator(true, new ExecutionConfig()), "comparator", ctx.addReusableObject$default$3());
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(137).append("\n         |").append(comp).append(".compare(\n         |  ").append(CodeGenUtils$.MODULE$.BINARY_GENERIC()).append(".getJavaObjectFromBinaryGeneric(").append(leftTerm).append(", ").append(ser).append("),\n         |  ").append(CodeGenUtils$.MODULE$.BINARY_GENERIC()).append(".getJavaObjectFromBinaryGeneric(").append(rightTerm).append(", ").append(ser).append(")\n         |)\n       ").toString())).stripMargin();
                } else {
                    string = new StringBuilder(12).append(leftTerm).append(".compareTo(").append(rightTerm).append(")").toString();
                }
            }
        }
        return string;
    }

    public String generateArrayCompare(CodeGeneratorContext ctx, boolean nullsIsLast, ArrayType arrayType, String leftTerm, String rightTerm) {
        int nullIsLastRet = nullsIsLast ? 1 : -1;
        LogicalType elementType = arrayType.getElementType();
        String fieldA = CodeGenUtils$.MODULE$.newName("fieldA");
        String isNullA = CodeGenUtils$.MODULE$.newName("isNullA");
        String lengthA = CodeGenUtils$.MODULE$.newName("lengthA");
        String fieldB = CodeGenUtils$.MODULE$.newName("fieldB");
        String isNullB = CodeGenUtils$.MODULE$.newName("isNullB");
        String lengthB = CodeGenUtils$.MODULE$.newName("lengthB");
        String minLength = CodeGenUtils$.MODULE$.newName("minLength");
        String i = CodeGenUtils$.MODULE$.newName("i");
        String comp = CodeGenUtils$.MODULE$.newName("comp");
        String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
        return new StringBuilder(626).append("\n        int ").append(lengthA).append(" = a.numElements();\n        int ").append(lengthB).append(" = b.numElements();\n        int ").append(minLength).append(" = (").append(lengthA).append(" > ").append(lengthB).append(") ? ").append(lengthB).append(" : ").append(lengthA).append(";\n        for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(minLength).append("; ").append(i).append("++) {\n          boolean ").append(isNullA).append(" = a.isNullAt(").append(i).append(");\n          boolean ").append(isNullB).append(" = b.isNullAt(").append(i).append(");\n          if (").append(isNullA).append(" && ").append(isNullB).append(") {\n            // Continue to compare the next element\n          } else if (").append(isNullA).append(") {\n            return ").append(nullIsLastRet).append(";\n          } else if (").append(isNullB).append(") {\n            return ").append(-nullIsLastRet).append(";\n          } else {\n            ").append(typeTerm).append(" ").append(fieldA).append(" = ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, i, leftTerm, elementType)).append(";\n            ").append(typeTerm).append(" ").append(fieldB).append(" = ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, i, rightTerm, elementType)).append(";\n            int ").append(comp).append(" = ").append(this.generateCompare(ctx, elementType, nullsIsLast, fieldA, fieldB)).append(";\n            if (").append(comp).append(" != 0) {\n              return ").append(comp).append(";\n            }\n          }\n        }\n\n        if (").append(lengthA).append(" < ").append(lengthB).append(") {\n          return -1;\n        } else if (").append(lengthA).append(" > ").append(lengthB).append(") {\n          return 1;\n        }\n      ").toString();
    }

    public String generateRowCompare(CodeGeneratorContext ctx, int[] keys, LogicalType[] keyTypes, boolean[] orders, boolean[] nullsIsLast, String leftTerm, String rightTerm) {
        ArrayBuffer compares = new ArrayBuffer();
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).indices().foreach((Function1 & Serializable & scala.Serializable)i -> GenerateUtils$.$anonfun$generateRowCompare$1(ctx, keys, keyTypes, orders, nullsIsLast, leftTerm, rightTerm, compares, BoxesRunTime.unboxToInt((Object)i)));
        return compares.mkString();
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$generateRowCompare$1(CodeGeneratorContext ctx$1, int[] keys$1, LogicalType[] keyTypes$1, boolean[] orders$1, boolean[] nullsIsLast$1, String leftTerm$1, String rightTerm$1, ArrayBuffer compares$1, int i) {
        int index = keys$1[i];
        String symbol = orders$1[i] ? "" : "-";
        int nullIsLastRet = nullsIsLast$1[i] ? 1 : -1;
        LogicalType t = keyTypes$1[i];
        String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(t);
        String fieldA = CodeGenUtils$.MODULE$.newName("fieldA");
        String isNullA = CodeGenUtils$.MODULE$.newName("isNullA");
        String fieldB = CodeGenUtils$.MODULE$.newName("fieldB");
        String isNullB = CodeGenUtils$.MODULE$.newName("isNullB");
        String comp = CodeGenUtils$.MODULE$.newName("comp");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(426).append("\n           |boolean ").append(isNullA).append(" = ").append(leftTerm$1).append(".isNullAt(").append(index).append(");\n           |boolean ").append(isNullB).append(" = ").append(rightTerm$1).append(".isNullAt(").append(index).append(");\n           |if (").append(isNullA).append(" && ").append(isNullB).append(") {\n           |  // Continue to compare the next element\n           |} else if (").append(isNullA).append(") {\n           |  return ").append(nullIsLastRet).append(";\n           |} else if (").append(isNullB).append(") {\n           |  return ").append(-nullIsLastRet).append(";\n           |} else {\n           |  ").append(typeTerm).append(" ").append(fieldA).append(" = ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx$1, index, leftTerm$1, t)).append(";\n           |  ").append(typeTerm).append(" ").append(fieldB).append(" = ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx$1, index, rightTerm$1, t)).append(";\n           |  int ").append(comp).append(" = ").append(MODULE$.generateCompare(ctx$1, t, nullsIsLast$1[i], fieldA, fieldB)).append(";\n           |  if (").append(comp).append(" != 0) {\n           |    return ").append(symbol).append(comp).append(";\n           |  }\n           |}\n         ").toString())).stripMargin();
        return compares$1.$plus$eq((Object)code);
    }

    private GenerateUtils$() {
        MODULE$ = this;
    }
}

