/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.calls;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.DataFormatConverters;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.calls.BuiltInMethods$;
import org.apache.flink.table.planner.typeutils.TypeCoercion$;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalarOperatorGens$ {
    public static ScalarOperatorGens$ MODULE$;

    static {
        new ScalarOperatorGens$();
    }

    public GeneratedExpression generateBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        Function1<String, String> function1;
        LogicalType logicalType = resultType;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            return this.generateDecimalBinaryArithmeticOperator(ctx, operator, decimalType, left, right);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        String string = operator;
        if ("%".equals(string)) {
            Function1<String, String> function12;
            if (PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
                function12 = this.numericCasting(left.resultType(), resultType);
            } else {
                BigIntType castedType = TypeCheckUtils.isDecimal((LogicalType)left.resultType()) ? new BigIntType() : left.resultType();
                function12 = this.numericCasting(left.resultType(), (LogicalType)castedType);
            }
            function1 = function12;
        } else {
            function1 = this.numericCasting(left.resultType(), resultType);
        }
        Function1<String, String> leftCasting = function1;
        Function1<String, String> rightCasting = this.numericCasting(right.resultType(), resultType);
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        return this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(7).append("(").append(resultTypeTerm).append(") (").append(leftCasting.apply(leftTerm)).append(" ").append(operator).append(" ").append(rightCasting.apply(rightTerm)).append(")").toString());
    }

    private GeneratedExpression generateDecimalBinaryArithmeticOperator(CodeGeneratorContext ctx, String operator, DecimalType resultType, GeneratedExpression left, GeneratedExpression right) {
        scala.collection.immutable.Map methods = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"+"), (Object)"add"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-"), (Object)"subtract"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"*"), (Object)"multiply"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"/"), (Object)"divide"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"%"), (Object)"mod")}));
        return this.generateOperatorIfNotNull(ctx, (LogicalType)resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> {
            String method = (String)methods.apply((Object)operator);
            String leftCasted = (String)this.castToDec$1(left.resultType(), resultType).apply(leftTerm);
            String rightCasted = (String)this.castToDec$1(right.resultType(), resultType).apply(rightTerm);
            int precision = resultType.getPrecision();
            int scale = resultType.getScale();
            return new StringBuilder(9).append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".").append(method).append("(").append(leftCasted).append(", ").append(rightCasted).append(", ").append(precision).append(", ").append(scale).append(")").toString();
        });
    }

    public GeneratedExpression generateUnaryArithmeticOperator(CodeGeneratorContext ctx, String operator, LogicalType resultType, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, resultType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)operandTerm -> {
            String string;
            if (TypeCheckUtils.isDecimal((LogicalType)operand.resultType())) {
                String string2 = operator;
                String string3 = "-";
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    string = new StringBuilder(9).append((String)operandTerm).append(".negate()").toString();
                    return string;
                }
            }
            if (TypeCheckUtils.isDecimal((LogicalType)operand.resultType())) {
                String string4 = operator;
                String string5 = "+";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    string = String.valueOf(operandTerm);
                    return string;
                }
            }
            string = new StringBuilder(2).append(operator).append("(").append((String)operandTerm).append(")").toString();
            return string;
        });
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateTemporalPlusMinus(CodeGeneratorContext ctx, boolean plus, LogicalType resultType, GeneratedExpression left, GeneratedExpression right) {
        block15: {
            block21: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block16: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                op = plus != false ? "+" : "-";
                                                var13_7 = new Tuple2((Object)left.resultType().getTypeRoot(), (Object)right.resultType().getTypeRoot());
                                                if (var13_7 == null) break block12;
                                                var14_8 = (LogicalTypeRoot)var13_7._1();
                                                var15_9 = (LogicalTypeRoot)var13_7._2();
                                                if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var14_8) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var15_9)) break block12;
                                                var11_10 = true;
                                                break block13;
                                            }
                                            if (var13_7 == null) ** GOTO lbl-1000
                                            var16_11 = (LogicalTypeRoot)var13_7._1();
                                            var17_12 = (LogicalTypeRoot)var13_7._2();
                                            if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var16_11) && LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var17_12)) {
                                                var11_10 = true;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                var11_10 = false;
                                            }
                                        }
                                        if (!var11_10) break block14;
                                        var6_13 = this.generateBinaryArithmeticOperator(ctx, op, left.resultType(), left, right);
                                        break block15;
                                    }
                                    if (var13_7 == null) break block16;
                                    var18_14 = (LogicalTypeRoot)var13_7._1();
                                    var19_15 = (LogicalTypeRoot)var13_7._2();
                                    if (!LogicalTypeRoot.DATE.equals(var18_14) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var19_15)) break block16;
                                    var20_16 = resultType.getTypeRoot();
                                    if (LogicalTypeRoot.DATE.equals(var20_16)) {
                                        var10_17 = this.generateOperatorIfNotNull(ctx, (LogicalType)new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$1(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                    } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var20_16)) {
                                        var10_17 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$2(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                    } else {
                                        throw new MatchError((Object)var20_16);
                                    }
                                    var6_13 = var10_17;
                                    break block15;
                                }
                                if (var13_7 == null) break block17;
                                var21_18 = (LogicalTypeRoot)var13_7._1();
                                var22_19 = (LogicalTypeRoot)var13_7._2();
                                if (!LogicalTypeRoot.DATE.equals(var21_18) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var22_19)) break block17;
                                var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new DateType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$3(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                                break block15;
                            }
                            if (var13_7 == null) break block18;
                            var23_20 = (LogicalTypeRoot)var13_7._1();
                            var24_21 = (LogicalTypeRoot)var13_7._2();
                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var23_20) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var24_21)) break block18;
                            var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$4(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                            break block15;
                        }
                        if (var13_7 == null) break block19;
                        var25_22 = (LogicalTypeRoot)var13_7._1();
                        var26_23 = (LogicalTypeRoot)var13_7._2();
                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var25_22) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var26_23)) break block19;
                        var6_13 = this.generateOperatorIfNotNull(ctx, (LogicalType)new TimeType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$5(java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)());
                        break block15;
                    }
                    if (var13_7 == null) break block20;
                    var27_24 = (LogicalTypeRoot)var13_7._1();
                    var28_25 = (LogicalTypeRoot)var13_7._2();
                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var27_24) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var28_25)) break block20;
                    var6_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$6(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                    break block15;
                }
                if (var13_7 == null) break block21;
                var29_26 = (LogicalTypeRoot)var13_7._1();
                var30_27 = (LogicalTypeRoot)var13_7._2();
                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var29_26) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var30_27)) break block21;
                var6_13 = this.generateOperatorIfNotNull(ctx, left.resultType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$7(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((String)op));
                break block15;
            }
            if (var13_7 == null) ** GOTO lbl-1000
            var31_28 = (LogicalTypeRoot)var13_7._1();
            var32_29 = (LogicalTypeRoot)var13_7._2();
            var9_30 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var31_28) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var31_28) != false ? true : LogicalTypeRoot.DATE.equals(var31_28) != false);
            if (var9_30 && (var8_31 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var32_29) != false ? true : (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var32_29) != false ? true : LogicalTypeRoot.DATE.equals(var32_29) != false)) && !plus) {
                var33_32 = resultType.getTypeRoot();
                if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var33_32)) {
                    var7_33 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$8(org.apache.flink.table.planner.codegen.GeneratedExpression org.apache.flink.table.planner.codegen.GeneratedExpression java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((GeneratedExpression)left, (GeneratedExpression)right));
                } else if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var33_32)) {
                    var7_33 = this.generateOperatorIfNotNull(ctx, resultType, left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateTemporalPlusMinus$9(org.apache.flink.table.planner.codegen.GeneratedExpression org.apache.flink.table.planner.codegen.GeneratedExpression java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;)((GeneratedExpression)left, (GeneratedExpression)right, (String)op));
                } else {
                    throw new MatchError((Object)var33_32);
                }
                var6_13 = var7_33;
            } else lbl-1000:
            // 2 sources

            {
                throw new CodeGenException("Unsupported temporal arithmetic.");
            }
        }
        return var6_13;
    }

    public GeneratedExpression generateUnaryIntervalPlusMinus(CodeGeneratorContext ctx, boolean plus, GeneratedExpression operand) {
        String operator = plus ? "+" : "-";
        return this.generateUnaryArithmeticOperator(ctx, operator, operand.resultType(), operand);
    }

    public GeneratedExpression generateIn(CodeGeneratorContext ctx, GeneratedExpression needle, Seq<GeneratedExpression> haystack) {
        GeneratedExpression generatedExpression;
        if (haystack.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.literal()))) {
            LogicalType logicalType;
            Function1 & Serializable & scala.Serializable intersect;
            Option<LogicalType> widerType = TypeCoercion$.MODULE$.widerTypeOf(needle.resultType(), ((GeneratedExpression)haystack.head()).resultType());
            Option<LogicalType> option = widerType;
            if (option instanceof Some) {
                Some some = (Some)option;
                LogicalType t = (LogicalType)some.value();
                intersect = (Function1 & Serializable & scala.Serializable)value -> (String)MODULE$.numericCasting(value.resultType(), t).apply((Object)value.resultTerm());
            } else if (None$.MODULE$.equals(option)) {
                intersect = (Function1 & Serializable & scala.Serializable)value -> value.resultTerm();
            } else {
                throw new MatchError(option);
            }
            Function1 & Serializable & scala.Serializable castNumeric = intersect;
            Option<LogicalType> option2 = widerType;
            if (option2 instanceof Some) {
                LogicalType t;
                Some some = (Some)option2;
                logicalType = t = (LogicalType)some.value();
            } else if (None$.MODULE$.equals(option2)) {
                logicalType = needle.resultType();
            } else {
                throw new MatchError(option2);
            }
            LogicalType resultType = logicalType;
            Seq elements = (Seq)haystack.map((Function1 & Serializable & scala.Serializable)element -> element.copy((String)castNumeric.apply(element), element.nullTerm(), element.code(), resultType, element.copy$default$5()), Seq$.MODULE$.canBuildFrom());
            String setTerm = ctx.addReusableHashSet((Seq<GeneratedExpression>)elements, resultType);
            GeneratedExpression castedNeedle = needle.copy((String)castNumeric.apply((Object)needle), needle.nullTerm(), needle.code(), resultType, needle.copy$default$5());
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType((LogicalType)new BooleanType());
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue((LogicalType)new BooleanType());
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n           |").append(castedNeedle.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n           |boolean ").append(nullTerm2).append(" = true;\n           |if (!").append(castedNeedle.nullTerm()).append(") {\n           |  ").append(resultTerm2).append(" = ").append(setTerm).append(".contains(").append(castedNeedle.resultTerm()).append(");\n           |  ").append(nullTerm2).append(" = !").append(resultTerm2).append(" && ").append(setTerm).append(".containsNull();\n           |}\n           |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(55).append("\n           |").append(castedNeedle.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(setTerm).append(".contains(").append(castedNeedle.resultTerm()).append(");\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = (GeneratedExpression)((TraversableOnce)haystack.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.generateEquals(ctx, needle, (GeneratedExpression)x$3), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(left, right) -> MODULE$.generateOr(ctx, (GeneratedExpression)left, (GeneratedExpression)right));
        }
        return generatedExpression;
    }

    public GeneratedExpression generateEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        GeneratedExpression generatedExpression;
        block15: {
            Function2 & Serializable & scala.Serializable intersect;
            while (true) {
                boolean canEqual = PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType());
                if (TypeCheckUtils.isCharacterString((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
                    generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)new BooleanType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString());
                    break block15;
                }
                if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
                    generatedExpression = this.generateComparison(ctx, "==", left, right);
                    break block15;
                }
                if (TypeCheckUtils.isArray((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.generateArrayComparison(ctx, left, right);
                    break block15;
                }
                if (TypeCheckUtils.isMap((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.generateMapComparison(ctx, left, right);
                    break block15;
                }
                if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && canEqual) {
                    generatedExpression = this.generateComparison(ctx, "==", left, right);
                    break block15;
                }
                if (TypeCheckUtils.isRaw((LogicalType)left.resultType()) && canEqual) {
                    Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                        throw new MatchError(seq);
                    }
                    String resultTerm = (String)((SeqLike)some.get()).apply(0);
                    String nullTerm = (String)((SeqLike)some.get()).apply(1);
                    Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
                    Tuple2 tuple22 = tuple2;
                    String resultTerm2 = (String)tuple22._1();
                    String nullTerm2 = (String)tuple22._2();
                    String genericSer = ctx.addReusableTypeSerializer(left.resultType());
                    String ser = new StringBuilder(21).append(genericSer).append(".getInnerSerializer()").toString();
                    BooleanType resultType = new BooleanType();
                    String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(262).append("\n         |").append(left.code()).append("\n         |").append(right.code()).append("\n         |boolean ").append(nullTerm2).append(" = ").append(left.nullTerm()).append(" || ").append(right.nullTerm()).append(";\n         |boolean ").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue((LogicalType)resultType)).append(";\n         |if (!").append(nullTerm2).append(") {\n         |  ").append(left.resultTerm()).append(".ensureMaterialized(").append(ser).append(");\n         |  ").append(right.resultTerm()).append(".ensureMaterialized(").append(ser).append(");\n         |  ").append(resultTerm2).append(" =\n         |    ").append(left.resultTerm()).append(".getBinarySection().equals(").append(right.resultTerm()).append(".getBinarySection());\n         |}\n         |").toString())).stripMargin();
                    generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, code, (LogicalType)resultType, GeneratedExpression$.MODULE$.apply$default$5());
                    break block15;
                }
                if (TypeCheckUtils.isTimePoint((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
                    if (right.literal()) {
                        right = this.generateCastStringLiteralToDateTime(ctx, right, left.resultType());
                        continue;
                    }
                    right = this.generateCast(ctx, right, left.resultType());
                    continue;
                }
                if (!TypeCheckUtils.isTimePoint((LogicalType)right.resultType()) || !TypeCheckUtils.isCharacterString((LogicalType)left.resultType())) break;
                if (left.literal()) {
                    GeneratedExpression generatedExpression2 = this.generateCastStringLiteralToDateTime(ctx, left, right.resultType());
                    left = generatedExpression2;
                    continue;
                }
                GeneratedExpression generatedExpression3 = this.generateCast(ctx, left, right.resultType());
                left = generatedExpression3;
            }
            BooleanType booleanType = new BooleanType();
            boolean bl = this.generateOperatorIfNotNull$default$5();
            if (TypeCheckUtils.isReference((LogicalType)left.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString();
            } else if (TypeCheckUtils.isReference((LogicalType)right.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(9).append((String)rightTerm).append(".equals(").append((String)leftTerm).append(")").toString();
            } else {
                throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
            }
            generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)booleanType, left, right, bl, (Function2<String, String, String>)intersect);
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotDistinctFrom(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return this.generateOr(ctx, this.generateAnd(ctx, this.generateIsNull(ctx, left), this.generateIsNull(ctx, right)), this.generateEquals(ctx, left, right));
    }

    public GeneratedExpression generateNotEquals(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        GeneratedExpression generatedExpression;
        if (TypeCheckUtils.isCharacterString((LogicalType)left.resultType()) && TypeCheckUtils.isCharacterString((LogicalType)right.resultType())) {
            generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)new BooleanType(), left, right, this.generateOperatorIfNotNull$default$5(), (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(10).append("!").append((String)leftTerm).append(".equals(").append((String)rightTerm).append(")").toString());
        } else if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
            generatedExpression = this.generateComparison(ctx, "!=", left, right);
        } else if (TypeCheckUtils.isTemporal((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            generatedExpression = this.generateComparison(ctx, "!=", left, right);
        } else if (TypeCheckUtils.isArray((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            GeneratedExpression equalsExpr = this.generateEquals(ctx, left, right);
            generatedExpression = new GeneratedExpression(new StringBuilder(3).append("(!").append(equalsExpr.resultTerm()).append(")").toString(), equalsExpr.nullTerm(), equalsExpr.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (TypeCheckUtils.isMap((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            GeneratedExpression equalsExpr = this.generateEquals(ctx, left, right);
            generatedExpression = new GeneratedExpression(new StringBuilder(3).append("(!").append(equalsExpr.resultTerm()).append(")").toString(), equalsExpr.nullTerm(), equalsExpr.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            generatedExpression = this.generateComparison(ctx, "!=", left, right);
        } else {
            Function2 & Serializable & scala.Serializable intersect;
            BooleanType booleanType = new BooleanType();
            boolean bl = this.generateOperatorIfNotNull$default$5();
            if (TypeCheckUtils.isReference((LogicalType)left.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(12).append("!(").append((String)leftTerm).append(".equals(").append((String)rightTerm).append("))").toString();
            } else if (TypeCheckUtils.isReference((LogicalType)right.resultType())) {
                intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(12).append("!(").append((String)rightTerm).append(".equals(").append((String)leftTerm).append("))").toString();
            } else {
                throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
            }
            generatedExpression = this.generateOperatorIfNotNull(ctx, (LogicalType)booleanType, left, right, bl, (Function2<String, String, String>)intersect);
        }
        return generatedExpression;
    }

    public GeneratedExpression generateComparison(CodeGeneratorContext ctx, String operator, GeneratedExpression left, GeneratedExpression right) {
        Function2 & Serializable & scala.Serializable intersect;
        BooleanType booleanType = new BooleanType();
        boolean bl = this.generateOperatorIfNotNull$default$5();
        if (TypeCheckUtils.isDecimal((LogicalType)left.resultType()) || TypeCheckUtils.isDecimal((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(Decimal.class))).append(".compare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)left.resultType()) && TypeCheckUtils.isNumeric((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
        } else if (TypeCheckUtils.isTimestamp((LogicalType)left.resultType()) && TypeCheckUtils.isTimestamp((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isTimestampWithLocalZone((LogicalType)left.resultType()) && TypeCheckUtils.isTimestampWithLocalZone((LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(15).append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
        } else if (TypeCheckUtils.isTemporal((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
        } else if (TypeCheckUtils.isBoolean((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            Function2 & Serializable & scala.Serializable intersect2;
            String string = operator;
            boolean bl2 = "==".equals(string) ? true : "!=".equals(string);
            if (bl2) {
                intersect2 = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(2).append((String)leftTerm).append(" ").append(operator).append(" ").append((String)rightTerm).toString();
            } else {
                boolean bl3 = ">".equals(string) ? true : ("<".equals(string) ? true : ("<=".equals(string) ? true : ">=".equals(string)));
                if (bl3) {
                    intersect2 = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(32).append("java.lang.Boolean.compare(").append((String)leftTerm).append(", ").append((String)rightTerm).append(") ").append(operator).append(" 0").toString();
                } else {
                    throw new CodeGenException(new StringBuilder(34).append("Unsupported boolean comparison '").append(operator).append("'.").toString());
                }
            }
            intersect = intersect2;
        } else if (TypeCheckUtils.isBinaryString((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(27).append("java.util.Arrays.equals(").append((String)leftTerm).append(", ").append((String)rightTerm).append(")").toString();
        } else if (TypeCheckUtils.isComparable((LogicalType)left.resultType()) && PlannerTypeUtils.isInteroperable((LogicalType)left.resultType(), (LogicalType)right.resultType())) {
            intersect = (Function2 & Serializable & scala.Serializable)(leftTerm, rightTerm) -> new StringBuilder(52).append("((").append((String)leftTerm).append(" == null) ? ((").append((String)rightTerm).append(" == null) ? 0 : -1) : ((").append((String)rightTerm).append(" == null) ? ").append(new StringBuilder(23).append("1 : (").append((String)leftTerm).append(".compareTo(").append((String)rightTerm).append(")))) ").append(operator).append(" 0").toString()).toString();
        } else {
            throw new CodeGenException(new StringBuilder(25).append("Incomparable types: ").append(left.resultType()).append(" and ").append(String.valueOf(right.resultType())).toString());
        }
        return this.generateOperatorIfNotNull(ctx, (LogicalType)booleanType, left, right, bl, (Function2<String, String, String>)intersect);
    }

    public GeneratedExpression generateIsNull(CodeGeneratorContext ctx, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (ctx.nullCheck()) {
            generatedExpression = new GeneratedExpression(operand.nullTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (!ctx.nullCheck() && TypeCheckUtils.isReference((LogicalType)operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = ").append(operand.resultTerm()).append(" == null;\n           |").toString())).stripMargin();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("false", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateIsNotNull(CodeGeneratorContext ctx, GeneratedExpression operand) {
        GeneratedExpression generatedExpression;
        if (ctx.nullCheck()) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = !").append(operand.nullTerm()).append(";\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else if (!ctx.nullCheck() && TypeCheckUtils.isReference((LogicalType)operand.resultType())) {
            String resultTerm = CodeGenUtils$.MODULE$.newName("result");
            String operatorCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n           |").append(operand.code()).append("\n           |boolean ").append(resultTerm).append(" = ").append(operand.resultTerm()).append(" != null;\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = new GeneratedExpression("true", GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public GeneratedExpression generateAnd(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(767).append("\n         |").append(left.code()).append("\n         |\n         |boolean ").append(resultTerm2).append(" = false;\n         |boolean ").append(nullTerm2).append(" = false;\n         |if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(") {\n         |  // left expr is false, skip right expr\n         |} else {\n         |  ").append(right.code()).append("\n         |\n         |  if (!").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = ").append(left.resultTerm()).append(" && ").append(right.resultTerm()).append(";\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && ").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && !").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |}\n       ").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         |").append(left.code()).append("\n         |boolean ").append(resultTerm2).append(" = false;\n         |if (").append(left.resultTerm()).append(") {\n         |  ").append(right.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(right.resultTerm()).append(";\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateOr(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(763).append("\n         |").append(left.code()).append("\n         |\n        |boolean ").append(resultTerm2).append(" = true;\n         |boolean ").append(nullTerm2).append(" = false;\n         |if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(") {\n         |  // left expr is true, skip right expr\n         |} else {\n         |  ").append(right.code()).append("\n         |\n        |  if (!").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = ").append(left.resultTerm()).append(" || ").append(right.resultTerm()).append(";\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && ").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = true;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (!").append(left.nullTerm()).append(" && !").append(left.resultTerm()).append(" && ").append(right.nullTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && ").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = true;\n         |    ").append(nullTerm2).append(" = false;\n         |  }\n         |  else if (").append(left.nullTerm()).append(" && !").append(right.nullTerm()).append(" && !").append(right.resultTerm()).append(") {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |  else {\n         |    ").append(resultTerm2).append(" = false;\n         |    ").append(nullTerm2).append(" = true;\n         |  }\n         |}\n         |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         |").append(left.code()).append("\n         |boolean ").append(resultTerm2).append(" = true;\n         |if (!").append(left.resultTerm()).append(") {\n         |  ").append(right.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(right.resultTerm()).append(";\n         |}\n         |").toString())).stripMargin().trim();
        return new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateNot(CodeGeneratorContext ctx, GeneratedExpression operand) {
        return this.generateUnaryOperatorIfNotNull(ctx, (LogicalType)new BooleanType(), operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(3).append("!(").append((String)operandTerm).append(")").toString());
    }

    public GeneratedExpression generateIsTrue(GeneratedExpression operand) {
        return new GeneratedExpression(operand.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotTrue(GeneratedExpression operand) {
        return new GeneratedExpression(new StringBuilder(3).append("(!").append(operand.resultTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringBuilder(8).append("(!").append(operand.resultTerm()).append(" && !").append(operand.nullTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateIsNotFalse(GeneratedExpression operand) {
        return new GeneratedExpression(new StringBuilder(6).append("(").append(operand.resultTerm()).append(" || ").append(operand.nullTerm()).append(")").toString(), GeneratedExpression$.MODULE$.NEVER_NULL(), operand.code(), (LogicalType)new BooleanType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateReinterpret(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block6: {
            block19: {
                block18: {
                    block8: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block12: {
                                                block11: {
                                                    block10: {
                                                        block9: {
                                                            block7: {
                                                                block5: {
                                                                    var6_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                    if (var6_4 == null || !PlannerTypeUtils.isInteroperable((LogicalType)operand.resultType(), (LogicalType)targetType)) break block5;
                                                                    x$17 = targetType;
                                                                    x$18 = operand.copy$default$1();
                                                                    x$19 = operand.copy$default$2();
                                                                    x$20 = operand.copy$default$3();
                                                                    x$21 = operand.copy$default$5();
                                                                    var4_10 = operand.copy(x$18, x$19, x$20, x$17, x$21);
                                                                    break block6;
                                                                }
                                                                if (var6_4 == null) break block7;
                                                                var12_11 = (LogicalTypeRoot)var6_4._1();
                                                                var13_12 = (LogicalTypeRoot)var6_4._2();
                                                                if (!LogicalTypeRoot.DATE.equals(var12_11) || !LogicalTypeRoot.INTEGER.equals(var13_12)) break block7;
                                                                var5_13 = true;
                                                                break block8;
                                                            }
                                                            if (var6_4 == null) break block9;
                                                            var14_14 = (LogicalTypeRoot)var6_4._1();
                                                            var15_15 = (LogicalTypeRoot)var6_4._2();
                                                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var14_14) || !LogicalTypeRoot.INTEGER.equals(var15_15)) break block9;
                                                            var5_13 = true;
                                                            break block8;
                                                        }
                                                        if (var6_4 == null) break block10;
                                                        var16_16 = (LogicalTypeRoot)var6_4._1();
                                                        var17_17 = (LogicalTypeRoot)var6_4._2();
                                                        if (!LogicalTypeRoot.INTEGER.equals(var16_16) || !LogicalTypeRoot.DATE.equals(var17_17)) break block10;
                                                        var5_13 = true;
                                                        break block8;
                                                    }
                                                    if (var6_4 == null) break block11;
                                                    var18_18 = (LogicalTypeRoot)var6_4._1();
                                                    var19_19 = (LogicalTypeRoot)var6_4._2();
                                                    if (!LogicalTypeRoot.INTEGER.equals(var18_18) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var19_19)) break block11;
                                                    var5_13 = true;
                                                    break block8;
                                                }
                                                if (var6_4 == null) break block12;
                                                var20_20 = (LogicalTypeRoot)var6_4._1();
                                                var21_21 = (LogicalTypeRoot)var6_4._2();
                                                if (!LogicalTypeRoot.INTEGER.equals(var20_20) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var21_21)) break block12;
                                                var5_13 = true;
                                                break block8;
                                            }
                                            if (var6_4 == null) break block13;
                                            var22_22 = (LogicalTypeRoot)var6_4._1();
                                            var23_23 = (LogicalTypeRoot)var6_4._2();
                                            if (!LogicalTypeRoot.BIGINT.equals(var22_22) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var23_23)) break block13;
                                            var5_13 = true;
                                            break block8;
                                        }
                                        if (var6_4 == null) break block14;
                                        var24_24 = (LogicalTypeRoot)var6_4._1();
                                        var25_25 = (LogicalTypeRoot)var6_4._2();
                                        if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var24_24) || !LogicalTypeRoot.INTEGER.equals(var25_25)) break block14;
                                        var5_13 = true;
                                        break block8;
                                    }
                                    if (var6_4 == null) break block15;
                                    var26_26 = (LogicalTypeRoot)var6_4._1();
                                    var27_27 = (LogicalTypeRoot)var6_4._2();
                                    if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var26_26) || !LogicalTypeRoot.BIGINT.equals(var27_27)) break block15;
                                    var5_13 = true;
                                    break block8;
                                }
                                if (var6_4 == null) break block16;
                                var28_28 = (LogicalTypeRoot)var6_4._1();
                                var29_29 = (LogicalTypeRoot)var6_4._2();
                                if (!LogicalTypeRoot.DATE.equals(var28_28) || !LogicalTypeRoot.BIGINT.equals(var29_29)) break block16;
                                var5_13 = true;
                                break block8;
                            }
                            if (var6_4 == null) break block17;
                            var30_30 = (LogicalTypeRoot)var6_4._1();
                            var31_31 = (LogicalTypeRoot)var6_4._2();
                            if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var30_30) || !LogicalTypeRoot.BIGINT.equals(var31_31)) break block17;
                            var5_13 = true;
                            break block8;
                        }
                        if (var6_4 == null) ** GOTO lbl-1000
                        var32_32 = (LogicalTypeRoot)var6_4._1();
                        var33_33 = (LogicalTypeRoot)var6_4._2();
                        if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var32_32) && LogicalTypeRoot.BIGINT.equals(var33_33)) {
                            var5_13 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            var5_13 = false;
                        }
                    }
                    if (!var5_13) break block18;
                    var4_10 = this.internalExprCasting(operand, targetType);
                    break block6;
                }
                if (var6_4 == null) break block19;
                var34_34 = (LogicalTypeRoot)var6_4._1();
                var35_35 = (LogicalTypeRoot)var6_4._2();
                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var34_34) || !LogicalTypeRoot.BIGINT.equals(var35_35)) break block19;
                var4_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateReinterpret$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                break block6;
            }
            if (var6_4 == null) ** GOTO lbl-1000
            var36_36 = (LogicalTypeRoot)var6_4._1();
            var37_37 = (LogicalTypeRoot)var6_4._2();
            if (LogicalTypeRoot.BIGINT.equals(var36_36) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var37_37)) {
                var4_10 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateReinterpret$2(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
            } else lbl-1000:
            // 2 sources

            {
                if (var6_4 != null) {
                    from = (LogicalTypeRoot)var6_4._1();
                    to = (LogicalTypeRoot)var6_4._2();
                    throw new CodeGenException(new StringBuilder(38).append("Unsupported reinterpret from '").append(from).append("' to '").append(to).append("'.").toString());
                }
                throw new MatchError((Object)var6_4);
            }
        }
        return var4_10;
    }

    /*
     * Unable to fully structure code
     */
    public GeneratedExpression generateCast(CodeGeneratorContext ctx, GeneratedExpression operand, LogicalType targetType) {
        block23: {
            block84: {
                block85: {
                    block83: {
                        block82: {
                            block75: {
                                block81: {
                                    block80: {
                                        block79: {
                                            block78: {
                                                block77: {
                                                    block76: {
                                                        block74: {
                                                            block73: {
                                                                block72: {
                                                                    block71: {
                                                                        block70: {
                                                                            block69: {
                                                                                block68: {
                                                                                    block67: {
                                                                                        block66: {
                                                                                            block65: {
                                                                                                block64: {
                                                                                                    block61: {
                                                                                                        block63: {
                                                                                                            block62: {
                                                                                                                block60: {
                                                                                                                    block59: {
                                                                                                                        block58: {
                                                                                                                            block57: {
                                                                                                                                block56: {
                                                                                                                                    block55: {
                                                                                                                                        block54: {
                                                                                                                                            block53: {
                                                                                                                                                block52: {
                                                                                                                                                    block51: {
                                                                                                                                                        block50: {
                                                                                                                                                            block49: {
                                                                                                                                                                block48: {
                                                                                                                                                                    block47: {
                                                                                                                                                                        block46: {
                                                                                                                                                                            block45: {
                                                                                                                                                                                block44: {
                                                                                                                                                                                    block43: {
                                                                                                                                                                                        block42: {
                                                                                                                                                                                            block41: {
                                                                                                                                                                                                block40: {
                                                                                                                                                                                                    block39: {
                                                                                                                                                                                                        block38: {
                                                                                                                                                                                                            block37: {
                                                                                                                                                                                                                block36: {
                                                                                                                                                                                                                    block35: {
                                                                                                                                                                                                                        block34: {
                                                                                                                                                                                                                            block33: {
                                                                                                                                                                                                                                block32: {
                                                                                                                                                                                                                                    block31: {
                                                                                                                                                                                                                                        block30: {
                                                                                                                                                                                                                                            block29: {
                                                                                                                                                                                                                                                block28: {
                                                                                                                                                                                                                                                    block27: {
                                                                                                                                                                                                                                                        block26: {
                                                                                                                                                                                                                                                            block25: {
                                                                                                                                                                                                                                                                block24: {
                                                                                                                                                                                                                                                                    block21: {
                                                                                                                                                                                                                                                                        block22: {
                                                                                                                                                                                                                                                                            var28_4 = new Tuple2((Object)operand.resultType().getTypeRoot(), (Object)targetType.getTypeRoot());
                                                                                                                                                                                                                                                                            if (var28_4 == null) break block21;
                                                                                                                                                                                                                                                                            var29_5 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                                                            var30_6 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var29_5) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var30_6)) break block21;
                                                                                                                                                                                                                                                                            v0 = ((TimestampType)operand.resultType()).getKind();
                                                                                                                                                                                                                                                                            var31_7 = TimestampKind.PROCTIME;
                                                                                                                                                                                                                                                                            if (!(v0 == null ? var31_7 != null : v0.equals(var31_7) == false)) break block22;
                                                                                                                                                                                                                                                                            v1 = ((TimestampType)operand.resultType()).getKind();
                                                                                                                                                                                                                                                                            var32_8 = TimestampKind.ROWTIME;
                                                                                                                                                                                                                                                                            if (!(v1 == null ? var32_8 != null : v1.equals(var32_8) == false)) break block22;
                                                                                                                                                                                                                                                                            v2 = ((TimestampType)targetType).getKind();
                                                                                                                                                                                                                                                                            var33_9 = TimestampKind.PROCTIME;
                                                                                                                                                                                                                                                                            if (!(v2 == null ? var33_9 != null : v2.equals(var33_9) == false)) break block22;
                                                                                                                                                                                                                                                                            v3 = ((TimestampType)targetType).getKind();
                                                                                                                                                                                                                                                                            var34_10 = TimestampKind.ROWTIME;
                                                                                                                                                                                                                                                                            if (v3 != null ? v3.equals(var34_10) == false : var34_10 != null) break block21;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        x$22 = new TimestampType(3);
                                                                                                                                                                                                                                                                        x$23 = operand.copy$default$1();
                                                                                                                                                                                                                                                                        x$24 = operand.copy$default$2();
                                                                                                                                                                                                                                                                        x$25 = operand.copy$default$3();
                                                                                                                                                                                                                                                                        x$26 = operand.copy$default$5();
                                                                                                                                                                                                                                                                        var4_16 = operand.copy(x$23, x$24, x$25, (LogicalType)x$22, x$26);
                                                                                                                                                                                                                                                                        break block23;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (var28_4 == null) break block24;
                                                                                                                                                                                                                                                                    var40_17 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                                                    var41_18 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var40_17) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var41_18)) break block24;
                                                                                                                                                                                                                                                                    fromType = (TimestampType)operand.resultType();
                                                                                                                                                                                                                                                                    toType = (TimestampType)targetType;
                                                                                                                                                                                                                                                                    if (fromType.getPrecision() <= toType.getPrecision()) {
                                                                                                                                                                                                                                                                        x$27 = targetType;
                                                                                                                                                                                                                                                                        x$28 = operand.copy$default$1();
                                                                                                                                                                                                                                                                        x$29 = operand.copy$default$2();
                                                                                                                                                                                                                                                                        x$30 = operand.copy$default$3();
                                                                                                                                                                                                                                                                        x$31 = operand.copy$default$5();
                                                                                                                                                                                                                                                                        v4 = operand.copy(x$28, x$29, x$30, x$27, x$31);
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                        v4 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$1(org.apache.flink.table.types.logical.TimestampType java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((TimestampType)toType, (String)method));
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    var4_16 = v4;
                                                                                                                                                                                                                                                                    break block23;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (var28_4 == null) break block25;
                                                                                                                                                                                                                                                                var50_27 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                                                var51_28 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var50_27) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var51_28)) break block25;
                                                                                                                                                                                                                                                                fromType = (TimestampType)operand.resultType();
                                                                                                                                                                                                                                                                toType = (LocalZonedTimestampType)targetType;
                                                                                                                                                                                                                                                                method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_TIMESTAMP_WITH_LOCAL_ZONE());
                                                                                                                                                                                                                                                                if (fromType.getPrecision() < toType.getPrecision()) {
                                                                                                                                                                                                                                                                    v5 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$2(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (String)method));
                                                                                                                                                                                                                                                                } else {
                                                                                                                                                                                                                                                                    truncate_method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                    v5 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$3(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.types.logical.LocalZonedTimestampType java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (LocalZonedTimestampType)toType, (String)method, (String)truncate_method));
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                var4_16 = v5;
                                                                                                                                                                                                                                                                break block23;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (var28_4 == null) break block26;
                                                                                                                                                                                                                                                            var56_33 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                                            var57_34 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var56_33) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var57_34)) break block26;
                                                                                                                                                                                                                                                            fromType = (LocalZonedTimestampType)operand.resultType();
                                                                                                                                                                                                                                                            toType = (TimestampType)targetType;
                                                                                                                                                                                                                                                            method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_ZONE_TO_TIMESTAMP());
                                                                                                                                                                                                                                                            if (fromType.getPrecision() < toType.getPrecision()) {
                                                                                                                                                                                                                                                                v6 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$4(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (String)method));
                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                truncate_method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                                v6 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$5(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.types.logical.TimestampType java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (TimestampType)toType, (String)method, (String)truncate_method));
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            var4_16 = v6;
                                                                                                                                                                                                                                                            break block23;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (var28_4 == null) break block27;
                                                                                                                                                                                                                                                        var62_39 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                                        var63_40 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var62_39) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var63_40)) break block27;
                                                                                                                                                                                                                                                        fromType = (LocalZonedTimestampType)operand.resultType();
                                                                                                                                                                                                                                                        toType = (LocalZonedTimestampType)targetType;
                                                                                                                                                                                                                                                        if (fromType.getPrecision() <= toType.getPrecision()) {
                                                                                                                                                                                                                                                            x$32 = targetType;
                                                                                                                                                                                                                                                            x$33 = operand.copy$default$1();
                                                                                                                                                                                                                                                            x$34 = operand.copy$default$2();
                                                                                                                                                                                                                                                            x$35 = operand.copy$default$3();
                                                                                                                                                                                                                                                            x$36 = operand.copy$default$5();
                                                                                                                                                                                                                                                            v7 = operand.copy(x$33, x$34, x$35, x$32, x$36);
                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                            method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TRUNCATE_SQL_TIMESTAMP());
                                                                                                                                                                                                                                                            v7 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$6(org.apache.flink.table.types.logical.LocalZonedTimestampType java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((LocalZonedTimestampType)toType, (String)method));
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        var4_16 = v7;
                                                                                                                                                                                                                                                        break block23;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (var28_4 == null || !PlannerTypeUtils.isInteroperable((LogicalType)operand.resultType(), (LogicalType)targetType)) break block28;
                                                                                                                                                                                                                                                    x$37 = targetType;
                                                                                                                                                                                                                                                    x$38 = operand.copy$default$1();
                                                                                                                                                                                                                                                    x$39 = operand.copy$default$2();
                                                                                                                                                                                                                                                    x$40 = operand.copy$default$3();
                                                                                                                                                                                                                                                    x$41 = operand.copy$default$5();
                                                                                                                                                                                                                                                    var4_16 = operand.copy(x$38, x$39, x$40, x$37, x$41);
                                                                                                                                                                                                                                                    break block23;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (var28_4 == null || !(var27_55 = LogicalTypeRoot.VARCHAR.equals(var77_54 = (LogicalTypeRoot)var28_4._2()) != false ? true : LogicalTypeRoot.CHAR.equals(var77_54) != false) || !TypeCheckUtils.isTimePoint((LogicalType)operand.resultType())) break block29;
                                                                                                                                                                                                                                                var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$7(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.planner.codegen.GeneratedExpression scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (GeneratedExpression)operand));
                                                                                                                                                                                                                                                break block23;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (var28_4 == null) break block30;
                                                                                                                                                                                                                                            var78_56 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                            var79_57 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                            if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var78_56) || !(var26_58 = LogicalTypeRoot.VARCHAR.equals(var79_57) != false ? true : LogicalTypeRoot.CHAR.equals(var79_57) != false)) break block30;
                                                                                                                                                                                                                                            method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_YEAR_MONTH_TO_STRING.method);
                                                                                                                                                                                                                                            timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.YEAR_TO_MONTH);
                                                                                                                                                                                                                                            var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$8(java.lang.String java.lang.String scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((String)method, (String)timeUnitRange));
                                                                                                                                                                                                                                            break block23;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (var28_4 == null) break block31;
                                                                                                                                                                                                                                        var82_61 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                        var83_62 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                        if (!LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var82_61) || !(var25_63 = LogicalTypeRoot.VARCHAR.equals(var83_62) != false ? true : LogicalTypeRoot.CHAR.equals(var83_62) != false)) break block31;
                                                                                                                                                                                                                                        method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.INTERVAL_DAY_TIME_TO_STRING.method);
                                                                                                                                                                                                                                        timeUnitRange = CodeGenUtils$.MODULE$.qualifyEnum(TimeUnitRange.DAY_TO_SECOND);
                                                                                                                                                                                                                                        var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$9(java.lang.String java.lang.String scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((String)method, (String)timeUnitRange));
                                                                                                                                                                                                                                        break block23;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (var28_4 == null) break block32;
                                                                                                                                                                                                                                    var86_66 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                    var87_67 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                    if (!LogicalTypeRoot.ARRAY.equals(var86_66) || !(var24_68 = LogicalTypeRoot.VARCHAR.equals(var87_67) != false ? true : LogicalTypeRoot.CHAR.equals(var87_67) != false)) break block32;
                                                                                                                                                                                                                                    var4_16 = this.generateCastArrayToString(ctx, operand, (ArrayType)operand.resultType());
                                                                                                                                                                                                                                    break block23;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (var28_4 == null) break block33;
                                                                                                                                                                                                                                var88_69 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                                var89_70 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                                if (!LogicalTypeRoot.VARBINARY.equals(var88_69) || !(var23_71 = LogicalTypeRoot.VARCHAR.equals(var89_70) != false ? true : LogicalTypeRoot.CHAR.equals(var89_70) != false)) break block33;
                                                                                                                                                                                                                                charset = StandardCharsets.class.getCanonicalName();
                                                                                                                                                                                                                                var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$10(java.lang.String scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((String)charset));
                                                                                                                                                                                                                                break block23;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (var28_4 == null) break block34;
                                                                                                                                                                                                                            var91_73 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                            var92_74 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                            if (!LogicalTypeRoot.MAP.equals(var91_73) || !(var22_75 = LogicalTypeRoot.VARCHAR.equals(var92_74) != false ? true : LogicalTypeRoot.CHAR.equals(var92_74) != false)) break block34;
                                                                                                                                                                                                                            var4_16 = this.generateCastMapToString(ctx, operand, (MapType)operand.resultType());
                                                                                                                                                                                                                            break block23;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (var28_4 == null) break block35;
                                                                                                                                                                                                                        var93_76 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                        var94_77 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                        if (!LogicalTypeRoot.ROW.equals(var93_76) || !(var21_78 = LogicalTypeRoot.VARCHAR.equals(var94_77) != false ? true : LogicalTypeRoot.CHAR.equals(var94_77) != false)) break block35;
                                                                                                                                                                                                                        var4_16 = this.generateCastBaseRowToString(ctx, operand, (RowType)operand.resultType());
                                                                                                                                                                                                                        break block23;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (var28_4 == null) break block36;
                                                                                                                                                                                                                    var95_79 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                                    var96_80 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                                    if (!LogicalTypeRoot.RAW.equals(var95_79) || !(var20_81 = LogicalTypeRoot.VARCHAR.equals(var96_80) != false ? true : LogicalTypeRoot.CHAR.equals(var96_80) != false)) break block36;
                                                                                                                                                                                                                    var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$11(org.apache.flink.table.planner.codegen.CodeGeneratorContext org.apache.flink.table.planner.codegen.GeneratedExpression scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)((CodeGeneratorContext)ctx, (GeneratedExpression)operand));
                                                                                                                                                                                                                    break block23;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (var28_4 == null || !(var19_83 = LogicalTypeRoot.VARCHAR.equals(var97_82 = (LogicalTypeRoot)var28_4._2()) != false ? true : LogicalTypeRoot.CHAR.equals(var97_82) != false)) break block37;
                                                                                                                                                                                                                var4_16 = GenerateUtils$.MODULE$.generateStringResultCallIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$12(scala.collection.Seq ), (Lscala/collection/Seq;)Ljava/lang/String;)());
                                                                                                                                                                                                                break block23;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (var28_4 == null) break block38;
                                                                                                                                                                                                            var98_84 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                            var99_85 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                            var18_86 = LogicalTypeRoot.VARCHAR.equals(var98_84) != false ? true : LogicalTypeRoot.CHAR.equals(var98_84) != false;
                                                                                                                                                                                                            if (!var18_86 || !LogicalTypeRoot.BOOLEAN.equals(var99_85)) break block38;
                                                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$13(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                            break block23;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (var28_4 == null || !(var17_88 = LogicalTypeRoot.VARCHAR.equals(var100_87 = (LogicalTypeRoot)var28_4._1()) != false ? true : LogicalTypeRoot.CHAR.equals(var100_87) != false) || !TypeCheckUtils.isNumeric((LogicalType)targetType)) break block39;
                                                                                                                                                                                                        var101_89 = targetType;
                                                                                                                                                                                                        if (var101_89 instanceof DecimalType) {
                                                                                                                                                                                                            var102_90 = (DecimalType)var101_89;
                                                                                                                                                                                                            var15_91 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$14(org.apache.flink.table.types.logical.DecimalType java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DecimalType)var102_90));
                                                                                                                                                                                                        } else {
                                                                                                                                                                                                            var104_92 = targetType.getTypeRoot();
                                                                                                                                                                                                            var16_93 = LogicalTypeRoot.TINYINT.equals(var104_92) != false ? "toByte" : (LogicalTypeRoot.SMALLINT.equals(var104_92) != false ? "toShort" : (LogicalTypeRoot.INTEGER.equals(var104_92) != false ? "toInt" : (LogicalTypeRoot.BIGINT.equals(var104_92) != false ? "toLong" : (LogicalTypeRoot.DOUBLE.equals(var104_92) != false ? "toDouble" : (LogicalTypeRoot.FLOAT.equals(var104_92) != false ? "toFloat" : null)))));
                                                                                                                                                                                                            methodName = var16_93;
                                                                                                                                                                                                            Predef$.MODULE$.assert(methodName != null, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$generateCast$15(), ()Ljava/lang/String;)());
                                                                                                                                                                                                            var15_91 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$16(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)methodName));
                                                                                                                                                                                                        }
                                                                                                                                                                                                        var4_16 = var15_91;
                                                                                                                                                                                                        break block23;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (var28_4 == null) break block40;
                                                                                                                                                                                                    var105_95 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                    var106_96 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                    var14_97 = LogicalTypeRoot.VARCHAR.equals(var105_95) != false ? true : LogicalTypeRoot.CHAR.equals(var105_95) != false;
                                                                                                                                                                                                    if (!var14_97 || !LogicalTypeRoot.DATE.equals(var106_96)) break block40;
                                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$17(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                    break block23;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (var28_4 == null) break block41;
                                                                                                                                                                                                var107_98 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                                var108_99 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                                var13_100 = LogicalTypeRoot.VARCHAR.equals(var107_98) != false ? true : LogicalTypeRoot.CHAR.equals(var107_98) != false;
                                                                                                                                                                                                if (!var13_100 || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var108_99)) break block41;
                                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$18(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                                break block23;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (var28_4 == null) break block42;
                                                                                                                                                                                            var109_101 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                            var110_102 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                            var12_103 = LogicalTypeRoot.VARCHAR.equals(var109_101) != false ? true : LogicalTypeRoot.CHAR.equals(var109_101) != false;
                                                                                                                                                                                            if (!var12_103 || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var110_102)) break block42;
                                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$19(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                            break block23;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (var28_4 == null) break block43;
                                                                                                                                                                                        var111_104 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                        var112_105 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                        var11_106 = LogicalTypeRoot.VARCHAR.equals(var111_104) != false ? true : LogicalTypeRoot.CHAR.equals(var111_104) != false;
                                                                                                                                                                                        if (!var11_106 || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var112_105)) break block43;
                                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, true, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$20(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                                                                        break block23;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (var28_4 == null) break block44;
                                                                                                                                                                                    var113_107 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                    var114_108 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                    var10_109 = LogicalTypeRoot.VARCHAR.equals(var113_107) != false ? true : LogicalTypeRoot.CHAR.equals(var113_107) != false;
                                                                                                                                                                                    if (!var10_109 || !(var9_110 = LogicalTypeRoot.VARBINARY.equals(var114_108) != false ? true : LogicalTypeRoot.BINARY.equals(var114_108) != false)) break block44;
                                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$21(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                                    break block23;
                                                                                                                                                                                }
                                                                                                                                                                                if (var28_4 == null) break block45;
                                                                                                                                                                                var115_111 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                                var116_112 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                                if (!LogicalTypeRoot.BOOLEAN.equals(var115_111) || !LogicalTypeRoot.DECIMAL.equals(var116_112)) break block45;
                                                                                                                                                                                dt = (DecimalType)targetType;
                                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$22(org.apache.flink.table.types.logical.DecimalType java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DecimalType)dt));
                                                                                                                                                                                break block23;
                                                                                                                                                                            }
                                                                                                                                                                            if (var28_4 == null || !LogicalTypeRoot.BOOLEAN.equals(var118_114 = (LogicalTypeRoot)var28_4._1()) || !TypeCheckUtils.isNumeric((LogicalType)targetType)) break block46;
                                                                                                                                                                            targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$23(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)targetTypeTerm));
                                                                                                                                                                            break block23;
                                                                                                                                                                        }
                                                                                                                                                                        if (var28_4 == null) break block47;
                                                                                                                                                                        var120_116 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                        var121_117 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                        if (!LogicalTypeRoot.DECIMAL.equals(var120_116) || !LogicalTypeRoot.BOOLEAN.equals(var121_117)) break block47;
                                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$24(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                        break block23;
                                                                                                                                                                    }
                                                                                                                                                                    if (var28_4 == null) break block48;
                                                                                                                                                                    var122_118 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                                    var123_119 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                                    if (!LogicalTypeRoot.DECIMAL.equals(var122_118) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var123_119)) break block48;
                                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$25(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                    break block23;
                                                                                                                                                                }
                                                                                                                                                                if (var28_4 == null || !LogicalTypeRoot.BOOLEAN.equals(var124_120 = (LogicalTypeRoot)var28_4._2()) || !TypeCheckUtils.isNumeric((LogicalType)operand.resultType())) break block49;
                                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$26(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                                break block23;
                                                                                                                                                            }
                                                                                                                                                            if (var28_4 == null || !TypeCheckUtils.isNumeric((LogicalType)operand.resultType()) || !TypeCheckUtils.isNumeric((LogicalType)targetType)) break block50;
                                                                                                                                                            operandCasting = this.numericCasting(operand.resultType(), targetType);
                                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$27(scala.Function1 java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(operandCasting));
                                                                                                                                                            break block23;
                                                                                                                                                        }
                                                                                                                                                        if (var28_4 == null) break block51;
                                                                                                                                                        var126_122 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                        var127_123 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                        if (!LogicalTypeRoot.DATE.equals(var126_122) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var127_123)) break block51;
                                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$28(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                        break block23;
                                                                                                                                                    }
                                                                                                                                                    if (var28_4 == null) break block52;
                                                                                                                                                    var128_124 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                    var129_125 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var128_124) || !LogicalTypeRoot.DATE.equals(var129_125)) break block52;
                                                                                                                                                    targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$29(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)targetTypeTerm));
                                                                                                                                                    break block23;
                                                                                                                                                }
                                                                                                                                                if (var28_4 == null) break block53;
                                                                                                                                                var131_127 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                                var132_128 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var131_127) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var132_128)) break block53;
                                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$30(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                                                                break block23;
                                                                                                                                            }
                                                                                                                                            if (var28_4 == null) break block54;
                                                                                                                                            var133_129 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                            var134_130 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var133_129) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var134_130)) break block54;
                                                                                                                                            targetTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(targetType);
                                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$31(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((String)targetTypeTerm));
                                                                                                                                            break block23;
                                                                                                                                        }
                                                                                                                                        if (var28_4 == null) break block55;
                                                                                                                                        var136_132 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                        var137_133 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                        if (!LogicalTypeRoot.DATE.equals(var136_132) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var137_133)) break block55;
                                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$32(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                        break block23;
                                                                                                                                    }
                                                                                                                                    if (var28_4 == null) break block56;
                                                                                                                                    var138_134 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                    var139_135 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var138_134) || !LogicalTypeRoot.DATE.equals(var139_135)) break block56;
                                                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$33(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                    break block23;
                                                                                                                                }
                                                                                                                                if (var28_4 == null) break block57;
                                                                                                                                var140_136 = (LogicalTypeRoot)var28_4._1();
                                                                                                                                var141_137 = (LogicalTypeRoot)var28_4._2();
                                                                                                                                if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var140_136) || !LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var141_137)) break block57;
                                                                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$34(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                                break block23;
                                                                                                                            }
                                                                                                                            if (var28_4 == null) break block58;
                                                                                                                            var142_138 = (LogicalTypeRoot)var28_4._1();
                                                                                                                            var143_139 = (LogicalTypeRoot)var28_4._2();
                                                                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(var142_138) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var143_139)) break block58;
                                                                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$35(org.apache.flink.table.planner.codegen.CodeGeneratorContext java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((CodeGeneratorContext)ctx));
                                                                                                                            break block23;
                                                                                                                        }
                                                                                                                        if (var28_4 == null) break block59;
                                                                                                                        var144_140 = (LogicalTypeRoot)var28_4._1();
                                                                                                                        var145_141 = (LogicalTypeRoot)var28_4._2();
                                                                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var144_140) || !LogicalTypeRoot.DECIMAL.equals(var145_141)) break block59;
                                                                                                                        dt = (DecimalType)targetType;
                                                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$36(org.apache.flink.table.types.logical.DecimalType java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((DecimalType)dt));
                                                                                                                        break block23;
                                                                                                                    }
                                                                                                                    if (var28_4 == null) break block60;
                                                                                                                    var147_143 = (LogicalTypeRoot)var28_4._1();
                                                                                                                    var148_144 = (LogicalTypeRoot)var28_4._2();
                                                                                                                    if (!LogicalTypeRoot.TINYINT.equals(var147_143) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var148_144)) break block60;
                                                                                                                    var8_145 = true;
                                                                                                                    break block61;
                                                                                                                }
                                                                                                                if (var28_4 == null) break block62;
                                                                                                                var149_146 = (LogicalTypeRoot)var28_4._1();
                                                                                                                var150_147 = (LogicalTypeRoot)var28_4._2();
                                                                                                                if (!LogicalTypeRoot.SMALLINT.equals(var149_146) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var150_147)) break block62;
                                                                                                                var8_145 = true;
                                                                                                                break block61;
                                                                                                            }
                                                                                                            if (var28_4 == null) break block63;
                                                                                                            var151_148 = (LogicalTypeRoot)var28_4._1();
                                                                                                            var152_149 = (LogicalTypeRoot)var28_4._2();
                                                                                                            if (!LogicalTypeRoot.INTEGER.equals(var151_148) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var152_149)) break block63;
                                                                                                            var8_145 = true;
                                                                                                            break block61;
                                                                                                        }
                                                                                                        if (var28_4 == null) ** GOTO lbl-1000
                                                                                                        var153_150 = (LogicalTypeRoot)var28_4._1();
                                                                                                        var154_151 = (LogicalTypeRoot)var28_4._2();
                                                                                                        if (LogicalTypeRoot.BIGINT.equals(var153_150) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var154_151)) {
                                                                                                            var8_145 = true;
                                                                                                        } else lbl-1000:
                                                                                                        // 2 sources

                                                                                                        {
                                                                                                            var8_145 = false;
                                                                                                        }
                                                                                                    }
                                                                                                    if (!var8_145) break block64;
                                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$37(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                                    break block23;
                                                                                                }
                                                                                                if (var28_4 == null) break block65;
                                                                                                var155_152 = (LogicalTypeRoot)var28_4._1();
                                                                                                var156_153 = (LogicalTypeRoot)var28_4._2();
                                                                                                if (!LogicalTypeRoot.FLOAT.equals(var155_152) || !LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var156_153)) break block65;
                                                                                                var7_154 = true;
                                                                                                break block66;
                                                                                            }
                                                                                            if (var28_4 == null) ** GOTO lbl-1000
                                                                                            var157_155 = (LogicalTypeRoot)var28_4._1();
                                                                                            var158_156 = (LogicalTypeRoot)var28_4._2();
                                                                                            if (LogicalTypeRoot.DOUBLE.equals(var157_155) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var158_156)) {
                                                                                                var7_154 = true;
                                                                                            } else lbl-1000:
                                                                                            // 2 sources

                                                                                            {
                                                                                                var7_154 = false;
                                                                                            }
                                                                                        }
                                                                                        if (!var7_154) break block67;
                                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$38(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                        break block23;
                                                                                    }
                                                                                    if (var28_4 == null) break block68;
                                                                                    var159_157 = (LogicalTypeRoot)var28_4._1();
                                                                                    var160_158 = (LogicalTypeRoot)var28_4._2();
                                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var159_157) || !LogicalTypeRoot.TINYINT.equals(var160_158)) break block68;
                                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$39(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                    break block23;
                                                                                }
                                                                                if (var28_4 == null) break block69;
                                                                                var161_159 = (LogicalTypeRoot)var28_4._1();
                                                                                var162_160 = (LogicalTypeRoot)var28_4._2();
                                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var161_159) || !LogicalTypeRoot.SMALLINT.equals(var162_160)) break block69;
                                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$40(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                                break block23;
                                                                            }
                                                                            if (var28_4 == null) break block70;
                                                                            var163_161 = (LogicalTypeRoot)var28_4._1();
                                                                            var164_162 = (LogicalTypeRoot)var28_4._2();
                                                                            if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var163_161) || !LogicalTypeRoot.INTEGER.equals(var164_162)) break block70;
                                                                            var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$41(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                            break block23;
                                                                        }
                                                                        if (var28_4 == null) break block71;
                                                                        var165_163 = (LogicalTypeRoot)var28_4._1();
                                                                        var166_164 = (LogicalTypeRoot)var28_4._2();
                                                                        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var165_163) || !LogicalTypeRoot.BIGINT.equals(var166_164)) break block71;
                                                                        var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$42(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                        break block23;
                                                                    }
                                                                    if (var28_4 == null) break block72;
                                                                    var167_165 = (LogicalTypeRoot)var28_4._1();
                                                                    var168_166 = (LogicalTypeRoot)var28_4._2();
                                                                    if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var167_165) || !LogicalTypeRoot.FLOAT.equals(var168_166)) break block72;
                                                                    var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$43(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                    break block23;
                                                                }
                                                                if (var28_4 == null) break block73;
                                                                var169_167 = (LogicalTypeRoot)var28_4._1();
                                                                var170_168 = (LogicalTypeRoot)var28_4._2();
                                                                if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(var169_167) || !LogicalTypeRoot.DOUBLE.equals(var170_168)) break block73;
                                                                var4_16 = this.generateUnaryOperatorIfNotNull(ctx, targetType, operand, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$generateCast$44(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
                                                                break block23;
                                                            }
                                                            if (var28_4 == null) break block74;
                                                            var171_169 = (LogicalTypeRoot)var28_4._1();
                                                            var172_170 = (LogicalTypeRoot)var28_4._2();
                                                            if (!LogicalTypeRoot.DATE.equals(var171_169) || !LogicalTypeRoot.INTEGER.equals(var172_170)) break block74;
                                                            var6_171 = true;
                                                            break block75;
                                                        }
                                                        if (var28_4 == null) break block76;
                                                        var173_172 = (LogicalTypeRoot)var28_4._1();
                                                        var174_173 = (LogicalTypeRoot)var28_4._2();
                                                        if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var173_172) || !LogicalTypeRoot.INTEGER.equals(var174_173)) break block76;
                                                        var6_171 = true;
                                                        break block75;
                                                    }
                                                    if (var28_4 == null) break block77;
                                                    var175_174 = (LogicalTypeRoot)var28_4._1();
                                                    var176_175 = (LogicalTypeRoot)var28_4._2();
                                                    if (!LogicalTypeRoot.INTEGER.equals(var175_174) || !LogicalTypeRoot.DATE.equals(var176_175)) break block77;
                                                    var6_171 = true;
                                                    break block75;
                                                }
                                                if (var28_4 == null) break block78;
                                                var177_176 = (LogicalTypeRoot)var28_4._1();
                                                var178_177 = (LogicalTypeRoot)var28_4._2();
                                                if (!LogicalTypeRoot.INTEGER.equals(var177_176) || !LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var178_177)) break block78;
                                                var6_171 = true;
                                                break block75;
                                            }
                                            if (var28_4 == null) break block79;
                                            var179_178 = (LogicalTypeRoot)var28_4._1();
                                            var180_179 = (LogicalTypeRoot)var28_4._2();
                                            if (!LogicalTypeRoot.INTEGER.equals(var179_178) || !LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var180_179)) break block79;
                                            var6_171 = true;
                                            break block75;
                                        }
                                        if (var28_4 == null) break block80;
                                        var181_180 = (LogicalTypeRoot)var28_4._1();
                                        var182_181 = (LogicalTypeRoot)var28_4._2();
                                        if (!LogicalTypeRoot.BIGINT.equals(var181_180) || !LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var182_181)) break block80;
                                        var6_171 = true;
                                        break block75;
                                    }
                                    if (var28_4 == null) break block81;
                                    var183_182 = (LogicalTypeRoot)var28_4._1();
                                    var184_183 = (LogicalTypeRoot)var28_4._2();
                                    if (!LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var183_182) || !LogicalTypeRoot.INTEGER.equals(var184_183)) break block81;
                                    var6_171 = true;
                                    break block75;
                                }
                                if (var28_4 == null) ** GOTO lbl-1000
                                var185_184 = (LogicalTypeRoot)var28_4._1();
                                var186_185 = (LogicalTypeRoot)var28_4._2();
                                if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(var185_184) && LogicalTypeRoot.BIGINT.equals(var186_185)) {
                                    var6_171 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    var6_171 = false;
                                }
                            }
                            if (!var6_171) break block82;
                            var4_16 = this.internalExprCasting(operand, targetType);
                            break block23;
                        }
                        if (var28_4 == null) break block83;
                        var187_186 = (LogicalTypeRoot)var28_4._1();
                        var188_187 = (LogicalTypeRoot)var28_4._2();
                        if (!LogicalTypeRoot.DATE.equals(var187_186) || !LogicalTypeRoot.BIGINT.equals(var188_187)) break block83;
                        var5_188 = true;
                        break block84;
                    }
                    if (var28_4 == null) break block85;
                    var189_189 = (LogicalTypeRoot)var28_4._1();
                    var190_190 = (LogicalTypeRoot)var28_4._2();
                    if (!LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(var189_189) || !LogicalTypeRoot.BIGINT.equals(var190_190)) break block85;
                    var5_188 = true;
                    break block84;
                }
                if (var28_4 == null) ** GOTO lbl-1000
                var191_191 = (LogicalTypeRoot)var28_4._1();
                var192_192 = (LogicalTypeRoot)var28_4._2();
                if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(var191_191) && LogicalTypeRoot.BIGINT.equals(var192_192)) {
                    var5_188 = true;
                } else lbl-1000:
                // 2 sources

                {
                    var5_188 = false;
                }
            }
            if (var5_188) {
                var4_16 = this.internalExprCasting(operand, targetType);
            } else {
                if (var28_4 != null) {
                    from = (LogicalTypeRoot)var28_4._1();
                    to = (LogicalTypeRoot)var28_4._2();
                    throw new CodeGenException(new StringBuilder(31).append("Unsupported cast from '").append(from).append("' to '").append(to).append("'.").toString());
                }
                throw new MatchError((Object)var28_4);
            }
        }
        return var4_16;
    }

    public GeneratedExpression generateIfElse(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands, LogicalType resultType, int i) {
        GeneratedExpression generatedExpression;
        if (i == operands.size() - 1) {
            generatedExpression = this.generateCast(ctx, (GeneratedExpression)operands.apply(i), resultType);
        } else {
            CodeGenUtils$.MODULE$.requireBoolean((GeneratedExpression)operands.apply(i));
            GeneratedExpression condition = (GeneratedExpression)operands.apply(i);
            GeneratedExpression trueAction = this.generateCast(ctx, (GeneratedExpression)operands.apply(i + 1), resultType);
            GeneratedExpression falseAction = this.generateIfElse(ctx, operands, resultType, i + 2);
            Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError(seq);
            }
            String resultTerm = (String)((SeqLike)some.get()).apply(0);
            String nullTerm = (String)((SeqLike)some.get()).apply(1);
            Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
            Tuple2 tuple22 = tuple2;
            String resultTerm2 = (String)tuple22._1();
            String nullTerm2 = (String)tuple22._2();
            String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
            String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
            String operatorCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n           |").append(condition.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n           |boolean ").append(nullTerm2).append(";\n           |if (").append(condition.resultTerm()).append(") {\n           |  ").append(trueAction.code()).append("\n           |  ").append(nullTerm2).append(" = ").append(trueAction.nullTerm()).append(";\n           |  if (!").append(nullTerm2).append(") {\n           |    ").append(resultTerm2).append(" = ").append(trueAction.resultTerm()).append(";\n           |  }\n           |}\n           |else {\n           |  ").append(falseAction.code()).append("\n           |  ").append(nullTerm2).append(" = ").append(falseAction.nullTerm()).append(";\n           |  if (!").append(nullTerm2).append(") {\n           |    ").append(resultTerm2).append(" = ").append(falseAction.resultTerm()).append(";\n           |  }\n           |}\n           |").toString())).stripMargin().trim() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(176).append("\n           |").append(condition.code()).append("\n           |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n           |if (").append(condition.resultTerm()).append(") {\n           |  ").append(trueAction.code()).append("\n           |  ").append(resultTerm2).append(" = ").append(trueAction.resultTerm()).append(";\n           |}\n           |else {\n           |  ").append(falseAction.code()).append("\n           |  ").append(resultTerm2).append(" = ").append(falseAction.resultTerm()).append(";\n           |}\n           |").toString())).stripMargin().trim();
            generatedExpression = new GeneratedExpression(resultTerm2, nullTerm2, operatorCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
        }
        return generatedExpression;
    }

    public int generateIfElse$default$4() {
        return 0;
    }

    public GeneratedExpression generateDot(CodeGeneratorContext ctx, Seq<GeneratedExpression> operands) {
        if (operands.size() > 2) {
            throw new CodeGenException("A DOT operator with more than 2 operands is not supported yet.");
        }
        Preconditions.checkArgument((boolean)((GeneratedExpression)operands.apply(1)).literal());
        Preconditions.checkArgument((boolean)TypeCheckUtils.isCharacterString((LogicalType)((GeneratedExpression)operands.apply(1)).resultType()));
        Preconditions.checkArgument((boolean)(((GeneratedExpression)operands.head()).resultType() instanceof RowType));
        String fieldName = ((GeneratedExpression)operands.apply(1)).literalValue().get().toString();
        int fieldIdx = ((RowType)((GeneratedExpression)operands.head()).resultType()).getFieldIndex(fieldName);
        GeneratedExpression access = GenerateUtils$.MODULE$.generateFieldAccess(ctx, ((GeneratedExpression)operands.head()).resultType(), ((GeneratedExpression)operands.head()).resultTerm(), fieldIdx);
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(access.resultType());
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(access.resultType());
        String resultCode = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n         |boolean ").append(nullTerm2).append(";\n         |if (").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.nullTerm(), Seq$.MODULE$.canBuildFrom())).mkString(" || ")).append(") {\n         |  ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |  ").append(nullTerm2).append(" = true;\n         |}\n         |else {\n         |  ").append(access.code()).append("\n         |  ").append(resultTerm2).append(" = ").append(access.resultTerm()).append(";\n         |  ").append(nullTerm2).append(" = ").append(access.nullTerm()).append(";\n         |}\n         |").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(49).append("\n         |").append(((TraversableOnce)operands.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.code(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).append("\n         |").append(access.code()).append("\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(access.resultTerm()).append(";\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, resultCode, access.resultType(), GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateRow(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        Preconditions.checkArgument((boolean)(resultType instanceof RowType));
        RowType rowType = (RowType)resultType;
        List fieldTypes = rowType.getChildren();
        boolean isLiteral = elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal()));
        boolean isPrimitive = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScalarOperatorGens$.$anonfun$generateRow$2(x$1)));
        if (isLiteral) {
            generatedExpression = this.generateLiteralRow(ctx, rowType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GeneratedExpression generatedExpression;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    GeneratedExpression element = (GeneratedExpression)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    if (element.literal()) {
                        generatedExpression = element;
                    } else {
                        LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
                        String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(tpe);
                        generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), tpe, (Option<Object>)new Some(null));
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                GeneratedExpression generatedExpression2 = generatedExpression;
                return generatedExpression2;
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression row = this.generateLiteralRow(ctx, rowType, (Seq<GeneratedExpression>)mapped);
            String code = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                GeneratedExpression element = (GeneratedExpression)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                LogicalType tpe = (LogicalType)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldTypes).apply(idx);
                String string = element.literal() ? "" : (ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n               |").append(element.code()).append("\n               |if (").append(element.nullTerm()).append(") {\n               |  ").append(CodeGenUtils$.MODULE$.binaryRowSetNull(idx, row.resultTerm(), tpe)).append(";\n               |} else {\n               |  ").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, row.resultTerm(), tpe, element.resultTerm())).append(";\n               |}\n           ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(47).append("\n               |").append(element.code()).append("\n               |").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, row.resultTerm(), tpe, element.resultTerm())).append(";\n           ").toString())).stripMargin());
                return string;
            }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
            generatedExpression = new GeneratedExpression(row.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)rowType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralRow(ctx, rowType, elements);
        }
        return generatedExpression;
    }

    private GeneratedExpression generateLiteralRow(CodeGeneratorContext ctx, RowType rowType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal())));
        GeneratedExpression expr = this.generateNonLiteralRow(ctx, rowType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), (LogicalType)rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralRow(CodeGeneratorContext ctx, RowType rowType, Seq<GeneratedExpression> elements) {
        String rowTerm = CodeGenUtils$.MODULE$.newName("row");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryRowWriter.class));
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            LogicalType tpe = rowType.getTypeAt(idx);
            String string = ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(124).append("\n             |").append(element.code()).append("\n             |if (").append(element.nullTerm()).append(") {\n             |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteNull(idx, writerTerm, tpe)).append(";\n             |} else {\n             |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, tpe)).append(";\n             |}\n           ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(43).append("\n             |").append(element.code()).append("\n             |").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, tpe)).append(";\n           ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(62).append("\n         |").append(writerTerm).append(".reset();\n         |").append(writeCode).append("\n         |").append(writerTerm).append(".complete();\n       ").toString())).stripMargin();
        ctx.addReusableMember(new StringBuilder(11).append(CodeGenUtils$.MODULE$.BINARY_ROW()).append(" ").append(rowTerm).append(" = new ").append(CodeGenUtils$.MODULE$.BINARY_ROW()).append("(").append(rowType.getFieldCount()).append(");").toString());
        ctx.addReusableMember(new StringBuilder(11).append(writerCls).append(" ").append(writerTerm).append(" = new ").append(writerCls).append("(").append(rowTerm).append(");").toString());
        return new GeneratedExpression(rowTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)rowType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArray(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        GeneratedExpression generatedExpression;
        Preconditions.checkArgument((boolean)(resultType instanceof ArrayType));
        ArrayType arrayType = (ArrayType)resultType;
        LogicalType elementType = arrayType.getElementType();
        boolean isLiteral = elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal()));
        boolean isPrimitive = PlannerTypeUtils.isPrimitive((LogicalType)elementType);
        if (isLiteral) {
            generatedExpression = this.generateLiteralArray(ctx, arrayType, elements);
        } else if (isPrimitive) {
            Seq mapped = (Seq)elements.map((Function1 & Serializable & scala.Serializable)element -> {
                GeneratedExpression generatedExpression;
                if (element.literal()) {
                    generatedExpression = element;
                } else {
                    String resultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
                    generatedExpression = new GeneratedExpression(resultTerm, GeneratedExpression$.MODULE$.ALWAYS_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), elementType, (Option<Object>)new Some(null));
                }
                return generatedExpression;
            }, Seq$.MODULE$.canBuildFrom());
            GeneratedExpression array = this.generateLiteralArray(ctx, arrayType, (Seq<GeneratedExpression>)mapped);
            String code = this.generatePrimitiveArrayUpdateCode(ctx, array.resultTerm(), elementType, elements);
            generatedExpression = new GeneratedExpression(array.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
        } else {
            generatedExpression = this.generateNonLiteralArray(ctx, arrayType, elements);
        }
        return generatedExpression;
    }

    private String generatePrimitiveArrayUpdateCode(CodeGeneratorContext ctx, String arrayTerm, LogicalType elementType, Seq<GeneratedExpression> elements) {
        return ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = element.literal() ? "" : (ctx.nullCheck() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n           |").append(element.code()).append("\n           |if (").append(element.nullTerm()).append(") {\n           |  ").append(CodeGenUtils$.MODULE$.binaryArraySetNull(idx, arrayTerm, elementType)).append(";\n           |} else {\n           |  ").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, arrayTerm, elementType, element.resultTerm())).append(";\n           |}\n             ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n           |").append(element.code()).append("\n           |").append(CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, arrayTerm, elementType, element.resultTerm())).append(";\n             ").toString())).stripMargin());
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    private GeneratedExpression generateLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        Preconditions.checkArgument((boolean)elements.forall((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)e.literal())));
        GeneratedExpression expr = this.generateNonLiteralArray(ctx, arrayType, elements);
        ctx.addReusableInitStatement(expr.code());
        return new GeneratedExpression(expr.resultTerm(), GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    private GeneratedExpression generateNonLiteralArray(CodeGeneratorContext ctx, ArrayType arrayType, Seq<GeneratedExpression> elements) {
        LogicalType elementType = arrayType.getElementType();
        String arrayTerm = CodeGenUtils$.MODULE$.newName("array");
        String writerTerm = CodeGenUtils$.MODULE$.newName("writer");
        String writerCls = CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(BinaryArrayWriter.class));
        int elementSize = BinaryArray.calculateFixLengthPartSize((LogicalType)elementType);
        String writeCode = ((TraversableOnce)((TraversableLike)elements.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GeneratedExpression element = (GeneratedExpression)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n           |").append(element.code()).append("\n           |if (").append(element.nullTerm()).append(") {\n           |  ").append(CodeGenUtils$.MODULE$.binaryArraySetNull(idx, writerTerm, elementType)).append(";\n           |} else {\n           |  ").append(CodeGenUtils$.MODULE$.binaryWriterWriteField(ctx, idx, element.resultTerm(), writerTerm, elementType)).append(";\n           |}\n          ").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(64).append("\n         |").append(writerTerm).append(".reset();\n         |").append(writeCode).append("\n         |").append(writerTerm).append(".complete();\n         ").toString())).stripMargin();
        String memberStmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(56).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(arrayTerm).append(" = new ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append("();\n         |").append(writerCls).append(" ").append(writerTerm).append(" = new ").append(writerCls).append("(").append(arrayTerm).append(", ").append(elements.length()).append(", ").append(elementSize).append(");\n       ").toString())).stripMargin();
        ctx.addReusableMember(memberStmt);
        return new GeneratedExpression(arrayTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, (LogicalType)arrayType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElementAt(CodeGeneratorContext ctx, GeneratedExpression array, GeneratedExpression index) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        LogicalType componentInfo = ((ArrayType)array.resultType()).getElementType();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(componentInfo);
        String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(componentInfo);
        String idxStr = new StringBuilder(4).append(index.resultTerm()).append(" - 1").toString();
        String arrayIsNull = new StringBuilder(11).append(array.resultTerm()).append(".isNullAt(").append(idxStr).append(")").toString();
        String arrayGet = CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, idxStr, array.resultTerm(), componentInfo);
        String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(86).append("\n         |").append(array.code()).append("\n         |").append(index.code()).append("\n         |boolean ").append(nullTerm2).append(" = ").append(array.nullTerm()).append(" || ").append(index.nullTerm()).append(" || ").append(arrayIsNull).append(";\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(" = ").append(nullTerm2).append(" ? ").append(defaultTerm).append(" : ").append(arrayGet).append(";\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, componentInfo, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayElement(CodeGeneratorContext ctx, GeneratedExpression array) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        LogicalType resultType = ((ArrayType)array.resultType()).getElementType();
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        String defaultValue = CodeGenUtils$.MODULE$.primitiveDefaultValue(resultType);
        String arrayLengthCode = new StringBuilder(21).append(array.nullTerm()).append(" ? 0 : ").append(array.resultTerm()).append(".numElements()").toString();
        String arrayGet = CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, 0, array.resultTerm(), resultType);
        String arrayAccessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(368).append("\n         |").append(array.code()).append("\n         |boolean ").append(nullTerm2).append(";\n         |").append(resultTypeTerm).append(" ").append(resultTerm2).append(";\n         |switch (").append(arrayLengthCode).append(") {\n         |  case 0:\n         |    ").append(nullTerm2).append(" = true;\n         |    ").append(resultTerm2).append(" = ").append(defaultValue).append(";\n         |    break;\n         |  case 1:\n         |    ").append(nullTerm2).append(" = ").append(array.resultTerm()).append(".isNullAt(0);\n         |    ").append(resultTerm2).append(" = ").append(nullTerm2).append(" ? ").append(defaultValue).append(" : ").append(arrayGet).append(";\n         |    break;\n         |  default:\n         |    throw new RuntimeException(\"Array has more than one element.\");\n         |}\n         |").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, arrayAccessCode, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateArrayCardinality(CodeGeneratorContext ctx, GeneratedExpression array) {
        return this.generateUnaryOperatorIfNotNull(ctx, (LogicalType)new IntType(), array, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$14 -> new StringBuilder(14).append(array.resultTerm()).append(".numElements()").toString());
    }

    public GeneratedExpression generateMap(CodeGeneratorContext ctx, LogicalType resultType, Seq<GeneratedExpression> elements) {
        String string;
        Preconditions.checkArgument((boolean)(resultType instanceof MapType));
        MapType mapType = (MapType)resultType;
        String baseMap = CodeGenUtils$.MODULE$.newName("map");
        Seq keyElements = elements.grouped(2).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            GeneratedExpression key;
            Seq seq = x0$6;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            GeneratedExpression generatedExpression = key = (GeneratedExpression)((SeqLike)some.get()).apply(0);
            return generatedExpression;
        }).toSeq();
        LogicalType keyType = mapType.getKeyType();
        GeneratedExpression keyExpr = this.generateArray(ctx, (LogicalType)new ArrayType(keyType), (Seq<GeneratedExpression>)keyElements);
        boolean isKeyFixLength = PlannerTypeUtils.isPrimitive((LogicalType)keyType);
        Seq valueElements = elements.grouped(2).map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            GeneratedExpression value;
            Seq seq = x0$7;
            Some some = Seq$.MODULE$.unapplySeq(seq);
            if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
                throw new MatchError((Object)seq);
            }
            GeneratedExpression generatedExpression = value = (GeneratedExpression)((SeqLike)some.get()).apply(1);
            return generatedExpression;
        }).toSeq();
        LogicalType valueType = mapType.getValueType();
        GeneratedExpression valueExpr = this.generateArray(ctx, (LogicalType)new ArrayType(valueType), (Seq<GeneratedExpression>)valueElements);
        boolean isValueFixLength = PlannerTypeUtils.isPrimitive((LogicalType)valueType);
        ctx.addReusableMember(new StringBuilder(9).append(CodeGenUtils$.MODULE$.BASE_MAP()).append(" ").append(baseMap).append(" = null;").toString());
        if (isKeyFixLength && isValueFixLength) {
            String binaryMap = CodeGenUtils$.MODULE$.newName("binaryMap");
            ctx.addReusableMember(new StringBuilder(9).append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(" ").append(binaryMap).append(" = null;").toString());
            String init = new StringBuilder(16).append(binaryMap).append(" = ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(".valueOf(").append(keyExpr.resultTerm()).append(", ").append(valueExpr.resultTerm()).append(");").toString();
            ctx.addReusableInitStatement(init);
            String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
            String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
            String keyUpdate = this.generatePrimitiveArrayUpdateCode(ctx, keyArrayTerm, keyType, (Seq<GeneratedExpression>)keyElements);
            String valueUpdate = this.generatePrimitiveArrayUpdateCode(ctx, valueArrayTerm, valueType, (Seq<GeneratedExpression>)valueElements);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(101).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(keyArrayTerm).append(" = ").append(binaryMap).append(".keyArray();\n         |").append(keyUpdate).append("\n         |").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(valueArrayTerm).append(" = ").append(binaryMap).append(".valueArray();\n         |").append(valueUpdate).append("\n         |").append(baseMap).append(" = ").append(binaryMap).append(";\n       ").toString())).stripMargin();
        } else {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n         |").append(keyExpr.code()).append("\n         |").append(valueExpr.code()).append("\n         |").append(baseMap).append(" = ").append(CodeGenUtils$.MODULE$.BINARY_MAP()).append(".valueOf(").append(keyExpr.resultTerm()).append(", ").append(valueExpr.resultTerm()).append(");\n       ").toString())).stripMargin();
        }
        String code = string;
        return new GeneratedExpression(baseMap, GeneratedExpression$.MODULE$.NEVER_NULL(), code, resultType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapGet(CodeGeneratorContext ctx, GeneratedExpression map, GeneratedExpression key) {
        Seq<String> seq = CodeGenUtils$.MODULE$.newNames((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"result", "isNull"}));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new MatchError(seq);
        }
        String resultTerm = (String)((SeqLike)some.get()).apply(0);
        String nullTerm = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)resultTerm, (Object)nullTerm);
        Tuple2 tuple22 = tuple2;
        String resultTerm2 = (String)tuple22._1();
        String nullTerm2 = (String)tuple22._2();
        String tmpKey = CodeGenUtils$.MODULE$.newName("key");
        String length = CodeGenUtils$.MODULE$.newName("length");
        String keys = CodeGenUtils$.MODULE$.newName("keys");
        String values = CodeGenUtils$.MODULE$.newName("values");
        String index = CodeGenUtils$.MODULE$.newName("index");
        String found = CodeGenUtils$.MODULE$.newName("found");
        String tmpValue = CodeGenUtils$.MODULE$.newName("value");
        MapType mapType = (MapType)map.resultType();
        LogicalType keyType = mapType.getKeyType();
        LogicalType valueType = mapType.getValueType();
        String keyTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
        String valueTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
        String valueDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType);
        String binaryMapTypeTerm = BinaryMap.class.getCanonicalName();
        String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
        String genericMapTypeTerm = GenericMap.class.getCanonicalName();
        String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
        String boxedValueTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(valueType);
        String mapTerm = map.resultTerm();
        GeneratedExpression equal = this.generateEquals(ctx, key, new GeneratedExpression(tmpKey, GeneratedExpression$.MODULE$.NEVER_NULL(), GeneratedExpression$.MODULE$.NO_CODE(), keyType, GeneratedExpression$.MODULE$.apply$default$5()));
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1002).append("\n         |if (").append(mapTerm).append(" instanceof ").append(binaryMapTypeTerm).append(") {\n         |  ").append(binaryMapTypeTerm).append(" ").append(binaryMapTerm).append(" = (").append(binaryMapTypeTerm).append(") ").append(mapTerm).append(";\n         |  final int ").append(length).append(" = ").append(binaryMapTerm).append(".numElements();\n         |  final ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(keys).append(" = ").append(binaryMapTerm).append(".keyArray();\n         |  final ").append(CodeGenUtils$.MODULE$.BINARY_ARRAY()).append(" ").append(values).append(" = ").append(binaryMapTerm).append(".valueArray();\n         |\n         |  int ").append(index).append(" = 0;\n         |  boolean ").append(found).append(" = false;\n         |  if (").append(key.nullTerm()).append(") {\n         |    while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n         |      if (").append(keys).append(".isNullAt(").append(index).append(")) {\n         |        ").append(found).append(" = true;\n         |      } else {\n         |        ").append(index).append("++;\n         |      }\n         |    }\n         |  } else {\n         |    while (").append(index).append(" < ").append(length).append(" && !").append(found).append(") {\n         |      final ").append(keyTypeTerm).append(" ").append(tmpKey).append(" = ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, index, keys, keyType)).append(";\n         |      ").append(equal.code()).append("\n         |      if (").append(equal.resultTerm()).append(") {\n         |        ").append(found).append(" = true;\n         |      } else {\n         |        ").append(index).append("++;\n         |      }\n         |    }\n         |  }\n         |\n         |  if (!").append(found).append(" || ").append(values).append(".isNullAt(").append(index).append(")) {\n         |    ").append(nullTerm2).append(" = true;\n         |  } else {\n         |    ").append(resultTerm2).append(" = ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, index, values, valueType)).append(";\n         |  }\n         |} else {\n         |  ").append(genericMapTypeTerm).append(" ").append(genericMapTerm).append(" = (").append(genericMapTypeTerm).append(") ").append(mapTerm).append(";\n         |  ").append(boxedValueTypeTerm).append(" ").append(tmpValue).append(" =\n         |    (").append(boxedValueTypeTerm).append(") ").append(genericMapTerm).append(".get((").append(keyTypeTerm).append(") ").append(key.resultTerm()).append(");\n         |  if (").append(tmpValue).append(" == null) {\n         |    ").append(nullTerm2).append(" = true;\n         |  } else {\n         |    ").append(resultTerm2).append(" = ").append(tmpValue).append(";\n         |  }\n         |}\n        ").toString())).stripMargin();
        String accessCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(119).append("\n         |").append(map.code()).append("\n         |").append(key.code()).append("\n         |boolean ").append(nullTerm2).append(" = (").append(map.nullTerm()).append(" || ").append(key.nullTerm()).append(");\n         |").append(valueTypeTerm).append(" ").append(resultTerm2).append(" = ").append(valueDefault).append(";\n         |if (!").append(nullTerm2).append(") {\n         | ").append(code).append("\n         |}\n        ").toString())).stripMargin();
        return new GeneratedExpression(resultTerm2, nullTerm2, accessCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedExpression generateMapCardinality(CodeGeneratorContext ctx, GeneratedExpression map) {
        return this.generateUnaryOperatorIfNotNull(ctx, (LogicalType)new IntType(), map, this.generateUnaryOperatorIfNotNull$default$4(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$16 -> new StringBuilder(14).append(map.resultTerm()).append(".numElements()").toString());
    }

    private GeneratedExpression generateCastStringLiteralToDateTime(CodeGeneratorContext ctx, GeneratedExpression stringLiteral, LogicalType expectType) {
        Preconditions.checkArgument((boolean)stringLiteral.literal());
        String rightTerm = stringLiteral.resultTerm();
        String typeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(expectType);
        String defaultTerm = CodeGenUtils$.MODULE$.primitiveDefaultValue(expectType);
        String term = CodeGenUtils$.MODULE$.newName("stringToTime");
        String code = this.stringToLocalTimeCode(expectType, rightTerm);
        String stmt = new StringBuilder(11).append(typeTerm).append(" ").append(term).append(" = ").append(stringLiteral.nullTerm()).append(" ? ").append(defaultTerm).append(" : ").append(code).append(";").toString();
        ctx.addReusableMember(stmt);
        LogicalType x$42 = expectType;
        String x$43 = term;
        String x$44 = stringLiteral.copy$default$2();
        String x$45 = stringLiteral.copy$default$3();
        Option<Object> x$46 = stringLiteral.copy$default$5();
        return stringLiteral.copy(x$43, x$44, x$45, x$42, x$46);
    }

    private GeneratedExpression generateCastArrayToString(CodeGeneratorContext ctx, GeneratedExpression operand, ArrayType at) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)terms -> {
            String builderCls = StringBuilder.class.getCanonicalName();
            String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
            ctx.addReusableMember(new StringBuilder(11).append(builderCls).append(" ").append(builderTerm).append(" = new ").append(builderCls).append("();").toString());
            String arrayTerm = (String)terms.head();
            String indexTerm = CodeGenUtils$.MODULE$.newName("i");
            String numTerm = CodeGenUtils$.MODULE$.newName("num");
            LogicalType elementType = at.getElementType();
            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
            String elementTerm = CodeGenUtils$.MODULE$.newName("element");
            String elementNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String elementCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n             |").append(elementCls).append(" ").append(elementTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType)).append(";\n             |boolean ").append(elementNullTerm).append(" = ").append(arrayTerm).append(".isNullAt(").append(indexTerm).append(");\n             |if (!").append(elementNullTerm).append(") {\n             |  ").append(elementTerm).append(" = (").append(elementCls).append(") ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, indexTerm, arrayTerm, elementType)).append(";\n             |}\n             ").toString())).stripMargin();
            GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, elementNullTerm, elementCode, elementType, GeneratedExpression$.MODULE$.apply$default$5());
            GeneratedExpression castExpr = MODULE$.generateCast(ctx, elementExpr, (LogicalType)new VarCharType(Integer.MAX_VALUE));
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(435).append("\n             |").append(builderTerm).append(".setLength(0);\n             |").append(builderTerm).append(".append(\"[\");\n             |int ").append(numTerm).append(" = ").append(arrayTerm).append(".numElements();\n             |for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(numTerm).append("; ").append(indexTerm).append("++) {\n             |  if (").append(indexTerm).append(" != 0) {\n             |    ").append(builderTerm).append(".append(\", \");\n             |  }\n             |\n             |  ").append(castExpr.code()).append("\n             |  if (").append(castExpr.nullTerm()).append(") {\n             |    ").append(builderTerm).append(".append(\"null\");\n             |  } else {\n             |    ").append(builderTerm).append(".append(").append(castExpr.resultTerm()).append(");\n             |  }\n             |}\n             |").append(builderTerm).append(".append(\"]\");\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)new StringBuilder(11).append(builderTerm).append(".toString()").toString());
        });
    }

    private GeneratedExpression generateCastMapToString(CodeGeneratorContext ctx, GeneratedExpression operand, MapType mt) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)terms -> {
            String resultTerm = CodeGenUtils$.MODULE$.newName("toStringResult");
            String builderCls = StringBuilder.class.getCanonicalName();
            String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
            ctx.addReusableMember(new StringBuilder(11).append(builderCls).append(" ").append(builderTerm).append(" = new ").append(builderCls).append("();").toString());
            String mapTerm = (String)terms.head();
            String genericMapCls = GenericMap.class.getCanonicalName();
            String genericMapTerm = CodeGenUtils$.MODULE$.newName("genericMap");
            String binaryMapCls = BinaryMap.class.getCanonicalName();
            String binaryMapTerm = CodeGenUtils$.MODULE$.newName("binaryMap");
            String arrayCls = BaseArray.class.getCanonicalName();
            String keyArrayTerm = CodeGenUtils$.MODULE$.newName("keyArray");
            String valueArrayTerm = CodeGenUtils$.MODULE$.newName("valueArray");
            String indexTerm = CodeGenUtils$.MODULE$.newName("i");
            String numTerm = CodeGenUtils$.MODULE$.newName("num");
            LogicalType keyType = mt.getKeyType();
            String keyCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(keyType);
            String keyTerm = CodeGenUtils$.MODULE$.newName("key");
            String keyNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String keyCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n             |").append(keyCls).append(" ").append(keyTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(keyType)).append(";\n             |boolean ").append(keyNullTerm).append(" = ").append(keyArrayTerm).append(".isNullAt(").append(indexTerm).append(");\n             |if (!").append(keyNullTerm).append(") {\n             |  ").append(keyTerm).append(" = (").append(keyCls).append(") ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, indexTerm, keyArrayTerm, keyType)).append(";\n             |}\n             ").toString())).stripMargin();
            GeneratedExpression keyExpr = new GeneratedExpression(keyTerm, keyNullTerm, keyCode, keyType, GeneratedExpression$.MODULE$.apply$default$5());
            GeneratedExpression keyCastExpr = MODULE$.generateCast(ctx, keyExpr, (LogicalType)new VarCharType(Integer.MAX_VALUE));
            LogicalType valueType = mt.getValueType();
            String valueCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(valueType);
            String valueTerm = CodeGenUtils$.MODULE$.newName("value");
            String valueNullTerm = CodeGenUtils$.MODULE$.newName("isNull");
            String valueCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(135).append("\n             |").append(valueCls).append(" ").append(valueTerm).append(" = ").append(CodeGenUtils$.MODULE$.primitiveDefaultValue(valueType)).append(";\n             |boolean ").append(valueNullTerm).append(" = ").append(valueArrayTerm).append(".isNullAt(").append(indexTerm).append(");\n             |if (!").append(valueNullTerm).append(") {\n             |  ").append(valueTerm).append(" = (").append(valueCls).append(") ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, indexTerm, valueArrayTerm, valueType)).append(";\n             |}\n             ").toString())).stripMargin();
            GeneratedExpression valueExpr = new GeneratedExpression(valueTerm, valueNullTerm, valueCode, valueType, GeneratedExpression$.MODULE$.apply$default$5());
            GeneratedExpression valueCastExpr = MODULE$.generateCast(ctx, valueExpr, (LogicalType)new VarCharType(Integer.MAX_VALUE));
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(995).append("\n             |String ").append(resultTerm).append(";\n             |if (").append(mapTerm).append(" instanceof ").append(binaryMapCls).append(") {\n             |  ").append(binaryMapCls).append(" ").append(binaryMapTerm).append(" = (").append(binaryMapCls).append(") ").append(mapTerm).append(";\n             |  ").append(arrayCls).append(" ").append(keyArrayTerm).append(" = ").append(binaryMapTerm).append(".keyArray();\n             |  ").append(arrayCls).append(" ").append(valueArrayTerm).append(" = ").append(binaryMapTerm).append(".valueArray();\n             |\n             |  ").append(builderTerm).append(".setLength(0);\n             |  ").append(builderTerm).append(".append(\"{\");\n             |\n             |  int ").append(numTerm).append(" = ").append(binaryMapTerm).append(".numElements();\n             |  for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(numTerm).append("; ").append(indexTerm).append("++) {\n             |    if (").append(indexTerm).append(" != 0) {\n             |      ").append(builderTerm).append(".append(\", \");\n             |    }\n             |\n             |    ").append(keyCastExpr.code()).append("\n             |    if (").append(keyCastExpr.nullTerm()).append(") {\n             |      ").append(builderTerm).append(".append(\"null\");\n             |    } else {\n             |      ").append(builderTerm).append(".append(").append(keyCastExpr.resultTerm()).append(");\n             |    }\n             |    ").append(builderTerm).append(".append(\"=\");\n             |\n             |    ").append(valueCastExpr.code()).append("\n             |    if (").append(valueCastExpr.nullTerm()).append(") {\n             |      ").append(builderTerm).append(".append(\"null\");\n             |    } else {\n             |      ").append(builderTerm).append(".append(").append(valueCastExpr.resultTerm()).append(");\n             |    }\n             |  }\n             |  ").append(builderTerm).append(".append(\"}\");\n             |\n             |  ").append(resultTerm).append(" = ").append(builderTerm).append(".toString();\n             |} else {\n             |  ").append(genericMapCls).append(" ").append(genericMapTerm).append(" = (").append(genericMapCls).append(") ").append(mapTerm).append(";\n             |  ").append(resultTerm).append(" = ").append(genericMapTerm).append(".toString();\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateCastBaseRowToString(CodeGeneratorContext ctx, GeneratedExpression operand, RowType brt) {
        return GenerateUtils$.MODULE$.generateStringResultCallWithStmtIfArgsNotNull(ctx, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)terms -> {
            String builderCls = StringBuilder.class.getCanonicalName();
            String builderTerm = CodeGenUtils$.MODULE$.newName("builder");
            ctx.addReusableMember(new StringBuilder(11).append(builderCls).append(" ").append(builderTerm).append(" = new ").append(builderCls).append("();").toString());
            String rowTerm = (String)terms.head();
            String appendCode = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(brt.getChildren()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                Tuple2 tuple2 = x0$8;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                LogicalType elementType = (LogicalType)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
                String elementTerm = CodeGenUtils$.MODULE$.newName("element");
                GeneratedExpression elementExpr = new GeneratedExpression(elementTerm, new StringBuilder(11).append(rowTerm).append(".isNullAt(").append(idx).append(")").toString(), new StringBuilder(8).append(elementCls).append(" ").append(elementTerm).append(" = (").append(elementCls).append(") ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, idx, rowTerm, elementType)).append(";").toString(), elementType, GeneratedExpression$.MODULE$.apply$default$5());
                GeneratedExpression castExpr = MODULE$.generateCast(ctx, elementExpr, (LogicalType)new VarCharType(Integer.MAX_VALUE));
                String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(181).append("\n               |").append((Object)(idx != 0 ? new StringBuilder(13).append(builderTerm).append(".append(\",\");").toString() : "")).append("\n               |").append(castExpr.code()).append("\n               |if (").append(castExpr.nullTerm()).append(") {\n               |  ").append(builderTerm).append(".append(\"null\");\n               |} else {\n               |  ").append(builderTerm).append(".append(").append(castExpr.resultTerm()).append(");\n               |}\n               ").toString())).stripMargin();
                return string;
            }, Buffer$.MODULE$.canBuildFrom())).mkString("\n");
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n             |").append(builderTerm).append(".setLength(0);\n             |").append(builderTerm).append(".append(\"(\");\n             |").append(appendCode).append("\n             |").append(builderTerm).append(".append(\")\");\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)new StringBuilder(11).append(builderTerm).append(".toString()").toString());
        });
    }

    private GeneratedExpression generateArrayComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, (LogicalType)new BooleanType(), (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            String leftTerm = (String)args.head();
            String rightTerm = (String)args.apply(1);
            String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
            String binaryArrayCls = BinaryArray.class.getCanonicalName();
            LogicalType elementType = ((ArrayType)left.resultType()).getElementType();
            String elementCls = CodeGenUtils$.MODULE$.primitiveTypeTermForType(elementType);
            String elementDefault = CodeGenUtils$.MODULE$.primitiveDefaultValue(elementType);
            String leftElementTerm = CodeGenUtils$.MODULE$.newName("leftElement");
            String leftElementNullTerm = CodeGenUtils$.MODULE$.newName("leftElementIsNull");
            GeneratedExpression leftElementExpr = new GeneratedExpression(leftElementTerm, leftElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
            String rightElementTerm = CodeGenUtils$.MODULE$.newName("rightElement");
            String rightElementNullTerm = CodeGenUtils$.MODULE$.newName("rightElementIsNull");
            GeneratedExpression rightElementExpr = new GeneratedExpression(rightElementTerm, rightElementNullTerm, "", elementType, GeneratedExpression$.MODULE$.apply$default$5());
            String indexTerm = CodeGenUtils$.MODULE$.newName("index");
            GeneratedExpression elementEqualsExpr = MODULE$.generateEquals(ctx, leftElementExpr, rightElementExpr);
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(896).append("\n             |boolean ").append(resultTerm).append(";\n             |if (").append(leftTerm).append(" instanceof ").append(binaryArrayCls).append(" && ").append(rightTerm).append(" instanceof ").append(binaryArrayCls).append(") {\n             |  ").append(resultTerm).append(" = ").append(leftTerm).append(".equals(").append(rightTerm).append(");\n             |} else {\n             |  if (").append(leftTerm).append(".numElements() == ").append(rightTerm).append(".numElements()) {\n             |    ").append(resultTerm).append(" = true;\n             |    for (int ").append(indexTerm).append(" = 0; ").append(indexTerm).append(" < ").append(leftTerm).append(".numElements(); ").append(indexTerm).append("++) {\n             |      ").append(elementCls).append(" ").append(leftElementTerm).append(" = ").append(elementDefault).append(";\n             |      boolean ").append(leftElementNullTerm).append(" = ").append(leftTerm).append(".isNullAt(").append(indexTerm).append(");\n             |      if (!").append(leftElementNullTerm).append(") {\n             |        ").append(leftElementTerm).append(" =\n             |          ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, indexTerm, leftTerm, elementType)).append(";\n             |      }\n             |\n             |      ").append(elementCls).append(" ").append(rightElementTerm).append(" = ").append(elementDefault).append(";\n             |      boolean ").append(rightElementNullTerm).append(" = ").append(rightTerm).append(".isNullAt(").append(indexTerm).append(");\n             |      if (!").append(rightElementNullTerm).append(") {\n             |        ").append(rightElementTerm).append(" =\n             |          ").append(CodeGenUtils$.MODULE$.baseRowFieldReadAccess(ctx, indexTerm, rightTerm, elementType)).append(";\n             |      }\n             |\n             |      ").append(elementEqualsExpr.code()).append("\n             |      if (!").append(elementEqualsExpr.resultTerm()).append(") {\n             |        ").append(resultTerm).append(" = false;\n             |        break;\n             |      }\n             |    }\n             |  } else {\n             |    ").append(resultTerm).append(" = false;\n             |  }\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateMapComparison(CodeGeneratorContext ctx, GeneratedExpression left, GeneratedExpression right) {
        return GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull(ctx, (LogicalType)new BooleanType(), (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), GenerateUtils$.MODULE$.generateCallWithStmtIfArgsNotNull$default$4(), (Function1<Seq<String>, Tuple2<String, String>>)(Function1 & Serializable & scala.Serializable)args -> {
            String leftTerm = (String)args.head();
            String rightTerm = (String)args.apply(1);
            String resultTerm = CodeGenUtils$.MODULE$.newName("compareResult");
            String binaryMapCls = BinaryMap.class.getCanonicalName();
            MapType mapType = (MapType)left.resultType();
            String mapCls = Map.class.getCanonicalName();
            String keyCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(mapType.getKeyType());
            String valueCls = CodeGenUtils$.MODULE$.boxedTypeTermForType(mapType.getValueType());
            String leftMapTerm = CodeGenUtils$.MODULE$.newName("leftMap");
            String leftKeyTerm = CodeGenUtils$.MODULE$.newName("leftKey");
            String leftValueTerm = CodeGenUtils$.MODULE$.newName("leftValue");
            String leftValueNullTerm = CodeGenUtils$.MODULE$.newName("leftValueIsNull");
            GeneratedExpression leftValueExpr = new GeneratedExpression(leftValueTerm, leftValueNullTerm, "", mapType.getValueType(), GeneratedExpression$.MODULE$.apply$default$5());
            String rightMapTerm = CodeGenUtils$.MODULE$.newName("rightMap");
            String rightValueTerm = CodeGenUtils$.MODULE$.newName("rightValue");
            String rightValueNullTerm = CodeGenUtils$.MODULE$.newName("rightValueIsNull");
            GeneratedExpression rightValueExpr = new GeneratedExpression(rightValueTerm, rightValueNullTerm, "", mapType.getValueType(), GeneratedExpression$.MODULE$.apply$default$5());
            String entryTerm = CodeGenUtils$.MODULE$.newName("entry");
            String entryCls = Map.Entry.class.getCanonicalName();
            GeneratedExpression valueEqualsExpr = MODULE$.generateEquals(ctx, leftValueExpr, rightValueExpr);
            String internalTypeCls = LogicalType.class.getCanonicalName();
            String keyTypeTerm = ctx.addReusableObject(mapType.getKeyType(), "keyType", internalTypeCls);
            String valueTypeTerm = ctx.addReusableObject(mapType.getValueType(), "valueType", internalTypeCls);
            String stmt = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(816).append("\n             |boolean ").append(resultTerm).append(";\n             |if (").append(leftTerm).append(".numElements() == ").append(rightTerm).append(".numElements()) {\n             |  ").append(resultTerm).append(" = true;\n             |  ").append(mapCls).append(" ").append(leftMapTerm).append(" = ").append(leftTerm).append(".toJavaMap(").append(keyTypeTerm).append(", ").append(valueTypeTerm).append(");\n             |  ").append(mapCls).append(" ").append(rightMapTerm).append(" = ").append(rightTerm).append(".toJavaMap(").append(keyTypeTerm).append(", ").append(valueTypeTerm).append(");\n             |\n             |  for (").append(entryCls).append(" ").append(entryTerm).append(" : ").append(leftMapTerm).append(".entrySet()) {\n             |    ").append(keyCls).append(" ").append(leftKeyTerm).append(" = (").append(keyCls).append(") ").append(entryTerm).append(".getKey();\n             |    if (").append(rightMapTerm).append(".containsKey(").append(leftKeyTerm).append(")) {\n             |      ").append(valueCls).append(" ").append(leftValueTerm).append(" = (").append(valueCls).append(") ").append(entryTerm).append(".getValue();\n             |      ").append(valueCls).append(" ").append(rightValueTerm).append(" = (").append(valueCls).append(") ").append(rightMapTerm).append(".get(").append(leftKeyTerm).append(");\n             |      boolean ").append(leftValueNullTerm).append(" = (").append(leftValueTerm).append(" == null);\n             |      boolean ").append(rightValueNullTerm).append(" = (").append(rightValueTerm).append(" == null);\n             |\n             |      ").append(valueEqualsExpr.code()).append("\n             |      if (!").append(valueEqualsExpr.resultTerm()).append(") {\n             |        ").append(resultTerm).append(" = false;\n             |        break;\n             |      }\n             |    } else {\n             |      ").append(resultTerm).append(" = false;\n             |      break;\n             |    }\n             |  }\n             |} else {\n             |  ").append(resultTerm).append(" = false;\n             |}\n             ").toString())).stripMargin();
            return new Tuple2((Object)stmt, (Object)resultTerm);
        });
    }

    private GeneratedExpression generateUnaryOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression operand, boolean resultNullable, Function1<String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{operand}))), resultNullable, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> (String)expr.apply(args.head()));
    }

    private boolean generateUnaryOperatorIfNotNull$default$4() {
        return false;
    }

    private GeneratedExpression generateOperatorIfNotNull(CodeGeneratorContext ctx, LogicalType returnType, GeneratedExpression left, GeneratedExpression right, boolean resultNullable, Function2<String, String, String> expr) {
        return GenerateUtils$.MODULE$.generateCallIfArgsNotNull(ctx, returnType, (Seq<GeneratedExpression>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeneratedExpression[]{left, right}))), resultNullable, (Function1<Seq<String>, String>)(Function1 & Serializable & scala.Serializable)args -> (String)expr.apply(args.head(), args.apply(1)));
    }

    private boolean generateOperatorIfNotNull$default$5() {
        return false;
    }

    private GeneratedExpression internalExprCasting(GeneratedExpression expr, LogicalType targetType) {
        LogicalType x$47 = targetType;
        String x$48 = expr.copy$default$1();
        String x$49 = expr.copy$default$2();
        String x$50 = expr.copy$default$3();
        Option<Object> x$51 = expr.copy$default$5();
        return expr.copy(x$48, x$49, x$50, x$47, x$51);
    }

    private Function1<String, String> numericCasting(LogicalType operandType, LogicalType resultType) {
        Function1 & Serializable & scala.Serializable intersect;
        String resultTypeTerm = CodeGenUtils$.MODULE$.primitiveTypeTermForType(resultType);
        if (PlannerTypeUtils.isInteroperable((LogicalType)operandType, (LogicalType)resultType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> String.valueOf(operandTerm);
        } else if (TypeCheckUtils.isDecimal((LogicalType)resultType) && TypeCheckUtils.isDecimal((LogicalType)operandType)) {
            DecimalType dt = (DecimalType)resultType;
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(20).append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".castToDecimal(").append((String)operandTerm).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString();
        } else if (TypeCheckUtils.isDecimal((LogicalType)resultType) && TypeCheckUtils.isNumeric((LogicalType)operandType)) {
            DecimalType dt = (DecimalType)resultType;
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(15).append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".castFrom(").append((String)operandTerm).append(", ").append(dt.getPrecision()).append(", ").append(dt.getScale()).append(")").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)resultType) && TypeCheckUtils.isDecimal((LogicalType)operandType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(3).append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".").append(ScalarOperatorGens$.decToPrimMethod$1(resultType)).append("(").append((String)operandTerm).append(")").toString();
        } else if (TypeCheckUtils.isNumeric((LogicalType)operandType) && TypeCheckUtils.isNumeric((LogicalType)resultType)) {
            String resultTypeValue = new StringBuilder(7).append(resultTypeTerm).append("Value()").toString();
            String boxedTypeTerm = CodeGenUtils$.MODULE$.boxedTypeTermForType(operandType);
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(9).append("(new ").append(boxedTypeTerm).append("(").append((String)operandTerm).append(")).").append(resultTypeValue).toString();
        } else if (TypeCheckUtils.isTimeInterval((LogicalType)resultType) && TypeCheckUtils.isInteger((LogicalType)operandType)) {
            intersect = (Function1 & Serializable & scala.Serializable)operandTerm -> new StringBuilder(5).append("((").append(resultTypeTerm).append(") ").append((String)operandTerm).append(")").toString();
        } else {
            throw new CodeGenException(new StringBuilder(30).append("Unsupported casting from ").append(operandType).append(" to ").append(resultType).append(".").toString());
        }
        return intersect;
    }

    private String stringToLocalTimeCode(LogicalType targetType, String operandTerm) {
        String string;
        LogicalTypeRoot logicalTypeRoot = targetType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_DATE())).append("(").append(operandTerm).append(".toString())").toString();
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIME())).append("(").append(operandTerm).append(".toString())").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(39).append("\n           |").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP())).append("(").append(operandTerm).append(".toString())\n           |").toString())).stripMargin();
        } else {
            throw new UnsupportedOperationException();
        }
        return string;
    }

    private String localTimeToStringCode(CodeGeneratorContext ctx, LogicalType fromType, String operandTerm) {
        String string;
        LogicalTypeRoot logicalTypeRoot = fromType.getTypeRoot();
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            string = new StringBuilder(2).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.UNIX_DATE_TO_STRING.method)).append("(").append(operandTerm).append(")").toString();
        } else if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            string = new StringBuilder(2).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.UNIX_TIME_TO_STRING())).append("(").append(operandTerm).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            int precision = ((TimestampType)fromType).getPrecision();
            string = new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING())).append("(").append(operandTerm).append(", ").append(precision).append(")").toString();
        } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_TO_STRING_TIME_ZONE());
            String zone = ctx.addReusableTimeZone();
            int precision = ((LocalZonedTimestampType)fromType).getPrecision();
            string = new StringBuilder(6).append(method).append("(").append(operandTerm).append(", ").append(zone).append(", ").append(precision).append(")").toString();
        } else {
            throw new MatchError((Object)logicalTypeRoot);
        }
        return string;
    }

    private final Function1 castToDec$1(LogicalType t, DecimalType resultType$1) {
        LogicalType logicalType = t;
        Function1<String, String> function1 = logicalType instanceof DecimalType ? operandTerm -> String.valueOf(operandTerm) : this.numericCasting(t, (LogicalType)resultType$1);
        return function1;
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$1(String op$1, String l, String r) {
        return new StringBuilder(35).append(l).append(" ").append(op$1).append(" (java.lang.Math.toIntExact(").append(r).append(" / ").append(86400000L).append("L))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$2(String op$1, String l, String r) {
        return new StringBuilder(26).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis((").append(l).append(" * ").append(86400000L).append("L) ").append(op$1).append(" ").append(r).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$3(String op$1, String l, String r) {
        return new StringBuilder(6).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.ADD_MONTHS.method)).append("(").append(l).append(", ").append(op$1).append("(").append(r).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$4(String op$1, String l, String r) {
        return new StringBuilder(36).append("java.lang.Math.toIntExact(((").append(l).append(" + ").append(86400000L).append("L) ").append(op$1).append(" (").append(new StringBuilder(38).append("java.lang.Math.toIntExact(").append(r).append(" % ").append(86400000L).append("L))) % ").append(86400000L).append("L)").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$5(String l, String r) {
        return String.valueOf(l);
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$6(String op$1, String l, String r) {
        String leftTerm = new StringBuilder(17).append(l).append(".getMillisecond()").toString();
        String nanoTerm = new StringBuilder(23).append(l).append(".getNanoOfMillisecond()").toString();
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(leftTerm).append(" ").append(op$1).append(" ").append(r).append(", ").append(nanoTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$7(String op$1, String l, String r) {
        String leftTerm = new StringBuilder(17).append(l).append(".getMillisecond()").toString();
        String nanoTerm = new StringBuilder(23).append(l).append(".getNanoOfMillisecond()").toString();
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n               |").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(\n               |  ").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.ADD_MONTHS.method)).append("(").append(leftTerm).append(", ").append(op$1).append("(").append(r).append(")),\n               |  ").append(nanoTerm).append(")\n             ").toString())).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$8(GeneratedExpression left$1, GeneratedExpression right$1, String ll, String rr) {
        LogicalTypeRoot logicalTypeRoot;
        Tuple2 tuple2 = new Tuple2((Object)left$1.resultType().getTypeRoot(), (Object)right$1.resultType().getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2) && LogicalTypeRoot.DATE.equals(logicalTypeRoot3)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(0).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append(new StringBuilder(8).append("(").append(leftTerm).append(", ").append(rr).append(" * ").append(86400000L).append("L)").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot4) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot5)) {
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(0).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append(new StringBuilder(8).append("(").append(ll).append(" * ").append(86400000L).append("L, ").append(rightTerm).append(")").toString()).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot6 = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot7 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot6) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot7)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append("(").append(leftTerm).append(", ").append(rightTerm).append(")").toString();
            }
        }
        if (tuple2 != null && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot = (LogicalTypeRoot)tuple2._1())) {
            String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
            return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append("(").append(leftTerm).append(", ").append(rr).append(")").toString();
        }
        if (tuple2 == null) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append("(").append(ll).append(", ").append(rr).append(")").toString();
        LogicalTypeRoot logicalTypeRoot8 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot8)) return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append("(").append(ll).append(", ").append(rr).append(")").toString();
        String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
        return new StringBuilder(4).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethod.SUBTRACT_MONTHS.method)).append("(").append(ll).append(", ").append(rightTerm).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ String $anonfun$generateTemporalPlusMinus$9(GeneratedExpression left$1, GeneratedExpression right$1, String op$1, String ll, String rr) {
        Tuple2 tuple2 = new Tuple2((Object)left$1.resultType().getTypeRoot(), (Object)right$1.resultType().getTypeRoot());
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot2 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
                return new StringBuilder(2).append(leftTerm).append(" ").append(op$1).append(" ").append(rightTerm).toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot3 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.DATE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot3)) {
                return new StringBuilder(14).append("(").append(ll).append(" * ").append(86400000L).append("L) ").append(op$1).append(" (").append(rr).append(" * ").append(86400000L).append("L)").toString();
            }
        }
        if (tuple2 != null) {
            LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
            LogicalTypeRoot logicalTypeRoot4 = (LogicalTypeRoot)tuple2._2();
            if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && LogicalTypeRoot.DATE.equals(logicalTypeRoot4)) {
                String leftTerm = new StringBuilder(17).append(ll).append(".getMillisecond()").toString();
                return new StringBuilder(8).append(leftTerm).append(" ").append(op$1).append(" (").append(rr).append(" * ").append(86400000L).append("L)").toString();
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        LogicalTypeRoot logicalTypeRoot = (LogicalTypeRoot)tuple2._1();
        LogicalTypeRoot logicalTypeRoot5 = (LogicalTypeRoot)tuple2._2();
        if (!LogicalTypeRoot.DATE.equals(logicalTypeRoot)) throw new MatchError((Object)tuple2);
        if (!LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot5)) throw new MatchError((Object)tuple2);
        String rightTerm = new StringBuilder(17).append(rr).append(".getMillisecond()").toString();
        return new StringBuilder(8).append("(").append(ll).append(" * ").append(86400000L).append("L) ").append(op$1).append(" ").append(rightTerm).toString();
    }

    public static final /* synthetic */ String $anonfun$generateReinterpret$1(String operandTerm) {
        return new StringBuilder(17).append(operandTerm).append(".getMillisecond()").toString();
    }

    public static final /* synthetic */ String $anonfun$generateReinterpret$2(String operandTerm) {
        return new StringBuilder(18).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$1(TimestampType toType$1, String method$1, String operandTerm) {
        return new StringBuilder(4).append(method$1).append("(").append(operandTerm).append(", ").append(toType$1.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$2(CodeGeneratorContext ctx$2, String method$2, String operandTerm) {
        String timeZone = ctx$2.addReusableTimeZone();
        return new StringBuilder(4).append(method$2).append("(").append(operandTerm).append(", ").append(timeZone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$3(CodeGeneratorContext ctx$2, LocalZonedTimestampType toType$2, String method$2, String truncate_method$1, String operandTerm) {
        String timeZone = ctx$2.addReusableTimeZone();
        return new StringBuilder(8).append(truncate_method$1).append("(").append(method$2).append("(").append(operandTerm).append(", ").append(timeZone).append("), ").append(toType$2.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$4(CodeGeneratorContext ctx$2, String method$3, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        return new StringBuilder(4).append(method$3).append("(").append(operandTerm).append(", ").append(zone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$5(CodeGeneratorContext ctx$2, TimestampType toType$3, String method$3, String truncate_method$2, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        return new StringBuilder(8).append(truncate_method$2).append("(").append(method$3).append("(").append(operandTerm).append(", ").append(zone).append("), ").append(toType$3.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$6(LocalZonedTimestampType toType$4, String method$4, String operandTerm) {
        return new StringBuilder(4).append(method$4).append("(").append(operandTerm).append(", ").append(toType$4.getPrecision()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$7(CodeGeneratorContext ctx$2, GeneratedExpression operand$2, Seq operandTerm) {
        return String.valueOf(MODULE$.localTimeToStringCode(ctx$2, operand$2.resultType(), (String)operandTerm.head()));
    }

    public static final /* synthetic */ String $anonfun$generateCast$8(String method$5, String timeUnitRange$1, Seq terms) {
        return new StringBuilder(4).append(method$5).append("(").append(terms.head()).append(", ").append(timeUnitRange$1).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$9(String method$6, String timeUnitRange$2, Seq terms) {
        return new StringBuilder(7).append(method$6).append("(").append(terms.head()).append(", ").append(timeUnitRange$2).append(", 3)").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$10(String charset$1, Seq terms) {
        return new StringBuilder(22).append("(new String(").append(terms.head()).append(", ").append(charset$1).append(".UTF_8))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$11(CodeGeneratorContext ctx$2, GeneratedExpression operand$2, Seq terms) {
        DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)operand$2.resultType()));
        String converterTerm = ctx$2.addReusableObject(converter, "converter", ctx$2.addReusableObject$default$3());
        return new StringBuilder(19).append(" \"\" + ").append(converterTerm).append(".toExternal(").append(terms.head()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$12(Seq terms) {
        return new StringBuilder(6).append(" \"\" + ").append(terms.head()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$13(String operandTerm) {
        return new StringBuilder(15).append(CodeGenUtils$.MODULE$.STRING_UTIL()).append(".toBooleanSQL(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$14(DecimalType x2$1, String operandTerm) {
        return new StringBuilder(16).append(CodeGenUtils$.MODULE$.STRING_UTIL()).append(".toDecimal(").append(operandTerm).append(", ").append(x2$1.getPrecision()).append(", ").append(x2$1.getScale()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$15() {
        return "Unexpected data type.";
    }

    public static final /* synthetic */ String $anonfun$generateCast$16(String methodName$1, String operandTerm) {
        return new StringBuilder(12).append("(").append(CodeGenUtils$.MODULE$.STRING_UTIL()).append(".").append(methodName$1).append("(").append(operandTerm).append(".trim()))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$17(String operandTerm) {
        return new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_DATE())).append("(").append(operandTerm).append(".toString())").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$18(String operandTerm) {
        return new StringBuilder(13).append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIME())).append("(").append(operandTerm).append(".toString())").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$19(String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(40).append("\n             |").append(CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP())).append("(").append(operandTerm).append(".toString())\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$20(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.STRING_TO_TIMESTAMP_TIME_ZONE());
        return new StringBuilder(33).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(method).append("(").append(operandTerm).append(".toString(), ").append(zone).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$21(String operandTerm) {
        return new StringBuilder(11).append(operandTerm).append(".getBytes()").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$22(DecimalType dt$1, String operandTerm) {
        return new StringBuilder(15).append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".castFrom(").append(operandTerm).append(", ").append(dt$1.getPrecision()).append(", ").append(dt$1.getScale()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$23(String targetTypeTerm$1, String operandTerm) {
        return new StringBuilder(13).append("(").append(targetTypeTerm$1).append(") (").append(operandTerm).append(" ? 1 : 0)").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$24(String operandTerm) {
        return new StringBuilder(16).append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".castToBoolean(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$25(String operandTerm) {
        return new StringBuilder(36).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".castToTimestamp(").append(operandTerm).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$26(String operandTerm) {
        return new StringBuilder(5).append(operandTerm).append(" != 0").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$27(Function1 operandCasting$1, String operandTerm) {
        return String.valueOf(operandCasting$1.apply((Object)operandTerm));
    }

    public static final /* synthetic */ String $anonfun$generateCast$28(String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |").append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(\n             |  ").append(operandTerm).append(" * ").append(DateTimeUtils.class.getCanonicalName()).append(".MILLIS_PER_DAY)\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$29(String targetTypeTerm$2, String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(83).append("\n             |(").append(targetTypeTerm$2).append(") (").append(operandTerm).append(".getMillisecond() /\n             |  ").append(DateTimeUtils.class.getCanonicalName()).append(".MILLIS_PER_DAY)\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$30(String operandTerm) {
        return new StringBuilder(18).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(operandTerm).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$31(String targetTypeTerm$3, String operandTerm) {
        return new StringBuilder(24).append("(").append(targetTypeTerm$3).append(") (").append(operandTerm).append(".getMillisecond() % ").append(new StringBuilder(16).append(DateTimeUtils.class.getCanonicalName()).append(".MILLIS_PER_DAY)").toString()).toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$32(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.DATE_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE());
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(method).append("(").append(operandTerm).append(", ").append(zone).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$33(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_DATE());
        return new StringBuilder(21).append(method).append("(").append(operandTerm).append(".getMillisecond(), ").append(zone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$34(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIME_TO_TIMESTAMP_WITH_LOCAL_TIME_ZONE());
        return new StringBuilder(22).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(").append(method).append("(").append(operandTerm).append(", ").append(zone).append("))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$35(CodeGeneratorContext ctx$2, String operandTerm) {
        String zone = ctx$2.addReusableTimeZone();
        String method = CodeGenUtils$.MODULE$.qualifyMethod(BuiltInMethods$.MODULE$.TIMESTAMP_WITH_LOCAL_TIME_ZONE_TO_TIME());
        return new StringBuilder(21).append(method).append("(").append(operandTerm).append(".getMillisecond(), ").append(zone).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$36(DecimalType dt$2, String operandTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(114).append("\n             |").append(CodeGenUtils$.MODULE$.DECIMAL_TERM()).append(".castFrom(\n             |  ((double) (").append(operandTerm).append(".getMillisecond() / 1000.0)),\n             |  ").append(dt$2.getPrecision()).append(", ").append(dt$2.getScale()).append(")\n           ").toString())).stripMargin();
    }

    public static final /* synthetic */ String $anonfun$generateCast$37(String operandTerm) {
        return new StringBuilder(34).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis(((long) ").append(operandTerm).append(") * 1000)").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$38(String operandTerm) {
        return new StringBuilder(34).append(CodeGenUtils$.MODULE$.SQL_TIMESTAMP()).append(".fromEpochMillis((long) (").append(operandTerm).append(" * 1000))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$39(String operandTerm) {
        return new StringBuilder(35).append("((byte) (").append(operandTerm).append(".getMillisecond() / 1000))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$40(String operandTerm) {
        return new StringBuilder(36).append("((short) (").append(operandTerm).append(".getMillisecond() / 1000))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$41(String operandTerm) {
        return new StringBuilder(34).append("((int) (").append(operandTerm).append(".getMillisecond() / 1000))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$42(String operandTerm) {
        return new StringBuilder(35).append("((long) (").append(operandTerm).append(".getMillisecond() / 1000))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$43(String operandTerm) {
        return new StringBuilder(38).append("((float) (").append(operandTerm).append(".getMillisecond() / 1000.0))").toString();
    }

    public static final /* synthetic */ String $anonfun$generateCast$44(String operandTerm) {
        return new StringBuilder(39).append("((double) (").append(operandTerm).append(".getMillisecond() / 1000.0))").toString();
    }

    public static final /* synthetic */ boolean $anonfun$generateRow$2(LogicalType x$1) {
        return PlannerTypeUtils.isPrimitive((LogicalType)x$1);
    }

    private static final String decToPrimMethod$1(LogicalType targetType) {
        String string;
        LogicalTypeRoot logicalTypeRoot = targetType.getTypeRoot();
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            string = "castToByte";
        } else if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            string = "castToShort";
        } else if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            string = "castToInt";
        } else if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            string = "castToLong";
        } else if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            string = "castToFloat";
        } else if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            string = "castToDouble";
        } else if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            string = "castToBoolean";
        } else {
            throw new CodeGenException(new StringBuilder(36).append("Unsupported decimal casting type: '").append(targetType).append("'").toString());
        }
        return string;
    }

    private ScalarOperatorGens$() {
        MODULE$ = this;
    }
}

