/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.delegation.StreamExecutor;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.StreamExecNode;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.trait.AccModeTraitDef$;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateAsRetractionTraitDef$;
import org.apache.flink.table.planner.plan.utils.ExecNodePlanDumper$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import org.apache.flink.table.planner.utils.ExecutorUtils;
import org.apache.flink.table.planner.utils.PlanUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001=\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005-\u0001F.\u00198oKJ\u0014\u0015m]3\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u0007\u0019I!A\u0007\r\u0003\u0011\u0015CXmY;u_JD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0007G>tg-[4\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011aA1qS&\u0011!e\b\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\rC\u0005%\u0001\t\u0005\t\u0015!\u0003&W\u0005ya-\u001e8di&|gnQ1uC2|w\r\u0005\u0002'S5\tqE\u0003\u0002)\r\u000591-\u0019;bY><\u0017B\u0001\u0016(\u0005=1UO\\2uS>t7)\u0019;bY><\u0017B\u0001\u0013\u0013\u0011%i\u0003A!A!\u0002\u0013q\u0013'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0019z\u0013B\u0001\u0019(\u00059\u0019\u0015\r^1m_\u001el\u0015M\\1hKJL!!\f\n\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\u0015)dg\u000e\u001d:!\t\t\u0002\u0001C\u0003\u0016e\u0001\u0007a\u0003C\u0003\u001de\u0001\u0007Q\u0004C\u0003%e\u0001\u0007Q\u0005C\u0003.e\u0001\u0007a\u0006C\u0003<\u0001\u0011EC(\u0001\u0007hKR$&/Y5u\t\u001647/F\u0001>!\rq\u0014iQ\u0007\u0002\u007f)\t\u0001)A\u0003tG\u0006d\u0017-\u0003\u0002C\u007f\t)\u0011I\u001d:bsB\u0012AI\u0014\t\u0004\u000b*cU\"\u0001$\u000b\u0005\u001dC\u0015\u0001\u00029mC:T!!\u0013\u0006\u0002\u000f\r\fGnY5uK&\u00111J\u0012\u0002\f%\u0016dGK]1ji\u0012+g\r\u0005\u0002N\u001d2\u0001A!C(;\u0003\u0003\u0005\tQ!\u0001Q\u0005\ryF%M\t\u0003#R\u0003\"A\u0010*\n\u0005M{$a\u0002(pi\"Lgn\u001a\t\u0003\u000bVK!A\u0016$\u0003\u0011I+G\u000e\u0016:bSRDQ\u0001\u0017\u0001\u0005Re\u000bAbZ3u\u001fB$\u0018.\\5{KJ,\u0012A\u0017\t\u00037~k\u0011\u0001\u0018\u0006\u0003;z\u000b\u0001b\u001c9uS6L'0\u001a\u0006\u0003\u000f\u0012I!\u0001\u0019/\u0003\u0013=\u0003H/[7ju\u0016\u0014\b\"\u00022\u0001\t#\u001a\u0017a\u0004;sC:\u001cH.\u0019;f)>\u0004F.\u00198\u0015\u0005\u0011\\\bcA3kY6\taM\u0003\u0002hQ\u0006!Q\u000f^5m\u0015\u0005I\u0017\u0001\u00026bm\u0006L!a\u001b4\u0003\t1K7\u000f\u001e\u0019\u0003[V\u00042A\u001c:u\u001b\u0005y'B\u00019r\u0003\r!\u0017m\u001a\u0006\u0003A!I!a]8\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B\u0011Q*\u001e\u0003\nm\u0006\f\t\u0011!A\u0003\u0002]\u00141a\u0018\u00135#\t\t\u0006\u0010\u0005\u0002?s&\u0011!p\u0010\u0002\u0004\u0003:L\b\"\u0002?b\u0001\u0004i\u0018!C3yK\u000etu\u000eZ3t!\r)'N \u0019\u0006\u007f\u0006E\u0011q\u0003\t\t\u0003\u0003\tY!a\u0004\u0002\u00165\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003fq\u0016\u001c'bAA\u0005=\u0006)an\u001c3fg&!\u0011QBA\u0002\u0005!)\u00050Z2O_\u0012,\u0007cA'\u0002\u0012\u0011Q\u00111C>\u0002\u0002\u0003\u0005)\u0011A<\u0003\u0007}##\u0007E\u0002N\u0003/!!\"!\u0007|\u0003\u0003\u0005\tQ!\u0001x\u0005\ryFe\r\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003\u001d)\u0007\u0010\u001d7bS:$b!!\t\u00028\u0005\u001d\u0003\u0003BA\u0012\u0003cqA!!\n\u0002.A\u0019\u0011qE \u000e\u0005\u0005%\"bAA\u0016\u001d\u00051AH]8pizJ1!a\f@\u0003\u0019\u0001&/\u001a3fM&!\u00111GA\u001b\u0005\u0019\u0019FO]5oO*\u0019\u0011qF \t\u0011\u0005e\u00121\u0004a\u0001\u0003w\t!b\u001c9fe\u0006$\u0018n\u001c8t!\u0011)'.!\u0010\u0011\t\u0005}\u00121I\u0007\u0003\u0003\u0003R1!!\u000f\u0007\u0013\u0011\t)%!\u0011\u0003\u0013=\u0003XM]1uS>t\u0007\u0002CA%\u00037\u0001\r!a\u0013\u0002\u0011\u0015DH/\u001a8eK\u0012\u00042APA'\u0013\r\tye\u0010\u0002\b\u0005>|G.Z1o\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+\nAd\u0019:fCR,G)^7nsBc\u0017M\u001c8fe\u001a{'/\u0012=qY\u0006Lg\u000eF\u00016\u0001")
public class StreamPlanner
extends PlannerBase {
    private final TableConfig config;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), MiniBatchIntervalTraitDef$.MODULE$.INSTANCE(), UpdateAsRetractionTraitDef$.MODULE$.INSTANCE(), AccModeTraitDef$.MODULE$.INSTANCE()});
    }

    @Override
    public Optimizer getOptimizer() {
        return new StreamCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public List<Transformation<?>> translateToPlan(List<ExecNode<?, ?>> execNodes) {
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execNodes).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ExecNode execNode = x0$2;
            if (!(execNode instanceof StreamExecNode)) {
                throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            StreamExecNode streamExecNode = (StreamExecNode)execNode;
            Transformation transformation = streamExecNode.translateToPlan(this);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public String explain(List<Operation> operations, boolean extended) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            RelNode relNode;
            Operation operation = x0$3;
            if (operation instanceof QueryOperation) {
                QueryOperation queryOperation = (QueryOperation)operation;
                relNode = this.getRelBuilder().queryOperation(queryOperation).build();
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                relNode = this.translateToRel(modifyOperation);
            } else {
                throw new TableException(new java.lang.StringBuilder(23).append("Unsupported operation: ").append(operation.getClass().getCanonicalName()).toString());
            }
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        List<ExecNode<?, ?>> execNodes = this.translateToExecNodePlan(optimizedRelNodes);
        StreamPlanner plannerForExplain = this.createDummyPlannerForExplain();
        plannerForExplain.overrideEnvParallelism();
        List<Transformation<?>> transformations = plannerForExplain.translateToPlan(execNodes);
        StreamGraph streamGraph = ExecutorUtils.generateStreamGraph(this.getExecEnv(), transformations);
        String executionPlan = PlanUtil$.MODULE$.explainStreamGraph(streamGraph);
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Logical Plan ==");
        sb.append(System.lineSeparator());
        Tuple2 tuple22 = tuple2 = extended ? new Tuple2((Object)SqlExplainLevel.ALL_ATTRIBUTES, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)SqlExplainLevel.DIGEST_ATTRIBUTES, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SqlExplainLevel explainLevel = (SqlExplainLevel)((Object)tuple2._1());
        boolean withRetractTraits = tuple2._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)explainLevel, (Object)BoxesRunTime.boxToBoolean((boolean)withRetractTraits));
        Tuple2 tuple24 = tuple23;
        SqlExplainLevel explainLevel2 = (SqlExplainLevel)((Object)tuple24._1());
        boolean withRetractTraits2 = tuple24._2$mcZ$sp();
        Buffer x$2 = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execNodes);
        SqlExplainLevel x$3 = explainLevel2;
        boolean x$4 = withRetractTraits2;
        boolean x$5 = ExecNodePlanDumper$.MODULE$.dagToString$default$3();
        boolean x$6 = ExecNodePlanDumper$.MODULE$.dagToString$default$5();
        boolean x$7 = ExecNodePlanDumper$.MODULE$.dagToString$default$6();
        sb.append(ExecNodePlanDumper$.MODULE$.dagToString((Seq<ExecNode<?, ?>>)x$2, x$3, x$5, x$4, x$6, x$7));
        sb.append(System.lineSeparator());
        sb.append("== Physical Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(executionPlan);
        return sb.toString();
    }

    private StreamPlanner createDummyPlannerForExplain() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        StreamExecutor executor = new StreamExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.config, super.functionCatalog(), super.catalogManager());
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.config = config;
        super(executor, config, functionCatalog, catalogManager, true);
    }
}

