/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.tools.RelBuilder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionDefaultVisitor;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexDistinctKeyVariable;
import org.apache.flink.table.planner.expressions.CallExpressionResolver;
import org.apache.flink.table.planner.expressions.RexNodeExpression;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class DeclarativeExpressionResolver
extends ExpressionDefaultVisitor<ResolvedExpression> {
    private final DeclarativeAggregateFunction function;
    private final boolean isMerge;
    private final CallExpressionResolver resolver;

    public DeclarativeExpressionResolver(RelBuilder relBuilder, DeclarativeAggregateFunction function, boolean isMerge) {
        this.function = function;
        this.isMerge = isMerge;
        this.resolver = new CallExpressionResolver(relBuilder);
    }

    protected ResolvedExpression defaultMethod(Expression expression) {
        if (expression instanceof UnresolvedReferenceExpression) {
            UnresolvedReferenceExpression expr = (UnresolvedReferenceExpression)expression;
            String name = expr.getName();
            int localIndex = ArrayUtils.indexOf((Object[])this.function.aggBufferAttributes(), (Object)expr);
            if (localIndex == -1) {
                if (this.isMerge) {
                    return this.toMergeInputExpr(name, ArrayUtils.indexOf((Object[])this.function.mergeOperands(), (Object)expr));
                }
                return this.toAccInputExpr(name, ArrayUtils.indexOf((Object[])this.function.operands(), (Object)expr));
            }
            return this.toAggBufferExpr(name, localIndex);
        }
        if (expression instanceof UnresolvedCallExpression) {
            UnresolvedCallExpression unresolvedCall = (UnresolvedCallExpression)expression;
            return this.resolver.resolve((Expression)new UnresolvedCallExpression(unresolvedCall.getFunctionDefinition(), unresolvedCall.getChildren().stream().map(c -> (ResolvedExpression)c.accept((ExpressionVisitor)this)).collect(Collectors.toList())));
        }
        if (expression instanceof ResolvedExpression) {
            return (ResolvedExpression)expression;
        }
        return this.resolver.resolve(expression);
    }

    public abstract ResolvedExpression toMergeInputExpr(String var1, int var2);

    public abstract ResolvedExpression toAccInputExpr(String var1, int var2);

    public abstract ResolvedExpression toAggBufferExpr(String var1, int var2);

    public static ResolvedExpression toRexInputRef(RelBuilder builder, int i, LogicalType t) {
        RelDataType tp = ((FlinkTypeFactory)builder.getTypeFactory()).createFieldTypeFromLogicalType(t);
        return new RexNodeExpression(new RexInputRef(i, tp), LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)t));
    }

    public static ResolvedExpression toRexDistinctKey(RelBuilder builder, String name, LogicalType t) {
        return new RexNodeExpression(new RexDistinctKeyVariable(name, ((FlinkTypeFactory)builder.getTypeFactory()).createFieldTypeFromLogicalType(t), t), LogicalTypeDataTypeConverter.fromLogicalTypeToDataType((LogicalType)t));
    }
}

