/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import java.io.Serializable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem$;
import org.apache.flink.table.planner.expressions.BinaryArithmetic;
import org.apache.flink.table.planner.expressions.Ceil;
import org.apache.flink.table.planner.expressions.Div;
import org.apache.flink.table.planner.expressions.Floor;
import org.apache.flink.table.planner.expressions.Literal;
import org.apache.flink.table.planner.expressions.Minus;
import org.apache.flink.table.planner.expressions.Mul;
import org.apache.flink.table.planner.expressions.PlannerExpression;
import org.apache.flink.table.planner.expressions.Plus;
import org.apache.flink.table.planner.expressions.Round;
import org.apache.flink.table.planner.expressions.UnaryExpression;
import org.apache.flink.table.planner.typeutils.TypeCoercion$;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;

public final class ReturnTypeInference$ {
    public static ReturnTypeInference$ MODULE$;
    private FlinkTypeSystem typeSystem;
    private FlinkTypeFactory typeFactory;
    private volatile byte bitmap$0;

    static {
        new ReturnTypeInference$();
    }

    private FlinkTypeSystem typeSystem$lzycompute() {
        ReturnTypeInference$ returnTypeInference$ = this;
        synchronized (returnTypeInference$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.typeSystem = new FlinkTypeSystem();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.typeSystem;
    }

    private FlinkTypeSystem typeSystem() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.typeSystem$lzycompute() : this.typeSystem;
    }

    private FlinkTypeFactory typeFactory$lzycompute() {
        ReturnTypeInference$ returnTypeInference$ = this;
        synchronized (returnTypeInference$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.typeFactory = new FlinkTypeFactory(this.typeSystem());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.typeFactory;
    }

    private FlinkTypeFactory typeFactory() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.typeFactory$lzycompute() : this.typeFactory;
    }

    public TypeInformation<?> inferMinus(Minus minus) {
        return this.inferPlusOrMinus(minus);
    }

    public TypeInformation<?> inferPlus(Plus plus) {
        return this.inferPlusOrMinus(plus);
    }

    private TypeInformation<?> inferPlusOrMinus(BinaryArithmetic op) {
        Function3 & Serializable & scala.Serializable decimalTypeInference = (Function3 & Serializable & scala.Serializable)(leftType, rightType, wideResultType) -> {
            TypeInformation typeInformation;
            if (SqlTypeUtil.isExactNumeric(leftType) && SqlTypeUtil.isExactNumeric(rightType) && (SqlTypeUtil.isDecimal(leftType) || SqlTypeUtil.isDecimal(rightType))) {
                DecimalTypeInfo decimalTypeInfo;
                int lp = leftType.getPrecision();
                int ls = leftType.getScale();
                int rp = rightType.getPrecision();
                int rs = rightType.getScale();
                int scale = Math.max(ls, rs);
                Predef$.MODULE$.assert(scale <= MODULE$.typeSystem().getMaxNumericScale());
                int precision = Math.max(lp - ls, rp - rs) + scale + 1;
                precision = Math.min(precision, MODULE$.typeSystem().getMaxNumericPrecision());
                Predef$.MODULE$.assert(precision > 0);
                TypeInformation typeInformation2 = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)wideResultType);
                if (typeInformation2 instanceof DecimalTypeInfo) {
                    decimalTypeInfo = DecimalTypeInfo.of((int)precision, (int)scale);
                } else if (typeInformation2 instanceof BigDecimalTypeInfo) {
                    decimalTypeInfo = BigDecimalTypeInfo.of((int)precision, (int)scale);
                } else {
                    throw new MatchError((Object)typeInformation2);
                }
                typeInformation = decimalTypeInfo;
            } else {
                RelDataType resultType = MODULE$.typeFactory().leastRestrictive((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon(leftType, (List)new .colon.colon(rightType, (List)Nil$.MODULE$))).asJava());
                typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(resultType));
            }
            return typeInformation;
        };
        return this.inferBinaryArithmetic(op, decimalTypeInference, (Function1 & Serializable & scala.Serializable)t -> TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)t));
    }

    public TypeInformation<?> inferMul(Mul mul) {
        Function2 & Serializable & scala.Serializable decimalTypeInference = (Function2 & Serializable & scala.Serializable)(leftType, rightType) -> MODULE$.typeFactory().createDecimalProduct((RelDataType)leftType, (RelDataType)rightType);
        return this.inferDivOrMul(mul, (Function2<RelDataType, RelDataType, RelDataType>)decimalTypeInference);
    }

    public TypeInformation<?> inferDiv(Div div) {
        Function2 & Serializable & scala.Serializable decimalTypeInference = (Function2 & Serializable & scala.Serializable)(leftType, rightType) -> MODULE$.typeFactory().createDecimalQuotient((RelDataType)leftType, (RelDataType)rightType);
        return this.inferDivOrMul(div, (Function2<RelDataType, RelDataType, RelDataType>)decimalTypeInference);
    }

    private TypeInformation<?> inferDivOrMul(BinaryArithmetic op, Function2<RelDataType, RelDataType, RelDataType> decimalTypeInfer) {
        Function3 & Serializable & scala.Serializable decimalFunc = (Function3 & Serializable & scala.Serializable)(leftType, rightType, x$1) -> {
            TypeInformation typeInformation;
            RelDataType decimalType = (RelDataType)decimalTypeInfer.apply(leftType, rightType);
            if (decimalType != null) {
                typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(decimalType));
            } else {
                RelDataType resultType = MODULE$.typeFactory().leastRestrictive((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon(leftType, (List)new .colon.colon(rightType, (List)Nil$.MODULE$))).asJava());
                typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(resultType));
            }
            return typeInformation;
        };
        Function1 & Serializable & scala.Serializable nonDecimalType = (Function1 & Serializable & scala.Serializable)t -> TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)t);
        return this.inferBinaryArithmetic(op, decimalFunc, nonDecimalType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeInformation<?> inferBinaryArithmetic(BinaryArithmetic binaryOp, Function3<RelDataType, RelDataType, LogicalType, TypeInformation<?>> decimalInfer, Function1<LogicalType, TypeInformation<?>> nonDecimalInfer) {
        LogicalType leftType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(binaryOp.left().resultType());
        LogicalType rightType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(binaryOp.right().resultType());
        boolean bl = false;
        Some some = null;
        Option<LogicalType> option = TypeCoercion$.MODULE$.widerTypeOf(leftType, rightType);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogicalType t = (LogicalType)some.value();
            if (t instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)t;
                RelDataType leftRelDataType = this.typeFactory().createFieldTypeFromLogicalType(leftType);
                RelDataType rightRelDataType = this.typeFactory().createFieldTypeFromLogicalType(rightType);
                return (TypeInformation)decimalInfer.apply((Object)leftRelDataType, (Object)rightRelDataType, (Object)decimalType);
            }
        }
        if (bl) {
            LogicalType t = (LogicalType)some.value();
            return (TypeInformation)nonDecimalInfer.apply((Object)t);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        throw new TableException("This will not happen here!");
    }

    public TypeInformation<?> inferRound(Round round) {
        TypeInformation typeInformation;
        block5: {
            TypeInformation typeInformation2;
            block2: {
                int n;
                TypeInformation numType;
                block4: {
                    block3: {
                        numType = round.left().resultType();
                        typeInformation2 = numType;
                        boolean bl = typeInformation2 instanceof DecimalTypeInfo ? true : typeInformation2 instanceof BigDecimalTypeInfo;
                        if (!bl) break block2;
                        PlannerExpression plannerExpression = round.right();
                        if (!(plannerExpression instanceof Literal)) break block3;
                        Literal literal = (Literal)plannerExpression;
                        Object v = literal.value();
                        TypeInformation<?> typeInformation3 = literal.resultType();
                        if (!(v instanceof Integer)) break block3;
                        n = BoxesRunTime.unboxToInt((Object)v);
                        BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                        TypeInformation<?> typeInformation4 = typeInformation3;
                        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation4) : typeInformation4 != null)) break block4;
                    }
                    throw new TableException("This will not happen here!");
                }
                int n2 = n;
                int lenValue = n2;
                LogicalType numLogicalType = TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(numType);
                RelDataType numRelDataType = this.typeFactory().createFieldTypeFromLogicalType(numLogicalType);
                int p = numRelDataType.getPrecision();
                int s = numRelDataType.getScale();
                DecimalType dt = FlinkTypeSystem$.MODULE$.inferRoundType(p, s, lenValue);
                typeInformation = TypeInfoLogicalTypeConverter.fromLogicalTypeToTypeInfo((LogicalType)dt);
                break block5;
            }
            typeInformation = typeInformation2;
        }
        return typeInformation;
    }

    public TypeInformation<?> inferFloor(Floor floor) {
        return this.getArg0OrExactNoScale(floor);
    }

    public TypeInformation<?> inferCeil(Ceil ceil) {
        return this.getArg0OrExactNoScale(ceil);
    }

    private TypeInformation<?> getArg0OrExactNoScale(UnaryExpression op) {
        DecimalTypeInfo decimalTypeInfo;
        DecimalTypeInfo childType = op.child().resultType();
        DecimalTypeInfo decimalTypeInfo2 = childType;
        if (decimalTypeInfo2 instanceof DecimalTypeInfo) {
            DecimalTypeInfo decimalTypeInfo3 = decimalTypeInfo2;
            decimalTypeInfo = DecimalTypeInfo.of((int)decimalTypeInfo3.precision(), (int)0);
        } else if (decimalTypeInfo2 instanceof BigDecimalTypeInfo) {
            BigDecimalTypeInfo bigDecimalTypeInfo = (BigDecimalTypeInfo)decimalTypeInfo2;
            decimalTypeInfo = BigDecimalTypeInfo.of((int)bigDecimalTypeInfo.precision(), (int)0);
        } else {
            decimalTypeInfo = childType;
        }
        return decimalTypeInfo;
    }

    private ReturnTypeInference$() {
        MODULE$ = this;
    }
}

