/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.LogicalType;

public abstract class FirstValueAggFunction<T>
extends AggregateFunction<T, GenericRow> {
    public boolean isDeterministic() {
        return false;
    }

    public GenericRow createAccumulator() {
        GenericRow acc = new GenericRow(2);
        acc.setField(0, null);
        acc.setLong(1, Long.MAX_VALUE);
        return acc;
    }

    public void accumulate(GenericRow acc, Object value) {
        if (value != null && acc.getLong(1) == Long.MAX_VALUE) {
            acc.setField(0, value);
            acc.setLong(1, System.currentTimeMillis());
        }
    }

    public void accumulate(GenericRow acc, Object value, Long order) {
        if (value != null && acc.getLong(1) > order) {
            acc.setField(0, value);
            acc.setLong(1, order.longValue());
        }
    }

    public void resetAccumulator(GenericRow acc) {
        acc.setField(0, null);
        acc.setLong(1, Long.MAX_VALUE);
    }

    public T getValue(GenericRow acc) {
        return (T)acc.getField(0);
    }

    public TypeInformation<GenericRow> getAccumulatorType() {
        LogicalType[] fieldTypes = new LogicalType[]{TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType((TypeInformation)this.getResultType()), new BigIntType()};
        String[] fieldNames = new String[]{"value", "time"};
        return new BaseRowTypeInfo(fieldTypes, fieldNames);
    }

    public static class StringFirstValueAggFunction
    extends FirstValueAggFunction<BinaryString> {
        public TypeInformation<BinaryString> getResultType() {
            return BinaryStringTypeInfo.INSTANCE;
        }

        public void accumulate(GenericRow acc, BinaryString value) {
            if (value != null) {
                super.accumulate(acc, value.copy());
            }
        }

        public void accumulate(GenericRow acc, BinaryString value, Long order) {
            if (value != null) {
                super.accumulate(acc, value.copy(), order);
            }
        }
    }

    public static class DecimalFirstValueAggFunction
    extends FirstValueAggFunction<Decimal> {
        private DecimalTypeInfo decimalTypeInfo;

        public DecimalFirstValueAggFunction(DecimalTypeInfo decimalTypeInfo) {
            this.decimalTypeInfo = decimalTypeInfo;
        }

        public void accumulate(GenericRow acc, Decimal value) {
            super.accumulate(acc, value);
        }

        public void accumulate(GenericRow acc, Decimal value, Long order) {
            super.accumulate(acc, value, order);
        }

        public TypeInformation<Decimal> getResultType() {
            return this.decimalTypeInfo;
        }
    }

    public static class BooleanFirstValueAggFunction
    extends FirstValueAggFunction<Boolean> {
        public TypeInformation<Boolean> getResultType() {
            return Types.BOOLEAN;
        }
    }

    public static class DoubleFirstValueAggFunction
    extends FirstValueAggFunction<Double> {
        public TypeInformation<Double> getResultType() {
            return Types.DOUBLE;
        }
    }

    public static class FloatFirstValueAggFunction
    extends FirstValueAggFunction<Float> {
        public TypeInformation<Float> getResultType() {
            return Types.FLOAT;
        }
    }

    public static class LongFirstValueAggFunction
    extends FirstValueAggFunction<Long> {
        public TypeInformation<Long> getResultType() {
            return Types.LONG;
        }
    }

    public static class IntFirstValueAggFunction
    extends FirstValueAggFunction<Integer> {
        public TypeInformation<Integer> getResultType() {
            return Types.INT;
        }
    }

    public static class ShortFirstValueAggFunction
    extends FirstValueAggFunction<Short> {
        public TypeInformation<Short> getResultType() {
            return Types.SHORT;
        }
    }

    public static class ByteFirstValueAggFunction
    extends FirstValueAggFunction<Byte> {
        public TypeInformation<Byte> getResultType() {
            return Types.BYTE;
        }
    }
}

