/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.PartitionNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoTableSourceScanRule$;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.plan.utils.PartitionPruner$;
import org.apache.flink.table.planner.plan.utils.RexNodeExtractor$;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.table.planner.utils.CatalogTableStatisticsConverter;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.sources.PartitionableTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001M\u0011A\u0005U;tQB\u000b'\u000f^5uS>t\u0017J\u001c;p)\u0006\u0014G.Z*pkJ\u001cWmU2b]J+H.\u001a\u0006\u0003\u0007\u0011\tq\u0001\\8hS\u000e\fGN\u0003\u0002\u0006\r\u0005)!/\u001e7fg*\u0011q\u0001C\u0001\u0005a2\fgN\u0003\u0002\n\u0015\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0006\r\u0003\u0015!\u0018M\u00197f\u0015\tia\"A\u0003gY&t7N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!F\r\u000e\u0003YQ!aB\f\u000b\u0005aq\u0011aB2bY\u000eLG/Z\u0005\u00035Y\u0011!BU3m\u001fB$(+\u001e7f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!\u0001C\u0003\"\u0001\u0011\u0005#%A\u0004nCR\u001c\u0007.Z:\u0015\u0005\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#a\u0002\"p_2,\u0017M\u001c\u0005\u0006U\u0001\u0002\raK\u0001\u0005G\u0006dG\u000e\u0005\u0002\u0016Y%\u0011QF\u0006\u0002\u000f%\u0016dw\n\u001d;Sk2,7)\u00197m\u0011\u0015y\u0003\u0001\"\u00111\u0003\u001dyg.T1uG\"$\"!\r\u001b\u0011\u0005\u0011\u0012\u0014BA\u001a&\u0005\u0011)f.\u001b;\t\u000b)r\u0003\u0019A\u0016\t\u000bY\u0002A\u0011B\u001c\u0002#\u001d,G\u000fU1si&$\u0018n\u001c8Ti\u0006$8\u000f\u0006\u00039\u0005&s\u0005c\u0001\u0013:w%\u0011!(\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005q\u0002U\"A\u001f\u000b\u0005yz\u0014!B:uCR\u001c(BA\u0004\u000b\u0013\t\tUH\u0001\u0006UC\ndWm\u0015;biNDQaQ\u001bA\u0002\u0011\u000bqaY1uC2|w\r\u0005\u0002F\u000f6\taI\u0003\u0002D\u0015%\u0011\u0001J\u0012\u0002\b\u0007\u0006$\u0018\r\\8h\u0011\u0015QU\u00071\u0001L\u0003Ay'M[3di&#WM\u001c;jM&,'\u000f\u0005\u0002F\u0019&\u0011QJ\u0012\u0002\u0011\u001f\nTWm\u0019;JI\u0016tG/\u001b4jKJDQaT\u001bA\u0002A\u000b\u0001\u0002]1siN\u0003Xm\u0019\t\u0005#ZC\u0006,D\u0001S\u0015\t\u0019F+\u0001\u0003vi&d'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u00131!T1q!\tI\u0006M\u0004\u0002[=B\u00111,J\u0007\u00029*\u0011QLE\u0001\u0007yI|w\u000e\u001e \n\u0005}+\u0013A\u0002)sK\u0012,g-\u0003\u0002bE\n11\u000b\u001e:j]\u001eT!aX\u0013\t\u000b\u0011\u0004A\u0011B3\u00021\u0005$'.^:u!\u0006\u0014H/\u001b;j_:\u0004&/\u001a3jG\u0006$X\r\u0006\u0003gYF\u001c\bCA4k\u001b\u0005A'BA5\u0018\u0003\r\u0011X\r_\u0005\u0003W\"\u0014qAU3y\u001d>$W\rC\u0003nG\u0002\u0007a.A\bj]B,HOR5fY\u0012t\u0015-\\3t!\r!s\u000eW\u0005\u0003a\u0016\u0012Q!\u0011:sCfDQA]2A\u00029\f1\u0003]1si&$\u0018n\u001c8GS\u0016dGMT1nKNDQ\u0001^2A\u0002\u0019\f!\u0003]1si&$\u0018n\u001c8Qe\u0016$\u0017nY1uK\u001e)aO\u0001E\u0001o\u0006!\u0003+^:i!\u0006\u0014H/\u001b;j_:Le\u000e^8UC\ndWmU8ve\u000e,7kY1o%VdW\r\u0005\u0002 q\u001a)\u0011A\u0001E\u0001sN\u0011\u0001P\u001f\t\u0003ImL!\u0001`\u0013\u0003\r\u0005s\u0017PU3g\u0011\u0015a\u0002\u0010\"\u0001\u007f)\u00059\b\"CA\u0001q\n\u0007I\u0011AA\u0002\u0003!Iej\u0015+B\u001d\u000e+U#\u0001\u000b\t\u000f\u0005\u001d\u0001\u0010)A\u0005)\u0005I\u0011JT*U\u0003:\u001bU\t\t")
public class PushPartitionIntoTableSourceScanRule
extends RelOptRule {
    public static RelOptRule INSTANCE() {
        return PushPartitionIntoTableSourceScanRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        TableSourceTable tableSourceTable;
        Filter filter = (Filter)call.rel(0);
        if (filter.getCondition() == null) {
            return false;
        }
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        TableSourceTable tableSourceTable2 = scan.getTable().unwrap(TableSourceTable.class);
        boolean bl = tableSourceTable2 != null ? (tableSourceTable = tableSourceTable2).catalogTable().isPartitioned() && tableSourceTable.tableSource() instanceof PartitionableTableSource : false;
        return bl;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        TableStats tableStats;
        List list;
        Filter filter = (Filter)call.rel(0);
        LogicalTableScan scan = (LogicalTableScan)call.rel(1);
        FlinkContext context = call.getPlanner().getContext().unwrap(FlinkContext.class);
        TableConfig config = context.getTableConfig();
        TableSourceTable tableSourceTable = scan.getTable().unwrap(TableSourceTable.class);
        ObjectIdentifier tableIdentifier = tableSourceTable.tableIdentifier();
        Option catalogOption = JavaScalaConversionUtil$.MODULE$.toScala(context.getCatalogManager().getCatalog(tableIdentifier.getCatalogName()));
        String[] partitionFieldNames = (String[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(tableSourceTable.catalogTable().getPartitionKeys()).toSeq().toArray(ClassTag$.MODULE$.apply(String.class));
        PartitionableTableSource tableSource = (PartitionableTableSource)tableSourceTable.tableSource();
        RelDataType inputFieldType = filter.getInput().getRowType();
        String[] inputFields = (String[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputFieldType.getFieldNames()).toList().toArray(ClassTag$.MODULE$.apply(String.class));
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        int maxCnfNodeCount = FlinkRelOptUtil$.MODULE$.getMaxCnfNodeCount(scan);
        Tuple2<Seq<RexNode>, Seq<RexNode>> tuple2 = RexNodeExtractor$.MODULE$.extractPartitionPredicateList(filter.getCondition(), maxCnfNodeCount, inputFields, rexBuilder, partitionFieldNames);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq partitionPredicates = (Seq)tuple2._1();
        Seq nonPartitionPredicates = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionPredicates, (Object)nonPartitionPredicates);
        Tuple2 tuple23 = tuple22;
        Seq partitionPredicates2 = (Seq)tuple23._1();
        Seq nonPartitionPredicates2 = (Seq)tuple23._2();
        RexNode partitionPredicate = RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(partitionPredicates2));
        if (partitionPredicate.isAlwaysTrue()) {
            return;
        }
        LogicalType[] partitionFieldTypes = (LogicalType[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFieldNames)).map((Function1 & Serializable & scala.Serializable)name -> {
            int index = inputFieldType.getFieldNames().indexOf(name);
            Predef$.MODULE$.require(index >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append((String)name).append(" is not found in ").append(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputFieldType.getFieldNames()).mkString(", ")).toString());
            return inputFieldType.getFieldList().get(index).getType();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(RelDataType.class))))).map((Function1 & Serializable & scala.Serializable)relDataType -> FlinkTypeFactory$.MODULE$.toLogicalType((RelDataType)relDataType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogicalType.class)));
        Option option = catalogOption;
        if (option instanceof Some) {
            List list2;
            Some some = (Some)option;
            Catalog catalog = (Catalog)some.value();
            RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(inputFields, context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(config.getLocalTimeZone()));
            Option option2 = PushPartitionIntoTableSourceScanRule.toExpressions$1(partitionPredicates2, converter);
            if (option2 instanceof Some) {
                List list3;
                Some some2 = (Some)option2;
                Seq expressions = (Seq)some2.value();
                try {
                    list3 = JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(catalog.listPartitionsByFilter(tableIdentifier.toObjectPath(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(expressions))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getPartitionSpec(), Buffer$.MODULE$.canBuildFrom()));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    list3 = this.internalPartitionPrune$1(config, tableIdentifier, catalogOption, partitionFieldNames, tableSource, inputFieldType, partitionPredicate, partitionFieldTypes);
                }
                list2 = list3;
            } else if (None$.MODULE$.equals(option2)) {
                list2 = this.internalPartitionPrune$1(config, tableIdentifier, catalogOption, partitionFieldNames, tableSource, inputFieldType, partitionPredicate, partitionFieldTypes);
            } else {
                throw new MatchError((Object)option2);
            }
            list = list2;
        } else if (None$.MODULE$.equals(option)) {
            list = this.internalPartitionPrune$1(config, tableIdentifier, catalogOption, partitionFieldNames, tableSource, inputFieldType, partitionPredicate, partitionFieldTypes);
        } else {
            throw new MatchError(option);
        }
        List remainingPartitions = list;
        TableSource newTableSource = tableSource.applyPartitionPruning(remainingPartitions);
        if (newTableSource.explainSource().equals(tableSourceTable.tableSource().explainSource())) {
            throw new TableException("Failed to push partition into table source! table source with pushdown capability must override and change explainSource() API to explain the pushdown applied!");
        }
        FlinkStatistic statistic = tableSourceTable.getStatistic();
        Option option3 = catalogOption;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            Catalog catalog = (Catalog)some.value();
            tableStats = this.mergePartitionStats$1(tableIdentifier, remainingPartitions, catalog);
        } else if (None$.MODULE$.equals(option3)) {
            tableStats = null;
        } else {
            throw new MatchError(option3);
        }
        TableStats tableStats2 = tableStats;
        FlinkStatistic newStatistic = FlinkStatistic$.MODULE$.builder().statistic(statistic).tableStats(tableStats2).build();
        TableSourceTable newTableSourceTable = tableSourceTable.copy(newTableSource, newStatistic);
        LogicalTableScan newScan = new LogicalTableScan(scan.getCluster(), scan.getTraitSet(), newTableSourceTable);
        RexNode nonPartitionPredicate = RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(nonPartitionPredicates2));
        if (nonPartitionPredicate.isAlwaysTrue()) {
            call.transformTo(newScan);
        } else {
            Filter newFilter = filter.copy(filter.getTraitSet(), newScan, nonPartitionPredicate);
            call.transformTo(newFilter);
        }
    }

    private Option<TableStats> getPartitionStats(Catalog catalog, ObjectIdentifier objectIdentifier, Map<String, String> partSpec) {
        None$ none$;
        ObjectPath tablePath = objectIdentifier.toObjectPath();
        CatalogPartitionSpec spec = new CatalogPartitionSpec(new LinkedHashMap<String, String>(partSpec));
        try {
            CatalogTableStatistics tableStatistics = catalog.getPartitionStatistics(tablePath, spec);
            CatalogColumnStatistics columnStatistics = catalog.getPartitionColumnStatistics(tablePath, spec);
            none$ = new Some((Object)CatalogTableStatisticsConverter.convertToTableStats(tableStatistics, columnStatistics));
        }
        catch (PartitionNotExistException partitionNotExistException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private RexNode adjustPartitionPredicate(String[] inputFieldNames, String[] partitionFieldNames, RexNode partitionPredicate) {
        return partitionPredicate.accept(new RexShuttle(null, inputFieldNames, partitionFieldNames){
            private final String[] inputFieldNames$1;
            private final String[] partitionFieldNames$2;

            public RexNode visitInputRef(RexInputRef inputRef) {
                int index = inputRef.getIndex();
                String fieldName = this.inputFieldNames$1[index];
                int newIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitionFieldNames$2)).indexOf((Object)fieldName);
                Predef$.MODULE$.require(newIndex >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append(fieldName).append(" is not found in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.partitionFieldNames$2)).mkString(", ")).toString());
                return index == newIndex ? inputRef : new RexInputRef(newIndex, inputRef.getType());
            }
            {
                this.inputFieldNames$1 = inputFieldNames$1;
                this.partitionFieldNames$2 = partitionFieldNames$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitInputRef$1(org.apache.flink.table.planner.plan.rules.logical.PushPartitionIntoTableSourceScanRule$$anon$1 java.lang.String )}, serializedLambda);
            }
        });
    }

    private static final List getAllPartitions$1(ObjectIdentifier tableIdentifier$1, Option catalogOption$1, PartitionableTableSource tableSource$1) {
        List list;
        Option option = catalogOption$1;
        if (option instanceof Some) {
            Some some = (Some)option;
            Catalog c = (Catalog)some.value();
            list = JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(c.listPartitions(tableIdentifier$1.toObjectPath())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPartitionSpec(), Buffer$.MODULE$.canBuildFrom())).toList());
        } else if (None$.MODULE$.equals(option)) {
            list = tableSource$1.getPartitions();
        } else {
            throw new MatchError((Object)option);
        }
        return list;
    }

    private final List internalPartitionPrune$1(TableConfig config$1, ObjectIdentifier tableIdentifier$1, Option catalogOption$1, String[] partitionFieldNames$1, PartitionableTableSource tableSource$1, RelDataType inputFieldType$1, RexNode partitionPredicate$1, LogicalType[] partitionFieldTypes$1) {
        List allPartitions = PushPartitionIntoTableSourceScanRule.getAllPartitions$1(tableIdentifier$1, catalogOption$1, tableSource$1);
        RexNode finalPartitionPredicate = this.adjustPartitionPredicate((String[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputFieldType$1.getFieldNames()).toList().toArray(ClassTag$.MODULE$.apply(String.class)), partitionFieldNames$1, partitionPredicate$1);
        return PartitionPruner$.MODULE$.prunePartitions(config$1, partitionFieldNames$1, partitionFieldTypes$1, allPartitions, finalPartitionPredicate);
    }

    public static final /* synthetic */ boolean $anonfun$onMatch$5(RexNodeToExpressionConverter converter$1, ArrayBuffer expressions$1, Object nonLocalReturnKey1$1, RexNode predicate) {
        Option<ResolvedExpression> option = predicate.accept(converter$1);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)None$.MODULE$);
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        ResolvedExpression expr = (ResolvedExpression)some.value();
        boolean bl = JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)expressions$1).add(expr);
        return bl;
    }

    private static final Option toExpressions$1(Seq partitionPredicates$1, RexNodeToExpressionConverter converter$1) {
        Option option;
        Object object = new Object();
        try {
            ArrayBuffer expressions = new ArrayBuffer();
            partitionPredicates$1.foreach((Function1 & Serializable & scala.Serializable)predicate -> BoxesRunTime.boxToBoolean((boolean)PushPartitionIntoTableSourceScanRule.$anonfun$onMatch$5(converter$1, expressions, object, predicate)));
            option = new Some((Object)expressions);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$onMatch$7(PushPartitionIntoTableSourceScanRule $this, ObjectIdentifier tableIdentifier$1, Catalog catalog$1, ObjectRef stats$1, Object nonLocalReturnKey2$1, Map p) {
        BoxedUnit boxedUnit;
        Option<TableStats> option = $this.getPartitionStats(catalog$1, tableIdentifier$1, p);
        if (option instanceof Some) {
            Some some = (Some)option;
            TableStats currStats = (TableStats)some.value();
            if ((TableStats)stats$1.elem == null) {
                stats$1.elem = currStats;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                stats$1.elem = ((TableStats)stats$1.elem).merge(currStats);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, null);
            }
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final TableStats mergePartitionStats$1(ObjectIdentifier tableIdentifier$1, List remainingPartitions$1, Catalog catalog$1) {
        TableStats tableStats;
        Object object = new Object();
        try {
            ObjectRef stats = ObjectRef.create(null);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(remainingPartitions$1).foreach((Function1 & Serializable & scala.Serializable)p -> {
                PushPartitionIntoTableSourceScanRule.$anonfun$onMatch$7(this, tableIdentifier$1, catalog$1, stats, object, p);
                return BoxedUnit.UNIT;
            });
            tableStats = (TableStats)stats.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tableStats = (TableStats)ex.value();
            }
            throw ex;
        }
        return tableStats;
    }

    public PushPartitionIntoTableSourceScanRule() {
        super(RelOptRule.operand(Filter.class, RelOptRule.operand(LogicalTableScan.class, RelOptRule.none()), new RelOptRuleOperand[0]), "PushPartitionIntoTableSourceScanRule");
    }
}

