/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder$;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.calcite.SqlExprToRexConverterFactory;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.plan.schema.FlinkPreparingTableBase;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\u0001\u0003\u0001E\u0011!cQ1uC2|wmU8ve\u000e,G+\u00192mK*\u00111\u0001B\u0001\u0007g\u000eDW-\\1\u000b\u0005\u00151\u0011\u0001\u00029mC:T!a\u0002\u0005\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0011BC\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u00171\tQA\u001a7j].T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u0001QC\u0001\n]'\t\u00011\u0003\u0005\u0002\u0015+5\t!!\u0003\u0002\u0017\u0005\t9b\t\\5oWB\u0013X\r]1sS:<G+\u00192mK\n\u000b7/\u001a\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005a!/\u001a7PaR\u001c6\r[3nCB\u0011!DH\u0007\u00027)\u0011Q\u0001\b\u0006\u0003;1\tqaY1mG&$X-\u0003\u0002 7\ta!+\u001a7PaR\u001c6\r[3nC\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0003oC6,7\u000fE\u0002$Q)j\u0011\u0001\n\u0006\u0003K\u0019\nA!\u001e;jY*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0011a\u0015n\u001d;\u0011\u0005-\"dB\u0001\u00173!\ti\u0003'D\u0001/\u0015\ty\u0003#\u0001\u0004=e>|GO\u0010\u0006\u0002c\u0005)1oY1mC&\u00111\u0007M\u0001\u0007!J,G-\u001a4\n\u0005U2$AB*ue&twM\u0003\u00024a!A\u0001\b\u0001B\u0001B\u0003%\u0011(A\u0004s_^$\u0016\u0010]3\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014\u0001\u0002;za\u0016T!A\u0010\u000f\u0002\u0007I,G.\u0003\u0002Aw\tY!+\u001a7ECR\fG+\u001f9f\u0011!\u0011\u0005A!b\u0001\n\u0003\u0019\u0015aC:dQ\u0016l\u0017\rV1cY\u0016,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f\u001a\tqaY1uC2|w-\u0003\u0002J\r\n\u00112)\u0019;bY><7k\u00195f[\u0006$\u0016M\u00197f\u0011!Y\u0005A!A!\u0002\u0013!\u0015\u0001D:dQ\u0016l\u0017\rV1cY\u0016\u0004\u0003\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0001(\u0002\u0019\r\fG/\u00197pOR\u000b'\r\\3\u0016\u0003=\u0003\"\u0001\u0015*\u000e\u0003ES!a\u0012\u0005\n\u0005M\u000b&\u0001D\"bi\u0006dwn\u001a+bE2,\u0007\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B(\u0002\u001b\r\fG/\u00197pOR\u000b'\r\\3!\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u0019a\u0014N\\5u}Q1\u0011LZ4iS*\u00042\u0001\u0006\u0001[!\tYF\f\u0004\u0001\u0005\u000bu\u0003!\u0019\u00010\u0003\u0003Q\u000b\"aX2\u0011\u0005\u0001\fW\"\u0001\u0019\n\u0005\t\u0004$a\u0002(pi\"Lgn\u001a\t\u0003A\u0012L!!\u001a\u0019\u0003\u0007\u0005s\u0017\u0010C\u0003\u0019-\u0002\u0007\u0011\u0004C\u0003\"-\u0002\u0007!\u0005C\u00039-\u0002\u0007\u0011\bC\u0003C-\u0002\u0007A\tC\u0003N-\u0002\u0007q\n\u0003\u0005m\u0001!\u0015\r\u0011\"\u0001n\u0003-\u0019w\u000e\\;n]\u0016C\bO]:\u0016\u00039\u0004BaK8+U%\u0011\u0001O\u000e\u0002\u0004\u001b\u0006\u0004\b\u0002\u0003:\u0001\u0011\u000b\u0007I\u0011A:\u0002\u0017Q\f'\r\\3T_V\u00148-Z\u000b\u0002iB\u0019Q\u000f\u001f.\u000e\u0003YT!a\u001e\u0005\u0002\u000fM|WO]2fg&\u0011\u0011P\u001e\u0002\f)\u0006\u0014G.Z*pkJ\u001cW\rC\u0003|\u0001\u0011\u0005C0\u0001\thKR\fV/\u00197jM&,GMT1nKR\t!\u0005C\u0003\u007f\u0001\u0011\u0005s0A\u0003u_J+G\u000e\u0006\u0003\u0002\u0002\u0005%\u0001\u0003BA\u0002\u0003\u000bi\u0011!P\u0005\u0004\u0003\u000fi$a\u0002*fY:{G-\u001a\u0005\b\u0003\u0017i\b\u0019AA\u0007\u0003\u001d\u0019wN\u001c;fqR\u0004B!a\u0004\u0002\u00169\u0019!$!\u0005\n\u0007\u0005M1$A\u0006SK2|\u0005\u000f\u001e+bE2,\u0017\u0002BA\f\u00033\u0011A\u0002V8SK2\u001cuN\u001c;fqRT1!a\u0005\u001c\u0011\u001d\ti\u0002\u0001C\u0005\u0003?\t\u0001DZ5oI\u0006sGm\u0011:fCR,G+\u00192mKN{WO]2f)\t\t\t\u0003\r\u0003\u0002$\u0005\u001d\u0002\u0003B;y\u0003K\u00012aWA\u0014\t-\tI#a\u0007\u0002\u0002\u0003\u0005)\u0011\u00010\u0003\u0007}#\u0013\u0007C\u0004\u0002.\u0001!\t&a\f\u0002+\u0015D\b\u000f\\1j]N{WO]2f\u0003N\u001cFO]5oOR\u0019!%!\r\t\u0011\u0005M\u00121\u0006a\u0001\u0003k\t!\u0001^:1\t\u0005]\u00121\b\t\u0005kb\fI\u0004E\u0002\\\u0003w!1\"!\u0010\u00022\u0005\u0005\t\u0011!B\u0001=\n\u0019q\f\n\u001a\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\u0005\u0011RM]1tKRKW.Z%oI&\u001c\u0017\r^8s)\u0015I\u0014QIA%\u0011\u001d\t9%a\u0010A\u0002e\n1B]3m\t\u0006$\u0018\rV=qK\"A\u00111JA \u0001\u0004\ti%A\u0004gC\u000e$xN]=\u0011\t\u0005=\u00131K\u0007\u0003\u0003#R!!\b\u0004\n\t\u0005U\u0013\u0011\u000b\u0002\u0011\r2Lgn\u001b+za\u00164\u0015m\u0019;pef\u0004")
public class CatalogSourceTable<T>
extends FlinkPreparingTableBase {
    private Map<String, String> columnExprs;
    private TableSource<T> tableSource;
    private final RelOptSchema relOptSchema;
    private final RelDataType rowType;
    private final CatalogSchemaTable schemaTable;
    private final CatalogTable catalogTable;
    private volatile byte bitmap$0;

    public CatalogSchemaTable schemaTable() {
        return this.schemaTable;
    }

    public CatalogTable catalogTable() {
        return this.catalogTable;
    }

    private Map<String, String> columnExprs$lzycompute() {
        CatalogSourceTable catalogSourceTable = this;
        synchronized (catalogSourceTable) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.columnExprs = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.catalogTable().getSchema().getTableColumns()).filter((Function1 & Serializable & scala.Serializable)column -> BoxesRunTime.boxToBoolean((boolean)column.isGenerated()))).map((Function1 & Serializable & scala.Serializable)column -> new Tuple2((Object)column.getName(), column.getExpr().get()), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.columnExprs;
    }

    public Map<String, String> columnExprs() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.columnExprs$lzycompute() : this.columnExprs;
    }

    private TableSource<T> tableSource$lzycompute() {
        CatalogSourceTable catalogSourceTable = this;
        synchronized (catalogSourceTable) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tableSource = this.findAndCreateTableSource();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tableSource;
    }

    public TableSource<T> tableSource() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tableSource$lzycompute() : this.tableSource;
    }

    @Override
    public List<String> getQualifiedName() {
        return this.explainSourceAsString(this.tableSource());
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context) {
        Object object;
        Object object2;
        RelOptCluster cluster = context.getCluster();
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        RelDataType erasedRowType = this.eraseTimeIndicator(this.rowType, typeFactory);
        TableSourceTable<T> tableSourceTable = new TableSourceTable<T>(this.relOptSchema, this.schemaTable().getTableIdentifier(), erasedRowType, this.statistic, this.tableSource(), this.schemaTable().isStreamingMode(), this.catalogTable());
        int[] physicalFields = (int[])((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldList()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)CatalogSourceTable.$anonfun$toRel$1(this, f)))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToInteger((int)f.getIndex()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        TableSourceTable<T> newRelTable = tableSourceTable.copy(this.tableSource(), physicalFields);
        LogicalTableScan scan = LogicalTableScan.create(cluster, newRelTable);
        FlinkRelBuilder relBuilder = FlinkRelBuilder$.MODULE$.of(cluster, this.getRelOptSchema());
        relBuilder.push(scan);
        SqlExprToRexConverterFactory toRexFactory = cluster.getPlanner().getContext().unwrap(FlinkContext.class).getSqlExprToRexConverterFactory();
        Buffer fieldNames = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(erasedRowType.getFieldNames()).asScala();
        if (this.columnExprs().nonEmpty()) {
            String[] fieldExprs = (String[])((TraversableOnce)fieldNames.map((Function1 & Serializable & scala.Serializable)name -> this.columnExprs().contains(name) ? (String)this.columnExprs().apply(name) : new StringBuilder(2).append("`").append((String)name).append("`").toString(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            RexNode[] rexNodes = toRexFactory.create(newRelTable.getRowType()).convertToRexNodes(fieldExprs);
            object2 = relBuilder.projectNamed(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rexNodes)).toList()), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(fieldNames), true);
        } else {
            object2 = BoxedUnit.UNIT;
        }
        Option watermarkSpec = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.catalogTable().getSchema().getWatermarkSpecs()).asScala()).headOption();
        if (this.schemaTable().isStreamingMode() && watermarkSpec.nonEmpty()) {
            if (TableSourceValidation.hasRowtimeAttribute(this.tableSource())) {
                throw new TableException("If watermark is specified in DDL, the underlying TableSource of connector shouldn't return an non-empty list of RowtimeAttributeDescriptor via DefinedRowtimeAttributes interface.");
            }
            String rowtime = ((WatermarkSpec)watermarkSpec.get()).getRowtimeAttribute();
            if (rowtime.contains(".")) {
                throw new TableException(new StringBuilder(64).append("Nested field '").append(rowtime).append("' as rowtime attribute is not supported right now.").toString());
            }
            int rowtimeIndex = fieldNames.indexOf((Object)rowtime);
            RexNode watermarkRexNode = toRexFactory.create(erasedRowType).convertToRexNode(((WatermarkSpec)watermarkSpec.get()).getWatermarkExpr());
            object = relBuilder.watermark(rowtimeIndex, watermarkRexNode);
        } else {
            object = BoxedUnit.UNIT;
        }
        return relBuilder.build();
    }

    private TableSource<?> findAndCreateTableSource() {
        TableSource tableSource;
        Optional<TableFactory> tableFactoryOpt = this.schemaTable().getTableFactory();
        if (tableFactoryOpt.isPresent()) {
            TableFactory tableFactory = tableFactoryOpt.get();
            if (!(tableFactory instanceof TableSourceFactory)) {
                throw new TableException("Cannot query a sink-only table. TableFactory provided by catalog must implement TableSourceFactory");
            }
            TableSourceFactory tableSourceFactory = (TableSourceFactory)tableFactory;
            TableSource tableSource2 = tableSourceFactory.createTableSource(this.schemaTable().getTableIdentifier().toObjectPath(), this.catalogTable());
            tableSource = tableSource2;
        } else {
            tableSource = TableFactoryUtil.findAndCreateTableSource((CatalogTable)this.catalogTable());
        }
        TableSource tableSource3 = tableSource;
        String tableName = this.schemaTable().getTableIdentifier().asSummaryString();
        TableSource tableSource4 = tableSource3;
        if (tableSource4 instanceof StreamTableSource) {
            StreamTableSource streamTableSource = (StreamTableSource)tableSource4;
            if (!this.schemaTable().isStreamingMode() && !streamTableSource.isBounded()) {
                throw new ValidationException(new StringBuilder(51).append("Cannot query on an unbounded source in batch mode, ").append(new StringBuilder(20).append("but '").append(tableName).append("' is unbounded.").toString()).toString());
            }
        } else {
            throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource");
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return tableSource3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> explainSourceAsString(TableSource<?> ts) {
        void var2_2;
        ArrayList<String> ret = new ArrayList<String>(super.explainSourceAsString(ts));
        ret.add(new StringBuilder(7).append("class: ").append(CatalogSourceTable.class.getSimpleName()).toString());
        return var2_2;
    }

    private RelDataType eraseTimeIndicator(RelDataType relDataType, FlinkTypeFactory factory) {
        RowType logicalRowType = FlinkTypeFactory$.MODULE$.toLogicalRowType(relDataType);
        List fieldNames = logicalRowType.getFieldNames();
        Buffer fieldTypes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(logicalRowType.getFields()).map((Function1 & Serializable & scala.Serializable)f -> {
            LogicalType logicalType;
            if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(f.getType())) {
                TimestampType timeIndicatorType = (TimestampType)f.getType();
                logicalType = new TimestampType(timeIndicatorType.isNullable(), TimestampKind.REGULAR, timeIndicatorType.getPrecision());
            } else {
                logicalType = f.getType();
            }
            return logicalType;
        }, Buffer$.MODULE$.canBuildFrom());
        return factory.buildRelNodeRowType((Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldNames), (Seq<LogicalType>)fieldTypes);
    }

    public static final /* synthetic */ boolean $anonfun$toRel$1(CatalogSourceTable $this, RelDataTypeField f) {
        return !$this.columnExprs().contains((Object)f.getName());
    }

    public CatalogSourceTable(RelOptSchema relOptSchema, List<String> names, RelDataType rowType, CatalogSchemaTable schemaTable, CatalogTable catalogTable) {
        this.relOptSchema = relOptSchema;
        this.rowType = rowType;
        this.schemaTable = schemaTable;
        this.catalogTable = catalogTable;
        super(relOptSchema, rowType, names, schemaTable.getStatistic());
    }
}

