/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.nodes.calcite.Expand;
import org.apache.flink.table.planner.plan.nodes.calcite.Rank;
import org.apache.flink.table.planner.plan.nodes.calcite.WindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecGroupAggregateBase;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecLocalHashWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecLocalSortWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecWindowAggregateBase;
import org.apache.flink.table.planner.plan.utils.AggregateUtil$;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil;
import org.apache.flink.table.planner.plan.utils.RankUtil$;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class FlinkRelMdUtil$ {
    public static FlinkRelMdUtil$ MODULE$;

    static {
        new FlinkRelMdUtil$();
    }

    public Double getSemiAntiJoinRowCount(RelMetadataQuery mq, RelNode left, RelNode right, JoinRelType joinType, RexNode condition, boolean isAnti) {
        double selectivity;
        Double leftCount;
        block1: {
            leftCount = mq.getRowCount(left);
            if (leftCount == null) {
                return null;
            }
            selectivity = RexUtil.getSelectivity(condition);
            if (!isAnti) break block1;
            selectivity = 1.0 - selectivity;
        }
        return Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(leftCount) * selectivity);
    }

    /*
     * Unable to fully structure code
     */
    public RexNode makeSemiAntiJoinSelectivityRexNode(RelMetadataQuery mq, Join rel) {
        v0 = rel.getJoinType();
        var3_3 = JoinRelType.SEMI;
        if (!(v0 == null ? var3_3 != null : v0.equals((Object)var3_3) == false)) ** GOTO lbl-1000
        v1 = rel.getJoinType();
        var4_4 = JoinRelType.ANTI;
        if (!(v1 != null ? v1.equals((Object)var4_4) == false : var4_4 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Predef$.MODULE$.require(v2);
        joinInfo = rel.analyzeCondition();
        rexBuilder = rel.getCluster().getRexBuilder();
        v3 = rel.getJoinType();
        var7_7 = JoinRelType.ANTI;
        return this.makeSemiAntiJoinSelectivityRexNode(mq, joinInfo, rel.getLeft(), rel.getRight(), !(v3 != null ? v3.equals((Object)var7_7) == false : var7_7 != null), rexBuilder);
    }

    private RexNode makeSemiAntiJoinSelectivityRexNode(RelMetadataQuery mq, JoinInfo joinInfo, RelNode left, RelNode right, boolean isAnti, RexBuilder rexBuilder) {
        double antiJoinSelectivity;
        Double equiSelectivity = !joinInfo.leftKeys.isEmpty() ? Predef$.MODULE$.double2Double(RelMdUtil.computeSemiJoinSelectivity(mq, left, right, joinInfo.leftKeys, joinInfo.rightKeys)) : Predef$.MODULE$.double2Double(1.0);
        double nonEquiSelectivity = RelMdUtil.guessSelectivity(joinInfo.getRemaining(rexBuilder));
        double semiJoinSelectivity = Predef$.MODULE$.Double2double(equiSelectivity) * nonEquiSelectivity;
        double selectivity = isAnti ? ((antiJoinSelectivity = 1.0 - semiJoinSelectivity) == 0.0 ? 0.1 : antiJoinSelectivity) : semiJoinSelectivity;
        return rexBuilder.makeCall((SqlOperator)RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC, rexBuilder.makeApproxLiteral(new BigDecimal(selectivity)));
    }

    public Double adaptNdvBasedOnSelectivity(Double rowCount, Double distinctRowCount, Double selectivity) {
        double ndv = Math.min(Predef$.MODULE$.Double2double(distinctRowCount), Predef$.MODULE$.Double2double(rowCount));
        return Predef$.MODULE$.double2Double(Math.max((1.0 - Math.pow(1.0 - Predef$.MODULE$.Double2double(selectivity), Predef$.MODULE$.Double2double(rowCount) / ndv)) * ndv, 1.0));
    }

    public Double getAggregationRatioIfNdvUnavailable(int groupingLength) {
        return Predef$.MODULE$.double2Double(1.0 - package$.MODULE$.exp(-0.1 * (double)groupingLength));
    }

    public RexNode makeNamePropertiesSelectivityRexNode(WindowAggregate winAgg, RexNode predicate) {
        int[] fullGroupSet = AggregateUtil$.MODULE$.checkAndGetFullGroupSet(winAgg);
        return this.makeNamePropertiesSelectivityRexNode(winAgg, fullGroupSet, winAgg.getNamedProperties(), predicate);
    }

    public RexNode makeNamePropertiesSelectivityRexNode(BatchExecWindowAggregateBase globalWinAgg, RexNode predicate) {
        Predef$.MODULE$.require(globalWinAgg.isFinal(), (Function0 & Serializable & scala.Serializable)() -> "local window agg does not contain NamedProperties!");
        int[] fullGrouping = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(globalWinAgg.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(globalWinAgg.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return this.makeNamePropertiesSelectivityRexNode(globalWinAgg, fullGrouping, globalWinAgg.getNamedProperties(), predicate);
    }

    public RexNode makeNamePropertiesSelectivityRexNode(SingleRel winAgg, int[] fullGrouping, Seq<FlinkRelBuilder.PlannerNamedWindowProperty> namedProperties, RexNode predicate) {
        Object object;
        if (predicate == null || predicate.isAlwaysTrue() || namedProperties.isEmpty()) {
            return predicate;
        }
        RexBuilder rexBuilder = winAgg.getCluster().getRexBuilder();
        int namePropertiesStartIdx = winAgg.getRowType().getFieldCount() - namedProperties.size();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(0, namePropertiesStartIdx), predicate, pushable, notPushable);
        if (JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(notPushable).nonEmpty()) {
            RexNode pred = RexUtil.composeConjunction(rexBuilder, notPushable, true);
            double selectivity = RelMdUtil.guessSelectivity(pred);
            RexNode fun = rexBuilder.makeCall((SqlOperator)RelMdUtil.ARTIFICIAL_SELECTIVITY_FUNC, rexBuilder.makeApproxLiteral(new BigDecimal(selectivity)));
            object = BoxesRunTime.boxToBoolean((boolean)pushable.add(fun));
        } else {
            object = BoxedUnit.UNIT;
        }
        return RexUtil.composeConjunction(rexBuilder, pushable, true);
    }

    public Double getRowCountOfLocalAgg(int parallelism, Double inputRowCount, Double globalAggRowCount) {
        return Predef$.MODULE$.double2Double(Math.min((1.0 - package$.MODULE$.pow(1.0 - 1.0 / (double)parallelism, Predef$.MODULE$.Double2double(inputRowCount) / Predef$.MODULE$.Double2double(globalAggRowCount))) * Predef$.MODULE$.Double2double(globalAggRowCount) * (double)parallelism, Predef$.MODULE$.Double2double(inputRowCount)));
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, Aggregate aggRel) {
        ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
        ArrayBuffer aggCalls = new ArrayBuffer();
        int[] groupSet = aggRel.getGroupSet().toArray();
        Tuple2<int[], Seq<AggregateCall>> tuple2 = AggregateUtil$.MODULE$.checkAndSplitAggCalls(aggRel);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int[] auxGroupSet = (int[])tuple2._1();
        Seq otherAggCalls = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)auxGroupSet, (Object)otherAggCalls);
        Tuple2 tuple23 = tuple22;
        int[] auxGroupSet2 = (int[])tuple23._1();
        Seq otherAggCalls2 = (Seq)tuple23._2();
        int[] fullGroupSet = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupSet)).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(auxGroupSet2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        boolean containsAllAggGroupKeys = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(fullGroupSet)).indices().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> groupKey.get(x$1));
        JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)groupKey).foreach((Function1 & Serializable & scala.Serializable)bit -> {
            Object object;
            if (Predef$.MODULE$.Integer2int(bit) < fullGroupSet.length) {
                object = childKeyBuilder.set(fullGroupSet[Predef$.MODULE$.Integer2int(bit)]);
            } else if (!containsAllAggGroupKeys) {
                AggregateCall agg = (AggregateCall)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(otherAggCalls2).get(Predef$.MODULE$.Integer2int(bit) - (fullGroupSet.length + aggRel.getIndicatorCount()));
                object = aggCalls.$plus$eq((Object)agg);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return new Tuple2((Object)childKeyBuilder.build(), aggCalls.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)));
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, BatchExecGroupAggregateBase aggRel) {
        Predef$.MODULE$.require(!aggRel.isFinal() || !aggRel.isMerge(), (Function0 & Serializable & scala.Serializable)() -> "Cannot handle global agg which has local agg!");
        return this.setChildKeysOfAgg(groupKey, aggRel);
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> setAggChildKeys(ImmutableBitSet groupKey, BatchExecWindowAggregateBase aggRel) {
        Predef$.MODULE$.require(!aggRel.isFinal() || !aggRel.isMerge(), (Function0 & Serializable & scala.Serializable)() -> "Cannot handle global agg which has local agg!");
        return this.setChildKeysOfAgg(groupKey, aggRel);
    }

    private Tuple2<ImmutableBitSet, AggregateCall[]> setChildKeysOfAgg(ImmutableBitSet groupKey, SingleRel agg) {
        Tuple2 tuple2;
        SingleRel singleRel = agg;
        if (singleRel instanceof BatchExecLocalSortWindowAggregate) {
            BatchExecLocalSortWindowAggregate batchExecLocalSortWindowAggregate = (BatchExecLocalSortWindowAggregate)singleRel;
            tuple2 = new Tuple2(batchExecLocalSortWindowAggregate.getAggCallList(), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalSortWindowAggregate.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{batchExecLocalSortWindowAggregate.inputTimeFieldIndex()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalSortWindowAggregate.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else if (singleRel instanceof BatchExecLocalHashWindowAggregate) {
            BatchExecLocalHashWindowAggregate batchExecLocalHashWindowAggregate = (BatchExecLocalHashWindowAggregate)singleRel;
            tuple2 = new Tuple2(batchExecLocalHashWindowAggregate.getAggCallList(), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalHashWindowAggregate.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{batchExecLocalHashWindowAggregate.inputTimeFieldIndex()})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecLocalHashWindowAggregate.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else if (singleRel instanceof BatchExecWindowAggregateBase) {
            BatchExecWindowAggregateBase batchExecWindowAggregateBase = (BatchExecWindowAggregateBase)singleRel;
            tuple2 = new Tuple2(batchExecWindowAggregateBase.getAggCallList(), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecWindowAggregateBase.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecWindowAggregateBase.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else if (singleRel instanceof BatchExecGroupAggregateBase) {
            BatchExecGroupAggregateBase batchExecGroupAggregateBase = (BatchExecGroupAggregateBase)singleRel;
            tuple2 = new Tuple2(batchExecGroupAggregateBase.getAggCallList(), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecGroupAggregateBase.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(batchExecGroupAggregateBase.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
        } else {
            throw new IllegalArgumentException(new StringBuilder(19).append("Unknown aggregate: ").append(agg.getRelTypeName()).toString());
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Seq aggCalls = (Seq)tuple22._1();
        int[] fullGroupSet = (int[])tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)aggCalls, (Object)fullGroupSet);
        Tuple2 tuple24 = tuple23;
        Seq aggCalls2 = (Seq)tuple24._1();
        int[] fullGroupSet2 = (int[])tuple24._2();
        boolean containsAllAggGroupKeys = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(fullGroupSet2)).indices().forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> groupKey.get(x$1));
        ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
        ArrayBuffer aggs = new ArrayBuffer();
        JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)groupKey).foreach((Function1 & Serializable & scala.Serializable)bit -> {
            Object object;
            if (Predef$.MODULE$.Integer2int(bit) < fullGroupSet2.length) {
                object = childKeyBuilder.set(fullGroupSet2[Predef$.MODULE$.Integer2int(bit)]);
            } else if (!containsAllAggGroupKeys) {
                AggregateCall agg = (AggregateCall)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(aggCalls2).get(Predef$.MODULE$.Integer2int(bit) - fullGroupSet2.length);
                object = aggs.$plus$eq((Object)agg);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return new Tuple2((Object)childKeyBuilder.build(), aggs.toArray(ClassTag$.MODULE$.apply(AggregateCall.class)));
    }

    public ImmutableBitSet setChildKeysOfWinAgg(ImmutableBitSet groupKey, BatchExecWindowAggregateBase globalWinAgg) {
        Predef$.MODULE$.require(globalWinAgg.isMerge(), (Function0 & Serializable & scala.Serializable)() -> "Cannot handle global agg which does not have local window agg!");
        ImmutableBitSet.Builder childKeyBuilder = ImmutableBitSet.builder();
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(groupKey.toArray())).foreach((Function1 & Serializable & scala.Serializable)key -> FlinkRelMdUtil$.$anonfun$setChildKeysOfWinAgg$2(globalWinAgg, childKeyBuilder, BoxesRunTime.unboxToInt((Object)key)));
        return childKeyBuilder.build();
    }

    public Tuple2<ImmutableBitSet, AggregateCall[]> splitGroupKeysOnAggregate(SingleRel agg, ImmutableBitSet groupKey) {
        Tuple2 tuple2;
        SingleRel singleRel = agg;
        if (singleRel instanceof Aggregate) {
            int[] auxGroupSet;
            Aggregate aggregate = (Aggregate)singleRel;
            Tuple2<int[], Seq<AggregateCall>> tuple22 = AggregateUtil$.MODULE$.checkAndSplitAggCalls(aggregate);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            int[] nArray = auxGroupSet = (int[])tuple22._1();
            int[] auxGroupSet2 = nArray;
            Tuple2<ImmutableBitSet, AggregateCall[]> tuple23 = this.setAggChildKeys(groupKey, aggregate);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            ImmutableBitSet childKeys = (ImmutableBitSet)tuple23._1();
            AggregateCall[] aggCalls = (AggregateCall[])tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)childKeys, (Object)aggCalls);
            Tuple2 tuple25 = tuple24;
            ImmutableBitSet childKeys2 = (ImmutableBitSet)tuple25._1();
            AggregateCall[] aggCalls2 = (AggregateCall[])tuple25._2();
            ImmutableBitSet childKeyExcludeAuxKey = FlinkRelMdUtil$.removeAuxKey$1(childKeys2, aggregate.getGroupSet().toArray(), auxGroupSet2);
            tuple2 = new Tuple2((Object)childKeyExcludeAuxKey, (Object)aggCalls2);
        } else if (singleRel instanceof BatchExecGroupAggregateBase) {
            BatchExecGroupAggregateBase batchExecGroupAggregateBase = (BatchExecGroupAggregateBase)singleRel;
            Tuple2<ImmutableBitSet, AggregateCall[]> tuple26 = this.setAggChildKeys(groupKey, batchExecGroupAggregateBase);
            if (tuple26 == null) {
                throw new MatchError(tuple26);
            }
            ImmutableBitSet childKeys = (ImmutableBitSet)tuple26._1();
            AggregateCall[] aggCalls = (AggregateCall[])tuple26._2();
            Tuple2 tuple27 = new Tuple2((Object)childKeys, (Object)aggCalls);
            Tuple2 tuple28 = tuple27;
            ImmutableBitSet childKeys3 = (ImmutableBitSet)tuple28._1();
            AggregateCall[] aggCalls3 = (AggregateCall[])tuple28._2();
            ImmutableBitSet childKeyExcludeAuxKey = FlinkRelMdUtil$.removeAuxKey$1(childKeys3, batchExecGroupAggregateBase.getGrouping(), batchExecGroupAggregateBase.getAuxGrouping());
            tuple2 = new Tuple2((Object)childKeyExcludeAuxKey, (Object)aggCalls3);
        } else if (singleRel instanceof BatchExecWindowAggregateBase) {
            BatchExecWindowAggregateBase batchExecWindowAggregateBase = (BatchExecWindowAggregateBase)singleRel;
            Tuple2<ImmutableBitSet, AggregateCall[]> tuple29 = this.setAggChildKeys(groupKey, batchExecWindowAggregateBase);
            if (tuple29 == null) {
                throw new MatchError(tuple29);
            }
            ImmutableBitSet childKeys = (ImmutableBitSet)tuple29._1();
            AggregateCall[] aggCalls = (AggregateCall[])tuple29._2();
            Tuple2 tuple210 = new Tuple2((Object)childKeys, (Object)aggCalls);
            Tuple2 tuple211 = tuple210;
            ImmutableBitSet childKeys4 = (ImmutableBitSet)tuple211._1();
            AggregateCall[] aggCalls4 = (AggregateCall[])tuple211._2();
            ImmutableBitSet childKeyExcludeAuxKey = FlinkRelMdUtil$.removeAuxKey$1(childKeys4, batchExecWindowAggregateBase.getGrouping(), batchExecWindowAggregateBase.getAuxGrouping());
            tuple2 = new Tuple2((Object)childKeyExcludeAuxKey, (Object)aggCalls4);
        } else {
            throw new IllegalArgumentException(new StringBuilder(20).append("Unknown aggregate: ").append(agg.getRelTypeName()).append(".").toString());
        }
        return tuple2;
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(Aggregate agg, RexNode predicate) {
        int[] fullGroupSet = AggregateUtil$.MODULE$.checkAndGetFullGroupSet(agg);
        return this.splitPredicateOnAgg(fullGroupSet, agg, predicate);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(BatchExecGroupAggregateBase agg, RexNode predicate) {
        return this.splitPredicateOnAgg((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(agg.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(agg.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), agg, predicate);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAggregate(BatchExecWindowAggregateBase agg, RexNode predicate) {
        return this.splitPredicateOnAgg((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(agg.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(agg.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), agg, predicate);
    }

    public RexNode setChildPredicateOfWinAgg(RexNode predicate, BatchExecWindowAggregateBase globalWinAgg) {
        Predef$.MODULE$.require(globalWinAgg.isMerge(), (Function0 & Serializable & scala.Serializable)() -> "Cannot handle global agg which does not have local window agg!");
        if (predicate == null) {
            return null;
        }
        int[] fullGrouping = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(globalWinAgg.getGrouping())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(globalWinAgg.getAuxGrouping())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return RexUtil.shift(predicate, fullGrouping.length, 1);
    }

    private Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnAgg(int[] grouping, SingleRel agg, RexNode predicate) {
        None$ none$;
        ArrayList<RexNode> notPushable = new ArrayList<RexNode>();
        ArrayList<RexNode> pushable = new ArrayList<RexNode>();
        int numOfGroupKey = grouping.length;
        RelOptUtil.splitFilters(ImmutableBitSet.range(0, numOfGroupKey), predicate, pushable, notPushable);
        RexBuilder rexBuilder = agg.getCluster().getRexBuilder();
        if (pushable.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            List<RelDataTypeField> aggOutputFields = agg.getRowType().getFieldList();
            List<RelDataTypeField> aggInputFields = agg.getInput().getRowType().getFieldList();
            int[] adjustments = new int[aggOutputFields.size()];
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(grouping)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FlinkRelMdUtil$.$anonfun$splitPredicateOnAgg$1(adjustments, x0$1);
                return BoxedUnit.UNIT;
            });
            Buffer pushableConditions = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(pushable).map((Function1 & Serializable & scala.Serializable)pushCondition -> pushCondition.accept(new RelOptUtil.RexInputConverter(rexBuilder, aggOutputFields, aggInputFields, adjustments)), Buffer$.MODULE$.canBuildFrom());
            none$ = Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(pushableConditions), true));
        }
        None$ childPred = none$;
        None$ restPred = notPushable.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, notPushable, true));
        return new Tuple2((Object)childPred, (Object)restPred);
    }

    public Double binaryRowAverageSize(RelNode rel) {
        RowType binaryType = FlinkTypeFactory$.MODULE$.toLogicalRowType(rel.getRowType());
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        List<Double> columnSizes = mq.getAverageColumnSizes(rel);
        DoubleRef length = DoubleRef.create((double)0.0);
        ((IterableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(columnSizes).zip((GenIterable)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(binaryType.getChildren()), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            FlinkRelMdUtil$.$anonfun$binaryRowAverageSize$1(length, x0$2);
            return BoxedUnit.UNIT;
        });
        length.elem += (double)BinaryRow.calculateBitSetWidthInBytes((int)columnSizes.size());
        return Predef$.MODULE$.double2Double(length.elem);
    }

    public Double computeSortMemory(RelMetadataQuery mq, RelNode inputOfSort) {
        int normalizedKeyBytes = 16;
        Double rowCount = mq.getRowCount(inputOfSort);
        Double averageRowSize = this.binaryRowAverageSize(inputOfSort);
        double recordAreaInBytes = Predef$.MODULE$.Double2double(rowCount) * (Predef$.MODULE$.Double2double(averageRowSize) + (double)4);
        double indexAreaInBytes = Predef$.MODULE$.Double2double(rowCount) * (double)(normalizedKeyBytes + 8);
        return Predef$.MODULE$.double2Double(recordAreaInBytes + indexAreaInBytes);
    }

    public Tuple2<Option<RexNode>, Option<RexNode>> splitPredicateOnRank(Rank rank, RexNode predicate) {
        int rankFunColumnIndex = BoxesRunTime.unboxToInt((Object)RankUtil$.MODULE$.getRankNumberColumnIndex(rank).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1));
        if (predicate == null || predicate.isAlwaysTrue() || rankFunColumnIndex < 0) {
            return new Tuple2((Object)new Some((Object)predicate), (Object)None$.MODULE$);
        }
        ArrayList<RexNode> rankNodes = new ArrayList<RexNode>();
        ArrayList<RexNode> nonRankNodes = new ArrayList<RexNode>();
        RelOptUtil.splitFilters(ImmutableBitSet.range(0, rankFunColumnIndex), predicate, nonRankNodes, rankNodes);
        RexBuilder rexBuilder = rank.getCluster().getRexBuilder();
        None$ nonRankPred = nonRankNodes.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, nonRankNodes, true));
        None$ rankPred = rankNodes.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)RexUtil.composeConjunction(rexBuilder, rankNodes, true));
        return new Tuple2((Object)nonRankPred, (Object)rankPred);
    }

    public Double getRankRangeNdv(RankRange rankRange) {
        Double d;
        RankRange rankRange2 = rankRange;
        if (rankRange2 instanceof ConstantRankRange) {
            ConstantRankRange constantRankRange = (ConstantRankRange)rankRange2;
            d = Predef$.MODULE$.double2Double((double)(constantRankRange.getRankEnd() - constantRankRange.getRankStart() + 1L));
        } else {
            d = Predef$.MODULE$.double2Double(100.0);
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    public Set<Object> getInputRefIndices(int index, Expand expand) {
        void var3_3;
        HashSet inputRefs = new HashSet();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(expand.projects()).foreach((Function1 & Serializable & scala.Serializable)project -> BoxesRunTime.boxToBoolean((boolean)FlinkRelMdUtil$.$anonfun$getInputRefIndices$1(index, inputRefs, project)));
        return var3_3;
    }

    public Tuple2<ImmutableBitSet, ImmutableBitSet> splitColumnsIntoLeftAndRight(int leftCount, ImmutableBitSet columns) {
        ImmutableBitSet.Builder leftBuilder = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightBuilder = ImmutableBitSet.builder();
        JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)columns).foreach((Function1 & Serializable & scala.Serializable)bit -> Predef$.MODULE$.Integer2int(bit) < leftCount ? leftBuilder.set(Predef$.MODULE$.Integer2int(bit)) : rightBuilder.set(Predef$.MODULE$.Integer2int(bit) - leftCount));
        return new Tuple2((Object)leftBuilder.build(), (Object)rightBuilder.build());
    }

    public Double cardOfCalcExpr(RelMetadataQuery mq, Calc calc, RexNode expr) {
        return expr.accept(new FlinkRelMdUtil.CardOfCalcExpr(mq, calc));
    }

    public static final /* synthetic */ ImmutableBitSet.Builder $anonfun$setChildKeysOfWinAgg$2(BatchExecWindowAggregateBase globalWinAgg$1, ImmutableBitSet.Builder childKeyBuilder$3, int key) {
        return key < globalWinAgg$1.getGrouping().length ? childKeyBuilder$3.set(key) : childKeyBuilder$3.set(key + 1);
    }

    private static final ImmutableBitSet removeAuxKey$1(ImmutableBitSet groupKey, int[] groupSet, int[] auxGroupSet) {
        return groupKey.contains(ImmutableBitSet.of(groupSet)) ? groupKey.except(ImmutableBitSet.of(auxGroupSet)) : groupKey;
    }

    public static final /* synthetic */ void $anonfun$splitPredicateOnAgg$1(int[] adjustments$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int bit = tuple2._1$mcI$sp();
        int index = tuple2._2$mcI$sp();
        adjustments$1[index] = bit - index;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$binaryRowAverageSize$1(DoubleRef length$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            Double columnSize = (Double)tuple2._1();
            LogicalType internalType = (LogicalType)tuple2._2();
            if (BinaryRow.isInFixedLengthPart((LogicalType)internalType)) {
                length$1.elem += (double)8;
                boxedUnit = BoxedUnit.UNIT;
            } else if (columnSize == null) {
                length$1.elem += (double)16;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                length$1.elem += Predef$.MODULE$.Double2double(columnSize) + (double)8;
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$getInputRefIndices$1(int index$1, HashSet inputRefs$1, List project) {
        boolean bl;
        RexNode rexNode = (RexNode)project.get(index$1);
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            bl = inputRefs$1.add(BoxesRunTime.boxToInteger((int)rexInputRef.getIndex()));
        } else {
            bl = inputRefs$1.add(BoxesRunTime.boxToInteger((int)-1));
        }
        return bl;
    }

    private FlinkRelMdUtil$() {
        MODULE$ = this;
    }
}

