/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RexImplicationChecker;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.mutable.Holder;
import org.apache.calcite.rel.mutable.MutableAggregate;
import org.apache.calcite.rel.mutable.MutableCalc;
import org.apache.calcite.rel.mutable.MutableFilter;
import org.apache.calcite.rel.mutable.MutableIntersect;
import org.apache.calcite.rel.mutable.MutableJoin;
import org.apache.calcite.rel.mutable.MutableRel;
import org.apache.calcite.rel.mutable.MutableRelVisitor;
import org.apache.calcite.rel.mutable.MutableRels;
import org.apache.calcite.rel.mutable.MutableScan;
import org.apache.calcite.rel.mutable.MutableSingleRel;
import org.apache.calcite.rel.mutable.MutableUnion;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ControlFlowException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.calcite.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.LinkedHashMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Multimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;

public class SubstitutionVisitor {
    private static final boolean DEBUG = CalciteSystemProperty.DEBUG.value();
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    protected static final ImmutableList<UnifyRule> DEFAULT_RULES = ImmutableList.of(TrivialRule.access$000(), ScanToCalcUnifyRule.INSTANCE, CalcToCalcUnifyRule.INSTANCE, JoinOnLeftCalcToJoinUnifyRule.INSTANCE, JoinOnRightCalcToJoinUnifyRule.INSTANCE, JoinOnCalcsToJoinUnifyRule.INSTANCE, AggregateToAggregateUnifyRule.INSTANCE, AggregateOnCalcToAggregateUnifyRule.INSTANCE, UnionToUnionUnifyRule.INSTANCE, UnionOnCalcsToUnionUnifyRule.INSTANCE, IntersectToIntersectUnifyRule.INSTANCE);
    protected final RelBuilder relBuilder;
    private final ImmutableList<UnifyRule> rules;
    private final Map<Pair<Class, Class>, List<UnifyRule>> ruleMap = new HashMap<Pair<Class, Class>, List<UnifyRule>>();
    private final RelOptCluster cluster;
    private final RexSimplify simplify;
    private final Holder query;
    private final MutableRel target;
    final List<MutableRel> targetLeaves;
    final List<MutableRel> queryLeaves;
    final Map<MutableRel, MutableRel> replacementMap = new HashMap<MutableRel, MutableRel>();
    final Multimap<MutableRel, MutableRel> equivalents = LinkedHashMultimap.create();
    protected final MutableRel[] slots = new MutableRel[2];

    public SubstitutionVisitor(RelNode target_, RelNode query_) {
        this(target_, query_, DEFAULT_RULES, RelFactories.LOGICAL_BUILDER);
    }

    public SubstitutionVisitor(RelNode target_, RelNode query_, ImmutableList<UnifyRule> rules) {
        this(target_, query_, rules, RelFactories.LOGICAL_BUILDER);
    }

    public SubstitutionVisitor(RelNode target_, RelNode query_, ImmutableList<UnifyRule> rules, RelBuilderFactory relBuilderFactory) {
        this.cluster = target_.getCluster();
        RexExecutor executor = Util.first(this.cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR);
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        this.simplify = new RexSimplify(this.cluster.getRexBuilder(), predicates, executor);
        this.rules = rules;
        this.query = Holder.of(MutableRels.toMutable(query_));
        this.target = MutableRels.toMutable(target_);
        this.relBuilder = relBuilderFactory.create(this.cluster, null);
        final Set parents = Sets.newIdentityHashSet();
        final ArrayList allNodes = new ArrayList();
        MutableRelVisitor visitor = new MutableRelVisitor(){

            @Override
            public void visit(MutableRel node) {
                parents.add(node.getParent());
                allNodes.add(node);
                super.visit(node);
            }
        };
        visitor.go(this.target);
        allNodes.removeAll(parents);
        this.targetLeaves = ImmutableList.copyOf(allNodes);
        allNodes.clear();
        parents.clear();
        visitor.go(this.query);
        allNodes.removeAll(parents);
        this.queryLeaves = ImmutableList.copyOf(allNodes);
    }

    void register(MutableRel result, MutableRel query) {
    }

    @VisibleForTesting
    public static RexNode splitFilter(RexSimplify simplify, RexNode condition, RexNode target) {
        RexNode x2;
        RexNode r;
        RexNode target2;
        RexBuilder rexBuilder = simplify.rexBuilder;
        RexNode condition2 = SubstitutionVisitor.canonizeNode(rexBuilder, condition);
        RexNode z = SubstitutionVisitor.splitOr(rexBuilder, condition2, target2 = SubstitutionVisitor.canonizeNode(rexBuilder, target));
        if (z != null) {
            return z;
        }
        if (SubstitutionVisitor.isEquivalent(rexBuilder, condition2, target2)) {
            return rexBuilder.makeLiteral(true);
        }
        RexNode x = RexUtil.andNot(rexBuilder, target2, condition2);
        if (SubstitutionVisitor.mayBeSatisfiable(x) && !(r = SubstitutionVisitor.canonizeNode(rexBuilder, simplify.simplifyUnknownAsFalse(x2 = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(condition2, target2))))).isAlwaysFalse() && SubstitutionVisitor.isEquivalent(rexBuilder, condition2, r)) {
            List<RexNode> conjs = RelOptUtil.conjunctions(r);
            for (RexNode e : RelOptUtil.conjunctions(target2)) {
                RexUtil.removeAll(conjs, e);
            }
            return RexUtil.composeConjunction(rexBuilder, conjs);
        }
        return null;
    }

    private static RexNode canonizeNode(RexBuilder rexBuilder, RexNode condition) {
        switch (condition.getKind()) {
            case AND: 
            case OR: {
                RexCall call = (RexCall)condition;
                TreeMap<String, RexNode> newOperands = new TreeMap<String, RexNode>();
                for (RexNode operand : call.operands) {
                    operand = SubstitutionVisitor.canonizeNode(rexBuilder, operand);
                    newOperands.put(operand.toString(), operand);
                }
                if (newOperands.size() < 2) {
                    return (RexNode)newOperands.values().iterator().next();
                }
                return rexBuilder.makeCall(call.getOperator(), ImmutableList.copyOf(newOperands.values()));
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case GREATER_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: {
                RexCall call = (RexCall)condition;
                RexNode left = call.getOperands().get(0);
                RexNode right = call.getOperands().get(1);
                if (left.toString().compareTo(right.toString()) <= 0) {
                    return call;
                }
                return RexUtil.invert(rexBuilder, call);
            }
        }
        return condition;
    }

    private static RexNode splitOr(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        List<RexNode> conditions = RelOptUtil.disjunctions(condition);
        int conditionsLength = conditions.size();
        int targetsLength = 0;
        for (RexNode e : RelOptUtil.disjunctions(target)) {
            RexUtil.removeAll(conditions, e);
            ++targetsLength;
        }
        if (conditions.isEmpty() && conditionsLength == targetsLength) {
            return rexBuilder.makeLiteral(true);
        }
        if (conditions.isEmpty()) {
            return condition;
        }
        return null;
    }

    private static boolean isEquivalent(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        HashSet<String> targetDisjunctions;
        HashSet<String> conditionDisjunctions = new HashSet<String>(RexUtil.strings(RelOptUtil.conjunctions(condition)));
        return conditionDisjunctions.equals(targetDisjunctions = new HashSet<String>(RexUtil.strings(RelOptUtil.conjunctions(target))));
    }

    public static boolean mayBeSatisfiable(RexNode e) {
        ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
        ArrayList<RexNode> notDisjunctions = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e, disjunctions, notDisjunctions);
        for (RexNode disjunction : disjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode disjunction : notDisjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode notDisjunction : notDisjunctions) {
            List<RexNode> disjunctions2 = RelOptUtil.conjunctions(notDisjunction);
            if (!disjunctions.containsAll(disjunctions2)) continue;
            return false;
        }
        return true;
    }

    public RelNode go0(RelNode replacement_) {
        MutableRel node0;
        assert (false);
        MutableRel replacement = MutableRels.toMutable(replacement_);
        assert (SubstitutionVisitor.equalType("target", this.target, "replacement", replacement, Litmus.THROW));
        this.replacementMap.put(this.target, replacement);
        UnifyResult unifyResult = this.matchRecurse(this.target);
        if (unifyResult == null) {
            return null;
        }
        MutableRel node = node0 = unifyResult.result;
        if (DEBUG) {
            System.out.println("Convert: query:\n" + this.query.deep() + "\nunify.query:\n" + ((UnifyResult)unifyResult).call.query.deep() + "\nunify.result:\n" + unifyResult.result.deep() + "\nunify.target:\n" + ((UnifyResult)unifyResult).call.target.deep() + "\nnode0:\n" + node0.deep() + "\nnode:\n" + node.deep());
        }
        return MutableRels.fromMutable(node, this.relBuilder);
    }

    public List<RelNode> go(RelNode replacement_) {
        List<List<Replacement>> matches2 = this.go(MutableRels.toMutable(replacement_));
        if (matches2.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<RelNode> sub = new ArrayList<RelNode>();
        sub.add(MutableRels.fromMutable(this.query.getInput(), this.relBuilder));
        SubstitutionVisitor.reverseSubstitute(this.relBuilder, this.query, matches2, sub, 0, matches2.size());
        return sub;
    }

    private List<List<Replacement>> go(MutableRel replacement) {
        int count;
        assert (SubstitutionVisitor.equalType("target", this.target, "replacement", replacement, Litmus.THROW));
        List<MutableRel> queryDescendants = MutableRels.descendants(this.query);
        List<MutableRel> targetDescendants = MutableRels.descendants(this.target);
        HashMap<MutableRel, MutableRel> map = new HashMap<MutableRel, MutableRel>();
        for (MutableRel queryDescendant : queryDescendants) {
            map.put(queryDescendant, queryDescendant);
        }
        for (MutableRel targetDescendant : targetDescendants) {
            MutableRel queryDescendant = (MutableRel)map.get(targetDescendant);
            if (queryDescendant == null) continue;
            assert (this.rowTypesAreEquivalent(queryDescendant, targetDescendant, Litmus.THROW));
            this.equivalents.put(queryDescendant, targetDescendant);
        }
        map.clear();
        ArrayList<Replacement> attempted = new ArrayList<Replacement>();
        ArrayList<List<Replacement>> substitutions = new ArrayList<List<Replacement>>();
        block2: do {
            count = 0;
            MutableRel queryDescendant = this.query;
            block3: while (queryDescendant != null) {
                for (Replacement r : attempted) {
                    if (!r.stopTrying || queryDescendant != r.after) continue;
                    queryDescendant = MutableRels.preOrderTraverseNext(queryDescendant);
                    continue block3;
                }
                MutableRel next = MutableRels.preOrderTraverseNext(queryDescendant);
                MutableRel childOrNext = ((MutableRel)queryDescendant).getInputs().isEmpty() ? next : ((MutableRel)queryDescendant).getInputs().get(0);
                for (MutableRel targetDescendant : targetDescendants) {
                    for (UnifyRule rule : this.applicableRules(queryDescendant, targetDescendant)) {
                        UnifyResult result;
                        UnifyRuleCall call = rule.match(this, queryDescendant, targetDescendant);
                        if (call == null || (result = rule.apply(call)) == null) continue;
                        ++count;
                        attempted.add(new Replacement(((UnifyResult)result).call.query, result.result, result.stopTrying));
                        ((UnifyResult)result).call.query.replaceInParent(result.result);
                        for (int i = 0; i < rule.slotCount; ++i) {
                            Collection<MutableRel> equi = this.equivalents.get(this.slots[i]);
                            if (equi.isEmpty()) continue;
                            this.equivalents.remove(this.slots[i], equi.iterator().next());
                        }
                        assert (this.rowTypesAreEquivalent(result.result, ((UnifyResult)result).call.query, Litmus.THROW));
                        this.equivalents.put(result.result, ((UnifyResult)result).call.query);
                        if (targetDescendant != this.target) continue block2;
                        if (!this.target.equals(replacement)) {
                            Replacement r = SubstitutionVisitor.replace(this.query.getInput(), this.target, replacement.clone());
                            assert (r != null) : rule + "should have returned a result containing the target.";
                            attempted.add(r);
                        }
                        substitutions.add(ImmutableList.copyOf(attempted));
                        attempted.clear();
                        queryDescendant = next;
                        continue block3;
                    }
                }
                queryDescendant = childOrNext;
            }
        } while (count != 0 && !attempted.isEmpty());
        if (!attempted.isEmpty()) {
            SubstitutionVisitor.undoReplacement(attempted);
        }
        return substitutions;
    }

    private boolean rowTypesAreEquivalent(MutableRel rel0, MutableRel rel1, Litmus litmus) {
        if (rel0.rowType.getFieldCount() != rel1.rowType.getFieldCount()) {
            return litmus.fail("Mismatch for column count: [{}]", Pair.of(rel0, rel1));
        }
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(rel0.rowType.getFieldList(), rel1.rowType.getFieldList())) {
            if (((RelDataTypeField)pair.left).getType().equals(((RelDataTypeField)pair.right).getType())) continue;
            return litmus.fail("Mismatch for column type: [{}]", Pair.of(rel0, rel1));
        }
        return litmus.succeed();
    }

    public static Replacement replace(MutableRel query, MutableRel find, MutableRel replace) {
        if (find.equals(replace)) {
            return null;
        }
        assert (SubstitutionVisitor.equalType("find", find, "replace", replace, Litmus.THROW));
        return SubstitutionVisitor.replaceRecurse(query, find, replace);
    }

    private static Replacement replaceRecurse(MutableRel query, MutableRel find, MutableRel replace) {
        if (find.equals(query)) {
            query.replaceInParent(replace);
            return new Replacement(query, replace);
        }
        for (MutableRel input : query.getInputs()) {
            Replacement r = SubstitutionVisitor.replaceRecurse(input, find, replace);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    private static void undoReplacement(List<Replacement> replacement) {
        for (int i = replacement.size() - 1; i >= 0; --i) {
            Replacement r = replacement.get(i);
            r.after.replaceInParent(r.before);
        }
    }

    private static void redoReplacement(List<Replacement> replacement) {
        for (Replacement r : replacement) {
            r.before.replaceInParent(r.after);
        }
    }

    private static void reverseSubstitute(RelBuilder relBuilder, Holder query, List<List<Replacement>> matches2, List<RelNode> sub, int replaceCount, int maxCount) {
        if (matches2.isEmpty()) {
            return;
        }
        List<List<Replacement>> rem = matches2.subList(1, matches2.size());
        SubstitutionVisitor.reverseSubstitute(relBuilder, query, rem, sub, replaceCount, maxCount);
        SubstitutionVisitor.undoReplacement(matches2.get(0));
        if (++replaceCount < maxCount) {
            sub.add(MutableRels.fromMutable(query.getInput(), relBuilder));
        }
        SubstitutionVisitor.reverseSubstitute(relBuilder, query, rem, sub, replaceCount, maxCount);
        SubstitutionVisitor.redoReplacement(matches2.get(0));
    }

    private UnifyResult matchRecurse(MutableRel target) {
        assert (false);
        List<MutableRel> targetInputs = target.getInputs();
        MutableRel queryParent = null;
        for (MutableRel targetInput : targetInputs) {
            UnifyResult unifyResult = this.matchRecurse(targetInput);
            if (unifyResult == null) {
                return null;
            }
            queryParent = ((UnifyResult)unifyResult).call.query.replaceInParent(unifyResult.result);
        }
        if (targetInputs.isEmpty()) {
            for (MutableRel queryLeaf : this.queryLeaves) {
                for (UnifyRule rule : this.applicableRules(queryLeaf, target)) {
                    UnifyResult x = this.apply(rule, queryLeaf, target);
                    if (x == null) continue;
                    if (DEBUG) {
                        System.out.println("Rule: " + rule + "\nQuery:\n" + queryParent + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + queryParent : "") + "\nTarget:\n" + target.deep() + "\nResult:\n" + x.result.deep() + "\n");
                    }
                    return x;
                }
            }
        } else {
            assert (queryParent != null);
            for (UnifyRule rule : this.applicableRules(queryParent, target)) {
                UnifyResult x = this.apply(rule, queryParent, target);
                if (x == null) continue;
                if (DEBUG) {
                    System.out.println("Rule: " + rule + "\nQuery:\n" + queryParent.deep() + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + queryParent.toString() : "") + "\nTarget:\n" + target.deep() + "\nResult:\n" + x.result.deep() + "\n");
                }
                return x;
            }
        }
        if (DEBUG) {
            System.out.println("Unify failed:\nQuery:\n" + queryParent.toString() + "\nTarget:\n" + target.toString() + "\n");
        }
        return null;
    }

    private UnifyResult apply(UnifyRule rule, MutableRel query, MutableRel target) {
        UnifyRuleCall call = new UnifyRuleCall(rule, query, target, ImmutableList.of());
        return rule.apply(call);
    }

    private List<UnifyRule> applicableRules(MutableRel query, MutableRel target) {
        Class<?> targetClass;
        Class<?> queryClass = query.getClass();
        Pair<Class<?>, Class<?>> key = Pair.of(queryClass, targetClass = target.getClass());
        Collection<UnifyRule> list = this.ruleMap.get(key);
        if (list == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (UnifyRule rule : this.rules) {
                if (!SubstitutionVisitor.mightMatch(rule, queryClass, targetClass)) continue;
                builder.add(rule);
            }
            list = builder.build();
            this.ruleMap.put((Pair<Class, Class>)key, (List<UnifyRule>)list);
        }
        return list;
    }

    private static boolean mightMatch(UnifyRule rule, Class queryClass, Class targetClass) {
        return rule.queryOperand.clazz.isAssignableFrom(queryClass) && rule.targetOperand.clazz.isAssignableFrom(targetClass);
    }

    private static boolean sameRelCollectionNoOrderConsidered(List<MutableRel> list0, List<MutableRel> list1) {
        if (list0.size() != list1.size()) {
            return false;
        }
        for (MutableRel rel : list0) {
            int index = list1.indexOf(rel);
            if (index == -1) {
                return false;
            }
            list1.remove(index);
        }
        return true;
    }

    private static int fieldCnt(MutableRel rel) {
        return rel.rowType.getFieldCount();
    }

    private static Pair<RexNode, List<RexNode>> explainCalc(MutableCalc calc) {
        RexShuttle shuttle = SubstitutionVisitor.getExpandShuttle(calc.program);
        RexNode condition = shuttle.apply(calc.program.getCondition());
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (RexNode rexNode : shuttle.apply(calc.program.getProjectList())) {
            projects.add(rexNode);
        }
        if (condition == null) {
            return Pair.of(calc.cluster.getRexBuilder().makeLiteral(true), projects);
        }
        return Pair.of(condition, projects);
    }

    private static UnifyResult tryMergeParentCalcAndGenResult(UnifyRuleCall call, MutableRel child) {
        MutableCalc mergedCalc;
        MutableRel parent = call.query.getParent();
        if (child instanceof MutableCalc && parent instanceof MutableCalc && (mergedCalc = SubstitutionVisitor.mergeCalc(call.getCluster().getRexBuilder(), (MutableCalc)parent, (MutableCalc)child)) != null) {
            return call.create(parent).result(mergedCalc, false);
        }
        return call.result(child);
    }

    private static MutableCalc mergeCalc(RexBuilder rexBuilder, MutableCalc topCalc, MutableCalc bottomCalc) {
        RexProgram topProgram = topCalc.program;
        if (RexOver.containsOver(topProgram)) {
            return null;
        }
        RexProgram mergedProgram = RexProgramBuilder.mergePrograms(topCalc.program, bottomCalc.program, rexBuilder);
        assert (mergedProgram.getOutputRowType() == topProgram.getOutputRowType());
        return MutableCalc.of(bottomCalc.getInput(), mergedProgram);
    }

    private static RexShuttle getExpandShuttle(final RexProgram rexProgram) {
        return new RexShuttle(){

            @Override
            public RexNode visitLocalRef(RexLocalRef localRef) {
                return rexProgram.expandLocalRef(localRef);
            }
        };
    }

    private static boolean implies(RelOptCluster cluster, RexNode cond0, RexNode cond1, RelDataType rowType) {
        RexExecutorImpl rexImpl = (RexExecutorImpl)cluster.getPlanner().getExecutor();
        RexImplicationChecker rexImplicationChecker = new RexImplicationChecker(cluster.getRexBuilder(), rexImpl, rowType);
        return rexImplicationChecker.implies(cond0, cond1);
    }

    private static boolean referenceByMapping(RexNode joinCondition, List<RexNode> ... projectsOfInputs) {
        final ArrayList<RexNode> projects = new ArrayList<RexNode>();
        for (List<RexNode> projectsOfInput : projectsOfInputs) {
            projects.addAll(projectsOfInput);
        }
        try {
            RexVisitorImpl<Void> rexVisitor = new RexVisitorImpl<Void>(true){

                @Override
                public Void visitInputRef(RexInputRef inputRef) {
                    if (!(projects.get(inputRef.getIndex()) instanceof RexInputRef)) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitInputRef(inputRef);
                }
            };
            joinCondition.accept(rexVisitor);
        }
        catch (Util.FoundOne e) {
            return false;
        }
        return true;
    }

    private static JoinRelType sameJoinType(JoinRelType type0, JoinRelType type1) {
        if (type0 == type1) {
            return type0;
        }
        return null;
    }

    public static MutableAggregate permute(MutableAggregate aggregate, MutableRel input, Mapping mapping) {
        ImmutableBitSet groupSet = Mappings.apply(mapping, aggregate.groupSet);
        ImmutableList<ImmutableBitSet> groupSets = Mappings.apply2(mapping, aggregate.groupSets);
        List<AggregateCall> aggregateCalls = Util.transform(aggregate.aggCalls, call -> call.transform(mapping));
        return MutableAggregate.of(input, groupSet, groupSets, aggregateCalls);
    }

    public static MutableRel unifyAggregates(MutableAggregate query, RexNode targetCond, MutableAggregate target) {
        MutableSingleRel result;
        RexBuilder rexBuilder = query.cluster.getRexBuilder();
        if (query.groupSets.equals(target.groupSets)) {
            ArrayList<Integer> projects = new ArrayList<Integer>();
            int groupCount = query.groupSet.cardinality();
            for (int i = 0; i < groupCount; ++i) {
                projects.add(i);
            }
            for (AggregateCall aggregateCall : query.aggCalls) {
                int i = target.aggCalls.indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                projects.add(groupCount + i);
            }
            List<RexNode> compenProjs = MutableRels.createProjectExprs(target, projects);
            RexProgram compenRexProgram = RexProgram.create(target.rowType, compenProjs, targetCond, query.rowType, rexBuilder);
            result = MutableCalc.of(target, compenRexProgram);
        } else if (target.getGroupType() == Aggregate.Group.SIMPLE) {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            target.groupSet.forEach(k -> map.put((Integer)k, map.size()));
            for (int c : query.groupSet) {
                if (map.containsKey(c)) continue;
                return null;
            }
            ImmutableBitSet groupSet = query.groupSet.permute(map);
            ImmutableList<ImmutableBitSet> groupSets = null;
            if (query.getGroupType() != Aggregate.Group.SIMPLE) {
                groupSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(query.groupSets, map));
            }
            ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
            for (AggregateCall aggregateCall : query.aggCalls) {
                if (aggregateCall.isDistinct()) {
                    return null;
                }
                int i = target.aggCalls.indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                aggregateCalls.add(AggregateCall.create(SubstitutionVisitor.getRollup(aggregateCall.getAggregation()), aggregateCall.isDistinct(), aggregateCall.isApproximate(), aggregateCall.ignoreNulls(), ImmutableList.of(Integer.valueOf(target.groupSet.cardinality() + i)), -1, aggregateCall.collation, aggregateCall.type, aggregateCall.name));
            }
            if (targetCond != null && !targetCond.isAlwaysTrue()) {
                RexProgram compenRexProgram = RexProgram.create(target.rowType, rexBuilder.identityProjects(target.rowType), targetCond, target.rowType, rexBuilder);
                result = MutableAggregate.of(MutableCalc.of(target, compenRexProgram), groupSet, groupSets, aggregateCalls);
            } else {
                result = MutableAggregate.of(target, groupSet, groupSets, aggregateCalls);
            }
        } else {
            return null;
        }
        return result;
    }

    public static SqlAggFunction getRollup(SqlAggFunction aggregation) {
        if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.MIN || aggregation == SqlStdOperatorTable.MAX || aggregation == SqlStdOperatorTable.SUM0 || aggregation == SqlStdOperatorTable.ANY_VALUE) {
            return aggregation;
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            return SqlStdOperatorTable.SUM0;
        }
        return null;
    }

    private static RexShuttle getRexShuttle(List<RexNode> rexNodes) {
        final HashMap<RexNode, Integer> map = new HashMap<RexNode, Integer>();
        for (RexNode e : rexNodes) {
            map.put(e, map.size());
        }
        return new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef ref) {
                Integer integer = (Integer)map.get(ref);
                if (integer != null) {
                    return new RexInputRef(integer, ref.getType());
                }
                throw MatchFailed.INSTANCE;
            }

            @Override
            public RexNode visitCall(RexCall call) {
                Integer integer = (Integer)map.get(call);
                if (integer != null) {
                    return new RexInputRef(integer, call.getType());
                }
                return super.visitCall(call);
            }

            @Override
            public RexNode visitLiteral(RexLiteral literal) {
                Integer integer = (Integer)map.get(literal);
                if (integer != null) {
                    return new RexInputRef(integer, literal.getType());
                }
                return super.visitLiteral(literal);
            }
        };
    }

    protected boolean isWeaker(MutableRel rel0, MutableRel rel) {
        MutableRel relinput;
        if (rel0 == rel || this.equivalents.get(rel0).contains(rel)) {
            return false;
        }
        if (!(rel0 instanceof MutableFilter) || !(rel instanceof MutableFilter)) {
            return false;
        }
        if (!rel.rowType.equals(rel0.rowType)) {
            return false;
        }
        MutableRel rel0input = ((MutableFilter)rel0).getInput();
        if (rel0input != (relinput = ((MutableFilter)rel).getInput()) && !this.equivalents.get(rel0input).contains(relinput)) {
            return false;
        }
        return SubstitutionVisitor.implies(rel0.cluster, ((MutableFilter)rel0).condition, ((MutableFilter)rel).condition, rel.rowType);
    }

    public static boolean equalType(String desc0, MutableRel rel0, String desc1, MutableRel rel1, Litmus litmus) {
        return RelOptUtil.equal(desc0, rel0.rowType, desc1, rel1.rowType, litmus);
    }

    private static class SlotCounter {
        int queryCount;
        int targetCount;

        private SlotCounter() {
        }

        void visit(Operand operand) {
            if (operand instanceof QueryOperand) {
                ++this.queryCount;
            } else if (operand instanceof TargetOperand) {
                ++this.targetCount;
            } else if (!(operand instanceof AnyOperand)) {
                for (Operand input : ((InternalOperand)operand).inputs) {
                    this.visit(input);
                }
            }
        }
    }

    private static class TargetOperand
    extends Operand {
        private final int ordinal;

        protected TargetOperand(int ordinal) {
            super(MutableRel.class);
            this.ordinal = ordinal;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            MutableRel rel0 = visitor.slots[this.ordinal];
            assert (rel0 != null) : "QueryOperand should have been called first";
            return rel0 == rel || visitor.equivalents.get(rel0).contains(rel);
        }

        @Override
        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            MutableRel rel0 = visitor.slots[this.ordinal];
            assert (rel0 != null) : "QueryOperand should have been called first";
            return visitor.isWeaker(rel0, rel);
        }
    }

    private static class QueryOperand
    extends Operand {
        private final int ordinal;

        protected QueryOperand(int ordinal) {
            super(MutableRel.class);
            this.ordinal = ordinal;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            visitor.slots[this.ordinal] = rel;
            return true;
        }
    }

    private static class AnyOperand
    extends Operand {
        AnyOperand(Class<? extends MutableRel> clazz) {
            super(clazz);
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel);
        }
    }

    private static class InternalOperand
    extends Operand {
        private final List<Operand> inputs;

        InternalOperand(Class<? extends MutableRel> clazz, List<Operand> inputs) {
            super(clazz);
            this.inputs = inputs;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel) && InternalOperand.allMatch(visitor, this.inputs, rel.getInputs());
        }

        @Override
        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel) && InternalOperand.allWeaker(visitor, this.inputs, rel.getInputs());
        }

        private static boolean allMatch(SubstitutionVisitor visitor, List<Operand> operands, List<MutableRel> rels) {
            if (operands.size() != rels.size()) {
                return false;
            }
            for (Pair<Operand, MutableRel> pair : Pair.zip(operands, rels)) {
                if (((Operand)pair.left).matches(visitor, (MutableRel)pair.right)) continue;
                return false;
            }
            return true;
        }

        private static boolean allWeaker(SubstitutionVisitor visitor, List<Operand> operands, List<MutableRel> rels) {
            if (operands.size() != rels.size()) {
                return false;
            }
            for (Pair<Operand, MutableRel> pair : Pair.zip(operands, rels)) {
                if (((Operand)pair.left).isWeaker(visitor, (MutableRel)pair.right)) continue;
                return false;
            }
            return true;
        }
    }

    protected static abstract class Operand {
        protected final Class<? extends MutableRel> clazz;

        protected Operand(Class<? extends MutableRel> clazz) {
            this.clazz = clazz;
        }

        public abstract boolean matches(SubstitutionVisitor var1, MutableRel var2);

        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            return false;
        }
    }

    private static class IntersectToIntersectUnifyRule
    extends AbstractUnifyRule {
        public static final IntersectToIntersectUnifyRule INSTANCE = new IntersectToIntersectUnifyRule();

        private IntersectToIntersectUnifyRule() {
            super(IntersectToIntersectUnifyRule.any(MutableIntersect.class), IntersectToIntersectUnifyRule.any(MutableIntersect.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableIntersect query = (MutableIntersect)call.query;
            MutableIntersect target = (MutableIntersect)call.target;
            ArrayList queryInputs = new ArrayList(query.getInputs());
            ArrayList targetInputs = new ArrayList(target.getInputs());
            if (query.isAll() == target.isAll() && SubstitutionVisitor.sameRelCollectionNoOrderConsidered(queryInputs, targetInputs)) {
                return call.result(target);
            }
            return null;
        }
    }

    private static class UnionOnCalcsToUnionUnifyRule
    extends AbstractUnifyRule {
        public static final UnionOnCalcsToUnionUnifyRule INSTANCE = new UnionOnCalcsToUnionUnifyRule();

        private UnionOnCalcsToUnionUnifyRule() {
            super(UnionOnCalcsToUnionUnifyRule.any(MutableUnion.class), UnionOnCalcsToUnionUnifyRule.any(MutableUnion.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableUnion query = (MutableUnion)call.query;
            MutableUnion target = (MutableUnion)call.target;
            ArrayList<MutableCalc> queryInputs = new ArrayList<MutableCalc>();
            ArrayList<MutableRel> queryGrandInputs = new ArrayList<MutableRel>();
            ArrayList targetInputs = new ArrayList(target.getInputs());
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            for (MutableRel rel : query.getInputs()) {
                if (rel instanceof MutableCalc) {
                    queryInputs.add((MutableCalc)rel);
                    queryGrandInputs.add(((MutableCalc)rel).getInput());
                    continue;
                }
                return null;
            }
            if (query.isAll() && target.isAll() && SubstitutionVisitor.sameRelCollectionNoOrderConsidered(queryGrandInputs, targetInputs)) {
                Pair queryInputExplained0 = SubstitutionVisitor.explainCalc((MutableCalc)queryInputs.get(0));
                for (int i = 1; i < queryGrandInputs.size(); ++i) {
                    Pair queryInputExplained = SubstitutionVisitor.explainCalc((MutableCalc)queryInputs.get(i));
                    if (!SubstitutionVisitor.splitFilter(call.getSimplify(), (RexNode)queryInputExplained0.left, (RexNode)queryInputExplained.left).isAlwaysTrue()) {
                        return null;
                    }
                    for (Pair pair : Pair.zip((List)queryInputExplained0.right, (List)queryInputExplained.right)) {
                        if (((RexNode)pair.left).equals(pair.right)) continue;
                        return null;
                    }
                }
                List<RexNode> projectExprs = MutableRels.createProjects(target, (List)queryInputExplained0.right);
                RexProgram compenRexProgram = RexProgram.create(target.rowType, projectExprs, (RexNode)queryInputExplained0.left, query.rowType, rexBuilder);
                MutableCalc compenCalc = MutableCalc.of(target, compenRexProgram);
                return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compenCalc);
            }
            return null;
        }
    }

    private static class UnionToUnionUnifyRule
    extends AbstractUnifyRule {
        public static final UnionToUnionUnifyRule INSTANCE = new UnionToUnionUnifyRule();

        private UnionToUnionUnifyRule() {
            super(UnionToUnionUnifyRule.any(MutableUnion.class), UnionToUnionUnifyRule.any(MutableUnion.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableUnion query = (MutableUnion)call.query;
            MutableUnion target = (MutableUnion)call.target;
            ArrayList queryInputs = new ArrayList(query.getInputs());
            ArrayList targetInputs = new ArrayList(target.getInputs());
            if (query.isAll() == target.isAll() && SubstitutionVisitor.sameRelCollectionNoOrderConsidered(queryInputs, targetInputs)) {
                return call.result(target);
            }
            return null;
        }
    }

    private static class AggregateToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateToAggregateUnifyRule INSTANCE = new AggregateToAggregateUnifyRule();

        private AggregateToAggregateUnifyRule() {
            super(AggregateToAggregateUnifyRule.operand(MutableAggregate.class, AggregateToAggregateUnifyRule.query(0)), AggregateToAggregateUnifyRule.operand(MutableAggregate.class, AggregateToAggregateUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableAggregate query = (MutableAggregate)call.query;
            MutableAggregate target = (MutableAggregate)call.target;
            assert (query != target);
            if (query.getInput() != target.getInput()) {
                return null;
            }
            if (!target.groupSet.contains(query.groupSet)) {
                return null;
            }
            MutableRel result = SubstitutionVisitor.unifyAggregates(query, null, target);
            if (result == null) {
                return null;
            }
            return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, result);
        }
    }

    private static class AggregateOnCalcToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateOnCalcToAggregateUnifyRule INSTANCE = new AggregateOnCalcToAggregateUnifyRule();

        private AggregateOnCalcToAggregateUnifyRule() {
            super(AggregateOnCalcToAggregateUnifyRule.operand(MutableAggregate.class, AggregateOnCalcToAggregateUnifyRule.operand(MutableCalc.class, AggregateOnCalcToAggregateUnifyRule.query(0))), AggregateOnCalcToAggregateUnifyRule.operand(MutableAggregate.class, AggregateOnCalcToAggregateUnifyRule.target(0)), 1);
        }

        @Override
        protected UnifyResult apply(UnifyRuleCall call) {
            MutableAggregate query = (MutableAggregate)call.query;
            MutableCalc qInput = (MutableCalc)query.getInput();
            Pair qInputExplained = SubstitutionVisitor.explainCalc(qInput);
            RexNode qInputCond = (RexNode)qInputExplained.left;
            List qInputProjs = (List)qInputExplained.right;
            final MutableAggregate target = (MutableAggregate)call.target;
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            Mappings.TargetMapping mapping = Project.getMapping(SubstitutionVisitor.fieldCnt(qInput.getInput()), qInputProjs);
            if (mapping == null) {
                return null;
            }
            if (!qInputCond.isAlwaysTrue()) {
                try {
                    qInputCond.accept(new RexVisitorImpl<Void>(true){

                        @Override
                        public Void visitInputRef(RexInputRef inputRef) {
                            if (!target.groupSets.stream().allMatch(groupSet -> groupSet.get(inputRef.getIndex()))) {
                                throw Util.FoundOne.NULL;
                            }
                            return (Void)super.visitInputRef(inputRef);
                        }
                    });
                }
                catch (Util.FoundOne one) {
                    return null;
                }
            }
            Mapping inverseMapping = mapping.inverse();
            MutableAggregate aggregate2 = SubstitutionVisitor.permute(query, qInput.getInput(), inverseMapping);
            Mappings.TargetMapping mappingForQueryCond = Mappings.target(target.groupSet::indexOf, target.getInput().rowType.getFieldCount(), target.groupSet.cardinality());
            RexNode targetCond = RexUtil.apply(mappingForQueryCond, qInputCond);
            MutableRel unifiedAggregate = SubstitutionVisitor.unifyAggregates(aggregate2, targetCond, target);
            if (unifiedAggregate == null) {
                return null;
            }
            if (!Mappings.keepsOrdering(mapping)) {
                int i;
                ArrayList<Integer> posList = new ArrayList<Integer>();
                int fieldCount = aggregate2.rowType.getFieldCount();
                ArrayList<Pair<Integer, Integer>> pairs = new ArrayList<Pair<Integer, Integer>>();
                List<Integer> groupings = aggregate2.groupSet.toList();
                for (i = 0; i < groupings.size(); ++i) {
                    pairs.add(Pair.of(mapping.getTarget(groupings.get(i)), i));
                }
                Collections.sort(pairs);
                pairs.forEach(pair -> posList.add((Integer)pair.right));
                for (i = posList.size(); i < fieldCount; ++i) {
                    posList.add(i);
                }
                List<RexNode> compenProjs = MutableRels.createProjectExprs(unifiedAggregate, posList);
                RexProgram compensatingRexProgram = RexProgram.create(unifiedAggregate.rowType, compenProjs, null, query.rowType, rexBuilder);
                MutableCalc compenCalc = MutableCalc.of(unifiedAggregate, compensatingRexProgram);
                if (unifiedAggregate instanceof MutableCalc) {
                    MutableCalc newCompenCalc = SubstitutionVisitor.mergeCalc(rexBuilder, compenCalc, (MutableCalc)unifiedAggregate);
                    return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, newCompenCalc);
                }
                return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compenCalc);
            }
            return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, unifiedAggregate);
        }
    }

    private static class JoinOnCalcsToJoinUnifyRule
    extends AbstractUnifyRule {
        public static final JoinOnCalcsToJoinUnifyRule INSTANCE = new JoinOnCalcsToJoinUnifyRule();

        private JoinOnCalcsToJoinUnifyRule() {
            super(JoinOnCalcsToJoinUnifyRule.operand(MutableJoin.class, JoinOnCalcsToJoinUnifyRule.operand(MutableCalc.class, JoinOnCalcsToJoinUnifyRule.query(0)), JoinOnCalcsToJoinUnifyRule.operand(MutableCalc.class, JoinOnCalcsToJoinUnifyRule.query(1))), JoinOnCalcsToJoinUnifyRule.operand(MutableJoin.class, JoinOnCalcsToJoinUnifyRule.target(0), JoinOnCalcsToJoinUnifyRule.target(1)), 2);
        }

        @Override
        protected UnifyResult apply(UnifyRuleCall call) {
            MutableJoin query = (MutableJoin)call.query;
            final MutableCalc qInput0 = (MutableCalc)query.getLeft();
            MutableCalc qInput1 = (MutableCalc)query.getRight();
            Pair qInput0Explained = SubstitutionVisitor.explainCalc(qInput0);
            RexNode qInput0Cond = (RexNode)qInput0Explained.left;
            final List qInput0Projs = (List)qInput0Explained.right;
            Pair qInput1Explained = SubstitutionVisitor.explainCalc(qInput1);
            RexNode qInput1Cond = (RexNode)qInput1Explained.left;
            final List qInput1Projs = (List)qInput1Explained.right;
            MutableJoin target = (MutableJoin)call.target;
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            JoinRelType joinRelType = SubstitutionVisitor.sameJoinType(query.joinType, target.joinType);
            if (joinRelType == null) {
                return null;
            }
            if (!(joinRelType == JoinRelType.INNER || joinRelType.isOuterJoin() && qInput0Cond.isAlwaysTrue() && qInput1Cond.isAlwaysTrue())) {
                return null;
            }
            if (!SubstitutionVisitor.referenceByMapping(query.condition, new List[]{qInput0Projs, qInput1Projs})) {
                return null;
            }
            RexNode newQueryJoinCond = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    int idx = inputRef.getIndex();
                    if (idx < SubstitutionVisitor.fieldCnt(qInput0)) {
                        int newIdx = ((RexInputRef)qInput0Projs.get(idx)).getIndex();
                        return new RexInputRef(newIdx, inputRef.getType());
                    }
                    int newIdx = ((RexInputRef)qInput1Projs.get(idx - SubstitutionVisitor.fieldCnt(qInput0))).getIndex() + SubstitutionVisitor.fieldCnt(qInput0.getInput());
                    return new RexInputRef(newIdx, inputRef.getType());
                }
            }.apply(query.condition);
            RexNode splitted = SubstitutionVisitor.splitFilter(call.getSimplify(), newQueryJoinCond, target.condition);
            if (splitted != null && splitted.isAlwaysTrue()) {
                RexNode qInput1CondShifted = RexUtil.shift(qInput1Cond, SubstitutionVisitor.fieldCnt(qInput0.getInput()));
                RexNode compenCond = RexUtil.composeConjunction(rexBuilder, ImmutableList.of(qInput0Cond, qInput1CondShifted));
                ArrayList compenProjs = new ArrayList();
                for (int i = 0; i < query.rowType.getFieldCount(); ++i) {
                    if (i < SubstitutionVisitor.fieldCnt(qInput0)) {
                        compenProjs.add(qInput0Projs.get(i));
                        continue;
                    }
                    RexNode shifted = RexUtil.shift((RexNode)qInput1Projs.get(i - SubstitutionVisitor.fieldCnt(qInput0)), SubstitutionVisitor.fieldCnt(qInput0.getInput()));
                    compenProjs.add(shifted);
                }
                RexProgram compensatingRexProgram = RexProgram.create(target.rowType, compenProjs, compenCond, query.rowType, rexBuilder);
                MutableCalc compensatingCalc = MutableCalc.of(target, compensatingRexProgram);
                return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compensatingCalc);
            }
            return null;
        }
    }

    private static class JoinOnRightCalcToJoinUnifyRule
    extends AbstractUnifyRule {
        public static final JoinOnRightCalcToJoinUnifyRule INSTANCE = new JoinOnRightCalcToJoinUnifyRule();

        private JoinOnRightCalcToJoinUnifyRule() {
            super(JoinOnRightCalcToJoinUnifyRule.operand(MutableJoin.class, JoinOnRightCalcToJoinUnifyRule.query(0), JoinOnRightCalcToJoinUnifyRule.operand(MutableCalc.class, JoinOnRightCalcToJoinUnifyRule.query(1))), JoinOnRightCalcToJoinUnifyRule.operand(MutableJoin.class, JoinOnRightCalcToJoinUnifyRule.target(0), JoinOnRightCalcToJoinUnifyRule.target(1)), 2);
        }

        @Override
        protected UnifyResult apply(UnifyRuleCall call) {
            MutableJoin query = (MutableJoin)call.query;
            final MutableRel qInput0 = query.getLeft();
            MutableCalc qInput1 = (MutableCalc)query.getRight();
            Pair qInput1Explained = SubstitutionVisitor.explainCalc(qInput1);
            RexNode qInput1Cond = (RexNode)qInput1Explained.left;
            final List qInput1Projs = (List)qInput1Explained.right;
            MutableJoin target = (MutableJoin)call.target;
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            JoinRelType joinRelType = SubstitutionVisitor.sameJoinType(query.joinType, target.joinType);
            if (joinRelType == null) {
                return null;
            }
            if (!(joinRelType == JoinRelType.INNER || joinRelType.isOuterJoin() && qInput1Cond.isAlwaysTrue())) {
                return null;
            }
            List<? extends RexNode> identityProjects = rexBuilder.identityProjects(qInput0.rowType);
            if (!SubstitutionVisitor.referenceByMapping(query.condition, new List[]{identityProjects, qInput1Projs})) {
                return null;
            }
            RexNode newQueryJoinCond = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    int idx = inputRef.getIndex();
                    if (idx < SubstitutionVisitor.fieldCnt(qInput0)) {
                        return inputRef;
                    }
                    int newIdx = ((RexInputRef)qInput1Projs.get(idx - SubstitutionVisitor.fieldCnt(qInput0))).getIndex() + SubstitutionVisitor.fieldCnt(qInput0);
                    return new RexInputRef(newIdx, inputRef.getType());
                }
            }.apply(query.condition);
            RexNode splitted = SubstitutionVisitor.splitFilter(call.getSimplify(), newQueryJoinCond, target.condition);
            if (splitted != null && splitted.isAlwaysTrue()) {
                RexNode compenCond = RexUtil.shift(qInput1Cond, qInput0.rowType.getFieldCount());
                ArrayList<RexNode> compenProjs = new ArrayList<RexNode>();
                for (int i = 0; i < query.rowType.getFieldCount(); ++i) {
                    if (i < SubstitutionVisitor.fieldCnt(qInput0)) {
                        compenProjs.add(new RexInputRef(i, query.rowType.getFieldList().get(i).getType()));
                        continue;
                    }
                    RexNode shifted = RexUtil.shift((RexNode)qInput1Projs.get(i - SubstitutionVisitor.fieldCnt(qInput0)), qInput0.rowType.getFieldCount());
                    compenProjs.add(shifted);
                }
                RexProgram compensatingRexProgram = RexProgram.create(target.rowType, compenProjs, compenCond, query.rowType, rexBuilder);
                MutableCalc compenCalc = MutableCalc.of(target, compensatingRexProgram);
                return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compenCalc);
            }
            return null;
        }
    }

    private static class JoinOnLeftCalcToJoinUnifyRule
    extends AbstractUnifyRule {
        public static final JoinOnLeftCalcToJoinUnifyRule INSTANCE = new JoinOnLeftCalcToJoinUnifyRule();

        private JoinOnLeftCalcToJoinUnifyRule() {
            super(JoinOnLeftCalcToJoinUnifyRule.operand(MutableJoin.class, JoinOnLeftCalcToJoinUnifyRule.operand(MutableCalc.class, JoinOnLeftCalcToJoinUnifyRule.query(0)), JoinOnLeftCalcToJoinUnifyRule.query(1)), JoinOnLeftCalcToJoinUnifyRule.operand(MutableJoin.class, JoinOnLeftCalcToJoinUnifyRule.target(0), JoinOnLeftCalcToJoinUnifyRule.target(1)), 2);
        }

        @Override
        protected UnifyResult apply(UnifyRuleCall call) {
            MutableJoin query = (MutableJoin)call.query;
            final MutableCalc qInput0 = (MutableCalc)query.getLeft();
            MutableRel qInput1 = query.getRight();
            Pair qInput0Explained = SubstitutionVisitor.explainCalc(qInput0);
            RexNode qInput0Cond = (RexNode)qInput0Explained.left;
            final List qInput0Projs = (List)qInput0Explained.right;
            MutableJoin target = (MutableJoin)call.target;
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            JoinRelType joinRelType = SubstitutionVisitor.sameJoinType(query.joinType, target.joinType);
            if (joinRelType == null) {
                return null;
            }
            if (!(joinRelType == JoinRelType.INNER || joinRelType.isOuterJoin() && qInput0Cond.isAlwaysTrue())) {
                return null;
            }
            List<? extends RexNode> identityProjects = rexBuilder.identityProjects(qInput1.rowType);
            if (!SubstitutionVisitor.referenceByMapping(query.condition, new List[]{qInput0Projs, identityProjects})) {
                return null;
            }
            RexNode newQueryJoinCond = new RexShuttle(){

                @Override
                public RexNode visitInputRef(RexInputRef inputRef) {
                    int idx = inputRef.getIndex();
                    if (idx < SubstitutionVisitor.fieldCnt(qInput0)) {
                        int newIdx = ((RexInputRef)qInput0Projs.get(idx)).getIndex();
                        return new RexInputRef(newIdx, inputRef.getType());
                    }
                    int newIdx = idx - SubstitutionVisitor.fieldCnt(qInput0) + SubstitutionVisitor.fieldCnt(qInput0.getInput());
                    return new RexInputRef(newIdx, inputRef.getType());
                }
            }.apply(query.condition);
            RexNode splitted = SubstitutionVisitor.splitFilter(call.getSimplify(), newQueryJoinCond, target.condition);
            if (splitted != null && splitted.isAlwaysTrue()) {
                RexNode compenCond = qInput0Cond;
                ArrayList compenProjs = new ArrayList();
                for (int i = 0; i < SubstitutionVisitor.fieldCnt(query); ++i) {
                    if (i < SubstitutionVisitor.fieldCnt(qInput0)) {
                        compenProjs.add(qInput0Projs.get(i));
                        continue;
                    }
                    int newIdx = i - SubstitutionVisitor.fieldCnt(qInput0) + SubstitutionVisitor.fieldCnt(qInput0.getInput());
                    compenProjs.add(new RexInputRef(newIdx, query.rowType.getFieldList().get(i).getType()));
                }
                RexProgram compenRexProgram = RexProgram.create(target.rowType, compenProjs, compenCond, query.rowType, rexBuilder);
                MutableCalc compenCalc = MutableCalc.of(target, compenRexProgram);
                return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compenCalc);
            }
            return null;
        }
    }

    private static class CalcToCalcUnifyRule
    extends AbstractUnifyRule {
        public static final CalcToCalcUnifyRule INSTANCE = new CalcToCalcUnifyRule();

        private CalcToCalcUnifyRule() {
            super(CalcToCalcUnifyRule.operand(MutableCalc.class, CalcToCalcUnifyRule.query(0)), CalcToCalcUnifyRule.operand(MutableCalc.class, CalcToCalcUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableCalc query = (MutableCalc)call.query;
            Pair queryExplained = SubstitutionVisitor.explainCalc(query);
            RexNode queryCond = (RexNode)queryExplained.left;
            List queryProjs = (List)queryExplained.right;
            MutableCalc target = (MutableCalc)call.target;
            Pair targetExplained = SubstitutionVisitor.explainCalc(target);
            RexNode targetCond = (RexNode)targetExplained.left;
            List targetProjs = (List)targetExplained.right;
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            try {
                RexNode compenCond;
                RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(targetProjs);
                RexNode splitted = SubstitutionVisitor.splitFilter(call.getSimplify(), queryCond, targetCond);
                if (splitted != null) {
                    compenCond = splitted.isAlwaysTrue() ? null : shuttle.apply(splitted);
                } else if (SubstitutionVisitor.implies(call.getCluster(), queryCond, targetCond, query.getInput().rowType)) {
                    compenCond = shuttle.apply(queryCond);
                } else {
                    return null;
                }
                List compenProjs = shuttle.apply(queryProjs);
                if (compenCond == null && RexUtil.isIdentity(compenProjs, target.rowType)) {
                    return call.result(target);
                }
                RexProgram compenRexProgram = RexProgram.create(target.rowType, compenProjs, compenCond, query.rowType, rexBuilder);
                MutableCalc compenCalc = MutableCalc.of(target, compenRexProgram);
                return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compenCalc);
            }
            catch (MatchFailed e) {
                return null;
            }
        }
    }

    private static class ScanToCalcUnifyRule
    extends AbstractUnifyRule {
        public static final ScanToCalcUnifyRule INSTANCE = new ScanToCalcUnifyRule();

        private ScanToCalcUnifyRule() {
            super(ScanToCalcUnifyRule.any(MutableScan.class), ScanToCalcUnifyRule.operand(MutableCalc.class, ScanToCalcUnifyRule.any(MutableScan.class)), 0);
        }

        @Override
        protected UnifyResult apply(UnifyRuleCall call) {
            List<? extends RexNode> compenProjs;
            MutableScan query = (MutableScan)call.query;
            MutableCalc target = (MutableCalc)call.target;
            MutableScan targetInput = (MutableScan)target.getInput();
            Pair targetExplained = SubstitutionVisitor.explainCalc(target);
            RexNode targetCond = (RexNode)targetExplained.left;
            List targetProjs = (List)targetExplained.right;
            RexBuilder rexBuilder = call.getCluster().getRexBuilder();
            if (!query.equals(targetInput) || !targetCond.isAlwaysTrue()) {
                return null;
            }
            RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(targetProjs);
            try {
                compenProjs = shuttle.apply(rexBuilder.identityProjects(query.rowType));
            }
            catch (MatchFailed e) {
                return null;
            }
            if (RexUtil.isIdentity(compenProjs, target.rowType)) {
                return call.result(target);
            }
            RexProgram compenRexProgram = RexProgram.create(target.rowType, compenProjs, null, query.rowType, rexBuilder);
            MutableCalc compenCalc = MutableCalc.of(target, compenRexProgram);
            return SubstitutionVisitor.tryMergeParentCalcAndGenResult(call, compenCalc);
        }
    }

    private static class TrivialRule
    extends AbstractUnifyRule {
        private static final TrivialRule INSTANCE = new TrivialRule();

        private TrivialRule() {
            super(TrivialRule.any(MutableRel.class), TrivialRule.any(MutableRel.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            if (call.query.equals(call.target)) {
                return call.result(call.target);
            }
            return null;
        }

        static /* synthetic */ TrivialRule access$000() {
            return INSTANCE;
        }
    }

    protected static abstract class AbstractUnifyRule
    extends UnifyRule {
        public AbstractUnifyRule(Operand queryOperand, Operand targetOperand, int slotCount) {
            super(slotCount, queryOperand, targetOperand);
            assert (this.isValid());
        }

        protected boolean isValid() {
            SlotCounter slotCounter = new SlotCounter();
            slotCounter.visit(this.queryOperand);
            assert (slotCounter.queryCount == this.slotCount);
            assert (slotCounter.targetCount == 0);
            slotCounter.queryCount = 0;
            slotCounter.visit(this.targetOperand);
            assert (slotCounter.queryCount == 0);
            assert (slotCounter.targetCount == this.slotCount);
            return true;
        }

        protected static Operand operand(Class<? extends MutableRel> clazz, Operand ... inputOperands) {
            return new InternalOperand(clazz, ImmutableList.copyOf(inputOperands));
        }

        protected static Operand any(Class<? extends MutableRel> clazz) {
            return new AnyOperand(clazz);
        }

        protected static Operand query(int ordinal) {
            return new QueryOperand(ordinal);
        }

        protected static Operand target(int ordinal) {
            return new TargetOperand(ordinal);
        }
    }

    protected static class UnifyResult {
        private final UnifyRuleCall call;
        private final MutableRel result;
        private final boolean stopTrying;

        UnifyResult(UnifyRuleCall call, MutableRel result, boolean stopTrying) {
            this.call = call;
            assert (SubstitutionVisitor.equalType("query", call.query, "result", result, Litmus.THROW));
            this.result = result;
            this.stopTrying = stopTrying;
        }
    }

    protected class UnifyRuleCall {
        protected final UnifyRule rule;
        public final MutableRel query;
        public final MutableRel target;
        protected final ImmutableList<MutableRel> slots;

        public UnifyRuleCall(UnifyRule rule, MutableRel query, MutableRel target, ImmutableList<MutableRel> slots) {
            this.rule = Objects.requireNonNull(rule);
            this.query = Objects.requireNonNull(query);
            this.target = Objects.requireNonNull(target);
            this.slots = Objects.requireNonNull(slots);
        }

        public UnifyResult result(MutableRel result) {
            return this.result(result, true);
        }

        public UnifyResult result(MutableRel result, boolean stopTrying) {
            assert (MutableRels.contains(result, this.target));
            assert (SubstitutionVisitor.equalType("result", result, "query", this.query, Litmus.THROW));
            MutableRel replace = SubstitutionVisitor.this.replacementMap.get(this.target);
            if (replace != null) {
                assert (false);
                SubstitutionVisitor.replace(result, this.target, replace);
            }
            SubstitutionVisitor.this.register(result, this.query);
            return new UnifyResult(this, result, stopTrying);
        }

        public UnifyRuleCall create(MutableRel query) {
            return new UnifyRuleCall(this.rule, query, this.target, this.slots);
        }

        public RelOptCluster getCluster() {
            return SubstitutionVisitor.this.cluster;
        }

        public RexSimplify getSimplify() {
            return SubstitutionVisitor.this.simplify;
        }
    }

    protected static abstract class UnifyRule {
        protected final int slotCount;
        protected final Operand queryOperand;
        protected final Operand targetOperand;

        protected UnifyRule(int slotCount, Operand queryOperand, Operand targetOperand) {
            this.slotCount = slotCount;
            this.queryOperand = queryOperand;
            this.targetOperand = targetOperand;
        }

        protected abstract UnifyResult apply(UnifyRuleCall var1);

        protected UnifyRuleCall match(SubstitutionVisitor visitor, MutableRel query, MutableRel target) {
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target)) {
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return substitutionVisitor.new UnifyRuleCall(this, query, target, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }

        protected <E> ImmutableList<E> copy(E[] slots, int slotCount) {
            switch (slotCount) {
                case 0: {
                    return ImmutableList.of();
                }
                case 1: {
                    return ImmutableList.of(slots[0]);
                }
            }
            return ImmutableList.copyOf(slots).subList(0, slotCount);
        }
    }

    protected static class MatchFailed
    extends ControlFlowException {
        public static final MatchFailed INSTANCE = new MatchFailed();

        protected MatchFailed() {
        }
    }

    static class Replacement {
        final MutableRel before;
        final MutableRel after;
        final boolean stopTrying;

        Replacement(MutableRel before, MutableRel after) {
            this(before, after, true);
        }

        Replacement(MutableRel before, MutableRel after, boolean stopTrying) {
            this.before = before;
            this.after = after;
            this.stopTrying = stopTrying;
        }
    }
}

