/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.ViewExpanders;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.hint.Hintable;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelColumnMapping;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.ListTransientTable;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.TableFunctionReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Optionality;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;

public class RelBuilder {
    protected final RelOptCluster cluster;
    protected final RelOptSchema relOptSchema;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();
    private final RexSimplify simplifier;
    private final Config config;
    private final RelOptTable.ViewExpander viewExpander;
    private final RelFactories.Struct struct;

    protected RelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        if (context == null) {
            context = Contexts.EMPTY_CONTEXT;
        }
        this.config = this.getConfig(context);
        this.viewExpander = this.getViewExpander(cluster, context);
        this.struct = Objects.requireNonNull(RelFactories.Struct.fromContext(context));
        RexExecutor executor = Util.first(context.unwrap(RexExecutor.class), Util.first(cluster.getPlanner().getExecutor(), RexUtil.EXECUTOR));
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        this.simplifier = new RexSimplify(cluster.getRexBuilder(), predicates, executor);
    }

    private RelOptTable.ViewExpander getViewExpander(RelOptCluster cluster, Context context) {
        return Util.first(context.unwrap(RelOptTable.ViewExpander.class), ViewExpanders.simpleContext(cluster));
    }

    private Config getConfig(Context context) {
        Config config = Util.first(context.unwrap(Config.class), Config.DEFAULT);
        boolean simplify = Hook.REL_BUILDER_SIMPLIFY.get(config.simplify());
        return config.withSimplify(simplify);
    }

    public static RelBuilder create(FrameworkConfig config) {
        return Frameworks.withPrepare(config, (cluster, relOptSchema, rootSchema, statement) -> new RelBuilder(config.getContext(), cluster, relOptSchema));
    }

    public RelBuilder transform(UnaryOperator<Config> transform) {
        Context context = Contexts.of(this.struct, transform.apply(this.config));
        return new RelBuilder(context, this.cluster, this.relOptSchema);
    }

    public String toString() {
        return this.stack.stream().map(frame -> RelOptUtil.toString(frame.rel)).collect(Collectors.joining(""));
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RexBuilder getRexBuilder() {
        return this.cluster.getRexBuilder();
    }

    public static RelBuilderFactory proto(Context context) {
        return (cluster, schema) -> new RelBuilder(context, cluster, schema);
    }

    public static RelBuilderFactory proto(Object ... factories) {
        return RelBuilder.proto(Contexts.of(factories));
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    public RelOptSchema getRelOptSchema() {
        return this.relOptSchema;
    }

    public RelFactories.TableScanFactory getScanFactory() {
        return this.struct.scanFactory;
    }

    public RelBuilder push(RelNode node) {
        this.stack.push(new Frame(node));
        return this;
    }

    private void replaceTop(RelNode node) {
        Frame frame = this.stack.pop();
        this.stack.push(new Frame(node, frame.fields));
    }

    public RelBuilder pushAll(Iterable<? extends RelNode> nodes) {
        for (RelNode relNode : nodes) {
            this.push(relNode);
        }
        return this;
    }

    public RelNode build() {
        return this.stack.pop().rel;
    }

    public RelNode peek() {
        return this.peek_().rel;
    }

    private Frame peek_() {
        return this.stack.peek();
    }

    public RelNode peek(int n) {
        return this.peek_((int)n).rel;
    }

    private Frame peek_(int n) {
        return Iterables.get(this.stack, n);
    }

    public RelNode peek(int inputCount, int inputOrdinal) {
        return this.peek_((int)inputCount, (int)inputOrdinal).rel;
    }

    private Frame peek_(int inputCount, int inputOrdinal) {
        return this.peek_(inputCount - 1 - inputOrdinal);
    }

    private int inputOffset(int inputCount, int inputOrdinal) {
        int offset = 0;
        for (int i = 0; i < inputOrdinal; ++i) {
            offset += this.peek(inputCount, i).getRowType().getFieldCount();
        }
        return offset;
    }

    public RexNode literal(Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            RelDataType type = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
            return rexBuilder.makeNullLiteral(type);
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        if (value instanceof Enum) {
            return rexBuilder.makeLiteral(value, this.getTypeFactory().createSqlType(SqlTypeName.SYMBOL), false);
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    public RelBuilder variable(Holder<RexCorrelVariable> v) {
        v.set((RexCorrelVariable)this.getRexBuilder().makeCorrel(this.peek().getRowType(), this.cluster.createCorrel()));
        return this;
    }

    public RexInputRef field(String fieldName) {
        return this.field(1, 0, fieldName);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, String fieldName) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        List fieldNames = Pair.left(frame.fields());
        int i = fieldNames.indexOf(fieldName);
        if (i >= 0) {
            return this.field(inputCount, inputOrdinal, i);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] not found; input fields are: " + fieldNames);
    }

    public RexInputRef field(int fieldOrdinal) {
        return (RexInputRef)this.field(1, 0, fieldOrdinal, false);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, int fieldOrdinal) {
        return (RexInputRef)this.field(inputCount, inputOrdinal, fieldOrdinal, false);
    }

    private RexNode field(int inputCount, int inputOrdinal, int fieldOrdinal, boolean alias2) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        RelNode input = frame.rel;
        RelDataType rowType = input.getRowType();
        if (fieldOrdinal < 0 || fieldOrdinal > rowType.getFieldCount()) {
            throw new IllegalArgumentException("field ordinal [" + fieldOrdinal + "] out of range; input fields are: " + rowType.getFieldNames());
        }
        RelDataTypeField field = rowType.getFieldList().get(fieldOrdinal);
        int offset = this.inputOffset(inputCount, inputOrdinal);
        RexInputRef ref = this.cluster.getRexBuilder().makeInputRef(field.getType(), offset + fieldOrdinal);
        RelDataTypeField aliasField = frame.fields().get(fieldOrdinal);
        if (!alias2 || field.getName().equals(aliasField.getName())) {
            return ref;
        }
        return this.alias(ref, aliasField.getName());
    }

    public RexNode field(String alias2, String fieldName) {
        return this.field(1, alias2, fieldName);
    }

    public RexNode field(int inputCount, String alias2, String fieldName) {
        Objects.requireNonNull(alias2);
        Objects.requireNonNull(fieldName);
        ArrayList<String> fields = new ArrayList<String>();
        for (int inputOrdinal = 0; inputOrdinal < inputCount; ++inputOrdinal) {
            Frame frame = this.peek_(inputOrdinal);
            for (Ord<Field> p : Ord.zip(frame.fields)) {
                if (((ImmutableSet)((Field)p.e).left).contains(alias2) && ((RelDataTypeField)((Field)p.e).right).getName().equals(fieldName)) {
                    return this.field(inputCount, inputCount - 1 - inputOrdinal, p.i);
                }
                fields.add(String.format(Locale.ROOT, "{aliases=%s,fieldName=%s}", ((Field)p.e).left, ((RelDataTypeField)((Field)p.e).right).getName()));
            }
        }
        throw new IllegalArgumentException("no aliased field found; fields are: " + fields);
    }

    public RexNode field(RexNode e, String name) {
        return this.getRexBuilder().makeFieldAccess(e, name, false);
    }

    public ImmutableList<RexNode> fields() {
        return this.fields(1, 0);
    }

    public ImmutableList<RexNode> fields(int inputCount, int inputOrdinal) {
        RelNode input = this.peek(inputCount, inputOrdinal);
        RelDataType rowType = input.getRowType();
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (int fieldOrdinal : Util.range(rowType.getFieldCount())) {
            nodes.add(this.field(inputCount, inputOrdinal, fieldOrdinal));
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(RelCollation collation) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RexNode node = this.field(fieldCollation.getFieldIndex());
            switch (fieldCollation.direction) {
                case DESCENDING: {
                    node = this.desc(node);
                }
            }
            switch (fieldCollation.nullDirection) {
                case FIRST: {
                    node = this.nullsFirst(node);
                    break;
                }
                case LAST: {
                    node = this.nullsLast(node);
                }
            }
            nodes.add(node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(List<? extends Number> ordinals) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (Number number : ordinals) {
            RexNode node = this.field(1, 0, number.intValue(), false);
            nodes.add(node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(ImmutableBitSet ordinals) {
        return this.fields(ordinals.asList());
    }

    public ImmutableList<RexNode> fields(Iterable<String> fieldNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            builder.add(this.field(fieldName));
        }
        return builder.build();
    }

    public ImmutableList<RexNode> fields(Mappings.TargetMapping mapping) {
        return this.fields(Mappings.asList(mapping));
    }

    public RexNode dot(RexNode node, String fieldName) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldName, true);
    }

    public RexNode dot(RexNode node, int fieldOrdinal) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldOrdinal);
    }

    @Nonnull
    public RexNode call(SqlOperator operator, RexNode ... operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
    }

    @Nonnull
    private RexNode call(SqlOperator operator, List<RexNode> operandList) {
        RexBuilder builder = this.cluster.getRexBuilder();
        RelDataType type = builder.deriveReturnType(operator, operandList);
        return builder.makeCall(type, operator, operandList);
    }

    @Nonnull
    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
    }

    public RexNode and(RexNode ... operands) {
        return this.and(ImmutableList.copyOf(operands));
    }

    public RexNode and(Iterable<? extends RexNode> operands) {
        return RexUtil.composeConjunction(this.getRexBuilder(), operands);
    }

    public RexNode or(RexNode ... operands) {
        return this.or(ImmutableList.copyOf(operands));
    }

    public RexNode or(Iterable<? extends RexNode> operands) {
        return RexUtil.composeDisjunction(this.cluster.getRexBuilder(), operands);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT, operand);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode notEquals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, operand0, operand1);
    }

    public RexNode isNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NULL, operand);
    }

    public RexNode isNotNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision, scale);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode alias(RexNode expr, String alias2) {
        RexNode aliasLiteral = this.literal(alias2);
        switch (expr.getKind()) {
            case AS: {
                RexCall call = (RexCall)expr;
                if (((RexNode)call.operands.get(1)).equals(aliasLiteral)) {
                    return expr;
                }
                expr = (RexNode)call.operands.get(0);
            }
        }
        return this.call((SqlOperator)SqlStdOperatorTable.AS, expr, aliasLiteral);
    }

    public RexNode desc(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.DESC, node);
    }

    public RexNode nullsLast(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_LAST, node);
    }

    public RexNode nullsFirst(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, node);
    }

    public GroupKey groupKey() {
        return this.groupKey(ImmutableList.of());
    }

    public GroupKey groupKey(RexNode ... nodes) {
        return this.groupKey(ImmutableList.copyOf(nodes));
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes) {
        return new GroupKeyImpl(ImmutableList.copyOf(nodes), null, null);
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        return this.groupKey_(nodes, nodeLists);
    }

    @Deprecated
    public GroupKey groupKey(Iterable<? extends RexNode> nodes, boolean indicator, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        Aggregate.checkIndicator(indicator);
        return this.groupKey_(nodes, nodeLists);
    }

    private GroupKey groupKey_(Iterable<? extends RexNode> nodes, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Iterable<? extends RexNode> iterable : nodeLists) {
            builder.add(ImmutableList.copyOf(iterable));
        }
        return new GroupKeyImpl(ImmutableList.copyOf(nodes), (ImmutableList<ImmutableList<RexNode>>)builder.build(), null);
    }

    public GroupKey groupKey(int ... fieldOrdinals) {
        return this.groupKey(this.fields(ImmutableIntList.of(fieldOrdinals)));
    }

    public GroupKey groupKey(String ... fieldNames) {
        return this.groupKey(this.fields((Iterable<String>)ImmutableList.copyOf(fieldNames)));
    }

    public GroupKey groupKey(@Nonnull ImmutableBitSet groupSet) {
        return this.groupKey_(groupSet, ImmutableList.of(groupSet));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet, @Nonnull Iterable<? extends ImmutableBitSet> groupSets) {
        return this.groupKey_(groupSet, ImmutableList.copyOf(groupSets));
    }

    @Deprecated
    public GroupKey groupKey(ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets) {
        return this.groupKey_(groupSet, groupSets == null ? ImmutableList.of(groupSet) : ImmutableList.copyOf(groupSets));
    }

    @Deprecated
    public GroupKey groupKey(ImmutableBitSet groupSet, boolean indicator, ImmutableList<ImmutableBitSet> groupSets) {
        Aggregate.checkIndicator(indicator);
        return this.groupKey_(groupSet, groupSets == null ? ImmutableList.of(groupSet) : ImmutableList.copyOf(groupSets));
    }

    private GroupKey groupKey_(ImmutableBitSet groupSet, @Nonnull ImmutableList<ImmutableBitSet> groupSets) {
        if (groupSet.length() > this.peek().getRowType().getFieldCount()) {
            throw new IllegalArgumentException("out of bounds: " + groupSet);
        }
        Objects.requireNonNull(groupSets);
        ImmutableList<RexNode> nodes = this.fields(groupSet);
        return this.groupKey_(nodes, Util.transform(groupSets, bitSet -> this.fields((ImmutableBitSet)bitSet)));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias2, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, false, false, filter, ImmutableList.of(), alias2, ImmutableList.copyOf(operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, RexNode filter, String alias2, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, approximate, false, filter, ImmutableList.of(), alias2, ImmutableList.copyOf(operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias2, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, distinct, false, false, filter, ImmutableList.of(), alias2, ImmutableList.copyOf(operands));
    }

    @Deprecated
    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, RexNode filter, String alias2, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, distinct, approximate, false, filter, ImmutableList.of(), alias2, ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(aggFunction, false, false, false, null, ImmutableList.of(), null, ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, RexNode ... operands) {
        return this.aggregateCall(aggFunction, false, false, false, null, ImmutableList.of(), null, ImmutableList.copyOf(operands));
    }

    protected AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, RexNode filter, ImmutableList<RexNode> orderKeys, String alias2, ImmutableList<RexNode> operands) {
        return new AggCallImpl(aggFunction, distinct, approximate, ignoreNulls, filter, alias2, operands, orderKeys);
    }

    public AggCall count(RexNode ... operands) {
        return this.count(false, null, operands);
    }

    public AggCall count(Iterable<? extends RexNode> operands) {
        return this.count(false, null, operands);
    }

    public AggCall count(boolean distinct, String alias2, RexNode ... operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, false, false, null, ImmutableList.of(), alias2, ImmutableList.copyOf(operands));
    }

    public AggCall count(boolean distinct, String alias2, Iterable<? extends RexNode> operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, false, false, null, ImmutableList.of(), alias2, ImmutableList.copyOf(operands));
    }

    public AggCall countStar(String alias2) {
        return this.count(false, alias2, new RexNode[0]);
    }

    public AggCall sum(RexNode operand) {
        return this.sum(false, null, operand);
    }

    public AggCall sum(boolean distinct, String alias2, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.SUM, distinct, false, false, null, ImmutableList.of(), alias2, ImmutableList.of(operand));
    }

    public AggCall avg(RexNode operand) {
        return this.avg(false, null, operand);
    }

    public AggCall avg(boolean distinct, String alias2, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.AVG, distinct, false, false, null, ImmutableList.of(), alias2, ImmutableList.of(operand));
    }

    public AggCall min(RexNode operand) {
        return this.min(null, operand);
    }

    public AggCall min(String alias2, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MIN, false, false, false, null, ImmutableList.of(), alias2, ImmutableList.of(operand));
    }

    public AggCall max(RexNode operand) {
        return this.max(null, operand);
    }

    public AggCall max(String alias2, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MAX, false, false, false, null, ImmutableList.of(), alias2, ImmutableList.of(operand));
    }

    public RexNode patternField(String alpha, RelDataType type, int i) {
        return this.getRexBuilder().makePatternFieldRef(alpha, type, i);
    }

    public RexNode patternConcat(Iterable<? extends RexNode> nodes) {
        ImmutableList<RexNode> list = ImmutableList.copyOf(nodes);
        if (list.size() > 2) {
            return this.patternConcat(this.patternConcat(Util.skipLast(list)), Util.last(list));
        }
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_CONCAT, list);
    }

    public RexNode patternConcat(RexNode ... nodes) {
        return this.patternConcat(ImmutableList.copyOf(nodes));
    }

    public RexNode patternAlter(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_ALTER, ImmutableList.copyOf(nodes));
    }

    public RexNode patternAlter(RexNode ... nodes) {
        return this.patternAlter(ImmutableList.copyOf(nodes));
    }

    public RexNode patternQuantify(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_QUANTIFIER, ImmutableList.copyOf(nodes));
    }

    public RexNode patternQuantify(RexNode ... nodes) {
        return this.patternQuantify(ImmutableList.copyOf(nodes));
    }

    public RexNode patternPermute(Iterable<? extends RexNode> nodes) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_PERMUTE, ImmutableList.copyOf(nodes));
    }

    public RexNode patternPermute(RexNode ... nodes) {
        return this.patternPermute(ImmutableList.copyOf(nodes));
    }

    public RexNode patternExclude(RexNode node) {
        RelDataType t = this.getTypeFactory().createSqlType(SqlTypeName.NULL);
        return this.getRexBuilder().makeCall(t, SqlStdOperatorTable.PATTERN_EXCLUDE, ImmutableList.of(node));
    }

    public RelBuilder scan(Iterable<String> tableNames) {
        ImmutableList<String> names = ImmutableList.copyOf(tableNames);
        RelOptTable relOptTable = this.relOptSchema.getTableForMember(names);
        if (relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(String.join((CharSequence)".", names)).ex();
        }
        RelNode scan = this.struct.scanFactory.createScan(ViewExpanders.toRelContext(this.viewExpander, this.cluster), relOptTable);
        this.push(scan);
        this.rename(relOptTable.getRowType().getFieldNames());
        if (!(scan instanceof TableScan)) {
            this.as(Util.last(ImmutableList.copyOf(tableNames)));
        }
        return this;
    }

    public RelBuilder scan(String ... tableNames) {
        return this.scan(ImmutableList.copyOf(tableNames));
    }

    public RelBuilder snapshot(RexNode period) {
        Frame frame = this.stack.pop();
        RelNode snapshot = this.struct.snapshotFactory.createSnapshot(frame.rel, period);
        this.stack.push(new Frame(snapshot, frame.fields));
        return this;
    }

    private Set<RelColumnMapping> getColumnMappings(SqlOperator op) {
        SqlReturnTypeInference inference = op.getReturnTypeInference();
        if (inference instanceof TableFunctionReturnTypeInference) {
            return ((TableFunctionReturnTypeInference)inference).getColumnMappings();
        }
        return null;
    }

    public RexNode cursor(int inputCount, int ordinal) {
        if (inputCount <= ordinal || ordinal < 0) {
            throw new IllegalArgumentException("bad input count or ordinal");
        }
        RelNode input = this.peek(inputCount, ordinal);
        return this.call((SqlOperator)SqlStdOperatorTable.CURSOR, this.getRexBuilder().makeInputRef(input.getRowType(), ordinal));
    }

    public RelBuilder functionScan(SqlOperator operator, int inputCount, RexNode ... operands) {
        return this.functionScan(operator, inputCount, ImmutableList.copyOf(operands));
    }

    public RelBuilder functionScan(SqlOperator operator, int inputCount, Iterable<? extends RexNode> operands) {
        if (inputCount < 0 || inputCount > this.stack.size()) {
            throw new IllegalArgumentException("bad input count");
        }
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < inputCount; ++i) {
            inputs.add(0, this.build());
        }
        RexNode call = this.call(operator, (List<RexNode>)ImmutableList.copyOf(operands));
        RelNode functionScan = this.struct.tableFunctionScanFactory.createTableFunctionScan(this.cluster, inputs, call, null, this.getColumnMappings(operator));
        this.push(functionScan);
        return this;
    }

    public RelBuilder filter(RexNode ... predicates) {
        return this.filter(ImmutableSet.of(), ImmutableList.copyOf(predicates));
    }

    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        return this.filter(ImmutableSet.of(), predicates);
    }

    public RelBuilder filter(Iterable<CorrelationId> variablesSet, RexNode ... predicates) {
        return this.filter(variablesSet, ImmutableList.copyOf(predicates));
    }

    public RelBuilder filter(Iterable<CorrelationId> variablesSet, Iterable<? extends RexNode> predicates) {
        RexNode simplifiedPredicates = this.simplifier.simplifyFilterPredicates(predicates);
        if (simplifiedPredicates == null) {
            return this.empty();
        }
        if (!simplifiedPredicates.isAlwaysTrue()) {
            Frame frame = this.stack.pop();
            RelNode filter = this.struct.filterFactory.createFilter(frame.rel, simplifiedPredicates, ImmutableSet.copyOf(variablesSet));
            this.stack.push(new Frame(filter, frame.fields));
        }
        return this;
    }

    public RelBuilder project(RexNode ... nodes) {
        return this.project(ImmutableList.copyOf(nodes));
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes) {
        return this.project(nodes, ImmutableList.of());
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames) {
        return this.project(nodes, fieldNames, false);
    }

    public RelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, boolean force) {
        return this.project_(nodes, fieldNames, ImmutableList.of(), force);
    }

    public RelBuilder projectPlus(RexNode ... nodes) {
        return this.projectPlus(ImmutableList.copyOf(nodes));
    }

    public RelBuilder projectPlus(Iterable<RexNode> nodes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return this.project(((ImmutableList.Builder)((ImmutableList.Builder)builder.addAll(this.fields())).addAll(nodes)).build());
    }

    public RelBuilder projectExcept(RexNode ... expressions) {
        return this.projectExcept(ImmutableList.copyOf(expressions));
    }

    public RelBuilder projectExcept(Iterable<RexNode> expressions) {
        ArrayList<RexNode> allExpressions = new ArrayList<RexNode>(this.fields());
        HashSet<RexNode> excludeExpressions = new HashSet<RexNode>();
        for (RexNode excludeExp : expressions) {
            if (!excludeExpressions.add(excludeExp)) {
                throw new IllegalArgumentException("Input list contains duplicates. Expression " + excludeExp + " exists multiple times.");
            }
            if (allExpressions.remove(excludeExp)) continue;
            throw new IllegalArgumentException("Expression " + excludeExp.toString() + " not found.");
        }
        return this.project(allExpressions);
    }

    private RelBuilder project_(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, Iterable<RelHint> hints, boolean force) {
        Frame frame = this.stack.peek();
        RelDataType inputRowType = frame.rel.getRowType();
        ArrayList<RexNode> nodeList = Lists.newArrayList(nodes);
        if (!force && Iterables.isEmpty(fieldNames) && RexUtil.isIdentity(nodeList, inputRowType)) {
            return this;
        }
        ArrayList<String> fieldNameList = Lists.newArrayList(fieldNames);
        while (fieldNameList.size() < nodeList.size()) {
            fieldNameList.add(null);
        }
        if (frame.rel instanceof Project && this.config.bloat() >= 0) {
            Project project = (Project)frame.rel;
            for (int i = 0; i < fieldNameList.size(); ++i) {
                RexNode node;
                if (fieldNameList.get(i) != null || !((node = (RexNode)nodeList.get(i)) instanceof RexInputRef)) continue;
                RexInputRef ref = (RexInputRef)node;
                fieldNameList.set(i, project.getRowType().getFieldNames().get(ref.getIndex()));
            }
            List<RexNode> newNodes = RelOptUtil.pushPastProjectUnlessBloat(nodeList, project, this.config.bloat());
            if (newNodes != null) {
                Frame frame1 = this.stack.pop();
                ArrayList<Field> fields = new ArrayList<Field>();
                for (RelDataTypeField relDataTypeField : project.getInput().getRowType().getFieldList()) {
                    fields.add(new Field(ImmutableSet.of(), relDataTypeField));
                }
                for (Pair pair : Pair.zip(project.getProjects(), frame1.fields)) {
                    switch (((RexNode)pair.left).getKind()) {
                        case INPUT_REF: {
                            int i = ((RexInputRef)pair.left).getIndex();
                            Field field = (Field)fields.get(i);
                            ImmutableSet aliases = (ImmutableSet)((Field)pair.right).left;
                            fields.set(i, new Field(aliases, (RelDataTypeField)field.right));
                        }
                    }
                }
                this.stack.push(new Frame(project.getInput(), ImmutableList.copyOf(fields)));
                ImmutableSet.Builder mergedHints = ImmutableSet.builder();
                mergedHints.addAll(project.getHints());
                mergedHints.addAll(hints);
                return this.project_(newNodes, fieldNameList, mergedHints.build(), force);
            }
        }
        if (this.config.simplify()) {
            for (int i = 0; i < nodeList.size(); ++i) {
                nodeList.set(i, this.simplifier.simplifyPreservingType((RexNode)nodeList.get(i)));
            }
        }
        for (int i = 0; i < fieldNameList.size(); ++i) {
            if (fieldNameList.get(i) != null) continue;
            fieldNameList.set(i, this.inferAlias(nodeList, (RexNode)nodeList.get(i), i));
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        AbstractSet uniqueNameList = this.getTypeFactory().getTypeSystem().isSchemaCaseSensitive() ? new HashSet() : new TreeSet(String.CASE_INSENSITIVE_ORDER);
        for (int i = 0; i < fieldNameList.size(); ++i) {
            Field field;
            String name;
            RexNode node = (RexNode)nodeList.get(i);
            String string = name = (String)fieldNameList.get(i);
            if (name == null || uniqueNameList.contains(name)) {
                int j2 = 0;
                if (name == null) {
                    j2 = i;
                }
                while (uniqueNameList.contains(name = SqlValidatorUtil.F_SUGGESTER.apply(string, j2, j2++))) {
                }
                fieldNameList.set(i, name);
            }
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name, i, node.getType());
            switch (node.getKind()) {
                case INPUT_REF: {
                    int index = ((RexInputRef)node).getIndex();
                    field = new Field((ImmutableSet)((Field)frame.fields.get((int)index)).left, fieldType);
                    break;
                }
                default: {
                    field = new Field(ImmutableSet.of(), fieldType);
                }
            }
            uniqueNameList.add(name);
            fields.add(field);
        }
        if (!force && RexUtil.isIdentity(nodeList, inputRowType)) {
            if (fieldNameList.equals(inputRowType.getFieldNames())) {
                return this;
            }
            this.stack.pop();
            this.stack.push(new Frame(frame.rel, (ImmutableList)fields.build()));
            return this;
        }
        RelNode project = this.struct.projectFactory.createProject(frame.rel, ImmutableList.copyOf(hints), ImmutableList.copyOf(nodeList), fieldNameList);
        this.stack.pop();
        this.stack.push(new Frame(project, (ImmutableList)fields.build()));
        return this;
    }

    @Deprecated
    protected boolean shouldMergeProject() {
        return true;
    }

    public RelBuilder projectNamed(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, boolean force) {
        ImmutableList<? extends RexNode> nodeList;
        ImmutableList<? extends RexNode> immutableList = nodeList = nodes instanceof List ? (ImmutableList<? extends RexNode>)nodes : ImmutableList.copyOf(nodes);
        List<String> fieldNameList = fieldNames == null ? null : (fieldNames instanceof List ? (List<String>)fieldNames : ImmutableNullableList.copyOf(fieldNames));
        RelNode input = this.peek();
        RelDataType rowType = RexUtil.createStructType(this.cluster.getTypeFactory(), nodeList, fieldNameList, SqlValidatorUtil.F_SUGGESTER);
        if (!force && RexUtil.isIdentity(nodeList, input.getRowType())) {
            if (input instanceof Project && fieldNames != null) {
                Frame frame = this.stack.pop();
                Project childProject = (Project)frame.rel;
                Project newInput = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), rowType);
                this.stack.push(new Frame(newInput.attachHints(childProject.getHints()), frame.fields));
            }
        } else {
            this.project(nodeList, rowType.getFieldNames(), force);
        }
        return this;
    }

    public RelBuilder rename(List<String> fieldNames) {
        List<String> oldFieldNames = this.peek().getRowType().getFieldNames();
        Preconditions.checkArgument(fieldNames.size() <= oldFieldNames.size(), "More names than fields");
        ArrayList<String> newFieldNames = new ArrayList<String>(oldFieldNames);
        for (int i = 0; i < fieldNames.size(); ++i) {
            String s = fieldNames.get(i);
            if (s == null) continue;
            newFieldNames.set(i, s);
        }
        if (oldFieldNames.equals(newFieldNames)) {
            return this;
        }
        if (this.peek() instanceof Values) {
            Values v = (Values)this.build();
            RelDataTypeFactory.FieldInfoBuilder b = this.getTypeFactory().builder();
            for (Pair<String, RelDataTypeField> p : Pair.zip(newFieldNames, v.getRowType().getFieldList())) {
                ((RelDataTypeFactory.Builder)b).add((String)p.left, ((RelDataTypeField)p.right).getType());
            }
            return this.values(v.tuples, b.build());
        }
        return this.project(this.fields(), newFieldNames, true);
    }

    private String inferAlias(List<RexNode> exprList, RexNode expr, int i) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)expr;
                return ((RelDataTypeField)((Field)this.stack.peek().fields.get(ref.getIndex())).getValue()).getName();
            }
            case CAST: {
                return this.inferAlias(exprList, ((RexCall)expr).getOperands().get(0), -1);
            }
            case AS: {
                RexCall call = (RexCall)expr;
                if (i >= 0) {
                    exprList.set(i, call.getOperands().get(0));
                }
                return ((NlsString)((RexLiteral)call.getOperands().get(1)).getValue()).getValue();
            }
        }
        return null;
    }

    public RelBuilder distinct() {
        return this.aggregate(this.groupKey(this.fields()), new AggCall[0]);
    }

    public RelBuilder aggregate(GroupKey groupKey, AggCall ... aggCalls) {
        return this.aggregate(groupKey, (Iterable<AggCall>)ImmutableList.copyOf(aggCalls));
    }

    public RelBuilder aggregate(GroupKey groupKey, List<AggregateCall> aggregateCalls) {
        return this.aggregate(groupKey, aggregateCalls.stream().map(AggCallImpl2::new).collect(Collectors.toList()));
    }

    public RelBuilder aggregate(GroupKey groupKey, Iterable<AggCall> aggCalls) {
        Object aggregateCall;
        Object args;
        ImmutableList<ImmutableBitSet> groupSets;
        Registrar registrar = new Registrar(this.fields(), this.peek().getRowType().getFieldNames());
        GroupKeyImpl groupKey_ = (GroupKeyImpl)groupKey;
        ImmutableBitSet groupSet = ImmutableBitSet.of(registrar.registerExpressions(groupKey_.nodes));
        if (Iterables.isEmpty(aggCalls)) {
            Double minRowCount;
            RelMetadataQuery mq = this.peek().getCluster().getMetadataQuery();
            if (!groupSet.isEmpty() || (minRowCount = mq.getMinRowCount(this.peek())) != null && !(minRowCount < 1.0)) {
                Boolean unique;
                if (registrar.extraNodes.size() == this.fields().size() && (unique = mq.areColumnsUnique(this.peek(), groupSet)) != null && unique.booleanValue()) {
                    return this.project(this.fields(groupSet));
                }
                Double maxRowCount = mq.getMaxRowCount(this.peek());
                if (maxRowCount != null && maxRowCount <= 1.0) {
                    return this.project(this.fields(groupSet));
                }
            }
        }
        if (groupKey_.nodeLists != null) {
            int sizeBefore = registrar.extraNodes.size();
            TreeSet<ImmutableBitSet> groupSetSet = new TreeSet<ImmutableBitSet>(ImmutableBitSet.ORDERING);
            for (ImmutableList immutableList : groupKey_.nodeLists) {
                ImmutableBitSet groupSet2 = ImmutableBitSet.of(registrar.registerExpressions(immutableList));
                if (!groupSet.contains(groupSet2)) {
                    throw new IllegalArgumentException("group set element " + immutableList + " must be a subset of group key");
                }
                groupSetSet.add(groupSet2);
            }
            groupSets = ImmutableList.copyOf(groupSetSet);
            if (registrar.extraNodes.size() > sizeBefore) {
                throw new IllegalArgumentException("group sets contained expressions not in group key: " + registrar.extraNodes.subList(sizeBefore, registrar.extraNodes.size()));
            }
        } else {
            groupSets = ImmutableList.of(groupSet);
        }
        for (AggCall aggCall : aggCalls) {
            if (!(aggCall instanceof AggCallImpl)) continue;
            AggCallImpl aggCall1 = (AggCallImpl)aggCall;
            registrar.registerExpressions(aggCall1.operands);
            if (aggCall1.filter == null) continue;
            registrar.registerExpression(aggCall1.filter);
        }
        this.project(registrar.extraNodes);
        this.rename(registrar.names);
        Frame frame = this.stack.pop();
        RelNode r = frame.rel;
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (AggCall aggCall : aggCalls) {
            if (aggCall instanceof AggCallImpl) {
                int filterArg;
                AggCallImpl aggCall1 = (AggCallImpl)aggCall;
                args = registrar.registerExpressions(aggCall1.operands);
                int n = filterArg = aggCall1.filter == null ? -1 : registrar.registerExpression(aggCall1.filter);
                if (aggCall1.distinct && !aggCall1.aggFunction.isQuantifierAllowed()) {
                    throw new IllegalArgumentException("DISTINCT not allowed");
                }
                if (aggCall1.filter != null && !aggCall1.aggFunction.allowsFilter()) {
                    throw new IllegalArgumentException("FILTER not allowed");
                }
                RelCollation collation = RelCollations.of(aggCall1.orderKeys.stream().map(orderKey -> RelBuilder.collation(orderKey, RelFieldCollation.Direction.ASCENDING, null, Collections.emptyList())).collect(Collectors.toList()));
                aggregateCall = AggregateCall.create(aggCall1.aggFunction, aggCall1.distinct, aggCall1.approximate, aggCall1.ignoreNulls, args, filterArg, collation, groupSet.cardinality(), r, null, aggCall1.alias);
            } else {
                aggregateCall = ((AggCallImpl2)aggCall).aggregateCall;
            }
            aggregateCalls.add((AggregateCall)aggregateCall);
        }
        assert (ImmutableBitSet.ORDERING.isStrictlyOrdered(groupSets)) : groupSets;
        for (ImmutableBitSet set : groupSets) {
            assert (groupSet.contains(set));
        }
        if (this.config.pruneInputOfAggregate() && r instanceof Project) {
            Set<Integer> set = RelOptUtil.getAllFields2(groupSet, aggregateCalls);
            if (set.isEmpty()) {
                r = ((Project)r).getInput();
            } else if (set.size() < r.getRowType().getFieldCount()) {
                HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
                aggregateCall = set.iterator();
                while (aggregateCall.hasNext()) {
                    int source = (Integer)aggregateCall.next();
                    map.put(source, map.size());
                }
                groupSet = groupSet.permute(map);
                groupSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute(groupSets, map));
                Mappings.TargetMapping targetMapping = Mappings.target(map, r.getRowType().getFieldCount(), set.size());
                ArrayList<AggregateCall> oldAggregateCalls = new ArrayList<AggregateCall>(aggregateCalls);
                aggregateCalls.clear();
                args = oldAggregateCalls.iterator();
                while (args.hasNext()) {
                    AggregateCall aggregateCall2 = (AggregateCall)args.next();
                    aggregateCalls.add(aggregateCall2.transform(targetMapping));
                }
                Project project = (Project)r;
                ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
                RelDataTypeFactory.FieldInfoBuilder builder = this.cluster.getTypeFactory().builder();
                for (int i2 : set) {
                    newProjects.add(project.getProjects().get(i2));
                    ((RelDataTypeFactory.Builder)builder).add(project.getRowType().getFieldList().get(i2));
                }
                r = project.copy(r.getTraitSet(), project.getInput(), newProjects, builder.build());
            }
        }
        if (!this.config.dedupAggregateCalls() || Util.isDistinct(aggregateCalls)) {
            return this.aggregate_(groupSet, groupSets, r, aggregateCalls, registrar.extraNodes, frame.fields);
        }
        HashSet<AggregateCall> hashSet = new HashSet<AggregateCall>();
        ArrayList<Pair<Integer, String>> projects = new ArrayList<Pair<Integer, String>>();
        Util.range(groupSet.cardinality()).forEach(i -> projects.add(Pair.of(i, null)));
        ArrayList<AggregateCall> distinctAggregateCalls = new ArrayList<AggregateCall>();
        for (AggregateCall aggregateCall3 : aggregateCalls) {
            int i2;
            if (hashSet.add(aggregateCall3)) {
                int i3 = distinctAggregateCalls.size();
                distinctAggregateCalls.add(aggregateCall3);
            } else {
                i2 = distinctAggregateCalls.indexOf(aggregateCall3);
                assert (i2 >= 0);
            }
            projects.add(Pair.of(groupSet.cardinality() + i2, aggregateCall3.name));
        }
        this.aggregate_(groupSet, groupSets, r, distinctAggregateCalls, registrar.extraNodes, frame.fields);
        List fields = projects.stream().map(p -> p.right == null ? this.field((Integer)p.left) : this.alias(this.field((Integer)p.left), (String)p.right)).collect(Collectors.toList());
        return this.project(fields);
    }

    private RelBuilder aggregate_(ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, RelNode input, List<AggregateCall> aggregateCalls, List<RexNode> extraNodes, ImmutableList<Field> inFields) {
        RelNode aggregate = this.struct.aggregateFactory.createAggregate(input, ImmutableList.of(), groupSet, groupSets, aggregateCalls);
        ImmutableList.Builder fields = ImmutableList.builder();
        List<RelDataTypeField> aggregateFields = aggregate.getRowType().getFieldList();
        int i = 0;
        for (Integer groupField : groupSet.asList()) {
            RexNode node = extraNodes.get(groupField);
            SqlKind kind = node.getKind();
            switch (kind) {
                case INPUT_REF: {
                    fields.add(inFields.get(((RexInputRef)node).getIndex()));
                    break;
                }
                default: {
                    String name = aggregateFields.get(i).getName();
                    RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(name, i, node.getType());
                    fields.add(new Field(ImmutableSet.of(), fieldType));
                }
            }
            ++i;
        }
        for (int j2 = 0; j2 < aggregateCalls.size(); ++j2) {
            AggregateCall call = aggregateCalls.get(j2);
            RelDataTypeFieldImpl fieldType = new RelDataTypeFieldImpl(aggregateFields.get(i + j2).getName(), i + j2, call.getType());
            fields.add(new Field(ImmutableSet.of(), fieldType));
        }
        this.stack.push(new Frame(aggregate, (ImmutableList)fields.build()));
        return this;
    }

    private RelBuilder setOp(boolean all, SqlKind kind, int n) {
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < n; ++i) {
            inputs.add(0, this.build());
        }
        switch (kind) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                if (n >= 1) break;
                throw new IllegalArgumentException("bad INTERSECT/UNION/EXCEPT input count");
            }
            default: {
                throw new AssertionError((Object)("bad setOp " + (Object)((Object)kind)));
            }
        }
        switch (n) {
            case 1: {
                return this.push((RelNode)inputs.get(0));
            }
        }
        return this.push(this.struct.setOpFactory.createSetOp(kind, inputs, all));
    }

    public RelBuilder union(boolean all) {
        return this.union(all, 2);
    }

    public RelBuilder union(boolean all, int n) {
        return this.setOp(all, SqlKind.UNION, n);
    }

    public RelBuilder intersect(boolean all) {
        return this.intersect(all, 2);
    }

    public RelBuilder intersect(boolean all, int n) {
        return this.setOp(all, SqlKind.INTERSECT, n);
    }

    public RelBuilder minus(boolean all) {
        return this.minus(all, 2);
    }

    public RelBuilder minus(boolean all, int n) {
        return this.setOp(all, SqlKind.EXCEPT, n);
    }

    public RelBuilder transientScan(String tableName) {
        return this.transientScan(tableName, this.peek().getRowType());
    }

    public RelBuilder transientScan(String tableName, RelDataType rowType) {
        ListTransientTable transientTable = new ListTransientTable(tableName, rowType);
        RelOptTableImpl relOptTable = RelOptTableImpl.create(this.relOptSchema, rowType, (Table)transientTable, ImmutableList.of(tableName));
        RelNode scan = this.struct.scanFactory.createScan(ViewExpanders.toRelContext(this.viewExpander, this.cluster), (RelOptTable)relOptTable);
        this.push(scan);
        this.rename(rowType.getFieldNames());
        return this;
    }

    private RelBuilder tableSpool(Spool.Type readType, Spool.Type writeType, RelOptTable table) {
        RelNode spool = this.struct.spoolFactory.createTableSpool(this.peek(), readType, writeType, table);
        this.replaceTop(spool);
        return this;
    }

    public RelBuilder repeatUnion(String tableName, boolean all) {
        return this.repeatUnion(tableName, all, -1);
    }

    public RelBuilder repeatUnion(String tableName, boolean all, int iterationLimit) {
        RelOptTableFinder finder = new RelOptTableFinder(tableName);
        for (int i = 0; i < this.stack.size(); ++i) {
            this.peek(i).accept(finder);
            if (finder.relOptTable != null) break;
        }
        if (finder.relOptTable == null) {
            throw Static.RESOURCE.tableNotFound(tableName).ex();
        }
        RelNode iterative = this.tableSpool(Spool.Type.LAZY, Spool.Type.LAZY, finder.relOptTable).build();
        RelNode seed = this.tableSpool(Spool.Type.LAZY, Spool.Type.LAZY, finder.relOptTable).build();
        RelNode repeatUnion = this.struct.repeatUnionFactory.createRepeatUnion(seed, iterative, all, iterationLimit);
        return this.push(repeatUnion);
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition0, RexNode ... conditions) {
        return this.join(joinType, Lists.asList(condition0, conditions));
    }

    public RelBuilder join(JoinRelType joinType, Iterable<? extends RexNode> conditions) {
        return this.join(joinType, this.and(conditions), ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition) {
        return this.join(joinType, condition, ImmutableSet.of());
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        RelNode join;
        Frame right = this.stack.pop();
        Frame left = this.stack.pop();
        boolean correlate = variablesSet.size() == 1;
        RexNode postCondition = this.literal(true);
        if (this.config.simplify()) {
            if (condition instanceof RexCall) {
                condition = RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)condition, this.getRexBuilder());
            }
            condition = this.simplifier.simplifyUnknownAsFalse(condition);
        }
        if (correlate) {
            CorrelationId id = Iterables.getOnlyElement(variablesSet);
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns(id, right.rel);
            if (!RelOptUtil.notContainsCorrelation(left.rel, id, Litmus.IGNORE)) {
                throw new IllegalArgumentException("variable " + id + " must not be used by left input to correlation");
            }
            switch (joinType) {
                case LEFT: {
                    this.stack.push(right);
                    this.filter(condition.accept(new Shifter(left.rel, id, right.rel)));
                    right = this.stack.pop();
                    break;
                }
                default: {
                    postCondition = condition;
                }
            }
            join = this.struct.correlateFactory.createCorrelate(left.rel, right.rel, id, requiredColumns, joinType);
        } else {
            join = this.struct.joinFactory.createJoin(left.rel, right.rel, ImmutableList.of(), condition, variablesSet, joinType, false);
        }
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(join, (ImmutableList)fields.build()));
        this.filter(postCondition);
        return this;
    }

    public RelBuilder correlate(JoinRelType joinType, CorrelationId correlationId, RexNode ... requiredFields) {
        return this.correlate(joinType, correlationId, ImmutableList.copyOf(requiredFields));
    }

    public RelBuilder correlate(JoinRelType joinType, CorrelationId correlationId, Iterable<? extends RexNode> requiredFields) {
        Frame right = this.stack.pop();
        Registrar registrar = new Registrar(this.fields(), this.peek().getRowType().getFieldNames());
        List<Integer> requiredOrdinals = registrar.registerExpressions(ImmutableList.copyOf(requiredFields));
        this.project(registrar.extraNodes);
        this.rename(registrar.names);
        Frame left = this.stack.pop();
        RelNode correlate = this.struct.correlateFactory.createCorrelate(left.rel, right.rel, correlationId, ImmutableBitSet.of(requiredOrdinals), joinType);
        ImmutableList.Builder fields = ImmutableList.builder();
        fields.addAll(left.fields);
        fields.addAll(right.fields);
        this.stack.push(new Frame(correlate, (ImmutableList)fields.build()));
        return this;
    }

    public RelBuilder join(JoinRelType joinType, String ... fieldNames) {
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        for (String fieldName : fieldNames) {
            conditions.add(this.call((SqlOperator)SqlStdOperatorTable.EQUALS, this.field(2, 0, fieldName), this.field(2, 1, fieldName)));
        }
        return this.join(joinType, conditions);
    }

    public RelBuilder semiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode semiJoin = this.struct.joinFactory.createJoin(this.peek(), right.rel, ImmutableList.of(), this.and(conditions), ImmutableSet.of(), JoinRelType.SEMI, false);
        this.replaceTop(semiJoin);
        return this;
    }

    public RelBuilder semiJoin(RexNode ... conditions) {
        return this.semiJoin(ImmutableList.copyOf(conditions));
    }

    public RelBuilder antiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        RelNode antiJoin = this.struct.joinFactory.createJoin(this.peek(), right.rel, ImmutableList.of(), this.and(conditions), ImmutableSet.of(), JoinRelType.ANTI, false);
        this.replaceTop(antiJoin);
        return this;
    }

    public RelBuilder antiJoin(RexNode ... conditions) {
        return this.antiJoin(ImmutableList.copyOf(conditions));
    }

    public RelBuilder as(String alias2) {
        Frame pair = this.stack.pop();
        List<Field> newFields = Util.transform(pair.fields, field -> field.addAlias(alias2));
        this.stack.push(new Frame(pair.rel, ImmutableList.copyOf(newFields)));
        return this;
    }

    public RelBuilder values(String[] fieldNames, Object ... values) {
        if (fieldNames == null || fieldNames.length == 0 || values.length % fieldNames.length != 0 || values.length < fieldNames.length) {
            throw new IllegalArgumentException("Value count must be a positive multiple of field count");
        }
        final int rowCount = values.length / fieldNames.length;
        for (Ord<String> fieldName : Ord.zip(fieldNames)) {
            if (!this.allNull(values, fieldName.i, fieldNames.length)) continue;
            throw new IllegalArgumentException("All values of field '" + (String)fieldName.e + "' are null; cannot deduce type");
        }
        final ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(fieldNames.length, values);
        RelDataTypeFactory typeFactory = this.cluster.getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        for (final Ord<String> fieldName : Ord.zip(fieldNames)) {
            String name = fieldName.e != null ? (String)fieldName.e : "expr$" + fieldName.i;
            RelDataType type = typeFactory.leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RexLiteral)((ImmutableList)tupleList.get(index)).get(fieldName.i)).getType();
                }

                @Override
                public int size() {
                    return rowCount;
                }
            });
            ((RelDataTypeFactory.Builder)builder).add(name, type);
        }
        RelDataType rowType = builder.build();
        return this.values(tupleList, rowType);
    }

    private ImmutableList<ImmutableList<RexLiteral>> tupleList(int columnCount, Object[] values) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ArrayList<RexLiteral> valueList = new ArrayList<RexLiteral>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            valueList.add((RexLiteral)this.literal(value));
            if ((i + 1) % columnCount != 0) continue;
            listBuilder.add(ImmutableList.copyOf(valueList));
            valueList.clear();
        }
        return listBuilder.build();
    }

    private boolean allNull(Object[] values, int column, int columnCount) {
        for (int i = column; i < values.length; i += columnCount) {
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }

    public RelBuilder empty() {
        Frame frame = this.stack.pop();
        RelNode values = this.struct.valuesFactory.createValues(this.cluster, frame.rel.getRowType(), ImmutableList.of());
        this.stack.push(new Frame(values, frame.fields));
        return this;
    }

    public RelBuilder values(RelDataType rowType, Object ... columnValues) {
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(rowType.getFieldCount(), columnValues);
        RelNode values = this.struct.valuesFactory.createValues(this.cluster, rowType, ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(Iterable<? extends List<RexLiteral>> tupleList, RelDataType rowType) {
        RelNode values = this.struct.valuesFactory.createValues(this.cluster, rowType, RelBuilder.copy(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder values(RelDataType rowType) {
        return this.values(ImmutableList.of(), rowType);
    }

    private static <E> ImmutableList<ImmutableList<E>> copy(Iterable<? extends List<E>> tupleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int changeCount = 0;
        for (List<E> literals : tupleList) {
            ImmutableList<E> literals2 = ImmutableList.copyOf(literals);
            builder.add(literals2);
            if (literals == literals2) continue;
            ++changeCount;
        }
        if (changeCount == 0) {
            return (ImmutableList)tupleList;
        }
        return builder.build();
    }

    public RelBuilder limit(int offset, int fetch) {
        return this.sortLimit(offset, fetch, ImmutableList.of());
    }

    public RelBuilder exchange(RelDistribution distribution) {
        RelNode exchange = this.struct.exchangeFactory.createExchange(this.peek(), distribution);
        this.replaceTop(exchange);
        return this;
    }

    public RelBuilder sortExchange(RelDistribution distribution, RelCollation collation) {
        RelNode exchange = this.struct.sortExchangeFactory.createSortExchange(this.peek(), distribution, collation);
        this.replaceTop(exchange);
        return this;
    }

    public RelBuilder sort(int ... fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int field : fields) {
            builder.add(field < 0 ? this.desc(this.field(-field - 1)) : this.field(field));
        }
        return this.sortLimit(-1, -1, builder.build());
    }

    public RelBuilder sort(RexNode ... nodes) {
        return this.sortLimit(-1, -1, ImmutableList.copyOf(nodes));
    }

    public RelBuilder sort(Iterable<? extends RexNode> nodes) {
        return this.sortLimit(-1, -1, nodes);
    }

    public RelBuilder sortLimit(int offset, int fetch, RexNode ... nodes) {
        return this.sortLimit(offset, fetch, ImmutableList.copyOf(nodes));
    }

    public RelBuilder sortLimit(int offset, int fetch, Iterable<? extends RexNode> nodes) {
        RexNode fetchNode;
        Registrar registrar = new Registrar(this.fields());
        List<RelFieldCollation> fieldCollations = registrar.registerFieldCollations(nodes);
        RexNode offsetNode = offset <= 0 ? null : this.literal(offset);
        RexNode rexNode = fetchNode = fetch < 0 ? null : this.literal(fetch);
        if (offsetNode == null && fetch == 0) {
            return this.empty();
        }
        if (offsetNode == null && fetchNode == null && fieldCollations.isEmpty()) {
            return this;
        }
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (registrar.addedFieldCount() == 0);
            RelNode top = this.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    this.replaceTop(sort2.getInput());
                    RelNode sort = this.struct.sortFactory.createSort(this.peek(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop(sort);
                    return this;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    RelNode sort = this.struct.sortFactory.createSort(sort2.getInput(), sort2.collation, offsetNode, fetchNode);
                    this.replaceTop(this.struct.projectFactory.createProject(sort, project.getHints(), project.getProjects(), Pair.right(project.getNamedProjects())));
                    return this;
                }
            }
        }
        if (registrar.addedFieldCount() > 0) {
            this.project(registrar.extraNodes);
        }
        RelNode sort = this.struct.sortFactory.createSort(this.peek(), RelCollations.of(fieldCollations), offsetNode, fetchNode);
        this.replaceTop(sort);
        if (registrar.addedFieldCount() > 0) {
            this.project(registrar.originalExtraNodes);
        }
        return this;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, Util.first(nullDirection, direction.defaultNullDirection()));
            }
            case DESCENDING: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, Util.first(nullDirection, direction.defaultNullDirection()));
    }

    public RelBuilder convert(RelDataType castRowType, boolean rename) {
        RelNode r = this.build();
        RelNode r2 = RelOptUtil.createCastRel(r, castRowType, rename, this.struct.projectFactory);
        this.push(r2);
        return this;
    }

    public RelBuilder permute(Mapping mapping) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return this;
        }
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            exprList.add(this.field(mapping.getSource(i)));
        }
        return this.project(exprList);
    }

    public RelBuilder match(RexNode pattern, boolean strictStart, boolean strictEnd, Map<String, RexNode> patternDefinitions, Iterable<? extends RexNode> measureList, RexNode after, Map<String, ? extends SortedSet<String>> subsets, boolean allRows, Iterable<? extends RexNode> partitionKeys, Iterable<? extends RexNode> orderKeys, RexNode interval) {
        Registrar registrar = new Registrar(this.fields(), this.peek().getRowType().getFieldNames());
        List<RelFieldCollation> fieldCollations = registrar.registerFieldCollations(orderKeys);
        ImmutableBitSet partitionBitSet = ImmutableBitSet.of(registrar.registerExpressions(partitionKeys));
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = this.cluster.getTypeFactory().builder();
        for (RexNode rexNode : partitionKeys) {
            ((RelDataTypeFactory.Builder)typeBuilder).add(rexNode.toString(), rexNode.getType());
        }
        if (allRows) {
            for (RexNode rexNode : orderKeys) {
                if (typeBuilder.nameExists(rexNode.toString())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(rexNode.toString(), rexNode.getType());
            }
            RelDataType inputRowType = this.peek().getRowType();
            for (RelDataTypeField relDataTypeField : inputRowType.getFieldList()) {
                if (typeBuilder.nameExists(relDataTypeField.getName())) continue;
                ((RelDataTypeFactory.Builder)typeBuilder).add(relDataTypeField);
            }
        }
        ImmutableMap.Builder<String, RexNode> measures = ImmutableMap.builder();
        for (RexNode rexNode : measureList) {
            List<RexNode> operands = ((RexCall)rexNode).getOperands();
            String alias2 = operands.get(1).toString();
            ((RelDataTypeFactory.Builder)typeBuilder).add(alias2, operands.get(0).getType());
            measures.put(alias2, operands.get(0));
        }
        RelNode relNode = this.struct.matchFactory.createMatch(this.peek(), pattern, typeBuilder.build(), strictStart, strictEnd, patternDefinitions, measures.build(), after, subsets, allRows, partitionBitSet, RelCollations.of(fieldCollations), interval);
        this.stack.push(new Frame(relNode));
        return this;
    }

    public RelBuilder hints(RelHint ... hints) {
        return this.hints(ImmutableList.copyOf(hints));
    }

    public RelBuilder hints(Iterable<RelHint> hints) {
        Objects.requireNonNull(hints);
        Frame frame = this.peek_();
        assert (frame != null) : "There is no relational expression to attach the hints";
        assert (frame.rel instanceof Hintable) : "The top relational expression is not a Hintable";
        Hintable hintable = (Hintable)((Object)frame.rel);
        this.replaceTop(hintable.attachHints(ImmutableList.copyOf(hints)));
        return this;
    }

    public void clear() {
        this.stack.clear();
    }

    @Deprecated
    public static class ConfigBuilder {
        private Config config;

        private ConfigBuilder(@Nonnull Config config) {
            this.config = config;
        }

        public Config build() {
            return this.config;
        }

        public ConfigBuilder withDedupAggregateCalls(boolean dedupAggregateCalls) {
            this.config = this.config.withDedupAggregateCalls(dedupAggregateCalls);
            return this;
        }

        public ConfigBuilder withSimplify(boolean simplify) {
            this.config = this.config.withSimplify(simplify);
            return this;
        }
    }

    public static interface Config {
        public static final Config DEFAULT = ImmutableBeans.create(Config.class);

        @Deprecated
        public static ConfigBuilder builder() {
            return DEFAULT.toBuilder();
        }

        @Deprecated
        default public ConfigBuilder toBuilder() {
            return new ConfigBuilder(this);
        }

        @ImmutableBeans.Property
        @ImmutableBeans.IntDefault(value=100)
        public int bloat();

        public Config withBloat(int var1);

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=true)
        public boolean dedupAggregateCalls();

        public Config withDedupAggregateCalls(boolean var1);

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=true)
        public boolean pruneInputOfAggregate();

        public Config withPruneInputOfAggregate(boolean var1);

        @ImmutableBeans.Property
        @ImmutableBeans.BooleanDefault(value=true)
        public boolean simplify();

        public Config withSimplify(boolean var1);
    }

    private class Shifter
    extends RexShuttle {
        private final RelNode left;
        private final CorrelationId id;
        private final RelNode right;

        Shifter(RelNode left, CorrelationId id, RelNode right) {
            this.left = left;
            this.id = id;
            this.right = right;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType leftRowType = this.left.getRowType();
            RexBuilder rexBuilder = RelBuilder.this.getRexBuilder();
            int leftCount = leftRowType.getFieldCount();
            if (inputRef.getIndex() < leftCount) {
                RexNode v = rexBuilder.makeCorrel(leftRowType, this.id);
                return rexBuilder.makeFieldAccess(v, inputRef.getIndex());
            }
            return rexBuilder.makeInputRef(this.right, inputRef.getIndex() - leftCount);
        }
    }

    private static class Field
    extends Pair<ImmutableSet<String>, RelDataTypeField> {
        Field(ImmutableSet<String> left, RelDataTypeField right) {
            super(left, right);
        }

        Field addAlias(String alias2) {
            if (((ImmutableSet)this.left).contains(alias2)) {
                return this;
            }
            ImmutableCollection aliasList = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)this.left)).add(alias2)).build();
            return new Field((ImmutableSet<String>)aliasList, (RelDataTypeField)this.right);
        }
    }

    private static class Frame {
        final RelNode rel;
        final ImmutableList<Field> fields;

        private Frame(RelNode rel, ImmutableList<Field> fields) {
            this.rel = rel;
            this.fields = fields;
        }

        private Frame(RelNode rel) {
            String tableAlias = Frame.deriveAlias(rel);
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableSet<String> aliases = tableAlias == null ? ImmutableSet.of() : ImmutableSet.of(tableAlias);
            for (RelDataTypeField field : rel.getRowType().getFieldList()) {
                builder.add(new Field(aliases, field));
            }
            this.rel = rel;
            this.fields = builder.build();
        }

        private static String deriveAlias(RelNode rel) {
            List<String> names;
            if (rel instanceof TableScan && !(names = rel.getTable().getQualifiedName()).isEmpty()) {
                return Util.last(names);
            }
            return null;
        }

        List<RelDataTypeField> fields() {
            return Pair.right(this.fields);
        }
    }

    private static class Registrar {
        final List<RexNode> originalExtraNodes;
        final List<RexNode> extraNodes;
        final List<String> names = new ArrayList<String>();

        Registrar(Iterable<RexNode> fields) {
            this(fields, ImmutableList.of());
        }

        Registrar(Iterable<RexNode> fields, List<String> fieldNames) {
            this.originalExtraNodes = ImmutableList.copyOf(fields);
            this.extraNodes = new ArrayList<RexNode>(this.originalExtraNodes);
            this.names.addAll(fieldNames);
        }

        int registerExpression(RexNode node) {
            switch (node.getKind()) {
                case AS: {
                    ImmutableList<RexNode> operands = ((RexCall)node).operands;
                    int i = this.registerExpression((RexNode)operands.get(0));
                    this.names.set(i, RexLiteral.stringValue((RexNode)operands.get(1)));
                    return i;
                }
            }
            int i = this.extraNodes.indexOf(node);
            if (i < 0) {
                i = this.extraNodes.size();
                this.extraNodes.add(node);
                this.names.add(null);
            }
            return i;
        }

        List<Integer> registerExpressions(Iterable<? extends RexNode> nodes) {
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (RexNode rexNode : nodes) {
                builder.add(this.registerExpression(rexNode));
            }
            return builder;
        }

        List<RelFieldCollation> registerFieldCollations(Iterable<? extends RexNode> orderKeys) {
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
            for (RexNode rexNode : orderKeys) {
                RelFieldCollation collation = RelBuilder.collation(rexNode, RelFieldCollation.Direction.ASCENDING, null, this.extraNodes);
                if (RelCollations.ordinals(fieldCollations).contains(collation.getFieldIndex())) continue;
                fieldCollations.add(collation);
            }
            return ImmutableList.copyOf(fieldCollations);
        }

        int addedFieldCount() {
            return this.extraNodes.size() - this.originalExtraNodes.size();
        }
    }

    private static class AggCallImpl2
    implements AggCall {
        private final AggregateCall aggregateCall;

        AggCallImpl2(AggregateCall aggregateCall) {
            this.aggregateCall = Objects.requireNonNull(aggregateCall);
        }

        public String toString() {
            return this.aggregateCall.toString();
        }

        @Override
        public AggCall sort(Iterable<RexNode> orderKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall sort(RexNode ... orderKeys) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall approximate(boolean approximate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall filter(RexNode condition) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall as(String alias2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall distinct(boolean distinct) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall distinct() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AggCall ignoreNulls(boolean ignoreNulls) {
            throw new UnsupportedOperationException();
        }
    }

    private class AggCallImpl
    implements AggCall {
        private final SqlAggFunction aggFunction;
        private final boolean distinct;
        private final boolean approximate;
        private final boolean ignoreNulls;
        private final RexNode filter;
        private final String alias;
        private final ImmutableList<RexNode> operands;
        private final ImmutableList<RexNode> orderKeys;

        AggCallImpl(SqlAggFunction aggFunction, boolean distinct, boolean approximate, boolean ignoreNulls, RexNode filter, String alias2, ImmutableList<RexNode> operands, ImmutableList<RexNode> orderKeys) {
            this.aggFunction = Objects.requireNonNull(aggFunction);
            this.distinct = distinct && aggFunction.getDistinctOptionality() != Optionality.IGNORED;
            this.approximate = approximate;
            this.ignoreNulls = ignoreNulls;
            this.alias = alias2;
            this.operands = Objects.requireNonNull(operands);
            this.orderKeys = Objects.requireNonNull(orderKeys);
            if (filter != null) {
                if (filter.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                    throw Static.RESOURCE.filterMustBeBoolean().ex();
                }
                if (filter.getType().isNullable()) {
                    filter = RelBuilder.this.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, filter);
                }
            }
            this.filter = filter;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append(this.aggFunction.getName()).append('(');
            if (this.distinct) {
                b.append("DISTINCT ");
            }
            int iMax = this.operands.size() - 1;
            int i = 0;
            while (true) {
                b.append(this.operands.get(i));
                if (i == iMax) break;
                b.append(", ");
                ++i;
            }
            b.append(')');
            if (this.filter != null) {
                b.append(" FILTER (WHERE ").append(this.filter).append(')');
            }
            return b.toString();
        }

        @Override
        public AggCall sort(Iterable<RexNode> orderKeys) {
            ImmutableList<RexNode> orderKeyList = ImmutableList.copyOf(orderKeys);
            return orderKeyList.equals(this.orderKeys) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.operands, orderKeyList);
        }

        @Override
        public AggCall sort(RexNode ... orderKeys) {
            return this.sort(ImmutableList.copyOf(orderKeys));
        }

        @Override
        public AggCall approximate(boolean approximate) {
            return approximate == this.approximate ? this : new AggCallImpl(this.aggFunction, this.distinct, approximate, this.ignoreNulls, this.filter, this.alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall filter(RexNode condition) {
            return Objects.equals(condition, this.filter) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, condition, this.alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall as(String alias2) {
            return Objects.equals(alias2, this.alias) ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, this.ignoreNulls, this.filter, alias2, this.operands, this.orderKeys);
        }

        @Override
        public AggCall distinct(boolean distinct) {
            return distinct == this.distinct ? this : new AggCallImpl(this.aggFunction, distinct, this.approximate, this.ignoreNulls, this.filter, this.alias, this.operands, this.orderKeys);
        }

        @Override
        public AggCall distinct() {
            return this.distinct(true);
        }

        @Override
        public AggCall ignoreNulls(boolean ignoreNulls) {
            return ignoreNulls == this.ignoreNulls ? this : new AggCallImpl(this.aggFunction, this.distinct, this.approximate, ignoreNulls, this.filter, this.alias, this.operands, this.orderKeys);
        }
    }

    public static class GroupKeyImpl
    implements GroupKey {
        public final ImmutableList<RexNode> nodes;
        public final ImmutableList<ImmutableList<RexNode>> nodeLists;
        public final String alias;

        GroupKeyImpl(ImmutableList<RexNode> nodes, ImmutableList<ImmutableList<RexNode>> nodeLists, String alias2) {
            this.nodes = Objects.requireNonNull(nodes);
            this.nodeLists = nodeLists;
            this.alias = alias2;
        }

        public String toString() {
            return this.alias == null ? this.nodes.toString() : this.nodes + " as " + this.alias;
        }

        @Override
        public GroupKey alias(String alias2) {
            return Objects.equals(this.alias, alias2) ? this : new GroupKeyImpl(this.nodes, this.nodeLists, alias2);
        }
    }

    public static interface GroupKey {
        public GroupKey alias(String var1);
    }

    public static interface AggCall {
        public AggCall filter(RexNode var1);

        public AggCall sort(Iterable<RexNode> var1);

        public AggCall sort(RexNode ... var1);

        public AggCall approximate(boolean var1);

        public AggCall ignoreNulls(boolean var1);

        public AggCall as(String var1);

        public AggCall distinct(boolean var1);

        public AggCall distinct();
    }

    private static final class RelOptTableFinder
    extends RelHomogeneousShuttle {
        private RelOptTable relOptTable = null;
        private final String tableName;

        private RelOptTableFinder(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public RelNode visit(TableScan scan) {
            RelOptTable scanTable = scan.getTable();
            List<String> qualifiedName = scanTable.getQualifiedName();
            if (qualifiedName.get(qualifiedName.size() - 1).equals(this.tableName)) {
                this.relOptTable = scanTable;
            }
            return super.visit(scan);
        }
    }
}

