/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.io.DiscardingOutputFormat;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.Operator;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.utils.PlanGenerator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.DetachedJobExecutionResult;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.BatchTableEnvImpl$$anonfun$checkNoTimeAttributes$1$;
import org.apache.flink.table.api.internal.Registration;
import org.apache.flink.table.api.internal.TableEnvImpl;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.descriptors.BatchTableDescriptor;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DataSetQueryOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.plan.BatchOptimizer;
import org.apache.flink.table.plan.nodes.LogicalSink;
import org.apache.flink.table.plan.nodes.LogicalSink$;
import org.apache.flink.table.plan.nodes.dataset.DataSetRel;
import org.apache.flink.table.planner.Conversions$;
import org.apache.flink.table.runtime.MapRunner;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.OutputFormatTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.InputFormatTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.table.util.DummyNoOpOperator;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=f!B\u0001\u0003\u0003\u0003y!!\u0005\"bi\u000eDG+\u00192mK\u0016sg/S7qY*\u00111\u0001B\u0001\tS:$XM\u001d8bY*\u0011QAB\u0001\u0004CBL'BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0019Q\u000b'\r\\3F]ZLU\u000e\u001d7\t\u0013U\u0001!Q1A\u0005\u0002!1\u0012aB3yK\u000e,eN^\u000b\u0002/A\u0011\u0001\u0004H\u0007\u00023)\u0011!dG\u0001\u0005U\u00064\u0018M\u0003\u0002\u0006\u0011%\u0011Q$\u0007\u0002\u0015\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;\t\u0011}\u0001!\u0011!Q\u0001\n]\t\u0001\"\u001a=fG\u0016sg\u000f\t\u0005\nC\u0001\u0011\t\u0011)A\u0005E\u0019\naaY8oM&<\u0007CA\u0012%\u001b\u0005!\u0011BA\u0013\u0005\u0005-!\u0016M\u00197f\u0007>tg-[4\n\u0005\u0005\u0012\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\u001d\r\fG/\u00197pO6\u000bg.Y4feB\u0011!&L\u0007\u0002W)\u0011AFB\u0001\bG\u0006$\u0018\r\\8h\u0013\tq3F\u0001\bDCR\fGn\\4NC:\fw-\u001a:\t\u0011A\u0002!\u0011!Q\u0001\nE\nQ\"\\8ek2,W*\u00198bO\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0007\u0003\u0019iw\u000eZ;mK&\u0011ag\r\u0002\u000e\u001b>$W\u000f\\3NC:\fw-\u001a:\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0015Q4\bP\u001f?!\t\t\u0002\u0001C\u0003\u0016o\u0001\u0007q\u0003C\u0003\"o\u0001\u0007!\u0005C\u0003)o\u0001\u0007\u0011\u0006C\u00031o\u0001\u0007\u0011\u0007C\u0004A\u0001\t\u0007I\u0011B!\u00021\t,hMZ3sK\u0012lu\u000eZ5gs>\u0003XM]1uS>t7/F\u0001C!\r\u0019u)S\u0007\u0002\t*\u0011QIR\u0001\u0005kRLGNC\u0001\u001b\u0013\tAEIA\u0005BeJ\f\u0017\u0010T5tiB\u0011!*T\u0007\u0002\u0017*\u0011AJB\u0001\u000b_B,'/\u0019;j_:\u001c\u0018B\u0001(L\u0005=iu\u000eZ5gs>\u0003XM]1uS>t\u0007B\u0002)\u0001A\u0003%!)A\rck\u001a4WM]3e\u001b>$\u0017NZ=Pa\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003*\u0001\u0005\u0004%\t\u0001C*\u0002\u0013=\u0004H/[7ju\u0016\u0014X#\u0001+\u0011\u0005UCV\"\u0001,\u000b\u0005]3\u0011\u0001\u00029mC:L!!\u0017,\u0003\u001d\t\u000bGo\u00195PaRLW.\u001b>fe\"11\f\u0001Q\u0001\nQ\u000b!b\u001c9uS6L'0\u001a:!\u0011\u001di\u0006A1A\u0005\ny\u000bAB]3hSN$(/\u0019;j_:,\u0012a\u0018\n\u0004A\u0012Tg\u0001B1c\u0001}\u0013A\u0002\u0010:fM&tW-\\3oizBaa\u0019\u0001!\u0002\u0013y\u0016!\u0004:fO&\u001cHO]1uS>t\u0007\u0005\u0005\u0002fQ6\taM\u0003\u0002h\r\u0006!A.\u00198h\u0013\tIgM\u0001\u0004PE*,7\r\u001e\t\u0003#-L!\u0001\u001c\u0002\u0003\u0019I+w-[:ue\u0006$\u0018n\u001c8\t\u000b9\u0004A\u0011K8\u0002'Y\fG.\u001b3bi\u0016$\u0016M\u00197f'>,(oY3\u0015\u0005A4\bCA9u\u001b\u0005\u0011(\"A:\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0014(\u0001B+oSRDQa^7A\u0002a\f1\u0002^1cY\u0016\u001cv.\u001e:dKB\u001a\u00110a\u0001\u0011\u0007ilx0D\u0001|\u0015\tah!A\u0004t_V\u00148-Z:\n\u0005y\\(a\u0003+bE2,7k\\;sG\u0016\u0004B!!\u0001\u0002\u00041\u0001AaCA\u0003m\u0006\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00132#\u0011\tI!a\u0004\u0011\u0007E\fY!C\u0002\u0002\u000eI\u0014qAT8uQ&tw\rE\u0002r\u0003#I1!a\u0005s\u0005\r\te.\u001f\u0005\b\u0003/\u0001A\u0011KA\r\u0003E1\u0018\r\\5eCR,G+\u00192mKNKgn\u001b\u000b\u0004a\u0006m\u0001\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u001d\r|gNZ5hkJ,GmU5oWB\"\u0011\u0011EA\u0018!\u0019\t\u0019#!\u000b\u0002.5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0011!B:j].\u001c\u0018\u0002BA\u0016\u0003K\u0011\u0011\u0002V1cY\u0016\u001c\u0016N\\6\u0011\t\u0005\u0005\u0011q\u0006\u0003\r\u0003c\tY\"!A\u0001\u0002\u000b\u0005\u0011q\u0001\u0002\u0004?\u0012\"\u0004bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\bG>tg.Z2u)\u0011\tI$!\u0012\u0011\t\u0005m\u0012\u0011I\u0007\u0003\u0003{Q1!a\u0010\u0007\u0003-!Wm]2sSB$xN]:\n\t\u0005\r\u0013Q\b\u0002\u0015\u0005\u0006$8\r\u001b+bE2,G)Z:de&\u0004Ho\u001c:\t\u0011\u0005\u001d\u00131\u0007a\u0001\u0003\u0013\n1cY8o]\u0016\u001cGo\u001c:EKN\u001c'/\u001b9u_J\u0004B!a\u000f\u0002L%!\u0011QJA\u001f\u0005M\u0019uN\u001c8fGR|'\u000fR3tGJL\u0007\u000f^8s\u0011\u001d\t\t\u0006\u0001C)\u0003'\nqc\u001e:ji\u0016$vnU5oW\u0006sG\r\u0016:b]Nd\u0017\r^3\u0016\t\u0005U\u0013Q\u0010\u000b\u0007\u0003/\nY'!\u001e1\t\u0005e\u0013q\r\t\u0007\u00037\n\t'!\u001a\u000e\u0005\u0005u#bAA03\u0005Iq\u000e]3sCR|'o]\u0005\u0005\u0003G\niF\u0001\u0005ECR\f7+\u001b8l!\u0011\t\t!a\u001a\u0005\u0019\u0005%\u0014qJA\u0001\u0002\u0003\u0015\t!a\u0002\u0003\u0007}#s\u0007\u0003\u0005\u0002n\u0005=\u0003\u0019AA8\u00039\tX/\u001a:z\u001fB,'/\u0019;j_:\u00042ASA9\u0013\r\t\u0019h\u0013\u0002\u000f#V,'/_(qKJ\fG/[8o\u0011!\t9(a\u0014A\u0002\u0005e\u0014!\u0003;bE2,7+\u001b8l!\u0019\t\u0019#!\u000b\u0002|A!\u0011\u0011AA?\t!\ty(a\u0014C\u0002\u0005\u001d!!\u0001+\t\u000f\u0005\r\u0005\u0001\"\u0015\u0002\u0006\u0006Y\u0011\r\u001a3U_\n+hMZ3s+\u0011\t9)!$\u0015\u0007A\fI\tC\u0004\u0002\f\u0006\u0005\u0005\u0019A%\u0002\u001f5|G-\u001b4z\u001fB,'/\u0019;j_:$\u0001\"a \u0002\u0002\n\u0007\u0011q\u0001\u0005\b\u0003#\u0003A\u0011BAJ\u0003M9W\r^\"p]Z,'o]5p]6\u000b\u0007\u000f]3s+\u0019\t)*a,\u00026RQ\u0011qSA]\u0003\u0013\f\u0019.!7\u0011\u000bE\fI*!(\n\u0007\u0005m%O\u0001\u0004PaRLwN\u001c\t\t\u0003?\u000bI+!,\u000246\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0005gk:\u001cG/[8og*\u0019\u0011qU\u000e\u0002\r\r|W.\\8o\u0013\u0011\tY+!)\u0003\u00175\u000b\u0007OR;oGRLwN\u001c\t\u0005\u0003\u0003\ty\u000b\u0002\u0005\u00022\u0006=%\u0019AA\u0004\u0005\tIe\n\u0005\u0003\u0002\u0002\u0005UF\u0001CA\\\u0003\u001f\u0013\r!a\u0002\u0003\u0007=+F\u000b\u0003\u0005\u0002<\u0006=\u0005\u0019AA_\u0003A\u0001\b._:jG\u0006dG+\u001f9f\u0013:4w\u000e\u0005\u0004\u0002@\u0006\u0015\u0017QV\u0007\u0003\u0003\u0003TA!a1\u0002&\u0006AA/\u001f9fS:4w.\u0003\u0003\u0002H\u0006\u0005'a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\u0011\u0005-\u0017q\u0012a\u0001\u0003\u001b\faa]2iK6\f\u0007cA\u0012\u0002P&\u0019\u0011\u0011\u001b\u0003\u0003\u0017Q\u000b'\r\\3TG\",W.\u0019\u0005\t\u0003+\fy\t1\u0001\u0002X\u0006\t\"/Z9vKN$X\r\u001a+za\u0016LeNZ8\u0011\r\u0005}\u0016QYAZ\u0011!\tY.a$A\u0002\u0005u\u0017\u0001\u00044v]\u000e$\u0018n\u001c8OC6,\u0007\u0003BAp\u0003Kt1!]Aq\u0013\r\t\u0019O]\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r(\u000f\u0003\u0005\u0002n\u0002!\t\u0001CAx\u0003\u001d)\u0007\u0010\u001d7bS:$b!!8\u0002r\u0006e\bbB\u0004\u0002l\u0002\u0007\u00111\u001f\t\u0004G\u0005U\u0018bAA|\t\t)A+\u00192mK\"A\u00111`Av\u0001\u0004\ti0\u0001\u0005fqR,g\u000eZ3e!\r\t\u0018q`\u0005\u0004\u0005\u0003\u0011(a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003[\u0004A\u0011\tB\u0003)\u0011\tiNa\u0002\t\u000f\u001d\u0011\u0019\u00011\u0001\u0002t\"9\u0011Q\u001e\u0001\u0005B\t-A\u0003BAo\u0005\u001bA\u0001\"a?\u0003\n\u0001\u0007\u0011Q \u0005\b\u0005#\u0001A\u0011\u000bB\n\u0003=)\u0007\u0010\u001d7bS:Le\u000e^3s]\u0006dGCBAo\u0005+\u0011\u0019\u0003C\u0004M\u0005\u001f\u0001\rAa\u0006\u0011\u000b\r\u0013IB!\b\n\u0007\tmAI\u0001\u0003MSN$\bc\u0001&\u0003 %\u0019!\u0011E&\u0003\u0013=\u0003XM]1uS>t\u0007\u0002\u0003B\u0013\u0005\u001f\u0001\rAa\n\u0002\u0019\u0015DHO]1EKR\f\u0017\u000e\\:\u0011\u000bE\u0014IC!\f\n\u0007\t-\"O\u0001\u0006=e\u0016\u0004X-\u0019;fIz\u00022a\tB\u0018\u0013\r\u0011\t\u0004\u0002\u0002\u000e\u000bb\u0004H.Y5o\t\u0016$\u0018-\u001b7\t\u000f\tU\u0002\u0001\"\u0011\u00038\u00059Q\r_3dkR,G\u0003\u0002B\u001d\u0005\u0003\u0002BAa\u000f\u0003>5\u0011\u0011QU\u0005\u0005\u0005\u007f\t)K\u0001\nK_\n,\u00050Z2vi&|gNU3tk2$\b\u0002\u0003B\"\u0005g\u0001\r!!8\u0002\u000f)|'MT1nK\"9!Q\u0007\u0001\u0005\u0012\t\u001dCC\u0002B%\u00053\u0012I\u0007\u0005\u0003\u0003L\tUSB\u0001B'\u0015\u0011\u0011yE!\u0015\u0002\u0013\u0015DXmY;uS>t'b\u0001B*\u0011\u0005!1m\u001c:f\u0013\u0011\u00119F!\u0014\u0003\u0013){'m\u00117jK:$\b\u0002\u0003B.\u0005\u000b\u0002\rA!\u0018\u0002\u0013\u0011\fG/Y*j].\u001c\b#B\"\u0003\u001a\t}\u0003\u0007\u0002B1\u0005K\u0002b!a\u0017\u0002b\t\r\u0004\u0003BA\u0001\u0005K\"ABa\u001a\u0003Z\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u00111a\u0018\u00139\u0011!\u0011\u0019E!\u0012A\u0002\u0005u\u0007b\u0002B7\u0001\u0011%!qN\u0001\u0010Kb,7-\u001e;f!&\u0004X\r\\5oKR!!\u0011\nB9\u0011\u001d9&1\u000ea\u0001\u0005g\u0002BA!\u001e\u0003|5\u0011!q\u000f\u0006\u0004\u0005sZ\u0012a\u00013bO&!!Q\u0010B<\u0005!\u0001\u0016\u000e]3mS:,\u0007b\u0002BA\u0001\u0011\u0005!1Q\u0001\fO\u0016$\b+\u001b9fY&tW\r\u0006\u0003\u0003t\t\u0015\u0005\u0002\u0003B\"\u0005\u007f\u0002\r!!8\t\u000f\t%\u0005\u0001\"\u0003\u0003\f\u0006a2M]3bi\u0016\u0004\u0016\u000e]3mS:,\u0017I\u001c3DY\u0016\f'OQ;gM\u0016\u0014H\u0003\u0002B:\u0005\u001bC\u0001Ba\u0011\u0003\b\u0002\u0007\u0011Q\u001c\u0005\b\u0005#\u0003A\u0011\u0002BJ\u00039\u0019'/Z1uKBK\u0007/\u001a7j]\u0016$bAa\u001d\u0003\u0016\n\r\u0006\u0002CA\u0014\u0005\u001f\u0003\rAa&\u0011\u000b\r\u0013IB!'1\t\tm%q\u0014\t\u0007\u00037\n\tG!(\u0011\t\u0005\u0005!q\u0014\u0003\r\u0005C\u0013)*!A\u0001\u0002\u000b\u0005\u0011q\u0001\u0002\u0004?\u0012J\u0004\u0002\u0003B\"\u0005\u001f\u0003\r!!8\t\u000f\t\u001d\u0006\u0001\"\u0005\u0003*\u0006\u0001\u0012m])vKJLx\n]3sCRLwN\\\u000b\u0005\u0005W\u0013)\f\u0006\u0004\u0003.\n]&\u0011\u0019\t\u0006\u0015\n=&1W\u0005\u0004\u0005c[%!\u0006#bi\u0006\u001cV\r^)vKJLx\n]3sCRLwN\u001c\t\u0005\u0003\u0003\u0011)\f\u0002\u0005\u0002\u0000\t\u0015&\u0019AA\u0004\u0011!\u0011IL!*A\u0002\tm\u0016a\u00023bi\u0006\u001cV\r\u001e\t\u00061\tu&1W\u0005\u0004\u0005\u007fK\"a\u0002#bi\u0006\u001cV\r\u001e\u0005\t\u0005\u0007\u0014)\u000b1\u0001\u0003F\u00061a-[3mIN\u0004R!]AM\u0005\u000f\u0004R!\u001dBe\u0005\u001bL1Aa3s\u0005\u0015\t%O]1z!\u0011\u0011yM!6\u000e\u0005\tE'b\u0001Bj\r\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u00119N!5\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0003\\\u0002!IA!8\u0002+\rDWmY6O_RKW.Z!uiJL'-\u001e;fgV!!q\u001cBs)\r\u0001(\u0011\u001d\u0005\t\u0005G\u0014I\u000e1\u0001\u0003H\u0006\ta\r\u0002\u0005\u0002\u0000\te'\u0019AA\u0004\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005W\fa\u0002\u001e:b]Nd\u0017\r^3U_J+G\u000e\u0006\u0004\u0003n\nu(q \t\u0005\u0005_\u0014I0\u0004\u0002\u0003r*!!1\u001fB{\u0003\r\u0011X\r\u001c\u0006\u0004\u0005oT\u0011aB2bY\u000eLG/Z\u0005\u0005\u0005w\u0014\tPA\u0004SK2tu\u000eZ3\t\u000f\u0005-%q\u001da\u0001\u0013\"A1\u0011\u0001Bt\u0001\u0004\ti0\u0001\bbI\u0012dunZ5dC2\u001c\u0016N\\6\t\u000f\r\u0015\u0001\u0001\"\u0003\u0004\b\u0005IAO]1og2\fG/Z\u000b\u0005\u0007\u0013\u0019i\u0002\u0006\u0003\u0004\f\r]\u0001#B\"\u0003\u001a\r5\u0001\u0007BB\b\u0007'\u0001b!a\u0017\u0002b\rE\u0001\u0003BA\u0001\u0007'!Ab!\u0006\u0004\u0004\u0005\u0005\t\u0011!B\u0001\u0003\u000f\u0011Aa\u0018\u00132a!A1\u0011DB\u0002\u0001\u0004\u0019Y\"\u0001\tn_\u0012Lg-_(qKJ\fG/[8ogB!1I!\u0007J\t!\tyha\u0001C\u0002\u0005\u001d\u0001bBB\u0003\u0001\u0011%1\u0011E\u000b\u0005\u0007G\u0019i\u0004\u0006\u0006\u0004&\r=21GB\u001c\u0007\u007f\u0001Daa\n\u0004,A1\u00111LA1\u0007S\u0001B!!\u0001\u0004,\u0011a1QFB\u0010\u0003\u0003\u0005\tQ!\u0001\u0002\b\t!q\fJ\u00192\u0011\u001d\u0019\tda\bA\u0002i\nQBY1uG\"$\u0016M\u00197f\u000b:4\b\u0002CB\u001b\u0007?\u0001\rA!<\u0002\u001b=\u0004H/[7ju\u0016$gj\u001c3f\u0011!\t9ha\bA\u0002\re\u0002CBA\u0012\u0003S\u0019Y\u0004\u0005\u0003\u0002\u0002\ruB\u0001CA@\u0007?\u0011\r!a\u0002\t\u0011\r\u00053q\u0004a\u0001\u0003\u001b\f1\u0002^1cY\u0016\u001c6\r[3nC\"91Q\u0001\u0001\u0005\u0012\r\u0015S\u0003BB$\u0007\u001f\"Ba!\u0013\u0004ZQ!11JB*!\u0015A\"QXB'!\u0011\t\taa\u0014\u0005\u0011\rE31\tb\u0001\u0003\u000f\u0011\u0011!\u0011\u0005\t\u0007+\u001a\u0019\u0005q\u0001\u0004X\u0005\u0019A\u000f]3\u0011\r\u0005}\u0016QYB'\u0011\u001d911\ta\u0001\u0003gDqa!\u0002\u0001\t#\u0019i&\u0006\u0003\u0004`\r\u001dD\u0003BB1\u0007[\"Baa\u0019\u0004jA)\u0001D!0\u0004fA!\u0011\u0011AB4\t!\u0019\tfa\u0017C\u0002\u0005\u001d\u0001\u0002CB+\u00077\u0002\u001daa\u001b\u0011\r\u0005}\u0016QYB3\u0011!\tiga\u0017A\u0002\u0005=\u0004bBB\u0003\u0001\u0011E1\u0011O\u000b\u0005\u0007g\u001aY\b\u0006\u0004\u0004v\r\u00055Q\u0011\u000b\u0005\u0007o\u001ai\bE\u0003\u0019\u0005{\u001bI\b\u0005\u0003\u0002\u0002\rmD\u0001CB)\u0007_\u0012\r!a\u0002\t\u0011\rU3q\u000ea\u0002\u0007\u007f\u0002b!a0\u0002F\u000ee\u0004\u0002CBB\u0007_\u0002\rA!<\u0002\u00171|w-[2bYBc\u0017M\u001c\u0005\t\u0007\u000f\u001by\u00071\u0001\u0002N\u0006YAn\\4jG\u0006dG+\u001f9f\u0011\u001d\u0019Y\t\u0001C\u0005\u0007\u001b\u000babZ3u)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0006\u0004\u0002N\u000e=5Q\u0013\u0005\t\u0007#\u001bI\t1\u0001\u0004\u0014\u0006iqN]5hS:\fGNT1nKN\u0004R!\u001dBe\u0003;D\u0001ba&\u0004\n\u0002\u0007!Q^\u0001\u000e_B$\u0018.\\5{K\u0012\u0004F.\u00198\t\u000f\rm\u0005\u0001\"\u0003\u0004\u001e\u0006\tr-\u001a;FqBd\u0017-\u001b8EKR\f\u0017\u000e\\:\u0015\t\r}5\u0011\u0015\t\u0006c\n%'Q\u0006\u0005\t\u0003w\u001cI\n1\u0001\u0002~\"91Q\u0015\u0001\u0007\u0012\r\u001d\u0016\u0001G2sK\u0006$X\rR;n[f\u0014\u0015\r^2i)\u0006\u0014G.Z#omR\t!\bC\u0007\u0004,\u0002\u0001\n1!A\u0001\n\u0013\u0019iKJ\u0001\rgV\u0004XM\u001d\u0013d_:4\u0017nZ\u000b\u0002E\u0001")
public abstract class BatchTableEnvImpl
extends TableEnvImpl {
    private final ExecutionEnvironment execEnv;
    public final CatalogManager org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager;
    private final ArrayList<ModifyOperation> bufferedModifyOperations;
    private final BatchOptimizer optimizer;
    private final Registration registration;

    public /* synthetic */ TableConfig org$apache$flink$table$api$internal$BatchTableEnvImpl$$super$config() {
        return super.config();
    }

    public ExecutionEnvironment execEnv() {
        return this.execEnv;
    }

    private ArrayList<ModifyOperation> bufferedModifyOperations() {
        return this.bufferedModifyOperations;
    }

    public BatchOptimizer optimizer() {
        return this.optimizer;
    }

    private Registration registration() {
        return this.registration;
    }

    @Override
    public void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource, (TableSchema)tableSource.getTableSchema());
        if (tableSource instanceof BatchTableSource || tableSource instanceof InputFormatTableSource) {
            return;
        }
        throw new TableException("Only BatchTableSource and InputFormatTableSource can be registered in BatchTableEnvironment.");
    }

    @Override
    public void validateTableSink(TableSink<?> configuredSink) {
        if (configuredSink instanceof BatchTableSink || configuredSink instanceof OutputFormatTableSink) {
            return;
        }
        throw new TableException("Only BatchTableSink and OutputFormatTableSink can be registered in BatchTableEnvironment.");
    }

    public BatchTableDescriptor connect(ConnectorDescriptor connectorDescriptor) {
        return new BatchTableDescriptor(this.registration(), connectorDescriptor);
    }

    @Override
    public <T> DataSink<?> writeToSinkAndTranslate(QueryOperation queryOperation, TableSink<T> tableSink) {
        block4: {
            DataSink dataSink;
            block3: {
                TableSink<T> tableSink2;
                BatchTableEnvImpl batchTableEnv;
                block2: {
                    batchTableEnv = this.createDummyBatchTableEnv();
                    tableSink2 = tableSink;
                    if (!(tableSink2 instanceof BatchTableSink)) break block2;
                    BatchTableSink batchTableSink = (BatchTableSink)tableSink2;
                    TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
                    DataSet result = this.translate(queryOperation, outputType);
                    DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
                    dataSink = batchTableSink.consumeDataSet(dummyOp);
                    break block3;
                }
                if (!(tableSink2 instanceof OutputFormatTableSink)) break block4;
                OutputFormatTableSink outputFormatTableSink = (OutputFormatTableSink)tableSink2;
                TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
                DataSet result = this.translate(queryOperation, outputType);
                DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
                DataSink dataSink2 = dummyOp.output(outputFormatTableSink.getOutputFormat());
                dataSink = dataSink2.name(TableConnectorUtils.generateRuntimeName(outputFormatTableSink.getClass(), (String[])outputFormatTableSink.getTableSchema().getFieldNames()));
            }
            return dataSink;
        }
        throw new TableException("BatchTableSink or OutputFormatTableSink required to emit batch Table.");
    }

    @Override
    public <T> void addToBuffer(ModifyOperation modifyOperation) {
        this.bufferedModifyOperations().add(modifyOperation);
    }

    private <IN, OUT> Option<MapFunction<IN, OUT>> getConversionMapper(TypeInformation<IN> physicalTypeInfo, TableSchema schema, TypeInformation<OUT> requestedTypeInfo, String functionName) {
        Option<GeneratedFunction<MapFunction<Row, OUT>, OUT>> converterFunction = Conversions$.MODULE$.generateRowConverterFunction(physicalTypeInfo, schema, requestedTypeInfo, functionName, super.config());
        return converterFunction.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MapRunner<IN, OUT> apply(GeneratedFunction<MapFunction<Row, OUT>, OUT> func) {
                return new MapRunner<IN, OUT>(func.name(), func.code(), func.returnType());
            }
        });
    }

    public String explain(Table table, boolean extended) {
        return this.explainInternal(Collections.singletonList(table.getQueryOperation()), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.getExplainDetails(extended)));
    }

    public String explain(Table table) {
        return this.explain(table, false);
    }

    public String explain(boolean extended) {
        return this.explainInternal((List<Operation>)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.bufferedModifyOperations()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Operation apply(ModifyOperation x$1) {
                return x$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava()), (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])this.getExplainDetails(extended)));
    }

    @Override
    public String explainInternal(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "operations should not be empty";
            }
        });
        Buffer astList = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public final RelNode apply(Operation x0$1) {
                Operation operation;
                block7: {
                    RelNode relNode;
                    block6: {
                        block5: {
                            RelNode relNode2;
                            operation = x0$1;
                            if (!(operation instanceof QueryOperation)) break block5;
                            QueryOperation queryOperation = (QueryOperation)operation;
                            RelNode relNode3 = this.$outer.getRelBuilder().tableOperation(queryOperation).build();
                            RelNode relNode4 = relNode3;
                            if (relNode4 instanceof LogicalTableModify) {
                                LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                                List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                                Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "the length of qualified name should be 3.";
                                    }
                                });
                                CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of((String)qualifiedName.get(0), (String)qualifiedName.get(1), (String)qualifiedName.get(2)), (QueryOperation)new PlannerQueryOperation(logicalTableModify.getInput()));
                                relNode2 = this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$translateToRel((ModifyOperation)modifyOperation, true);
                            } else {
                                relNode2 = relNode3;
                            }
                            relNode = relNode2;
                            break block6;
                        }
                        if (!(operation instanceof ModifyOperation)) break block7;
                        ModifyOperation modifyOperation = (ModifyOperation)operation;
                        relNode = this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$translateToRel(modifyOperation, true);
                    }
                    return relNode;
                }
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.asSummaryString()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)astList.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public final RelNode apply(RelNode relNode) {
                return this.$outer.optimizer().optimize(relNode);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        BatchTableEnvImpl batchTableEnv = this.createDummyBatchTableEnv();
        Buffer dataSinks = (Buffer)((TraversableLike)optimizedNodes.zip((GenIterable)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala(), Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, batchTableEnv){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;
            private final BatchTableEnvImpl batchTableEnv$1;

            public final DataSink<?> apply(Tuple2<RelNode, Operation> x0$2) {
                Tuple2<RelNode, Operation> tuple2;
                block2: {
                    Operation operation;
                    block5: {
                        DataSink dataSink;
                        block4: {
                            RelNode optimizedNode;
                            block3: {
                                PlannerQueryOperation plannerQueryOperation;
                                tuple2 = x0$2;
                                if (tuple2 == null) break block2;
                                optimizedNode = (RelNode)tuple2._1();
                                Operation operation2 = (Operation)tuple2._2();
                                operation = operation2;
                                if (!(operation instanceof QueryOperation)) break block3;
                                QueryOperation queryOperation = (QueryOperation)operation;
                                QueryOperation queryOperation2 = queryOperation;
                                String[] stringArray = queryOperation2 instanceof PlannerQueryOperation && (plannerQueryOperation = (PlannerQueryOperation)queryOperation2).getCalciteTree() instanceof LogicalTableModify ? (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(plannerQueryOperation.getCalciteTree().getInput(0).getRowType().getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)) : queryOperation.getTableSchema().getFieldNames();
                                String[] fieldNames = stringArray;
                                DataSet<A> dataSet = this.$outer.translate(optimizedNode, this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$getTableSchema(fieldNames, optimizedNode), new GenericTypeInfo(Row.class));
                                dataSink = dataSet.output((OutputFormat)new DiscardingOutputFormat());
                                break block4;
                            }
                            if (!(operation instanceof ModifyOperation)) break block5;
                            ModifyOperation modifyOperation = (ModifyOperation)operation;
                            TableSink<?> tableSink = this.$outer.getTableSink(modifyOperation);
                            dataSink = this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$translate(this.batchTableEnv$1, optimizedNode, tableSink, this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$getTableSchema(modifyOperation.getChild().getTableSchema().getFieldNames(), optimizedNode));
                        }
                        DataSink dataSink2 = dataSink;
                        return dataSink2;
                    }
                    throw new TableException(new StringBuilder().append((Object)"Unsupported Operation: ").append((Object)operation.asSummaryString()).toString());
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchTableEnv$1 = batchTableEnv$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        String astPlan = ((TraversableOnce)astList.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RelNode x$1) {
                return RelOptUtil.toString(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        String optimizedPlan = ((TraversableOnce)optimizedNodes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RelNode x$1) {
                return RelOptUtil.toString(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        ExecutionEnvironment env = ((DataSink)dataSinks.head()).getDataSet().getExecutionEnvironment();
        String jasonSqlPlan = env.getExecutionPlan();
        boolean extended = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST);
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jasonSqlPlan, Predef$.MODULE$.boolean2Boolean(extended));
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Abstract Syntax Tree =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{astPlan}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Optimized Logical Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizedPlan}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Execution Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlPlan}))).toString();
    }

    public JobExecutionResult execute(String jobName) {
        Object object;
        Pipeline plan = this.createPipelineAndClearBuffer(jobName);
        try {
            JobClient jobClient = this.executePipeline(plan);
            object = this.execEnv().getConfiguration().getBoolean(DeploymentOptions.ATTACHED) ? (JobExecutionResult)jobClient.getJobExecutionResult(this.execEnv().getUserCodeClassLoader()).get() : new DetachedJobExecutionResult(jobClient.getJobID());
        }
        catch (Throwable throwable) {
            ExceptionUtils.rethrow((Throwable)throwable);
            object = null;
        }
        return object;
    }

    @Override
    public JobClient execute(List<DataSink<?>> dataSinks, String jobName) {
        Pipeline plan = this.createPipeline(dataSinks, jobName);
        return this.executePipeline(plan);
    }

    private JobClient executePipeline(Pipeline plan) {
        JobClient jobClient;
        Configuration configuration = this.execEnv().getConfiguration();
        Preconditions.checkNotNull((Object)configuration.get(DeploymentOptions.TARGET), (String)"No execution.target specified in your configuration file.");
        PipelineExecutorFactory executorFactory = this.execEnv().getExecutorServiceLoader().getExecutorFactory(configuration);
        Preconditions.checkNotNull((Object)executorFactory, (String)"Cannot find compatible factory for specified execution.target (=%s)", (Object[])new Object[]{configuration.get(DeploymentOptions.TARGET)});
        CompletableFuture jobClientFuture = executorFactory.getExecutor(configuration).execute(plan, configuration);
        try {
            jobClient = (JobClient)jobClientFuture.get();
        }
        catch (Throwable throwable) {
            ExceptionUtils.rethrow((Throwable)throwable);
            jobClient = null;
        }
        return jobClient;
    }

    public Pipeline getPipeline(String jobName) {
        return this.createPipelineAndClearBuffer(jobName);
    }

    private Pipeline createPipelineAndClearBuffer(String jobName) {
        List<DataSink<?>> dataSinks = this.translate(this.bufferedModifyOperations());
        try {
            return this.createPipeline(dataSinks, jobName);
        }
        finally {
            this.bufferedModifyOperations().clear();
        }
    }

    private Pipeline createPipeline(List<DataSink<?>> sinks, String jobName) {
        Field cacheFileField = ExecutionEnvironment.class.getDeclaredField("cacheFile");
        cacheFileField.setAccessible(true);
        PlanGenerator generator = new PlanGenerator(sinks, this.execEnv().getConfig(), this.execEnv().getParallelism(), (List)cacheFileField.get(this.execEnv()), jobName);
        return generator.generate();
    }

    public <T> DataSetQueryOperation<T> asQueryOperation(DataSet<T> dataSet, Option<Expression[]> fields) {
        Option<Expression[]> option;
        block4: {
            FieldInfoUtils.TypeInfoSchema typeInfoSchema;
            block3: {
                TypeInformation inputType;
                block2: {
                    inputType = dataSet.getType();
                    option = fields;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Expression[] f = (Expression[])some.x();
                    this.checkNoTimeAttributes(f);
                    typeInfoSchema = FieldInfoUtils.getFieldsInfo((TypeInformation)inputType, (Expression[])f);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                typeInfoSchema = FieldInfoUtils.getFieldsInfo((TypeInformation)inputType);
            }
            FieldInfoUtils.TypeInfoSchema fieldsInfo = typeInfoSchema;
            DataSetQueryOperation tableOperation = new DataSetQueryOperation(dataSet, fieldsInfo.getIndices(), fieldsInfo.toTableSchema());
            return tableOperation;
        }
        throw new MatchError(option);
    }

    private <T> void checkNoTimeAttributes(Expression[] f) {
        if (Predef$.MODULE$.refArrayOps((Object[])f).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression f) {
                return BoxesRunTime.unboxToBoolean((Object)f.accept((ExpressionVisitor)new ApiExpressionDefaultVisitor<Object>(this){

                    public boolean visit(UnresolvedCallExpression call) {
                        return BuiltInFunctionDefinitions.TIME_ATTRIBUTES.contains(call.getFunctionDefinition()) || ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(call.getChildren()).asScala()).exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$checkNoTimeAttributes$1$$anon$1 $outer;

                            public final boolean apply(Expression x$2) {
                                return BoxesRunTime.unboxToBoolean((Object)x$2.accept((ExpressionVisitor)this.$outer));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }

                    public boolean defaultMethod(Expression expression2) {
                        return false;
                    }
                }));
            }
        })) {
            throw new ValidationException(".rowtime and .proctime time indicators are not allowed in a batch environment.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RelNode org$apache$flink$table$api$internal$BatchTableEnvImpl$$translateToRel(ModifyOperation modifyOperation, boolean addLogicalSink) {
        RelNode relNode;
        RelNode input = this.getRelBuilder().tableOperation(modifyOperation.getChild()).build();
        if (addLogicalSink) {
            TableSink<?> tableSink = this.getTableSink(modifyOperation);
            ModifyOperation modifyOperation2 = modifyOperation;
            if (!(modifyOperation2 instanceof CatalogSinkModifyOperation)) throw new TableException(new StringBuilder().append((Object)"Unsupported Operation: ").append((Object)modifyOperation2.asSummaryString()).toString());
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
            LogicalSink logicalSink = LogicalSink$.MODULE$.create(input, tableSink, catalogSinkModifyOperation.getTableIdentifier().toString());
            relNode = logicalSink;
            return relNode;
        } else {
            relNode = input;
        }
        return relNode;
    }

    private <T> List<DataSink<?>> translate(List<ModifyOperation> modifyOperations) {
        Buffer relNodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(modifyOperations).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public final RelNode apply(ModifyOperation o) {
                return this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$translateToRel(o, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)relNodes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public final RelNode apply(RelNode relNode) {
                return this.$outer.optimizer().optimize(relNode);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        BatchTableEnvImpl batchTableEnv = this.createDummyBatchTableEnv();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(modifyOperations).asScala()).zip((GenIterable)optimizedNodes, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, batchTableEnv){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;
            private final BatchTableEnvImpl batchTableEnv$2;

            public final DataSink<?> apply(Tuple2<ModifyOperation, RelNode> x0$3) {
                Tuple2<ModifyOperation, RelNode> tuple2 = x0$3;
                if (tuple2 != null) {
                    ModifyOperation modifyOperation = (ModifyOperation)tuple2._1();
                    RelNode optimizedNode = (RelNode)tuple2._2();
                    TableSink<?> tableSink = this.$outer.getTableSink(modifyOperation);
                    DataSink<?> dataSink = this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$translate(this.batchTableEnv$2, optimizedNode, tableSink, this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$getTableSchema(modifyOperation.getChild().getTableSchema().getFieldNames(), optimizedNode));
                    return dataSink;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.batchTableEnv$2 = batchTableEnv$2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava();
    }

    public <T> DataSink<?> org$apache$flink$table$api$internal$BatchTableEnvImpl$$translate(BatchTableEnvImpl batchTableEnv, RelNode optimizedNode, TableSink<T> tableSink, TableSchema tableSchema) {
        block4: {
            DataSink dataSink;
            block3: {
                TableSink<T> tableSink2;
                block2: {
                    tableSink2 = tableSink;
                    if (!(tableSink2 instanceof BatchTableSink)) break block2;
                    BatchTableSink batchTableSink = (BatchTableSink)tableSink2;
                    TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
                    DataSet result = this.translate(optimizedNode, tableSchema, outputType);
                    DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
                    dataSink = batchTableSink.consumeDataSet(dummyOp);
                    break block3;
                }
                if (!(tableSink2 instanceof OutputFormatTableSink)) break block4;
                OutputFormatTableSink outputFormatTableSink = (OutputFormatTableSink)tableSink2;
                TypeInformation outputType = TypeConversions.fromDataTypeToLegacyInfo((DataType)tableSink.getConsumedDataType());
                DataSet result = this.translate(optimizedNode, tableSchema, outputType);
                DummyNoOpOperator dummyOp = new DummyNoOpOperator(batchTableEnv.execEnv(), result, result.getType());
                DataSink dataSink2 = dummyOp.output(outputFormatTableSink.getOutputFormat());
                dataSink = dataSink2.name(TableConnectorUtils.generateRuntimeName(outputFormatTableSink.getClass(), (String[])outputFormatTableSink.getTableSchema().getFieldNames()));
            }
            return dataSink;
        }
        throw new TableException("BatchTableSink or OutputFormatTableSink required to emit batch Table.");
    }

    public <A> DataSet<A> translate(Table table, TypeInformation<A> tpe) {
        return this.translate(table.getQueryOperation(), tpe);
    }

    public <A> DataSet<A> translate(QueryOperation queryOperation, TypeInformation<A> tpe) {
        RelNode relNode = this.getRelBuilder().tableOperation(queryOperation).build();
        RelNode dataSetPlan = this.optimizer().optimize(relNode);
        return this.translate(dataSetPlan, this.org$apache$flink$table$api$internal$BatchTableEnvImpl$$getTableSchema(queryOperation.getTableSchema().getFieldNames(), dataSetPlan), tpe);
    }

    public <A> DataSet<A> translate(RelNode logicalPlan, TableSchema logicalType, TypeInformation<A> tpe) {
        block2: {
            Option option;
            block5: {
                Operator operator;
                block4: {
                    Some some;
                    MapFunction mapFunction;
                    Operator plan;
                    block3: {
                        Option conversion;
                        FieldInfoUtils.validateInputTypeInfo(tpe);
                        RelNode relNode = logicalPlan;
                        if (!(relNode instanceof DataSetRel)) break block2;
                        DataSetRel dataSetRel = (DataSetRel)relNode;
                        this.execEnv().configure((ReadableConfig)super.config().getConfiguration(), Thread.currentThread().getContextClassLoader());
                        plan = dataSetRel.translateToPlan(this);
                        option = conversion = this.getConversionMapper(plan.getType(), logicalType, tpe, "DataSetSinkConversion");
                        if (!None$.MODULE$.equals(option)) break block3;
                        operator = plan;
                        break block4;
                    }
                    if (!(option instanceof Some) || (mapFunction = (MapFunction)(some = (Some)option).x()) == null) break block5;
                    MapFunction mapFunction2 = mapFunction;
                    operator = plan.map(mapFunction2).returns(tpe).name(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tpe.getTypeClass().getSimpleName()})));
                }
                Operator operator2 = operator;
                return operator2;
            }
            throw new MatchError(option);
        }
        throw new TableException("Cannot generate DataSet due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
    }

    public TableSchema org$apache$flink$table$api$internal$BatchTableEnvImpl$$getTableSchema(String[] originalNames, RelNode optimizedPlan) {
        DataType[] fieldTypes = (DataType[])((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(optimizedPlan.getRowType().getFieldList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RelDataType apply(RelDataTypeField x$3) {
                return x$3.getType();
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataType relDataType) {
                return FlinkTypeFactory$.MODULE$.toTypeInfo(relDataType);
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DataType apply(TypeInformation<?> x$1) {
                return TypeConversions.fromLegacyInfoToDataType(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DataType.class));
        return TableSchema.builder().fields(originalNames, fieldTypes).build();
    }

    private ExplainDetail[] getExplainDetails(boolean extended) {
        return extended ? (ExplainDetail[])((Object[])new ExplainDetail[]{ExplainDetail.ESTIMATED_COST}) : (ExplainDetail[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ExplainDetail.class));
    }

    public abstract BatchTableEnvImpl createDummyBatchTableEnv();

    public String explainInternal(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explainInternal(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Expression[] values) {
        return this.fromValues(rowType, (Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])values));
    }

    @Override
    public Table fromValues(Expression[] values) {
        return this.fromValues((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])values));
    }

    @Override
    public String explainSql(String statement, ExplainDetail[] extraDetails) {
        return this.explainSql(statement, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    @Override
    public void insertInto(Table table, String sinkPath, String[] sinkPathContinued) {
        this.insertInto(table, sinkPath, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])sinkPathContinued));
    }

    @Override
    public Table scan(String[] tablePath) {
        return this.scan((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])tablePath));
    }

    public BatchTableEnvImpl(ExecutionEnvironment execEnv, TableConfig config, CatalogManager catalogManager, ModuleManager moduleManager) {
        this.execEnv = execEnv;
        this.org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager = catalogManager;
        super(config, catalogManager, moduleManager);
        this.bufferedModifyOperations = new ArrayList();
        this.optimizer = new BatchOptimizer((Function0<CalciteConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public final CalciteConfig apply() {
                return this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$super$config().getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.planningConfigurationBuilder());
        this.registration = new Registration(this){
            private final /* synthetic */ BatchTableEnvImpl $outer;

            public void createTemporaryTable(String path, CatalogBaseTable table) {
                UnresolvedIdentifier unresolvedIdentifier = this.$outer.parseIdentifier(path);
                ObjectIdentifier objectIdentifier = this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager.qualifyIdentifier(unresolvedIdentifier);
                this.$outer.org$apache$flink$table$api$internal$BatchTableEnvImpl$$catalogManager.createTemporaryTable(table, objectIdentifier, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

