/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes;

import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.codegen.FunctionCodeGenerator;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.plan.nodes.CommonCalc;
import org.apache.flink.table.plan.schema.RowSchema;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.RichDouble$;

public abstract class CommonCalc$class {
    public static GeneratedFunction generateFunction(CommonCalc $this, FunctionCodeGenerator generator, String ruleDescription, RowSchema returnSchema, Seq calcProjection, Option calcCondition, TableConfig config, Class functionClass) {
        String string;
        GeneratedExpression projection = generator.generateResultExpression(returnSchema.typeInfo(), returnSchema.fieldNames(), (Seq<RexNode>)calcProjection);
        if (calcCondition.isEmpty()) {
            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |", "\n        |", ".collect(", ");\n        |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{projection.code(), generator.collectorTerm(), projection.resultTerm()})))).stripMargin();
        } else {
            GeneratedExpression filterCondition = generator.generateExpression((RexNode)calcCondition.get());
            string = projection == null ? new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |", "\n          |if (", ") {\n          |  ", ".collect(", ");\n          |}\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filterCondition.code(), filterCondition.resultTerm(), generator.collectorTerm(), generator.input1Term()})))).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          |", "\n          |if (", ") {\n          |  ", "\n          |  ", ".collect(", ");\n          |}\n          |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filterCondition.code(), filterCondition.resultTerm(), projection.code(), generator.collectorTerm(), projection.resultTerm()})))).stripMargin();
        }
        String body = string;
        return generator.generateFunction(ruleDescription, functionClass, body, returnSchema.typeInfo());
    }

    public static String conditionToString(CommonCalc $this, RexProgram calcProgram, Function3 expression2) {
        RexLocalRef cond = calcProgram.getCondition();
        List inFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getInputRowType().getFieldNames()).asScala()).toList();
        List localExprs = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getExprList()).asScala()).toList();
        return cond == null ? "" : (String)expression2.apply((Object)cond, (Object)inFields, (Object)new Some((Object)localExprs));
    }

    public static String selectionToString(CommonCalc $this, RexProgram calcProgram, Function3 expression2) {
        List proj = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getProjectList()).asScala()).toList();
        List inFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getInputRowType().getFieldNames()).asScala()).toList();
        List localExprs = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getExprList()).asScala()).toList();
        List outFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getOutputRowType().getFieldNames()).asScala()).toList();
        return ((TraversableOnce)((List)((IterableLike)proj.map((Function1)new Serializable($this, inFields, localExprs, expression2){
            public static final long serialVersionUID = 0L;
            private final List inFields$1;
            private final List localExprs$1;
            private final Function3 expression$1;

            public final String apply(RexLocalRef x$1) {
                return (String)this.expression$1.apply((Object)x$1, (Object)this.inFields$1, (Object)new Some((Object)this.localExprs$1));
            }
            {
                this.inFields$1 = inFields$1;
                this.localExprs$1 = localExprs$1;
                this.expression$1 = expression$1;
            }
        }, List$.MODULE$.canBuildFrom())).zip((GenIterable)outFields, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String e = (String)tuple2._1();
                    String o = (String)tuple2._2();
                    String string = e;
                    String string2 = o;
                    String string3 = !(string != null ? !string.equals(string2) : string2 != null) ? e : new StringBuilder().append((Object)e).append((Object)" AS ").append((Object)o).toString();
                    return string3;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public static String calcOpName(CommonCalc $this, RexProgram calcProgram, Function3 expression2) {
        String conditionStr = $this.conditionToString(calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2);
        String selectionStr = $this.selectionToString(calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "select: (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{calcProgram.getCondition() == null ? "" : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"where: (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{conditionStr})), selectionStr}));
    }

    public static String calcToString(CommonCalc $this, RexProgram calcProgram, Function3 expression2) {
        String name = $this.calcOpName(calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2);
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Calc(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}));
    }

    public static RelOptCost computeSelfCost(CommonCalc $this, RexProgram calcProgram, RelOptPlanner planner, double rowCnt) {
        int compCnt = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(calcProgram.getExprList()).asScala()).toList().count((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CommonCalc $outer;

            public final boolean apply(RexNode rexNode) {
                return this.$outer.isComputation(rexNode);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }) + 1;
        double newRowCnt = $this.estimateRowCount(calcProgram, rowCnt);
        return planner.getCostFactory().makeCost(newRowCnt, newRowCnt * (double)compCnt, 0.0);
    }

    public static double estimateRowCount(CommonCalc $this, RexProgram calcProgram, double rowCnt) {
        double d;
        if (calcProgram.getCondition() == null) {
            d = rowCnt;
        } else {
            RexNode exprs = calcProgram.expandLocalRef(calcProgram.getCondition());
            double selectivity = RelMdUtil.guessSelectivity(exprs, false);
            d = RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(rowCnt * selectivity), 1.0);
        }
        return d;
    }

    public static boolean isComputation(CommonCalc $this, RexNode rexNode) {
        RexCall rexCall;
        RexNode rexNode2 = rexNode;
        boolean bl = rexNode2 instanceof RexInputRef ? false : (rexNode2 instanceof RexLiteral ? false : !(rexNode2 instanceof RexCall) || !(rexCall = (RexCall)rexNode2).getOperator().getName().equals("CAST"));
        return bl;
    }

    public static void $init$(CommonCalc $this) {
    }
}

