/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.SelectTableSink;
import org.apache.flink.table.calcite.CalciteConfig;
import org.apache.flink.table.calcite.CalciteConfig$;
import org.apache.flink.table.calcite.CalciteParser;
import org.apache.flink.table.calcite.FlinkPlannerImpl;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.executor.StreamExecutor;
import org.apache.flink.table.explain.PlanJsonParser;
import org.apache.flink.table.expressions.ExpressionBridge;
import org.apache.flink.table.expressions.PlannerExpression;
import org.apache.flink.table.expressions.PlannerExpressionConverter$;
import org.apache.flink.table.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSinkFactoryContextImpl;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.PlannerQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.plan.StreamOptimizer;
import org.apache.flink.table.plan.nodes.LogicalSink;
import org.apache.flink.table.plan.nodes.LogicalSink$;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.planner.ParserImpl;
import org.apache.flink.table.planner.PlanningConfigurationBuilder;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.DataStreamTableSink;
import org.apache.flink.table.sinks.OverwritableTableSink;
import org.apache.flink.table.sinks.PartitionableTableSink;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.StreamSelectTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.TableSinkUtils$;
import org.apache.flink.table.sinks.UpsertStreamTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.util.DummyStreamExecutionEnvironment;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t%e\u0001B\u0001\u0003\u00015\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003\u001d\u0001H.\u00198oKJT!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dY\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\t!\u0002Z3mK\u001e\fG/[8o\u0013\tY\u0002DA\u0004QY\u0006tg.\u001a:\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/}I!\u0001\t\r\u0003\u0011\u0015CXmY;u_JD\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007G>tg-[4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011aA1qS&\u0011\u0001&\n\u0002\f)\u0006\u0014G.Z\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001M\u0017\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eD\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000fG\u0006$\u0018\r\\8h\u001b\u0006t\u0017mZ3s!\taC'\u0003\u00026[\tq1)\u0019;bY><W*\u00198bO\u0016\u0014\b\"B\u001c\u0001\t\u0003A\u0014A\u0002\u001fj]&$h\bF\u0003:wqjd\b\u0005\u0002;\u00015\t!\u0001C\u0003\u001em\u0001\u0007a\u0004C\u0003#m\u0001\u00071\u0005C\u0003+m\u0001\u00071\u0006C\u00033m\u0001\u00071\u0007C\u0004A\u0001\t\u0007I\u0011B!\u0002\u001d%tG/\u001a:oC2\u001c6\r[3nCV\t!\t\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006!!\u000e\u001a2d\u0015\t9\u0005\"A\u0004dC2\u001c\u0017\u000e^3\n\u0005%#%!D\"bY\u000eLG/Z*dQ\u0016l\u0017\r\u0003\u0004L\u0001\u0001\u0006IAQ\u0001\u0010S:$XM\u001d8bYN\u001b\u0007.Z7bA!9Q\n\u0001b\u0001\n\u0013q\u0015\u0001E3yaJ,7o]5p]\n\u0013\u0018\u000eZ4f+\u0005y\u0005c\u0001)T+6\t\u0011K\u0003\u0002S\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t!\u0016K\u0001\tFqB\u0014Xm]:j_:\u0014%/\u001b3hKB\u0011\u0001KV\u0005\u0003/F\u0013\u0011\u0003\u00157b]:,'/\u0012=qe\u0016\u001c8/[8o\u0011\u0019I\u0006\u0001)A\u0005\u001f\u0006\tR\r\u001f9sKN\u001c\u0018n\u001c8Ce&$w-\u001a\u0011\t\u000fm\u0003!\u0019!C\u00059\u0006a\u0002\u000f\\1o]&twmQ8oM&<WO]1uS>t')^5mI\u0016\u0014X#A/\u0011\u0005ir\u0016BA0\u0003\u0005q\u0001F.\u00198oS:<7i\u001c8gS\u001e,(/\u0019;j_:\u0014U/\u001b7eKJDa!\u0019\u0001!\u0002\u0013i\u0016!\b9mC:t\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\"vS2$WM\u001d\u0011\t\u0011\r\u0004!\u0019!C\u0001\r\u0011\f\u0011b\u001c9uS6L'0\u001a:\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u0003\u0002\tAd\u0017M\\\u0005\u0003U\u001e\u0014qb\u0015;sK\u0006lw\n\u001d;j[&TXM\u001d\u0005\u0007Y\u0002\u0001\u000b\u0011B3\u0002\u0015=\u0004H/[7ju\u0016\u0014\b\u0005\u000b\u0002l]B\u0011qN]\u0007\u0002a*\u0011\u0011OB\u0001\u000bC:tw\u000e^1uS>t\u0017BA:q\u0005E1\u0016n]5cY\u00164uN\u001d+fgRLgn\u001a\u0005\bk\u0002\u0011\r\u0011\"\u0003w\u0003\u0019\u0001\u0018M]:feV\tq\u000f\u0005\u0002\u0018q&\u0011\u0011\u0010\u0007\u0002\u0007!\u0006\u00148/\u001a:\t\rm\u0004\u0001\u0015!\u0003x\u0003\u001d\u0001\u0018M]:fe\u0002BQ! \u0001\u0005By\f\u0011bZ3u!\u0006\u00148/\u001a:\u0015\u0003]Dq!!\u0001\u0001\t\u0003\n\u0019!A\u0005ue\u0006t7\u000f\\1uKR!\u0011QAA\u001f!\u0019\t9!!\u0004\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0011\u0012\u0001B;uS2LA!a\u0004\u0002\n\t!A*[:ua\u0011\t\u0019\"!\n\u0011\r\u0005U\u0011QDA\u0011\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011a\u00013bO*\u0011aEB\u0005\u0005\u0003?\t9B\u0001\bUe\u0006t7OZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t-\t9c`A\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#\u0013'\u0005\u0003\u0002,\u0005]\u0002\u0003BA\u0017\u0003gi!!a\f\u000b\u0005\u0005E\u0012!B:dC2\f\u0017\u0002BA\u001b\u0003_\u0011qAT8uQ&tw\r\u0005\u0003\u0002.\u0005e\u0012\u0002BA\u001e\u0003_\u00111!\u00118z\u0011\u001d\tyd a\u0001\u0003\u0003\nq\u0002^1cY\u0016|\u0005/\u001a:bi&|gn\u001d\t\u0007\u0003\u000f\ti!a\u0011\u0011\t\u0005\u0015\u00131J\u0007\u0003\u0003\u000fR1!!\u0013\u0005\u0003)y\u0007/\u001a:bi&|gn]\u0005\u0005\u0003\u001b\n9EA\bN_\u0012Lg-_(qKJ\fG/[8o\u0011\u001d\t\t\u0006\u0001C!\u0003'\nQc\u0019:fCR,7+\u001a7fGR$\u0016M\u00197f'&t7\u000e\u0006\u0003\u0002V\u0005\u0005\u0004\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005mS%\u0001\u0005j]R,'O\\1m\u0013\u0011\ty&!\u0017\u0003\u001fM+G.Z2u)\u0006\u0014G.Z*j].D\u0001\"a\u0019\u0002P\u0001\u0007\u0011QM\u0001\fi\u0006\u0014G.Z*dQ\u0016l\u0017\rE\u0002%\u0003OJ1!!\u001b&\u0005-!\u0016M\u00197f'\u000eDW-\\1\t\u000f\u00055\u0004\u0001\"\u0011\u0002p\u00059Q\r\u001f9mC&tGCBA9\u0003\u007f\nI\t\u0005\u0003\u0002t\u0005ed\u0002BA\u0017\u0003kJA!a\u001e\u00020\u00051\u0001K]3eK\u001aLA!a\u001f\u0002~\t11\u000b\u001e:j]\u001eTA!a\u001e\u00020!A\u0011\u0011JA6\u0001\u0004\t\t\t\u0005\u0004\u0002\b\u00055\u00111\u0011\t\u0005\u0003\u000b\n))\u0003\u0003\u0002\b\u0006\u001d#!C(qKJ\fG/[8o\u0011!\tY)a\u001bA\u0002\u00055\u0015\u0001D3yiJ\fG)\u001a;bS2\u001c\bCBA\u0017\u0003\u001f\u000b\u0019*\u0003\u0003\u0002\u0012\u0006=\"A\u0003\u001fsKB,\u0017\r^3e}A\u0019A%!&\n\u0007\u0005]UEA\u0007FqBd\u0017-\u001b8EKR\f\u0017\u000e\u001c\u0005\b\u00037\u0003A\u0011IAO\u0003I9W\r^\"p[BdW\r^5p]\"Kg\u000e^:\u0015\r\u0005}\u0015QUAU!\u0019\ti#!)\u0002r%!\u00111UA\u0018\u0005\u0015\t%O]1z\u0011!\t9+!'A\u0002\u0005E\u0014!C:uCR,W.\u001a8u\u0011!\tY+!'A\u0002\u00055\u0016\u0001\u00039pg&$\u0018n\u001c8\u0011\t\u00055\u0012qV\u0005\u0005\u0003c\u000byCA\u0002J]RDq!!.\u0001\t\u0013\t9,\u0001\bue\u0006t7\u000f\\1uKR{'+\u001a7\u0015\t\u0005e\u0016\u0011\u001b\t\t\u0003[\tY,a0\u0002L&!\u0011QXA\u0018\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011YAd\u001b\t\t\u0019MC\u0002\u0002F\u001a\u000b1A]3m\u0013\u0011\tI-a1\u0003\u000fI+GNT8eKB!\u0011QFAg\u0013\u0011\ty-a\f\u0003\u000f\t{w\u000e\\3b]\"A\u00111[AZ\u0001\u0004\t\u0019%A\bn_\u0012Lg-_(qKJ\fG/[8o\u0011\u001d\t9\u000e\u0001C\u0005\u00033\fqbZ3u\r2Lgn\u001b)mC:tWM]\u000b\u0003\u00037\u0004B!!8\u0002b6\u0011\u0011q\u001c\u0006\u0003\u000f\u0012IA!a9\u0002`\n\u0001b\t\\5oWBc\u0017M\u001c8fe&k\u0007\u000f\u001c\u0005\t\u0003O\u0004A\u0011\u0001\u0004\u0002j\u0006iq-\u001a;SK2\u0014U/\u001b7eKJ,\"!a;\u0011\t\u0005u\u0017Q^\u0005\u0005\u0003_\fyNA\bGY&t7NU3m\u0005VLG\u000eZ3s\u0011!\t\u0019\u0010\u0001C\u0001\r\u0005U\u0018!C4fi\u000e{gNZ5h+\u0005\u0019\u0003\u0002CA}\u0001\u0011\u0005a!a?\u0002/\u001d,G/\u0012=fGV$\u0018n\u001c8F]ZL'o\u001c8nK:$XCAA\u007f!\u0011\tyPa\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t1\"\u001a8wSJ|g.\\3oi*\u0019aEa\u0002\u000b\u0007\t%a!A\u0005tiJ,\u0017-\\5oO&!!Q\u0002B\u0001\u0005i\u0019FO]3b[\u0016CXmY;uS>tWI\u001c<je>tW.\u001a8u\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'\tq\u0002\u001e:b]Nd\u0017\r^3U_\u000e\u0013vn\u001e\u000b\u0007\u0005+\u0011\tDa\r\u0011\r\t]!Q\u0004B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\t\u0015\u0011A\u00033bi\u0006\u001cHO]3b[&!!q\u0004B\r\u0005)!\u0015\r^1TiJ,\u0017-\u001c\t\u0005\u0005G\u0011i#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003\u0015!\u0018\u0010]3t\u0015\r\u0011Y\u0003B\u0001\beVtG/[7f\u0013\u0011\u0011yC!\n\u0003\t\r\u0013vn\u001e\u0005\u0007\u0007\t=\u0001\u0019A\u001d\t\u0011\tU\"q\u0002a\u0001\u0003\u007f\u000b1\u0002\\8hS\u000e\fG\u000e\u00157b]\"9!\u0011\b\u0001\u0005\n\tm\u0012aC<sSR,Gk\\*j].,BA!\u0010\u0003\\QA\u0011\u0011\u0018B \u0005\u0013\u0012y\u0006\u0003\u0005\u0003B\t]\u0002\u0019\u0001B\"\u00039!\u0018M\u00197f\u001fB,'/\u0019;j_:\u0004B!!\u0012\u0003F%!!qIA$\u00059\tV/\u001a:z\u001fB,'/\u0019;j_:D\u0001Ba\u0013\u00038\u0001\u0007!QJ\u0001\u0005g&t7\u000e\u0005\u0004\u0003P\tU#\u0011L\u0007\u0003\u0005#R1Aa\u0015\u0005\u0003\u0015\u0019\u0018N\\6t\u0013\u0011\u00119F!\u0015\u0003\u0013Q\u000b'\r\\3TS:\\\u0007\u0003BA\u0012\u00057\"\u0001B!\u0018\u00038\t\u0007\u0011\u0011\u0006\u0002\u0002)\"A!\u0011\rB\u001c\u0001\u0004\t\t(\u0001\u0005tS:\\g*Y7f\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005O\nAbZ3u)\u0006\u0014G.Z*j].$BA!\u001b\u0003zA1\u0011Q\u0006B6\u0005_JAA!\u001c\u00020\t1q\n\u001d;j_:\u0004DA!\u001d\u0003vA1!q\nB+\u0005g\u0002B!a\t\u0003v\u0011a!q\u000fB2\u0003\u0003\u0005\tQ!\u0001\u0002*\t\u0019q\fJ\u001a\t\u0011\tm$1\ra\u0001\u0005{\n\u0001c\u001c2kK\u000e$\u0018\nZ3oi&4\u0017.\u001a:\u0011\u00071\u0012y(C\u0002\u0003\u00026\u0012\u0001c\u00142kK\u000e$\u0018\nZ3oi&4\u0017.\u001a:\t\u000f\t\u0015\u0005\u0001\"\u0003\u0003\b\u0006\u00112M]3bi\u0016$U/\\7z!2\fgN\\3s)\u0005I\u0004")
public class StreamPlanner
implements Planner {
    private final Executor executor;
    public final TableConfig org$apache$flink$table$planner$StreamPlanner$$config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final CalciteSchema internalSchema;
    private final ExpressionBridge<PlannerExpression> expressionBridge;
    private final PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    @VisibleForTesting
    private final StreamOptimizer optimizer;
    private final Parser parser;

    private CalciteSchema internalSchema() {
        return this.internalSchema;
    }

    private ExpressionBridge<PlannerExpression> expressionBridge() {
        return this.expressionBridge;
    }

    public PlanningConfigurationBuilder org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder() {
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder;
    }

    public StreamOptimizer optimizer() {
        return this.optimizer;
    }

    private Parser parser() {
        return this.parser;
    }

    public Parser getParser() {
        return this.parser();
    }

    public List<Transformation<?>> translate(List<ModifyOperation> tableOperations) {
        StreamPlanner planner = this.createDummyPlanner();
        return (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableOperations).asScala()).map((Function1)new Serializable(this, planner){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;
            private final StreamPlanner planner$1;

            public final Transformation<?> apply(ModifyOperation operation) {
                Tuple2<RelNode, Object> tuple2 = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToRel(operation);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    RelNode ast = (RelNode)tuple2._1();
                    boolean updatesAsRetraction = tuple2._2$mcZ$sp();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)ast, (Object)BoxesRunTime.boxToBoolean((boolean)updatesAsRetraction));
                    RelNode ast2 = (RelNode)tuple23._1();
                    boolean updatesAsRetraction2 = tuple23._2$mcZ$sp();
                    RelNode optimizedPlan = this.$outer.optimizer().optimize(ast2, updatesAsRetraction2, this.$outer.getRelBuilder());
                    DataStream<CRow> dataStream = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToCRow(this.planner$1, optimizedPlan);
                    return dataStream.getTransformation();
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.planner$1 = planner$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$1) {
                return Objects.nonNull(x$1);
            }
        })).asJava();
    }

    public SelectTableSink createSelectTableSink(TableSchema tableSchema) {
        return new StreamSelectTableSink(tableSchema);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "operations should not be empty";
            }
        });
        Buffer astWithUpdatesAsRetractionTuples = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(operations).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;

            public final Tuple2<RelNode, Object> apply(Operation x0$1) {
                Operation operation;
                block7: {
                    Tuple2<RelNode, Object> tuple2;
                    block6: {
                        block5: {
                            Tuple2<RelNode, Object> tuple22;
                            operation = x0$1;
                            if (!(operation instanceof QueryOperation)) break block5;
                            QueryOperation queryOperation = (QueryOperation)operation;
                            RelNode relNode = this.$outer.getRelBuilder().tableOperation(queryOperation).build();
                            RelNode relNode2 = relNode;
                            if (relNode2 instanceof LogicalTableModify) {
                                LogicalTableModify logicalTableModify = (LogicalTableModify)relNode2;
                                List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                                Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "the length of qualified name should be 3.";
                                    }
                                });
                                CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of((String)qualifiedName.get(0), (String)qualifiedName.get(1), (String)qualifiedName.get(2)), (QueryOperation)new PlannerQueryOperation(logicalTableModify.getInput()));
                                tuple22 = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToRel((ModifyOperation)modifyOperation);
                            } else {
                                tuple22 = new Tuple2<RelNode, Object>((Object)relNode, (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            }
                            tuple2 = tuple22;
                            break block6;
                        }
                        if (!(operation instanceof ModifyOperation)) break block7;
                        ModifyOperation modifyOperation = (ModifyOperation)operation;
                        tuple2 = this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToRel(modifyOperation);
                    }
                    return tuple2;
                }
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.getClass().getCanonicalName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Buffer optimizedNodes = (Buffer)astWithUpdatesAsRetractionTuples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;

            public final RelNode apply(Tuple2<RelNode, Object> x0$2) {
                Tuple2<RelNode, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    RelNode ast = (RelNode)tuple2._1();
                    boolean updatesAsRetraction = tuple2._2$mcZ$sp();
                    RelNode relNode = this.$outer.optimizer().optimize(ast, updatesAsRetraction, this.$outer.getRelBuilder());
                    return relNode;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        StreamPlanner planner = this.createDummyPlanner();
        Buffer dataStreams = (Buffer)optimizedNodes.map((Function1)new Serializable(this, planner){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;
            private final StreamPlanner planner$2;

            public final DataStream<CRow> apply(RelNode p) {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$translateToCRow(this.planner$2, p);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.planner$2 = planner$2;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        String astPlan = ((TraversableOnce)astWithUpdatesAsRetractionTuples.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<RelNode, Object> p) {
                return RelOptUtil.toString((RelNode)p._1());
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        String optimizedPlan = ((TraversableOnce)optimizedNodes.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(RelNode x$1) {
                return RelOptUtil.toString(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString(System.lineSeparator());
        StreamExecutionEnvironment env = ((DataStream)dataStreams.head()).getExecutionEnvironment();
        String jsonSqlPlan = env.getExecutionPlan();
        String sqlPlan = PlanJsonParser.getSqlExecutionPlan(jsonSqlPlan, Predef$.MODULE$.boolean2Boolean(false));
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Abstract Syntax Tree =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{astPlan}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Optimized Logical Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizedPlan}))).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"== Physical Execution Plan =="})).s((Seq)Nil$.MODULE$)).append((Object)System.lineSeparator()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlPlan}))).toString();
    }

    public String[] getCompletionHints(String statement, int position) {
        FlinkPlannerImpl planner = this.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
        return planner.getCompletionHints(statement, position);
    }

    public Tuple2<RelNode, Object> org$apache$flink$table$planner$StreamPlanner$$translateToRel(ModifyOperation modifyOperation) {
        block8: {
            OutputConversionModifyOperation.UpdateMode updateMode;
            block12: {
                Tuple2.mcZZ.sp sp2;
                block13: {
                    Tuple2 tuple2;
                    block5: {
                        Tuple2.mcZZ.sp sp3;
                        Tuple2.mcZZ.sp sp4;
                        OutputConversionModifyOperation outputConversionModifyOperation;
                        block10: {
                            block11: {
                                block9: {
                                    ModifyOperation modifyOperation2;
                                    block6: {
                                        Option option;
                                        CatalogSinkModifyOperation catalogSinkModifyOperation;
                                        block7: {
                                            Tuple2 t;
                                            Tuple2 tuple22;
                                            block4: {
                                                modifyOperation2 = modifyOperation;
                                                if (!(modifyOperation2 instanceof UnregisteredSinkModifyOperation)) break block4;
                                                UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
                                                tuple2 = this.org$apache$flink$table$planner$StreamPlanner$$writeToSink(unregisteredSinkModifyOperation.getChild(), unregisteredSinkModifyOperation.getSink(), "UnregisteredSink");
                                                break block5;
                                            }
                                            if (!(modifyOperation2 instanceof CatalogSinkModifyOperation)) break block6;
                                            catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
                                            option = this.getTableSink(catalogSinkModifyOperation.getTableIdentifier()).map((Function1)new Serializable(this, catalogSinkModifyOperation){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ StreamPlanner $outer;
                                                private final CatalogSinkModifyOperation x3$1;

                                                public final Tuple2<RelNode, Object> apply(TableSink<?> sink) {
                                                    TableSinkUtils$.MODULE$.validateSink(this.x3$1.getStaticPartitions(), this.x3$1.getChild(), this.x3$1.getTableIdentifier(), sink);
                                                    TableSink<?> tableSink = sink;
                                                    if (tableSink instanceof PartitionableTableSink) {
                                                        PartitionableTableSink partitionableTableSink = (PartitionableTableSink)tableSink;
                                                        partitionableTableSink.setStaticPartition(this.x3$1.getStaticPartitions());
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    TableSink<?> tableSink2 = sink;
                                                    if (tableSink2 instanceof OverwritableTableSink) {
                                                        OverwritableTableSink overwritableTableSink = (OverwritableTableSink)tableSink2;
                                                        overwritableTableSink.setOverwrite(this.x3$1.isOverwrite());
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    } else {
                                                        Predef$.MODULE$.assert(!this.x3$1.isOverwrite(), (Function0)new Serializable(this, sink){
                                                            public static final long serialVersionUID = 0L;
                                                            private final TableSink sink$1;

                                                            public final String apply() {
                                                                return new StringBuilder().append((Object)"INSERT OVERWRITE requires ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " but actually got "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{OverwritableTableSink.class.getSimpleName()}))).append((Object)this.sink$1.getClass().getName()).toString();
                                                            }
                                                            {
                                                                this.sink$1 = sink$1;
                                                            }
                                                        });
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    }
                                                    return this.$outer.org$apache$flink$table$planner$StreamPlanner$$writeToSink(this.x3$1.getChild(), sink, this.x3$1.getTableIdentifier().asSummaryString());
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.x3$1 = x3$1;
                                                }
                                            });
                                            if (!(option instanceof Some)) break block7;
                                            Some some = (Some)option;
                                            tuple2 = tuple22 = (t = (Tuple2)some.x());
                                            break block5;
                                        }
                                        if (None$.MODULE$.equals(option)) {
                                            throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sink ", " does not exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{catalogSinkModifyOperation.getTableIdentifier()})));
                                        }
                                        throw new MatchError((Object)option);
                                    }
                                    if (!(modifyOperation2 instanceof OutputConversionModifyOperation)) break block8;
                                    outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
                                    updateMode = outputConversionModifyOperation.getUpdateMode();
                                    if (!OutputConversionModifyOperation.UpdateMode.RETRACT.equals(updateMode)) break block9;
                                    sp4 = new Tuple2.mcZZ.sp(true, true);
                                    break block10;
                                }
                                if (!OutputConversionModifyOperation.UpdateMode.APPEND.equals(updateMode)) break block11;
                                sp4 = new Tuple2.mcZZ.sp(false, false);
                                break block10;
                            }
                            if (!OutputConversionModifyOperation.UpdateMode.UPSERT.equals(updateMode)) break block12;
                            sp4 = new Tuple2.mcZZ.sp(false, true);
                        }
                        sp2 = sp4;
                        if (sp2 == null) break block13;
                        boolean isRetract = sp2._1$mcZ$sp();
                        boolean withChangeFlag = sp2._2$mcZ$sp();
                        Tuple2.mcZZ.sp sp5 = sp3 = new Tuple2.mcZZ.sp(isRetract, withChangeFlag);
                        boolean isRetract2 = sp5._1$mcZ$sp();
                        boolean withChangeFlag2 = sp5._2$mcZ$sp();
                        DataStreamTableSink tableSink = new DataStreamTableSink(outputConversionModifyOperation.getChild().getTableSchema(), TypeConversions.fromDataTypeToLegacyInfo((DataType)outputConversionModifyOperation.getType()), withChangeFlag2);
                        RelNode input = this.getRelBuilder().tableOperation(modifyOperation.getChild()).build();
                        LogicalSink sink = LogicalSink$.MODULE$.create(input, tableSink, "DataStreamTableSink");
                        tuple2 = new Tuple2((Object)sink, (Object)BoxesRunTime.boxToBoolean((boolean)isRetract2));
                    }
                    return tuple2;
                }
                throw new MatchError((Object)sp2);
            }
            throw new MatchError((Object)updateMode);
        }
        throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported ModifyOperation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modifyOperation})));
    }

    public FlinkPlannerImpl org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager.getCurrentCatalog();
        String currentDatabase = this.catalogManager.getCurrentDatabase();
        return this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createRelBuilder(currentCatalogName, currentDatabase);
    }

    public TableConfig getConfig() {
        return this.org$apache$flink$table$planner$StreamPlanner$$config;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return ((StreamExecutor)this.executor).getExecutionEnvironment();
    }

    public DataStream<CRow> org$apache$flink$table$planner$StreamPlanner$$translateToCRow(StreamPlanner planner, RelNode logicalPlan) {
        RelNode relNode = logicalPlan;
        if (relNode instanceof DataStreamRel) {
            DataStreamRel dataStreamRel = (DataStreamRel)relNode;
            this.getExecutionEnvironment().configure((ReadableConfig)this.org$apache$flink$table$planner$StreamPlanner$$config.getConfiguration(), Thread.currentThread().getContextClassLoader());
            DataStream<CRow> dataStream = dataStreamRel.translateToPlan(planner);
            return dataStream;
        }
        throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
    }

    public <T> Tuple2<RelNode, Object> org$apache$flink$table$planner$StreamPlanner$$writeToSink(QueryOperation tableOperation, TableSink<T> sink, String sinkName) {
        block8: {
            boolean bl;
            block6: {
                TableSink<T> tableSink;
                block7: {
                    block5: {
                        tableSink = sink;
                        if (!(tableSink instanceof RetractStreamTableSink)) break block5;
                        RetractStreamTableSink retractStreamTableSink = (RetractStreamTableSink)tableSink;
                        RetractStreamTableSink retractStreamTableSink2 = retractStreamTableSink;
                        if (retractStreamTableSink2 instanceof PartitionableTableSink) {
                            throw new TableException("Partitionable sink in retract stream mode is not supported yet!");
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        bl = true;
                        break block6;
                    }
                    if (!(tableSink instanceof UpsertStreamTableSink)) break block7;
                    UpsertStreamTableSink upsertStreamTableSink = (UpsertStreamTableSink)tableSink;
                    UpsertStreamTableSink upsertStreamTableSink2 = upsertStreamTableSink;
                    if (upsertStreamTableSink2 instanceof PartitionableTableSink) {
                        throw new TableException("Partitionable sink in upsert stream mode is not supported yet!");
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    bl = false;
                    break block6;
                }
                if (!(tableSink instanceof AppendStreamTableSink)) break block8;
                bl = false;
            }
            boolean updatesAsRetraction = bl;
            RelNode input = this.getRelBuilder().tableOperation(tableOperation).build();
            return new Tuple2((Object)LogicalSink$.MODULE$.create(input, sink, sinkName), (Object)BoxesRunTime.boxToBoolean((boolean)updatesAsRetraction));
        }
        throw new ValidationException("Stream Tables can only be emitted by AppendStreamTableSink, RetractStreamTableSink, or UpsertStreamTableSink.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<TableSink<?>> getTableSink(ObjectIdentifier objectIdentifier) {
        boolean bl = false;
        Some some = null;
        Option option = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager.getTable(objectIdentifier)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CatalogBaseTable apply(CatalogManager.TableLookupResult x$3) {
                return x$3.getTable();
            }
        });
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CatalogBaseTable s = (CatalogBaseTable)some.x();
            if (s instanceof ConnectorCatalogTable) {
                return JavaScalaConversionUtil$.MODULE$.toScala(((ConnectorCatalogTable)s).getTableSink());
            }
        }
        if (!bl) return None$.MODULE$;
        CatalogBaseTable s = (CatalogBaseTable)some.x();
        if (!(s instanceof CatalogTable)) return None$.MODULE$;
        Optional catalog = this.catalogManager.getCatalog(objectIdentifier.getCatalogName());
        CatalogTable catalogTable = (CatalogTable)s;
        TableSinkFactoryContextImpl context = new TableSinkFactoryContextImpl(objectIdentifier, catalogTable, (ReadableConfig)this.org$apache$flink$table$planner$StreamPlanner$$config.getConfiguration(), false);
        if (!catalog.isPresent()) return Option$.MODULE$.apply((Object)TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context));
        if (!((Catalog)catalog.get()).getTableFactory().isPresent()) return Option$.MODULE$.apply((Object)TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context));
        Optional sink = TableFactoryUtil.createTableSinkForCatalogTable((Catalog)((Catalog)catalog.get()), (TableSinkFactory.Context)context);
        if (!sink.isPresent()) return Option$.MODULE$.apply((Object)TableFactoryUtil.findAndCreateTableSink((TableSinkFactory.Context)context));
        return Option$.MODULE$.apply(sink.get());
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecutionEnvironment());
        StreamExecutor executor = new StreamExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.org$apache$flink$table$planner$StreamPlanner$$config, this.functionCatalog, this.catalogManager);
    }

    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.executor = executor;
        this.org$apache$flink$table$planner$StreamPlanner$$config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.internalSchema = CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, config, true));
        this.expressionBridge = new ExpressionBridge(PlannerExpressionConverter$.MODULE$.INSTANCE());
        this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder = new PlanningConfigurationBuilder(config, functionCatalog, this.internalSchema(), this.expressionBridge());
        this.optimizer = new StreamOptimizer((Function0<CalciteConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamPlanner $outer;

            public final CalciteConfig apply() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$config.getPlannerConfig().unwrap(CalciteConfig.class).orElse(CalciteConfig$.MODULE$.DEFAULT());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder());
        this.parser = new ParserImpl(catalogManager, new Supplier<FlinkPlannerImpl>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public FlinkPlannerImpl get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$getFlinkPlanner();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Supplier<CalciteParser>(this){
            private final /* synthetic */ StreamPlanner $outer;

            public CalciteParser get() {
                return this.$outer.org$apache$flink$table$planner$StreamPlanner$$planningConfigurationBuilder().createCalciteParser();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

