/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.SelectTableSink;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.SelectTableSinkSchemaConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;

public class BatchSelectTableSink
implements BatchTableSink<Row>,
SelectTableSink {
    private final TableSchema tableSchema;
    private final String accumulatorName;
    private final TypeSerializer<Row> typeSerializer;
    private JobClient jobClient;

    public BatchSelectTableSink(TableSchema tableSchema) {
        this.tableSchema = SelectTableSinkSchemaConverter.convertTimeAttributeToRegularTimestamp(tableSchema);
        this.accumulatorName = new AbstractID().toString();
        this.typeSerializer = this.tableSchema.toRowType().createSerializer(new ExecutionConfig());
    }

    public DataType getConsumedDataType() {
        return this.tableSchema.toRowDataType();
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public DataSink<?> consumeDataSet(DataSet<Row> dataSet) {
        return dataSet.output((OutputFormat)new Utils.CollectHelper(this.accumulatorName, this.typeSerializer)).name("Batch select table sink").setParallelism(1);
    }

    public void setJobClient(JobClient jobClient) {
        this.jobClient = (JobClient)Preconditions.checkNotNull((Object)jobClient, (String)"jobClient should not be null");
    }

    public CloseableIterator<Row> getResultIterator() {
        List rowList;
        JobExecutionResult jobExecutionResult;
        Preconditions.checkNotNull((Object)this.jobClient, (String)"jobClient is null, please call setJobClient first.");
        try {
            jobExecutionResult = (JobExecutionResult)this.jobClient.getJobExecutionResult(Thread.currentThread().getContextClassLoader()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new TableException("Failed to get job execution result.", (Throwable)e);
        }
        ArrayList accResult = (ArrayList)jobExecutionResult.getAccumulatorResult(this.accumulatorName);
        if (accResult == null) {
            throw new TableException("result is null.");
        }
        try {
            rowList = SerializedListAccumulator.deserializeList((ArrayList)accResult, this.typeSerializer);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new TableException("Failed to deserialize the result.", (Throwable)e);
        }
        return CloseableIterator.adapterForIterator(rowList.iterator());
    }
}

