/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.parse.CalciteParser;

@Internal
public class SqlToRexConverter {
    private final FlinkPlannerImpl planner;
    private final SqlDialect sqlDialect;
    private final RelDataType inputRowType;
    @Nullable
    private final RelDataType outputType;

    public SqlToRexConverter(FlinkPlannerImpl planner, SqlDialect sqlDialect, RelDataType inputRowType, @Nullable RelDataType outputType) {
        this.planner = planner;
        this.sqlDialect = sqlDialect;
        this.inputRowType = inputRowType;
        this.outputType = outputType;
    }

    public String expand(String expr) {
        CalciteParser parser = this.planner.parser();
        SqlNode node = parser.parseExpression(expr);
        SqlNode validated = this.planner.validateExpression(node, this.inputRowType, this.outputType);
        return validated.toSqlString(this.sqlDialect).getSql();
    }

    public RexNode convertToRexNode(String expr) {
        CalciteParser parser = this.planner.parser();
        return this.planner.rex(parser.parseExpression(expr), this.inputRowType, this.outputType);
    }

    public RexNode[] convertToRexNodes(String[] exprs) {
        CalciteParser parser = this.planner.parser();
        return (RexNode[])Stream.of(exprs).map(parser::parseExpression).map(node -> this.planner.rex((SqlNode)node, this.inputRowType, null)).toArray(RexNode[]::new);
    }
}

