/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.ExecNodeGraphInternalPlan;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.serde.JsonSerdeUtil;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.optimize.StreamCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.trait.MiniBatchIntervalTraitDef$;
import org.apache.flink.table.planner.plan.trait.ModifyKindSetTraitDef$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0001\u0003\u0001=\u0011Qb\u0015;sK\u0006l\u0007\u000b\\1o]\u0016\u0014(BA\u0002\u0005\u0003)!W\r\\3hCRLwN\u001c\u0006\u0003\u000b\u0019\tq\u0001\u001d7b]:,'O\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005-\u0001F.\u00198oKJ\u0014\u0015m]3\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001\"\u001a=fGV$xN\u001d\t\u0003/ei\u0011\u0001\u0007\u0006\u0003\u0007\u0019I!A\u0007\r\u0003\u0011\u0015CXmY;u_JD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\fi\u0006\u0014G.Z\"p]\u001aLw\r\u0005\u0002\u001fC5\tqD\u0003\u0002!\r\u0005\u0019\u0011\r]5\n\u0005\tz\"a\u0003+bE2,7i\u001c8gS\u001eD\u0011\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0016\u0002\u001b5|G-\u001e7f\u001b\u0006t\u0017mZ3s!\t1\u0013&D\u0001(\u0015\tAc!\u0001\u0004n_\u0012,H.Z\u0005\u0003U\u001d\u0012Q\"T8ek2,W*\u00198bO\u0016\u0014\u0018B\u0001\u0013\u0013\u0011%i\u0003A!A!\u0002\u0013qC'A\bgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h!\ty#'D\u00011\u0015\t\td!A\u0004dCR\fGn\\4\n\u0005M\u0002$a\u0004$v]\u000e$\u0018n\u001c8DCR\fGn\\4\n\u00055\u0012\u0002\"\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u001c;\u00039\u0019\u0017\r^1m_\u001el\u0015M\\1hKJ\u0004\"a\f\u001d\n\u0005e\u0002$AD\"bi\u0006dwnZ'b]\u0006<WM]\u0005\u0003mIA\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!P\u0001\fG2\f7o\u001d'pC\u0012,'\u000f\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!A.\u00198h\u0015\u0005\u0011\u0015\u0001\u00026bm\u0006L!\u0001R \u0003\u0017\rc\u0017m]:M_\u0006$WM\u001d\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f!K%j\u0013'N\u001dB\u0011\u0011\u0003\u0001\u0005\u0006+\u0015\u0003\rA\u0006\u0005\u00069\u0015\u0003\r!\b\u0005\u0006I\u0015\u0003\r!\n\u0005\u0006[\u0015\u0003\rA\f\u0005\u0006m\u0015\u0003\ra\u000e\u0005\u0006y\u0015\u0003\r!\u0010\u0005\u0006!\u0002!\t&U\u0001\rO\u0016$HK]1ji\u0012+gm]\u000b\u0002%B\u00191K\u0016-\u000e\u0003QS\u0011!V\u0001\u0006g\u000e\fG.Y\u0005\u0003/R\u0013Q!\u0011:sCf\u0004$!W2\u0011\u0007i{\u0016-D\u0001\\\u0015\taV,\u0001\u0003qY\u0006t'B\u00010\u000b\u0003\u001d\u0019\u0017\r\\2ji\u0016L!\u0001Y.\u0003\u0017I+G\u000e\u0016:bSR$UM\u001a\t\u0003E\u000ed\u0001\u0001B\u0005e\u001f\u0006\u0005\t\u0011!B\u0001K\n\u0019q\fJ\u0019\u0012\u0005\u0019L\u0007CA*h\u0013\tAGKA\u0004O_RD\u0017N\\4\u0011\u0005iS\u0017BA6\\\u0005!\u0011V\r\u001c+sC&$\b\"B7\u0001\t#r\u0017\u0001D4fi>\u0003H/[7ju\u0016\u0014X#A8\u0011\u0005A$X\"A9\u000b\u0005I\u001c\u0018\u0001C8qi&l\u0017N_3\u000b\u0005q#\u0011BA;r\u0005%y\u0005\u000f^5nSj,'\u000fC\u0003x\u0001\u0011E\u00030\u0001\u000ehKR,\u00050Z2O_\u0012,wI]1qQB\u0013xnY3tg>\u00148/F\u0001z!\u0015Q\u0018QAA\u0006\u001d\rY\u0018\u0011\u0001\b\u0003y~l\u0011! \u0006\u0003}:\ta\u0001\u0010:p_Rt\u0014\"A+\n\u0007\u0005\rA+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0011\u0011\u0002\u0002\u0004'\u0016\f(bAA\u0002)B!\u0011QBA\u000e\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!\u00039s_\u000e,7o]8s\u0015\u0011\t)\"a\u0006\u0002\t\u0015DXm\u0019\u0006\u0004\u00033\u0019\u0018!\u00028pI\u0016\u001c\u0018\u0002BA\u000f\u0003\u001f\u0011a#\u0012=fG:{G-Z$sCBD\u0007K]8dKN\u001cxN\u001d\u0005\b\u0003C\u0001A\u0011KA\u0012\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tG\u0003BA\u0013\u0003\u001f\u0002b!a\n\u0002.\u0005ERBAA\u0015\u0015\r\tY#Q\u0001\u0005kRLG.\u0003\u0003\u00020\u0005%\"\u0001\u0002'jgR\u0004D!a\r\u0002DA1\u0011QGA\u001f\u0003\u0003j!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0004I\u0006<'B\u0001\u0011\t\u0013\u0011\ty$a\u000e\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B\u0019!-a\u0011\u0005\u0019\u0005\u0015\u0013qDA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\u0007}##'E\u0002g\u0003\u0013\u00022aUA&\u0013\r\ti\u0005\u0016\u0002\u0004\u0003:L\b\u0002CA)\u0003?\u0001\r!a\u0015\u0002\u0013\u0015DXmY$sCBD\u0007\u0003BA+\u0003/j!!a\u0005\n\t\u0005e\u00131\u0003\u0002\u000e\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`\u00059Q\r\u001f9mC&tGCBA1\u0003c\n\t\t\u0005\u0003\u0002d\u0005-d\u0002BA3\u0003O\u0002\"\u0001 +\n\u0007\u0005%D+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\nyG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S\"\u0006\u0002CA:\u00037\u0002\r!!\u001e\u0002\u0015=\u0004XM]1uS>t7\u000f\u0005\u0004\u0002(\u00055\u0012q\u000f\t\u0005\u0003s\ni(\u0004\u0002\u0002|)\u0019\u00111\u000f\u0004\n\t\u0005}\u00141\u0010\u0002\n\u001fB,'/\u0019;j_:D\u0001\"a!\u0002\\\u0001\u0007\u0011QQ\u0001\rKb$(/\u0019#fi\u0006LGn\u001d\t\u0006'\u0006\u001d\u00151R\u0005\u0004\u0003\u0013#&A\u0003\u001fsKB,\u0017\r^3e}A\u0019a$!$\n\u0007\u0005=uDA\u0007FqBd\u0017-\u001b8EKR\f\u0017\u000e\u001c\u0005\b\u0003'\u0003A\u0011BAK\u0003I\u0019'/Z1uK\u0012+X.\\=QY\u0006tg.\u001a:\u0015\u0003!Cq!!'\u0001\t\u0003\nY*\u0001\u0005m_\u0006$\u0007\u000b\\1o)\u0011\ti*a)\u0011\u0007]\ty*C\u0002\u0002\"b\u0011A\"\u00138uKJt\u0017\r\u001c)mC:D\u0001\"!*\u0002\u0018\u0002\u0007\u0011qU\u0001\u000ea2\fgNU3gKJ,gnY3\u0011\u0007y\tI+C\u0002\u0002,~\u0011Q\u0002\u00157b]J+g-\u001a:f]\u000e,\u0007bBAX\u0001\u0011\u0005\u0013\u0011W\u0001\fG>l\u0007/\u001b7f!2\fg\u000e\u0006\u0003\u0002\u001e\u0006M\u0006\u0002CA[\u0003[\u0003\r!a.\u0002!5|G-\u001b4z\u001fB,'/\u0019;j_:\u001c\bCBA\u0014\u0003[\tI\f\u0005\u0003\u0002z\u0005m\u0016\u0002BA_\u0003w\u0012q\"T8eS\u001aLx\n]3sCRLwN\u001c\u0005\b\u0003\u0003\u0004A\u0011IAb\u00035!(/\u00198tY\u0006$X\r\u00157b]R!\u0011QYAi!\u0019\t9#!\f\u0002HB\"\u0011\u0011ZAg!\u0019\t)$!\u0010\u0002LB\u0019!-!4\u0005\u0019\u0005=\u0017qXA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\u0007}#3\u0007C\u0004]\u0003\u007f\u0003\r!!(\t\u000f\u0005U\u0007\u0001\"\u0011\u0002X\u0006YQ\r\u001f9mC&t\u0007\u000b\\1o)\u0019\t\t'!7\u0002\\\"9A,a5A\u0002\u0005u\u0005\u0002CAB\u0003'\u0004\r!!\"\t\u000f\u0005}\u0007\u0001\"\u0011\u0002b\u0006\t\"-\u001a4pe\u0016$&/\u00198tY\u0006$\u0018n\u001c8\u0015\u0005\u0005\r\bcA*\u0002f&\u0019\u0011q\u001d+\u0003\tUs\u0017\u000e\u001e")
public class StreamPlanner
extends PlannerBase {
    private final Executor executor;
    private final TableConfig tableConfig;
    private final ClassLoader classLoader;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), MiniBatchIntervalTraitDef$.MODULE$.INSTANCE(), ModifyKindSetTraitDef$.MODULE$.INSTANCE(), UpdateKindTraitDef$.MODULE$.INSTANCE()});
    }

    @Override
    public Optimizer getOptimizer() {
        return new StreamCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.beforeTranslation();
        StreamPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (!(execNode instanceof StreamExecNode)) {
                throw new TableException("Cannot generate DataStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            StreamExecNode streamExecNode = (StreamExecNode)execNode;
            Transformation transformation = streamExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom());
        this.afterTranslation();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations.$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(planner.extraTransformations())));
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        Tuple4<Buffer<RelNode>, Seq<RelNode>, ExecNodeGraph, StreamGraph> tuple4 = this.getExplainGraphs(operations);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Buffer sinkRelNodes = (Buffer)tuple4._1();
        Seq optimizedRelNodes = (Seq)tuple4._2();
        ExecNodeGraph execGraph = (ExecNodeGraph)tuple4._3();
        StreamGraph streamGraph = (StreamGraph)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)sinkRelNodes, (Object)optimizedRelNodes, (Object)execGraph, (Object)streamGraph);
        Tuple4 tuple43 = tuple42;
        Buffer sinkRelNodes2 = (Buffer)tuple43._1();
        Seq optimizedRelNodes2 = (Seq)tuple43._2();
        ExecNodeGraph execGraph2 = (ExecNodeGraph)tuple43._3();
        StreamGraph streamGraph2 = (StreamGraph)tuple43._4();
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes2.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, SqlExplainLevel.EXPPLAN_ATTRIBUTES, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5(), FlinkRelOptUtil$.MODULE$.toString$default$6(), FlinkRelOptUtil$.MODULE$.toString$default$7()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.DIGEST_ATTRIBUTES;
        boolean withChangelogTraits = extraDetails.contains((Object)ExplainDetail.CHANGELOG_MODE);
        optimizedRelNodes2.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            RelNode x$2 = rel;
            SqlExplainLevel x$3 = explainLevel;
            boolean x$4 = withChangelogTraits;
            boolean x$5 = FlinkRelOptUtil$.MODULE$.toString$default$3();
            boolean x$6 = FlinkRelOptUtil$.MODULE$.toString$default$5();
            boolean x$7 = FlinkRelOptUtil$.MODULE$.toString$default$6();
            boolean x$8 = FlinkRelOptUtil$.MODULE$.toString$default$7();
            sb.append(FlinkRelOptUtil$.MODULE$.toString(x$2, x$3, x$5, x$4, x$6, x$7, x$8));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph2));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph2.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private StreamPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new StreamPlanner(executor, this.tableConfig, super.moduleManager(), super.functionCatalog(), super.catalogManager(), this.classLoader);
    }

    public InternalPlan loadPlan(PlanReference planReference) {
        ExecNodeGraph execNodeGraph;
        SerdeContext ctx = this.createSerdeContext();
        ObjectReader objectReader = JsonSerdeUtil.createObjectReader(ctx);
        PlanReference planReference2 = planReference;
        if (planReference2 instanceof PlanReference.FilePlanReference) {
            PlanReference.FilePlanReference filePlanReference = (PlanReference.FilePlanReference)planReference2;
            execNodeGraph = (ExecNodeGraph)objectReader.readValue(filePlanReference.getFile(), ExecNodeGraph.class);
        } else if (planReference2 instanceof PlanReference.ContentPlanReference) {
            PlanReference.ContentPlanReference contentPlanReference = (PlanReference.ContentPlanReference)planReference2;
            execNodeGraph = (ExecNodeGraph)objectReader.readValue(contentPlanReference.getContent(), ExecNodeGraph.class);
        } else if (planReference2 instanceof PlanReference.ResourcePlanReference) {
            PlanReference.ResourcePlanReference resourcePlanReference = (PlanReference.ResourcePlanReference)planReference2;
            URL url = resourcePlanReference.getClassLoader().getResource(resourcePlanReference.getResourcePath());
            if (url == null) {
                throw new IOException(new java.lang.StringBuilder(47).append("Cannot load the plan reference from classpath: ").append(planReference).toString());
            }
            execNodeGraph = (ExecNodeGraph)objectReader.readValue(new File(url.toURI()), ExecNodeGraph.class);
        } else {
            throw new IllegalStateException("Unknown PlanReference. This is a bug, please contact the developers");
        }
        ExecNodeGraph execNodeGraph2 = execNodeGraph;
        return new ExecNodeGraphInternalPlan(JsonSerdeUtil.createObjectWriter(ctx).withDefaultPrettyPrinter().writeValueAsString((Object)execNodeGraph2), execNodeGraph2);
    }

    public InternalPlan compilePlan(List<ModifyOperation> modifyOperations) {
        this.beforeTranslation();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes, true);
        this.afterTranslation();
        return new ExecNodeGraphInternalPlan(JsonSerdeUtil.createObjectWriter(this.createSerdeContext()).withDefaultPrettyPrinter().writeValueAsString((Object)execGraph), execGraph);
    }

    /*
     * WARNING - void declaration
     */
    public List<Transformation<?>> translatePlan(InternalPlan plan) {
        void var3_3;
        this.beforeTranslation();
        ExecNodeGraph execGraph = ((ExecNodeGraphInternalPlan)plan).getExecNodeGraph();
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        return var3_3;
    }

    public String explainPlan(InternalPlan plan, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        this.beforeTranslation();
        ExecNodeGraph execGraph = ((ExecNodeGraphInternalPlan)plan).getExecNodeGraph();
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.afterTranslation();
        StreamGraph streamGraph = (StreamGraph)this.executor.createPipeline(transformations, (ReadableConfig)this.tableConfig.getConfiguration(), null);
        StringBuilder sb = new StringBuilder();
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    @Override
    public void beforeTranslation() {
        RuntimeExecutionMode runtimeMode;
        super.beforeTranslation();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getTableConfig().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.STREAMING;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    public String explainPlan(InternalPlan plan, ExplainDetail[] extraDetails) {
        return this.explainPlan(plan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public StreamPlanner(Executor executor, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager, ClassLoader classLoader) {
        this.executor = executor;
        this.tableConfig = tableConfig;
        this.classLoader = classLoader;
        super(executor, tableConfig, moduleManager, functionCatalog, catalogManager, true, classLoader);
    }
}

