/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.utils.IntervalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.JoinTypeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.plan.utils.TemporalJoinUtil$;
import org.apache.flink.table.planner.plan.utils.WindowJoinUtil$;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class JoinUtil$ {
    public static JoinUtil$ MODULE$;

    static {
        new JoinUtil$();
    }

    public JoinSpec createJoinSpec(Join join) {
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        JoinInfo joinInfo = this.createJoinInfo(join.getLeft(), join.getRight(), join.getCondition(), filterNulls);
        RexNode nonEquiCondition = RexUtil.composeConjunction(join.getCluster().getRexBuilder(), joinInfo.nonEquiConditions);
        return new JoinSpec(JoinTypeUtil.getFlinkJoinType(join.getJoinType()), joinInfo.leftKeys.toIntArray(), joinInfo.rightKeys.toIntArray(), (boolean[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(filterNulls).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Boolean()), nonEquiCondition);
    }

    public void validateJoinSpec(JoinSpec joinSpec, RowType leftType, RowType rightType, boolean allowEmptyKey) {
        if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(joinSpec.getLeftKeys())).isEmpty() && !allowEmptyKey) {
            throw new TableException(new StringBuilder(136).append("Joins should have at least one equality condition.\n").append(new StringBuilder(27).append("\tLeft type: ").append(leftType).append("\n\tright type: ").append(rightType).append("\n").toString()).append("please re-check the join statement and make sure there's ").append("equality condition for join.").toString());
        }
        int[] leftKeys = joinSpec.getLeftKeys();
        int[] rightKeys = joinSpec.getRightKeys();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), joinSpec.getJoinKeySize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
            LogicalType rightKeyType;
            LogicalType leftKeyType = leftType.getTypeAt(leftKeys[idx]);
            if (!PlannerTypeUtils.isInteroperable((LogicalType)leftKeyType, (LogicalType)(rightKeyType = rightType.getTypeAt(rightKeys[idx])))) {
                throw new TableException(new StringBuilder(88).append("Join: Equality join predicate on incompatible types. ").append(new StringBuilder(27).append("\tLeft type: ").append(leftType).append("\n\tright type: ").append(rightType).append("\n").toString()).append("please re-check the join statement.").toString());
            }
        });
    }

    public boolean validateJoinSpec$default$4() {
        return false;
    }

    public JoinInfo createJoinInfo(RelNode left, RelNode right, RexNode condition, List<Boolean> filterNulls) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, leftKeys, rightKeys, filterNulls);
        return remaining.isAlwaysTrue() ? JoinInfo.of(ImmutableIntList.copyOf(leftKeys), ImmutableIntList.copyOf(rightKeys)) : JoinInfo.of(left, right, condition);
    }

    public GeneratedJoinCondition generateConditionFunction(ReadableConfig tableConfig, ClassLoader classLoader, JoinSpec joinSpec, LogicalType leftType, LogicalType rightType) {
        return this.generateConditionFunction(tableConfig, classLoader, (RexNode)joinSpec.getNonEquiCondition().orElse(null), leftType, rightType);
    }

    public GeneratedJoinCondition generateConditionFunction(ReadableConfig tableConfig, ClassLoader classLoader, RexNode nonEquiCondition, LogicalType leftType, LogicalType rightType) {
        String string;
        CodeGeneratorContext ctx = new CodeGeneratorContext(tableConfig, classLoader);
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        LogicalType x$3 = leftType;
        String x$4 = qual$1.bindInput$default$2();
        Option<int[]> x$5 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput(x$3, x$4, x$5);
        LogicalType x$6 = rightType;
        String x$7 = qual$2.bindSecondInput$default$2();
        Option<int[]> x$8 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprGenerator = qual$2.bindSecondInput(x$6, x$7, x$8);
        if (nonEquiCondition == null) {
            string = "return true;";
        } else {
            GeneratedExpression condition = exprGenerator.generateExpression(nonEquiCondition);
            string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(condition.code()).append("\n         |return ").append(condition.resultTerm()).append(";\n         |").toString())).stripMargin();
        }
        String body = string;
        return FunctionCodeGenerator$.MODULE$.generateJoinCondition(ctx, "ConditionFunction", body, FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$4(), FunctionCodeGenerator$.MODULE$.generateJoinCondition$default$5());
    }

    public JoinInputSideSpec analyzeJoinInput(ClassLoader classLoader, InternalTypeInfo<RowData> inputTypeInfo, int[] joinKeys, List<int[]> uniqueKeys) {
        JoinInputSideSpec joinInputSideSpec;
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            joinInputSideSpec = JoinInputSideSpec.withoutUniqueKey();
        } else {
            HashSet joinKeySet = new HashSet();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(joinKeys)).map((Function1 & Serializable & scala.Serializable)x -> JoinUtil$.$anonfun$analyzeJoinInput$1(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)joinKeySet.add(x$1)));
            Buffer uniqueKeysContainedByJoinKey = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(uniqueKeys).filter((Function1 & Serializable & scala.Serializable)uk -> BoxesRunTime.boxToBoolean((boolean)joinKeySet.containsAll(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(uk)).toList()))));
            if (uniqueKeysContainedByJoinKey.isEmpty()) {
                int[] smallestUniqueKey = this.getSmallestKey(uniqueKeys);
                RowDataKeySelector uniqueKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, smallestUniqueKey, inputTypeInfo);
                InternalTypeInfo uniqueKeyTypeInfo = uniqueKeySelector.getProducedType();
                joinInputSideSpec = JoinInputSideSpec.withUniqueKey((InternalTypeInfo)uniqueKeyTypeInfo, (KeySelector)uniqueKeySelector);
            } else {
                int[] smallestUniqueKey = this.getSmallestKey(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(uniqueKeysContainedByJoinKey));
                RowDataKeySelector uniqueKeySelector = KeySelectorUtil.getRowDataSelector(classLoader, smallestUniqueKey, inputTypeInfo);
                InternalTypeInfo uniqueKeyTypeInfo = uniqueKeySelector.getProducedType();
                joinInputSideSpec = JoinInputSideSpec.withUniqueKeyContainedByJoinKey((InternalTypeInfo)uniqueKeyTypeInfo, (KeySelector)uniqueKeySelector);
            }
        }
        return joinInputSideSpec;
    }

    private int[] getSmallestKey(List<int[]> keys) {
        return (int[])JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(keys).reduce((Function2 & Serializable & scala.Serializable)(k1, k2) -> ((int[])k1).length <= ((int[])k2).length ? k1 : k2);
    }

    public boolean accessesTimeAttribute(RexNode expr, RelDataType inputType) {
        boolean bl;
        RexNode rexNode = expr;
        if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            RelDataType accessedType = inputType.getFieldList().get(rexInputRef.getIndex()).getType();
            bl = FlinkTypeFactory$.MODULE$.isTimeIndicatorType(accessedType);
        } else if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            bl = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JoinUtil$.MODULE$.accessesTimeAttribute(x$2, inputType)));
        } else {
            bl = false;
        }
        return bl;
    }

    public RelDataType combineJoinInputsRowType(Join join) {
        JoinRelType joinRelType = join.getJoinType();
        boolean bl = ((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType);
        RelDataType relDataType = bl ? SqlValidatorUtil.createJoinType(join.getCluster().getTypeFactory(), join.getLeft().getRowType(), join.getRight().getRowType(), null, Collections.emptyList()) : join.getRowType();
        return relDataType;
    }

    public boolean satisfyRegularJoin(FlinkLogicalJoin join, RelNode newLeft, RelNode newRight) {
        return newRight instanceof FlinkLogicalSnapshot ? false : (TemporalJoinUtil$.MODULE$.satisfyTemporalJoin(join, newLeft, newRight) ? false : (IntervalJoinUtil$.MODULE$.satisfyIntervalJoin(join, newLeft, newRight) ? false : !WindowJoinUtil$.MODULE$.satisfyWindowJoin(join, newLeft, newRight)));
    }

    public static final /* synthetic */ Integer $anonfun$analyzeJoinInput$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private JoinUtil$() {
        MODULE$ = this;
    }
}

