/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.model.JsonCustomSchema;
import org.apache.calcite.model.JsonJdbcSchema;
import org.apache.calcite.model.JsonLattice;
import org.apache.calcite.model.JsonMapSchema;
import org.apache.calcite.model.JsonMaterialization;
import org.apache.calcite.model.ModelHandler;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", defaultImpl=JsonMapSchema.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=JsonMapSchema.class, name="map"), @JsonSubTypes.Type(value=JsonJdbcSchema.class, name="jdbc"), @JsonSubTypes.Type(value=JsonCustomSchema.class, name="custom")})
public abstract class JsonSchema {
    public final String name;
    public final @Nullable List<Object> path;
    public final List<JsonMaterialization> materializations = new ArrayList<JsonMaterialization>();
    public final List<JsonLattice> lattices = new ArrayList<JsonLattice>();
    public final @Nullable Boolean cache;
    public final @Nullable Boolean autoLattice;

    protected JsonSchema(String name, @Nullable List<Object> path, @Nullable Boolean cache, @Nullable Boolean autoLattice) {
        this.name = name;
        this.path = path;
        this.cache = cache;
        this.autoLattice = autoLattice;
    }

    public abstract void accept(ModelHandler var1);

    public void visitChildren(ModelHandler modelHandler) {
        for (JsonLattice jsonLattice : this.lattices) {
            jsonLattice.accept(modelHandler);
        }
        for (JsonMaterialization jsonMaterialization : this.materializations) {
            jsonMaterialization.accept(modelHandler);
        }
    }

    public static enum Type {
        MAP,
        JDBC,
        CUSTOM;

    }
}

