/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJsonValueReturning;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class SqlJsonValueFunction
extends SqlFunction {
    public SqlJsonValueFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ReturnTypes.cascade(opBinding -> SqlJsonValueFunction.explicitTypeSpec(opBinding).orElse(SqlJsonValueFunction.getDefaultType(opBinding)), SqlTypeTransforms.FORCE_NULLABLE), null, OperandTypes.family(ImmutableList.of(SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER), ordinal -> ordinal > 1), SqlFunctionCategory.SYSTEM);
    }

    private static RelDataType getDefaultType(SqlOperatorBinding opBinding) {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.createSqlType(SqlTypeName.VARCHAR, 2000);
    }

    public static List<SqlNode> removeTypeSpecOperands(SqlCall call) {
        @Nullable SqlNode[] operands = call.getOperandList().toArray(new SqlNode[0]);
        if (SqlJsonValueFunction.hasExplicitTypeSpec(operands)) {
            operands[2] = null;
            operands[3] = null;
        }
        return Arrays.stream(operands).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.between(2, 10);
    }

    private static Optional<RelDataType> explicitTypeSpec(SqlOperatorBinding opBinding) {
        if (opBinding.getOperandCount() > 2 && opBinding.isOperandLiteral(2, false) && opBinding.getOperandLiteralValue(2, Object.class) instanceof SqlJsonValueReturning) {
            return Optional.of(opBinding.getOperandType(3));
        }
        return Optional.empty();
    }

    public static boolean hasExplicitTypeSpec(@Nullable SqlNode[] operands) {
        return operands.length > 2 && SqlJsonValueFunction.isReturningTypeSymbol(operands[2]);
    }

    private static boolean isReturningTypeSymbol(@Nullable SqlNode node) {
        return node instanceof SqlLiteral && ((SqlLiteral)node).getValue() instanceof SqlJsonValueReturning;
    }

    @Override
    public String getAllowedSignatures(String opNameToUse) {
        return "JSON_VALUE(json_doc, path [RETURNING type] [{NULL | ERROR | DEFAULT value} ON EMPTY] [{NULL | ERROR | DEFAULT value} ON ERROR])";
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep(",", true);
        for (int i = 1; i < call.operandCount(); ++i) {
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
        }
        writer.endFunCall(frame);
    }
}

