/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.flink.sql.parser.ddl.SqlAddReplaceColumns;
import org.apache.flink.sql.parser.ddl.SqlChangeColumn;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlTableOption;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.ddl.AlterTableChangeOperation;
import org.apache.flink.table.operations.ddl.AlterTableSchemaOperation;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

public class OperationConverterUtils {
    private OperationConverterUtils() {
    }

    public static Operation convertAddReplaceColumns(ObjectIdentifier tableIdentifier, SqlAddReplaceColumns addReplaceColumns, CatalogTable catalogTable, SqlValidator sqlValidator) {
        TableSchema oldSchema = catalogTable.getSchema();
        int numPartCol = catalogTable.getPartitionKeys().size();
        Set lastCols = oldSchema.getTableColumns().subList(oldSchema.getFieldCount() - numPartCol, oldSchema.getFieldCount()).stream().map(TableColumn::getName).collect(Collectors.toSet());
        if (!lastCols.equals(new HashSet(catalogTable.getPartitionKeys()))) {
            throw new ValidationException("ADD/REPLACE COLUMNS on partitioned tables requires partition columns to appear last");
        }
        TableSchema.Builder builder = TableSchema.builder();
        if (!addReplaceColumns.isReplace()) {
            List nonPartCols = oldSchema.getTableColumns().subList(0, oldSchema.getFieldCount() - numPartCol);
            for (TableColumn column : nonPartCols) {
                builder.add(column);
            }
            OperationConverterUtils.setWatermarkAndPK(builder, catalogTable.getSchema());
        }
        ArrayList<TableChange.AddColumn> tableChanges = new ArrayList<TableChange.AddColumn>();
        for (Object sqlNode : addReplaceColumns.getNewColumns()) {
            TableColumn.PhysicalColumn tableColumn = OperationConverterUtils.toTableColumn((SqlTableColumn)sqlNode, sqlValidator);
            builder.add((TableColumn)tableColumn);
            if (addReplaceColumns.isReplace()) continue;
            tableChanges.add(TableChange.add((Column)Column.physical((String)tableColumn.getName(), (DataType)tableColumn.getType()).withComment(OperationConverterUtils.getComment((SqlTableColumn)sqlNode))));
        }
        List partCols = oldSchema.getTableColumns().subList(oldSchema.getFieldCount() - numPartCol, oldSchema.getFieldCount());
        for (TableColumn column : partCols) {
            builder.add(column);
        }
        HashMap<String, String> newProperties = new HashMap<String, String>(catalogTable.getOptions());
        newProperties.putAll(OperationConverterUtils.extractProperties(addReplaceColumns.getProperties()));
        CatalogTableImpl newTable = new CatalogTableImpl(builder.build(), catalogTable.getPartitionKeys(), newProperties, catalogTable.getComment());
        if (addReplaceColumns.isReplace()) {
            return new AlterTableSchemaOperation(tableIdentifier, (CatalogTable)newTable, addReplaceColumns.ifTableExists());
        }
        return new AlterTableChangeOperation(tableIdentifier, tableChanges, (CatalogTable)newTable, addReplaceColumns.ifTableExists());
    }

    public static Operation convertChangeColumn(ObjectIdentifier tableIdentifier, SqlChangeColumn changeColumn, ResolvedCatalogTable catalogTable, SqlValidator sqlValidator) {
        String oldName = changeColumn.getOldName().getSimple();
        if (catalogTable.getPartitionKeys().indexOf(oldName) >= 0) {
            throw new ValidationException("CHANGE COLUMN cannot be applied to partition columns");
        }
        TableSchema oldSchema = catalogTable.getSchema();
        boolean first = changeColumn.isFirst();
        String after = changeColumn.getAfter() == null ? null : changeColumn.getAfter().getSimple();
        TableColumn.PhysicalColumn newTableColumn = OperationConverterUtils.toTableColumn(changeColumn.getNewColumn(), sqlValidator);
        TableSchema newSchema = OperationConverterUtils.changeColumn(oldSchema, oldName, (TableColumn)newTableColumn, first, after);
        HashMap<String, String> newProperties = new HashMap<String, String>(catalogTable.getOptions());
        newProperties.putAll(OperationConverterUtils.extractProperties(changeColumn.getProperties()));
        List<TableChange> tableChanges = OperationConverterUtils.buildModifyColumnChange((Column)catalogTable.getResolvedSchema().getColumn(oldName).orElseThrow(() -> new ValidationException("Failed to get old column: " + oldName)), (Column)Column.physical((String)newTableColumn.getName(), (DataType)newTableColumn.getType()).withComment(OperationConverterUtils.getComment(changeColumn.getNewColumn())), (TableChange.ColumnPosition)(first ? TableChange.ColumnPosition.first() : (after == null ? null : TableChange.ColumnPosition.after((String)after))));
        return new AlterTableChangeOperation(tableIdentifier, tableChanges, (CatalogTable)new CatalogTableImpl(newSchema, catalogTable.getPartitionKeys(), newProperties, catalogTable.getComment()), false);
    }

    public static List<TableChange> buildModifyColumnChange(Column oldColumn, Column newColumn, @Nullable TableChange.ColumnPosition columnPosition) {
        if (oldColumn.isPhysical() && newColumn.isPhysical()) {
            ArrayList<TableChange> changes = new ArrayList<TableChange>();
            String newComment = newColumn.getComment().orElse(oldColumn.getComment().orElse(null));
            if (!newColumn.getComment().equals(oldColumn.getComment())) {
                changes.add((TableChange)TableChange.modifyColumnComment((Column)oldColumn, (String)newComment));
            }
            if (!oldColumn.getDataType().getLogicalType().equals((Object)newColumn.getDataType().getLogicalType())) {
                changes.add((TableChange)TableChange.modifyPhysicalColumnType((Column)oldColumn.withComment(newComment), (DataType)newColumn.getDataType()));
            }
            if (!Objects.equals(newColumn.getName(), oldColumn.getName())) {
                changes.add((TableChange)TableChange.modifyColumnName((Column)oldColumn.withComment(newComment).copy(newColumn.getDataType()), (String)newColumn.getName()));
            }
            if (columnPosition != null) {
                changes.add((TableChange)TableChange.modifyColumnPosition((Column)newColumn, (TableChange.ColumnPosition)columnPosition));
            }
            return changes;
        }
        return Collections.singletonList(TableChange.modify((Column)oldColumn, (Column)newColumn, (TableChange.ColumnPosition)columnPosition));
    }

    public static TableSchema changeColumn(TableSchema oldSchema, String oldName, TableColumn newTableColumn, boolean first, String after) {
        int oldIndex = Arrays.asList(oldSchema.getFieldNames()).indexOf(oldName);
        if (oldIndex < 0) {
            throw new ValidationException(String.format("Old column %s not found for CHANGE COLUMN", oldName));
        }
        List tableColumns = oldSchema.getTableColumns();
        if (!first && after == null || oldName.equals(after)) {
            tableColumns.set(oldIndex, newTableColumn);
        } else {
            tableColumns.remove(oldIndex);
            if (first) {
                tableColumns.add(0, newTableColumn);
            } else {
                int newIndex = tableColumns.stream().map(TableColumn::getName).collect(Collectors.toList()).indexOf(after);
                if (newIndex < 0) {
                    throw new ValidationException(String.format("After column %s not found for CHANGE COLUMN", after));
                }
                tableColumns.add(newIndex + 1, newTableColumn);
            }
        }
        TableSchema.Builder builder = TableSchema.builder();
        for (TableColumn column : tableColumns) {
            builder.add(column);
        }
        OperationConverterUtils.setWatermarkAndPK(builder, oldSchema);
        return builder.build();
    }

    @Nullable
    public static String getComment(SqlTableColumn column) {
        return column.getComment().map(SqlCharStringLiteral.class::cast).map(c -> c.getValueAs(String.class)).orElse(null);
    }

    private static TableColumn.PhysicalColumn toTableColumn(SqlTableColumn tableColumn, SqlValidator sqlValidator) {
        if (!(tableColumn instanceof SqlTableColumn.SqlRegularColumn)) {
            throw new TableException("Only regular columns are supported for this operation yet.");
        }
        SqlTableColumn.SqlRegularColumn regularColumn = (SqlTableColumn.SqlRegularColumn)tableColumn;
        String name = regularColumn.getName().getSimple();
        SqlDataTypeSpec typeSpec = regularColumn.getType();
        boolean nullable = typeSpec.getNullable() == null || typeSpec.getNullable() != false;
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(typeSpec.deriveType(sqlValidator, nullable));
        DataType dataType = TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
        return TableColumn.physical((String)name, (DataType)dataType);
    }

    private static void setWatermarkAndPK(TableSchema.Builder builder, TableSchema schema) {
        for (WatermarkSpec watermarkSpec : schema.getWatermarkSpecs()) {
            builder.watermark(watermarkSpec);
        }
        schema.getPrimaryKey().ifPresent(pk -> builder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
    }

    public static Map<String, String> extractProperties(SqlNodeList propList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (propList != null) {
            propList.getList().forEach(p -> properties.put(((SqlTableOption)p).getKeyString(), ((SqlTableOption)p).getValueString()));
        }
        return properties;
    }
}

