/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BinarySection;
import org.apache.flink.table.dataformat.LazyBinaryFormat;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;

public final class BinaryGeneric<T>
extends LazyBinaryFormat<T> {
    public BinaryGeneric(T javaObject) {
        super(javaObject);
    }

    public BinaryGeneric(MemorySegment[] segments, int offset, int sizeInBytes) {
        super(segments, offset, sizeInBytes);
    }

    public BinaryGeneric(MemorySegment[] segments, int offset, int sizeInBytes, T javaObject) {
        super(segments, offset, sizeInBytes, javaObject);
    }

    @Override
    protected BinarySection materialize(TypeSerializer<T> serializer) {
        try {
            byte[] bytes = InstantiationUtil.serializeToByteArray(serializer, (Object)this.javaObject);
            return new BinarySection(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> BinaryGeneric<T> readBinaryGenericFieldFromSegments(MemorySegment[] segments, int baseOffset, long offsetAndSize) {
        int size = (int)offsetAndSize;
        int offset = (int)(offsetAndSize >> 32);
        return new BinaryGeneric<Object>(segments, offset + baseOffset, size, null);
    }

    public static <T> T getJavaObjectFromBinaryGeneric(BinaryGeneric<T> value, TypeSerializer<T> ser) {
        if (value.getJavaObject() == null) {
            try {
                value.setJavaObject(InstantiationUtil.deserializeFromByteArray(ser, (byte[])SegmentsUtil.copyToBytes(value.getSegments(), value.getOffset(), value.getSizeInBytes())));
            }
            catch (IOException e) {
                throw new FlinkRuntimeException((Throwable)e);
            }
        }
        return value.getJavaObject();
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("BinaryGeneric cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("BinaryGeneric does not have a hashCode");
    }

    public String toString() {
        return "BinaryGeneric{javaObject=" + this.javaObject + '}';
    }
}

