/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat;

import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.dataformat.vector.BytesColumnVector;
import org.apache.flink.table.dataformat.vector.VectorizedColumnBatch;

public final class ColumnarRow
implements BaseRow {
    private byte header;
    private VectorizedColumnBatch vectorizedColumnBatch;
    private int rowId;

    public ColumnarRow() {
    }

    public ColumnarRow(VectorizedColumnBatch vectorizedColumnBatch) {
        this(vectorizedColumnBatch, 0);
    }

    public ColumnarRow(VectorizedColumnBatch vectorizedColumnBatch, int rowId) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = rowId;
    }

    public void setVectorizedColumnBatch(VectorizedColumnBatch vectorizedColumnBatch) {
        this.vectorizedColumnBatch = vectorizedColumnBatch;
        this.rowId = 0;
    }

    public void setRowId(int rowId) {
        this.rowId = rowId;
    }

    @Override
    public byte getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(byte header) {
        this.header = header;
    }

    @Override
    public int getArity() {
        return this.vectorizedColumnBatch.getArity();
    }

    @Override
    public boolean isNullAt(int ordinal) {
        return this.vectorizedColumnBatch.isNullAt(this.rowId, ordinal);
    }

    @Override
    public boolean getBoolean(int ordinal) {
        return this.vectorizedColumnBatch.getBoolean(this.rowId, ordinal);
    }

    @Override
    public byte getByte(int ordinal) {
        return this.vectorizedColumnBatch.getByte(this.rowId, ordinal);
    }

    @Override
    public short getShort(int ordinal) {
        return this.vectorizedColumnBatch.getShort(this.rowId, ordinal);
    }

    @Override
    public int getInt(int ordinal) {
        return this.vectorizedColumnBatch.getInt(this.rowId, ordinal);
    }

    @Override
    public long getLong(int ordinal) {
        return this.vectorizedColumnBatch.getLong(this.rowId, ordinal);
    }

    @Override
    public float getFloat(int ordinal) {
        return this.vectorizedColumnBatch.getFloat(this.rowId, ordinal);
    }

    @Override
    public double getDouble(int ordinal) {
        return this.vectorizedColumnBatch.getDouble(this.rowId, ordinal);
    }

    @Override
    public BinaryString getString(int ordinal) {
        BytesColumnVector.Bytes byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, ordinal);
        return BinaryString.fromBytes(byteArray.data, byteArray.offset, byteArray.len);
    }

    @Override
    public Decimal getDecimal(int ordinal, int precision, int scale) {
        return this.vectorizedColumnBatch.getDecimal(this.rowId, ordinal, precision, scale);
    }

    @Override
    public SqlTimestamp getTimestamp(int ordinal, int precision) {
        return this.vectorizedColumnBatch.getTimestamp(this.rowId, ordinal, precision);
    }

    @Override
    public <T> BinaryGeneric<T> getGeneric(int pos) {
        throw new UnsupportedOperationException("GenericType is not supported.");
    }

    @Override
    public byte[] getBinary(int ordinal) {
        BytesColumnVector.Bytes byteArray = this.vectorizedColumnBatch.getByteArray(this.rowId, ordinal);
        if (byteArray.len == byteArray.data.length) {
            return byteArray.data;
        }
        byte[] ret = new byte[byteArray.len];
        System.arraycopy(byteArray.data, byteArray.offset, ret, 0, byteArray.len);
        return ret;
    }

    @Override
    public BaseRow getRow(int ordinal, int numFields) {
        throw new UnsupportedOperationException("Row is not supported.");
    }

    @Override
    public BaseArray getArray(int ordinal) {
        throw new UnsupportedOperationException("Array is not supported.");
    }

    @Override
    public BaseMap getMap(int ordinal) {
        throw new UnsupportedOperationException("Map is not supported.");
    }

    @Override
    public void setNullAt(int ordinal) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setBoolean(int ordinal, boolean value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setByte(int ordinal, byte value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setShort(int ordinal, short value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setInt(int ordinal, int value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setLong(int ordinal, long value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setFloat(int pos, float value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDouble(int ordinal, double value) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setDecimal(int ordinal, Decimal value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    @Override
    public void setTimestamp(int ordinal, SqlTimestamp value, int precision) {
        throw new UnsupportedOperationException("Not support the operation!");
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("ColumnarRow do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ColumnarRow do not support hashCode, please hash fields one by one!");
    }
}

