/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataformat.vector.heap;

import java.util.Arrays;
import org.apache.flink.table.dataformat.vector.AbstractColumnVector;
import org.apache.flink.table.dataformat.vector.heap.HeapIntVector;

public abstract class AbstractHeapVector
extends AbstractColumnVector {
    protected boolean[] isNull;
    protected HeapIntVector dictionaryIds;

    public AbstractHeapVector(int len) {
        this.isNull = new boolean[len];
    }

    @Override
    public void reset() {
        if (!this.noNulls) {
            Arrays.fill(this.isNull, false);
        }
        this.noNulls = true;
    }

    public void setNullAt(int i) {
        this.isNull[i] = true;
        this.noNulls = false;
    }

    @Override
    public boolean isNullAt(int i) {
        return !this.noNulls && this.isNull[i];
    }

    @Override
    public HeapIntVector reserveDictionaryIds(int capacity) {
        if (this.dictionaryIds == null) {
            this.dictionaryIds = new HeapIntVector(capacity);
        } else {
            this.dictionaryIds.reset();
        }
        return this.dictionaryIds;
    }

    public HeapIntVector getDictionaryIds() {
        return this.dictionaryIds;
    }
}

