/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.filesystem.PartitionComputer;
import org.apache.flink.types.Row;

@Internal
public class RowPartitionComputer
implements PartitionComputer<Row> {
    private static final long serialVersionUID = 1L;
    protected final String defaultPartValue;
    protected final String[] partitionColumns;
    private final int[] nonPartitionIndexes;
    protected final int[] partitionIndexes;

    public RowPartitionComputer(String defaultPartValue, String[] columnNames, String[] partitionColumns) {
        this.defaultPartValue = defaultPartValue;
        this.partitionColumns = partitionColumns;
        List<String> columnList = Arrays.asList(columnNames);
        this.partitionIndexes = Arrays.stream(partitionColumns).mapToInt(columnList::indexOf).toArray();
        List partitionIndexList = Arrays.stream(this.partitionIndexes).boxed().collect(Collectors.toList());
        this.nonPartitionIndexes = IntStream.range(0, columnNames.length).filter(c -> !partitionIndexList.contains(c)).toArray();
    }

    @Override
    public LinkedHashMap<String, String> generatePartValues(Row in) throws Exception {
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionIndexes.length; ++i) {
            String partitionValue;
            int index = this.partitionIndexes[i];
            Object field = in.getField(index);
            String string = partitionValue = field != null ? field.toString() : null;
            if (partitionValue == null || "".equals(partitionValue)) {
                partitionValue = this.defaultPartValue;
            }
            partSpec.put(this.partitionColumns[i], partitionValue);
        }
        return partSpec;
    }

    @Override
    public Row projectColumnsToWrite(Row in) throws Exception {
        return this.partitionIndexes.length == 0 ? in : Row.project((Row)in, (int[])this.nonPartitionIndexes);
    }
}

