/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.stream.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinInputSideSpec;
import org.apache.flink.table.runtime.operators.join.stream.state.JoinRecordStateViews;
import org.apache.flink.table.runtime.operators.join.stream.state.OuterJoinRecordStateView;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.IterableIterator;
import org.apache.flink.util.Preconditions;

public final class OuterJoinRecordStateViews {
    public static OuterJoinRecordStateView create(RuntimeContext ctx, String stateName, JoinInputSideSpec inputSideSpec, BaseRowTypeInfo recordType, long retentionTime, boolean stateCleaningEnabled) {
        StateTtlConfig ttlConfig = JoinRecordStateViews.createTtlConfig(retentionTime, stateCleaningEnabled);
        if (inputSideSpec.hasUniqueKey()) {
            if (inputSideSpec.joinKeyContainsUniqueKey()) {
                return new JoinKeyContainsUniqueKey(ctx, stateName, recordType, ttlConfig);
            }
            return new InputSideHasUniqueKey(ctx, stateName, recordType, inputSideSpec.getUniqueKeyType(), inputSideSpec.getUniqueKeySelector(), ttlConfig);
        }
        return new InputSideHasNoUniqueKey(ctx, stateName, recordType, ttlConfig);
    }

    private static final class RecordsIterable
    implements IterableIterator<BaseRow> {
        private final Iterator<Tuple2<BaseRow, Integer>> tupleIterator;

        private RecordsIterable(Iterable<Tuple2<BaseRow, Integer>> tuples) {
            Preconditions.checkNotNull(tuples);
            this.tupleIterator = tuples.iterator();
        }

        public Iterator<BaseRow> iterator() {
            return this;
        }

        public boolean hasNext() {
            return this.tupleIterator.hasNext();
        }

        public BaseRow next() {
            return (BaseRow)this.tupleIterator.next().f0;
        }
    }

    private static final class InputSideHasNoUniqueKey
    implements OuterJoinRecordStateView {
        private final MapState<BaseRow, Tuple2<Integer, Integer>> recordState;

        private InputSideHasNoUniqueKey(RuntimeContext ctx, String stateName, BaseRowTypeInfo recordType, StateTtlConfig ttlConfig) {
            TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types.INT, Types.INT});
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, (TypeInformation)recordType, (TypeInformation)tupleTypeInfo);
            if (!ttlConfig.equals(StateTtlConfig.DISABLED)) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
        }

        @Override
        public void addRecord(BaseRow record) throws Exception {
            this.addRecord(record, -1);
        }

        @Override
        public void addRecord(BaseRow record, int numOfAssociations) throws Exception {
            Tuple2 tuple = (Tuple2)this.recordState.get((Object)record);
            if (tuple != null) {
                tuple.f0 = (Integer)tuple.f0 + 1;
                tuple.f1 = numOfAssociations;
            } else {
                tuple = Tuple2.of((Object)1, (Object)numOfAssociations);
            }
            this.recordState.put((Object)record, (Object)tuple);
        }

        @Override
        public void updateNumOfAssociations(BaseRow record, int numOfAssociations) throws Exception {
            Tuple2 tuple = (Tuple2)this.recordState.get((Object)record);
            if (tuple != null) {
                tuple.f1 = numOfAssociations;
            } else {
                tuple = Tuple2.of((Object)1, (Object)numOfAssociations);
            }
            this.recordState.put((Object)record, (Object)tuple);
        }

        @Override
        public void retractRecord(BaseRow record) throws Exception {
            Tuple2 tuple = (Tuple2)this.recordState.get((Object)record);
            if (tuple != null) {
                if ((Integer)tuple.f0 > 1) {
                    tuple.f0 = (Integer)tuple.f0 - 1;
                    this.recordState.put((Object)record, (Object)tuple);
                } else {
                    this.recordState.remove((Object)record);
                }
            }
        }

        @Override
        public Iterable<BaseRow> getRecords() throws Exception {
            return new RecordsIterable(this.getRecordsAndNumOfAssociations());
        }

        @Override
        public Iterable<Tuple2<BaseRow, Integer>> getRecordsAndNumOfAssociations() throws Exception {
            return new IterableIterator<Tuple2<BaseRow, Integer>>(){
                private final Iterator<Map.Entry<BaseRow, Tuple2<Integer, Integer>>> backingIterable;
                private Tuple2<BaseRow, Integer> tuple;
                private int remainingTimes;
                {
                    this.backingIterable = recordState.entries().iterator();
                    this.remainingTimes = 0;
                }

                public boolean hasNext() {
                    return this.backingIterable.hasNext() || this.remainingTimes > 0;
                }

                public Tuple2<BaseRow, Integer> next() {
                    if (this.remainingTimes > 0) {
                        Preconditions.checkNotNull(this.tuple);
                        --this.remainingTimes;
                        return this.tuple;
                    }
                    Map.Entry<BaseRow, Tuple2<Integer, Integer>> entry = this.backingIterable.next();
                    this.tuple = Tuple2.of((Object)entry.getKey(), (Object)entry.getValue().f1);
                    this.remainingTimes = (Integer)entry.getValue().f0 - 1;
                    return this.tuple;
                }

                public Iterator<Tuple2<BaseRow, Integer>> iterator() {
                    return this;
                }
            };
        }
    }

    private static final class InputSideHasUniqueKey
    implements OuterJoinRecordStateView {
        private final MapState<BaseRow, Tuple2<BaseRow, Integer>> recordState;
        private final KeySelector<BaseRow, BaseRow> uniqueKeySelector;

        private InputSideHasUniqueKey(RuntimeContext ctx, String stateName, BaseRowTypeInfo recordType, BaseRowTypeInfo uniqueKeyType, KeySelector<BaseRow, BaseRow> uniqueKeySelector, StateTtlConfig ttlConfig) {
            Preconditions.checkNotNull((Object)((Object)uniqueKeyType));
            Preconditions.checkNotNull(uniqueKeySelector);
            TupleTypeInfo valueTypeInfo = new TupleTypeInfo(new TypeInformation[]{recordType, Types.INT});
            MapStateDescriptor recordStateDesc = new MapStateDescriptor(stateName, (TypeInformation)uniqueKeyType, (TypeInformation)valueTypeInfo);
            if (!ttlConfig.equals(StateTtlConfig.DISABLED)) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getMapState(recordStateDesc);
            this.uniqueKeySelector = uniqueKeySelector;
        }

        @Override
        public void addRecord(BaseRow record) throws Exception {
            this.addRecord(record, -1);
        }

        @Override
        public void addRecord(BaseRow record, int numOfAssociations) throws Exception {
            BaseRow uniqueKey = (BaseRow)this.uniqueKeySelector.getKey((Object)record);
            this.recordState.put((Object)uniqueKey, (Object)Tuple2.of((Object)record, (Object)numOfAssociations));
        }

        @Override
        public void updateNumOfAssociations(BaseRow record, int numOfAssociations) throws Exception {
            BaseRow uniqueKey = (BaseRow)this.uniqueKeySelector.getKey((Object)record);
            this.recordState.put((Object)uniqueKey, (Object)Tuple2.of((Object)record, (Object)numOfAssociations));
        }

        @Override
        public void retractRecord(BaseRow record) throws Exception {
            BaseRow uniqueKey = (BaseRow)this.uniqueKeySelector.getKey((Object)record);
            this.recordState.remove((Object)uniqueKey);
        }

        @Override
        public Iterable<BaseRow> getRecords() throws Exception {
            return new RecordsIterable(this.getRecordsAndNumOfAssociations());
        }

        @Override
        public Iterable<Tuple2<BaseRow, Integer>> getRecordsAndNumOfAssociations() throws Exception {
            return this.recordState.values();
        }
    }

    private static final class JoinKeyContainsUniqueKey
    implements OuterJoinRecordStateView {
        private final ValueState<Tuple2<BaseRow, Integer>> recordState;
        private final List<BaseRow> reusedRecordList;
        private final List<Tuple2<BaseRow, Integer>> reusedTupleList;

        private JoinKeyContainsUniqueKey(RuntimeContext ctx, String stateName, BaseRowTypeInfo recordType, StateTtlConfig ttlConfig) {
            TupleTypeInfo valueTypeInfo = new TupleTypeInfo(new TypeInformation[]{recordType, Types.INT});
            ValueStateDescriptor recordStateDesc = new ValueStateDescriptor(stateName, (TypeInformation)valueTypeInfo);
            if (!ttlConfig.equals(StateTtlConfig.DISABLED)) {
                recordStateDesc.enableTimeToLive(ttlConfig);
            }
            this.recordState = ctx.getState(recordStateDesc);
            this.reusedRecordList = new ArrayList<BaseRow>(1);
            this.reusedTupleList = new ArrayList<Tuple2<BaseRow, Integer>>(1);
        }

        @Override
        public void addRecord(BaseRow record) throws Exception {
            this.addRecord(record, -1);
        }

        @Override
        public void addRecord(BaseRow record, int numOfAssociations) throws Exception {
            this.recordState.update((Object)Tuple2.of((Object)record, (Object)numOfAssociations));
        }

        @Override
        public void updateNumOfAssociations(BaseRow record, int numOfAssociations) throws Exception {
            this.recordState.update((Object)Tuple2.of((Object)record, (Object)numOfAssociations));
        }

        @Override
        public void retractRecord(BaseRow record) throws Exception {
            this.recordState.clear();
        }

        @Override
        public Iterable<BaseRow> getRecords() throws Exception {
            Tuple2 tuple = (Tuple2)this.recordState.value();
            if (tuple == null) {
                this.reusedRecordList.clear();
            } else {
                this.reusedRecordList.add((BaseRow)tuple.f0);
            }
            return this.reusedRecordList;
        }

        @Override
        public Iterable<Tuple2<BaseRow, Integer>> getRecordsAndNumOfAssociations() throws Exception {
            this.reusedTupleList.clear();
            Tuple2 tuple = (Tuple2)this.recordState.value();
            if (tuple != null) {
                this.reusedTupleList.add((Tuple2<BaseRow, Integer>)tuple);
            }
            return this.reusedTupleList;
        }
    }
}

