/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.dataformat.SqlTimestamp;

public class SqlTimestampSerializer
extends TypeSerializer<SqlTimestamp> {
    private static final long serialVersionUID = 1L;
    private final int precision;

    public SqlTimestampSerializer(int precision) {
        this.precision = precision;
    }

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<SqlTimestamp> duplicate() {
        return new SqlTimestampSerializer(this.precision);
    }

    public SqlTimestamp createInstance() {
        return SqlTimestamp.fromEpochMillis(0L);
    }

    public SqlTimestamp copy(SqlTimestamp from) {
        return from;
    }

    public SqlTimestamp copy(SqlTimestamp from, SqlTimestamp reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return SqlTimestamp.isCompact(this.precision) ? 8 : 12;
    }

    public void serialize(SqlTimestamp record, DataOutputView target) throws IOException {
        if (SqlTimestamp.isCompact(this.precision)) {
            assert (record.getNanoOfMillisecond() == 0);
            target.writeLong(record.getMillisecond());
        } else {
            target.writeLong(record.getMillisecond());
            target.writeInt(record.getNanoOfMillisecond());
        }
    }

    public SqlTimestamp deserialize(DataInputView source) throws IOException {
        if (SqlTimestamp.isCompact(this.precision)) {
            long val = source.readLong();
            return SqlTimestamp.fromEpochMillis(val);
        }
        long longVal = source.readLong();
        int intVal = source.readInt();
        return SqlTimestamp.fromEpochMillis(longVal, intVal);
    }

    public SqlTimestamp deserialize(SqlTimestamp reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        if (SqlTimestamp.isCompact(this.precision)) {
            target.writeLong(source.readLong());
        } else {
            target.writeLong(source.readLong());
            target.writeInt(source.readInt());
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SqlTimestampSerializer that = (SqlTimestampSerializer)((Object)obj);
        return this.precision == that.precision;
    }

    public int hashCode() {
        return this.precision;
    }

    public TypeSerializerSnapshot<SqlTimestamp> snapshotConfiguration() {
        return new SqlTimestampSerializerSnapshot(this.precision);
    }

    public static final class SqlTimestampSerializerSnapshot
    implements TypeSerializerSnapshot<SqlTimestamp> {
        private static final int CURRENT_VERSION = 1;
        private int previousPrecision;

        public SqlTimestampSerializerSnapshot() {
        }

        SqlTimestampSerializerSnapshot(int precision) {
            this.previousPrecision = precision;
        }

        public int getCurrentVersion() {
            return 1;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.previousPrecision);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.previousPrecision = in.readInt();
        }

        public TypeSerializer<SqlTimestamp> restoreSerializer() {
            return new SqlTimestampSerializer(this.previousPrecision);
        }

        public TypeSerializerSchemaCompatibility<SqlTimestamp> resolveSchemaCompatibility(TypeSerializer<SqlTimestamp> newSerializer) {
            if (!(newSerializer instanceof SqlTimestampSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            SqlTimestampSerializer sqlTimestampSerializer = (SqlTimestampSerializer)newSerializer;
            if (this.previousPrecision != sqlTimestampSerializer.precision) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

