/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.scala.typeutils.CaseClassTypeInfo;
import org.apache.flink.api.scala.typeutils.ScalaCaseClassSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.bridge.scala.StreamStatementSet;
import org.apache.flink.table.api.bridge.scala.StreamTableEnvironment;
import org.apache.flink.table.api.bridge.scala.internal.StreamStatementSetImpl;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.api.package$;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.SchemaTranslator;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ScalaDataStreamQueryOperation;
import org.apache.flink.table.operations.ScalaExternalQueryOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.typeutils.FieldInfoUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Internal
@ScalaSignature(bytes="\u0006\u0001\u0011-e\u0001B\u0001\u0003\u0001M\u0011!d\u0015;sK\u0006lG+\u00192mK\u0016sg/\u001b:p]6,g\u000e^%na2T!a\u0001\u0003\u0002\u0011%tG/\u001a:oC2T!!\u0002\u0004\u0002\u000bM\u001c\u0017\r\\1\u000b\u0005\u001dA\u0011A\u00022sS\u0012<WM\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0005-a\u0011!\u0002;bE2,'BA\u0007\u000f\u0003\u00151G.\u001b8l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001F\r\u0011\u0005U9R\"\u0001\f\u000b\u0005\rA\u0011B\u0001\r\u0017\u0005Q!\u0016M\u00197f\u000b:4\u0018N]8o[\u0016tG/S7qYB\u0011!dG\u0007\u0002\t%\u0011A\u0004\u0002\u0002\u0017'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi\"Aa\u0004\u0001B\u0001B\u0003%q$\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\tR\u0011aB2bi\u0006dwnZ\u0005\u0003I\u0005\u0012abQ1uC2|w-T1oC\u001e,'\u000f\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u00035iw\u000eZ;mK6\u000bg.Y4feB\u0011\u0001fK\u0007\u0002S)\u0011!FC\u0001\u0007[>$W\u000f\\3\n\u00051J#!D'pIVdW-T1oC\u001e,'\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u00111\u0013\t\t\u0014EA\bGk:\u001cG/[8o\u0007\u0006$\u0018\r\\8h\u0011!\u0019\u0004A!A!\u0002\u0013!\u0014AB2p]\u001aLw\r\u0005\u00026m5\t\u0001\"\u0003\u00028\u0011\tYA+\u00192mK\u000e{gNZ5h\u0011!I\u0004A!A!\u0002\u0013Q\u0014!G:dC2\fW\t_3dkRLwN\\#om&\u0014xN\\7f]R\u0004\"a\u000f!\u000e\u0003qR!!B\u001f\u000b\u0005%q$BA \r\u0003%\u0019HO]3b[&tw-\u0003\u0002By\tQ2\u000b\u001e:fC6,\u00050Z2vi&|g.\u00128wSJ|g.\\3oi\"A1\t\u0001B\u0001B\u0003%A)A\u0004qY\u0006tg.\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0011A\u00033fY\u0016<\u0017\r^5p]&\u0011\u0011J\u0012\u0002\b!2\fgN\\3s\u0011!Y\u0005A!A!\u0002\u0013a\u0015\u0001C3yK\u000e,Ho\u001c:\u0011\u0005\u0015k\u0015B\u0001(G\u0005!)\u00050Z2vi>\u0014\b\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u0017%\u001c8\u000b\u001e:fC6Lgn\u001a\t\u0003%Rk\u0011a\u0015\u0006\u0002\u000b%\u0011Qk\u0015\u0002\b\u0005>|G.Z1o\u0011!9\u0006A!A!\u0002\u0013A\u0016aD;tKJ\u001cE.Y:t\u0019>\fG-\u001a:\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\nY1\t\\1tg2{\u0017\rZ3s\u0011\u0015\t\u0007\u0001\"\u0001c\u0003\u0019a\u0014N\\5u}QQ1-\u001a4hQ&T7\u000e\\7\u0011\u0005\u0011\u0004Q\"\u0001\u0002\t\u000by\u0001\u0007\u0019A\u0010\t\u000b\u0019\u0002\u0007\u0019A\u0014\t\u000b9\u0002\u0007\u0019A\u0018\t\u000bM\u0002\u0007\u0019\u0001\u001b\t\u000be\u0002\u0007\u0019\u0001\u001e\t\u000b\r\u0003\u0007\u0019\u0001#\t\u000b-\u0003\u0007\u0019\u0001'\t\u000bA\u0003\u0007\u0019A)\t\u000b]\u0003\u0007\u0019\u0001-\t\u000b=\u0004A\u0011\t9\u0002\u001d\u0019\u0014x.\u001c#bi\u0006\u001cFO]3b[V\u0011\u0011\u000f \u000b\u0003eV\u0004\"!N:\n\u0005QD!!\u0002+bE2,\u0007\"\u0002<o\u0001\u00049\u0018A\u00033bi\u0006\u001cFO]3b[B\u00191\b\u001f>\n\u0005ed$A\u0003#bi\u0006\u001cFO]3b[B\u00111\u0010 \u0007\u0001\t\u0015ihN1\u0001\u007f\u0005\u0005!\u0016cA@\u0002\u0006A\u0019!+!\u0001\n\u0007\u0005\r1KA\u0004O_RD\u0017N\\4\u0011\u0007I\u000b9!C\u0002\u0002\nM\u00131!\u00118z\u0011\u0019y\u0007\u0001\"\u0011\u0002\u000eU!\u0011qBA\f)\u0015\u0011\u0018\u0011CA\r\u0011\u001d1\u00181\u0002a\u0001\u0003'\u0001Ba\u000f=\u0002\u0016A\u001910a\u0006\u0005\ru\fYA1\u0001\u007f\u0011!\tY\"a\u0003A\u0002\u0005u\u0011AB:dQ\u0016l\u0017\rE\u00026\u0003?I1!!\t\t\u0005\u0019\u00196\r[3nC\"9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012a\u00054s_6\u001c\u0005.\u00198hK2|wm\u0015;sK\u0006lGc\u0001:\u0002*!9a/a\tA\u0002\u0005-\u0002\u0003B\u001ey\u0003[\u0001B!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003ga\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u001c\u0003c\u00111AU8x\u0011\u001d\t)\u0003\u0001C!\u0003w!RA]A\u001f\u0003\u007fAqA^A\u001d\u0001\u0004\tY\u0003\u0003\u0005\u0002\u001c\u0005e\u0002\u0019AA\u000f\u0011\u001d\t)\u0003\u0001C!\u0003\u0007\"rA]A#\u0003\u000f\nI\u0005C\u0004w\u0003\u0003\u0002\r!a\u000b\t\u0011\u0005m\u0011\u0011\ta\u0001\u0003;A\u0001\"a\u0013\u0002B\u0001\u0007\u0011QJ\u0001\u000eG\"\fgnZ3m_\u001elu\u000eZ3\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u000b\u0003%\u0019wN\u001c8fGR|'/\u0003\u0003\u0002X\u0005E#!D\"iC:<W\r\\8h\u001b>$W\rC\u0004\u0002\\\u0001!\t%!\u0018\u0002'\r\u0014X-\u0019;f)\u0016l\u0007o\u001c:bef4\u0016.Z<\u0016\t\u0005}\u0013q\u0011\u000b\u0007\u0003C\n9'!!\u0011\u0007I\u000b\u0019'C\u0002\u0002fM\u0013A!\u00168ji\"A\u0011\u0011NA-\u0001\u0004\tY'\u0001\u0003qCRD\u0007\u0003BA7\u0003wrA!a\u001c\u0002xA\u0019\u0011\u0011O*\u000e\u0005\u0005M$bAA;%\u00051AH]8pizJ1!!\u001fT\u0003\u0019\u0001&/\u001a3fM&!\u0011QPA@\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011P*\t\u000fY\fI\u00061\u0001\u0002\u0004B!1\b_AC!\rY\u0018q\u0011\u0003\u0007{\u0006e#\u0019\u0001@\t\u000f\u0005m\u0003\u0001\"\u0011\u0002\fV!\u0011QRAL)!\t\t'a$\u0002\u0012\u0006e\u0005\u0002CA5\u0003\u0013\u0003\r!a\u001b\t\u000fY\fI\t1\u0001\u0002\u0014B!1\b_AK!\rY\u0018q\u0013\u0003\u0007{\u0006%%\u0019\u0001@\t\u0011\u0005m\u0011\u0011\u0012a\u0001\u0003;Aq!!(\u0001\t\u0013\ty*\u0001\nge>l7\u000b\u001e:fC6Le\u000e^3s]\u0006dW\u0003BAQ\u0003c#\u0012B]AR\u0003g\u000b9-!4\t\u000fY\fY\n1\u0001\u0002&B1\u0011qUAW\u0003_k!!!+\u000b\u0007\u0005-V(\u0001\u0006eCR\f7\u000f\u001e:fC6L1!_AU!\rY\u0018\u0011\u0017\u0003\u0007{\u0006m%\u0019\u0001@\t\u0011\u0005m\u00111\u0014a\u0001\u0003;AC!a-\u00028B!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016AC1o]>$\u0018\r^5p]*\u0011\u0011\u0011Y\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u000b\fYL\u0001\u0005Ok2d\u0017M\u00197f\u0011!\tI-a'A\u0002\u0005-\u0014\u0001\u0003<jK^\u0004\u0016\r\u001e5)\t\u0005\u001d\u0017q\u0017\u0005\t\u0003\u0017\nY\n1\u0001\u0002N!9\u0011\u0011\u001b\u0001\u0005B\u0005M\u0017\u0001\u0004;p\t\u0006$\u0018m\u0015;sK\u0006lG\u0003BA\u0016\u0003+DaaCAh\u0001\u0004\u0011\bbBAi\u0001\u0011\u0005\u0013\u0011\\\u000b\u0005\u00037\f\t\u000f\u0006\u0004\u0002^\u0006\r\u0018Q\u001d\t\u0005wa\fy\u000eE\u0002|\u0003C$a!`Al\u0005\u0004q\bBB\u0006\u0002X\u0002\u0007!\u000f\u0003\u0005\u0002h\u0006]\u0007\u0019AAu\u0003-!\u0018M]4fi\u000ec\u0017m]:\u0011\r\u00055\u00141^Ap\u0013\u0011\ti/a \u0003\u000b\rc\u0017m]:\t\u000f\u0005E\u0007\u0001\"\u0011\u0002rV!\u00111_A})\u0019\t)0a?\u0002~B!1\b_A|!\rY\u0018\u0011 \u0003\u0007{\u0006=(\u0019\u0001@\t\r-\ty\u000f1\u0001s\u0011!\ty0a<A\u0002\t\u0005\u0011A\u0004;be\u001e,G\u000fR1uCRK\b/\u001a\u0019\u0005\u0005\u0007\u0011y\u0001\u0005\u0004\u0003\u0006\t%!QB\u0007\u0003\u0005\u000fQ1!a\r\u000b\u0013\u0011\u0011YAa\u0002\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0007cA>\u0003\u0010\u0011Y!\u0011CA\u007f\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryF%\r\u0005\b\u0005+\u0001A\u0011\tB\f\u0003E!xn\u00115b]\u001e,Gn\\4TiJ,\u0017-\u001c\u000b\u0005\u0003W\u0011I\u0002\u0003\u0004\f\u0005'\u0001\rA\u001d\u0005\b\u0005+\u0001A\u0011\tB\u000f)\u0019\tYCa\b\u0003\"!11Ba\u0007A\u0002ID\u0001Ba\t\u0003\u001c\u0001\u0007\u0011QD\u0001\ri\u0006\u0014x-\u001a;TG\",W.\u0019\u0005\b\u0005+\u0001A\u0011\tB\u0014)!\tYC!\u000b\u0003,\t5\u0002BB\u0006\u0003&\u0001\u0007!\u000f\u0003\u0005\u0003$\t\u0015\u0002\u0019AA\u000f\u0011!\tYE!\nA\u0002\u00055\u0003b\u0002B\u0019\u0001\u0011%!1G\u0001\u0011i>\u001cFO]3b[&sG/\u001a:oC2,BA!\u000e\u0003<QA!q\u0007B\u001f\u0005\u007f\u0011)\u0007\u0005\u0003<q\ne\u0002cA>\u0003<\u00111QPa\fC\u0002yDaa\u0003B\u0018\u0001\u0004\u0011\b\u0002\u0003B!\u0005_\u0001\rAa\u0011\u0002/M\u001c\u0007.Z7b)J\fgn\u001d7bi&|gNU3tk2$\b\u0003\u0002B#\u0005?rAAa\u0012\u0003\\9!!\u0011\nB-\u001d\u0011\u0011YEa\u0016\u000f\t\t5#Q\u000b\b\u0005\u0005\u001f\u0012\u0019F\u0004\u0003\u0002r\tE\u0013\"A\t\n\u0005=\u0001\u0012BA\u0007\u000f\u0013\tYA\"\u0003\u0002#\u0015%\u0019!QL\u0011\u0002!M\u001b\u0007.Z7b)J\fgn\u001d7bi>\u0014\u0018\u0002\u0002B1\u0005G\u0012q\u0002\u0015:pIV\u001c\u0017N\\4SKN,H\u000e\u001e\u0006\u0004\u0005;\n\u0003\u0002CA&\u0005_\u0001\r!!\u0014)\t\t\u0015\u0014q\u0017\u0005\b\u0005c\u0001A\u0011\u0002B6+\u0011\u0011iGa\u001d\u0015\r\t=$Q\u000fB<!\u0011Y\u0004P!\u001d\u0011\u0007m\u0014\u0019\b\u0002\u0004~\u0005S\u0012\rA \u0005\u0007\u0017\t%\u0004\u0019\u0001:\t\u0011\te$\u0011\u000ea\u0001\u0005w\nq\"\\8eS\u001aLx\n]3sCRLwN\u001c\t\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)\u0019!\u0011\u0011\u0006\u0002\u0015=\u0004XM]1uS>t7/\u0003\u0003\u0003\u0006\n}$aD'pI&4\u0017p\u00149fe\u0006$\u0018n\u001c8\t\u000f\t%\u0005\u0001\"\u0011\u0003\f\u0006\u00112M]3bi\u0016\u001cF/\u0019;f[\u0016tGoU3u)\t\u0011i\tE\u0002\u001b\u0005\u001fK1A!%\u0005\u0005I\u0019FO]3b[N#\u0018\r^3nK:$8+\u001a;\t\u0011\tU\u0005\u0001\"\u0001\u0003\u0005/\u000b!#\u0019;uC\u000eD\u0017i\u001d#bi\u0006\u001cFO]3b[R!\u0011\u0011\rBM\u0011!\u0011YJa%A\u0002\tu\u0015\u0001E7pI&4\u0017p\u00149fe\u0006$\u0018n\u001c8t!\u0019\u0011yJ!*\u0003|5\u0011!\u0011\u0015\u0006\u0004\u0005Gc\u0016\u0001B;uS2LAAa*\u0003\"\n!A*[:u\u0011\u0019y\u0007\u0001\"\u0011\u0003,V!!Q\u0016B[)\u0015\u0011(q\u0016B\\\u0011\u001d1(\u0011\u0016a\u0001\u0005c\u0003Ba\u000f=\u00034B\u00191P!.\u0005\ru\u0014IK1\u0001\u007f\u0011!\u0011IL!+A\u0002\tm\u0016A\u00024jK2$7\u000fE\u0003S\u0005{\u0013\t-C\u0002\u0003@N\u0013!\u0002\u0010:fa\u0016\fG/\u001a3?!\u0011\u0011\u0019M!3\u000e\u0005\t\u0015'b\u0001Bd\u0015\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u0011YM!2\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0003P\u0002!\tE!5\u0002%I,w-[:uKJ$\u0015\r^1TiJ,\u0017-\\\u000b\u0005\u0005'\u0014y\u000e\u0006\u0004\u0002b\tU'\u0011\u001c\u0005\t\u0005/\u0014i\r1\u0001\u0002l\u0005!a.Y7f\u0011\u001d1(Q\u001aa\u0001\u00057\u0004Ba\u000f=\u0003^B\u00191Pa8\u0005\ru\u0014iM1\u0001\u007f\u0011\u001d\u0011y\r\u0001C!\u0005G,BA!:\u0003pRA\u0011\u0011\rBt\u0005S\u0014\t\u0010\u0003\u0005\u0003X\n\u0005\b\u0019AA6\u0011\u001d1(\u0011\u001da\u0001\u0005W\u0004Ba\u000f=\u0003nB\u00191Pa<\u0005\ru\u0014\tO1\u0001\u007f\u0011!\u0011IL!9A\u0002\tm\u0006b\u0002B{\u0001\u0011\u0005#q_\u0001\u000fi>\f\u0005\u000f]3oIN#(/Z1n+\u0011\u0011Ip!\u0001\u0015\t\tm8\u0011\u0004\u000b\u0005\u0005{\u001c\u0019\u0001\u0005\u0003<q\n}\bcA>\u0004\u0002\u00111QPa=C\u0002yD!b!\u0002\u0003t\u0006\u0005\t9AB\u0004\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0007\u0013\u0019)Ba@\u000e\u0005\r-!\u0002BB\u0007\u0007\u001f\t\u0001\u0002^=qK&tgm\u001c\u0006\u0005\u0007#\u0019\u0019\"\u0001\u0004d_6lwN\u001c\u0006\u0003\u00131IAaa\u0006\u0004\f\tyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0003\u0004\f\u0005g\u0004\rA\u001d\u0005\b\u0007;\u0001A\u0011IB\u0010\u0003=!xNU3ue\u0006\u001cGo\u0015;sK\u0006lW\u0003BB\u0011\u0007_!Baa\t\u00048Q!1QEB\u0019!\u0011Y\u0004pa\n\u0011\rI\u001bI#UB\u0017\u0013\r\u0019Yc\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007m\u001cy\u0003\u0002\u0004~\u00077\u0011\rA \u0005\u000b\u0007g\u0019Y\"!AA\u0004\rU\u0012AC3wS\u0012,gnY3%eA11\u0011BB\u000b\u0007[AaaCB\u000e\u0001\u0004\u0011\bbBB\u001e\u0001\u0011\u00053QH\u0001\u0011e\u0016<\u0017n\u001d;fe\u001a+hn\u0019;j_:,Baa\u0010\u0004LQ11\u0011IB'\u0007\u001f\"B!!\u0019\u0004D!Q1QIB\u001d\u0003\u0003\u0005\u001daa\u0012\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0004\u0004\n\rU1\u0011\n\t\u0004w\u000e-CAB?\u0004:\t\u0007a\u0010\u0003\u0005\u0003X\u000ee\u0002\u0019AA6\u0011!\u0019\tf!\u000fA\u0002\rM\u0013A\u0001;g!\u0019\u0019)fa\u0017\u0004J5\u00111q\u000b\u0006\u0004\u00073R\u0011!\u00034v]\u000e$\u0018n\u001c8t\u0013\u0011\u0019ifa\u0016\u0003\u001bQ\u000b'\r\\3Gk:\u001cG/[8o\u0011\u001d\u0019Y\u0004\u0001C!\u0007C*baa\u0019\u0004p\reDCBB3\u0007{\u001ay\b\u0006\u0004\u0002b\r\u001d4\u0011\u000f\u0005\u000b\u0007S\u001ay&!AA\u0004\r-\u0014AC3wS\u0012,gnY3%iA11\u0011BB\u000b\u0007[\u00022a_B8\t\u0019i8q\fb\u0001}\"Q11OB0\u0003\u0003\u0005\u001da!\u001e\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007\u0005\u0004\u0004\n\rU1q\u000f\t\u0004w\u000eeDaBB>\u0007?\u0012\rA \u0002\u0004\u0003\u000e\u001b\u0005\u0002\u0003Bl\u0007?\u0002\r!a\u001b\t\u0011\r\u00055q\fa\u0001\u0007\u0007\u000b\u0011A\u001a\t\t\u0007+\u001a)i!\u001c\u0004x%!1qQB,\u0005E\tum\u001a:fO\u0006$XMR;oGRLwN\u001c\u0005\b\u0007w\u0001A\u0011IBF+\u0019\u0019ii!'\u0004$R11qRBS\u0007O#b!!\u0019\u0004\u0012\u000em\u0005BCBJ\u0007\u0013\u000b\t\u0011q\u0001\u0004\u0016\u0006QQM^5eK:\u001cW\r\n\u001c\u0011\r\r%1QCBL!\rY8\u0011\u0014\u0003\u0007{\u000e%%\u0019\u0001@\t\u0015\ru5\u0011RA\u0001\u0002\b\u0019y*\u0001\u0006fm&$WM\\2fI]\u0002ba!\u0003\u0004\u0016\r\u0005\u0006cA>\u0004$\u0012911PBE\u0005\u0004q\b\u0002\u0003Bl\u0007\u0013\u0003\r!a\u001b\t\u0011\r\u00055\u0011\u0012a\u0001\u0007S\u0003\u0002b!\u0016\u0004,\u000e]5\u0011U\u0005\u0005\u0007[\u001b9F\u0001\fUC\ndW-Q4he\u0016<\u0017\r^3Gk:\u001cG/[8o\u0011\u001d\u0019\t\f\u0001C)\u0007g\u000b1C^1mS\u0012\fG/\u001a+bE2,7k\\;sG\u0016$B!!\u0019\u00046\"A1qWBX\u0001\u0004\u0019I,A\u0006uC\ndWmU8ve\u000e,\u0007\u0007BB^\u0007\u0013\u0004ba!0\u0004D\u000e\u001dWBAB`\u0015\r\u0019\tMC\u0001\bg>,(oY3t\u0013\u0011\u0019)ma0\u0003\u0017Q\u000b'\r\\3T_V\u00148-\u001a\t\u0004w\u000e%GaCBf\u0007k\u000b\t\u0011!A\u0003\u0002y\u00141a\u0018\u00133\u0011\u001d\u0019y\r\u0001C\u0005\u0007#\f\u0011cZ3u)J\fgn\u001d4pe6\fG/[8o+\u0011\u0019\u0019na9\u0015\r\rU7Q]Bt!\u0019\u00199n!8\u0004b6\u00111\u0011\u001c\u0006\u0005\u00077\u001c\u0019\"A\u0002eC\u001eLAaa8\u0004Z\nqAK]1og\u001a|'/\\1uS>t\u0007cA>\u0004d\u00121Qp!4C\u0002yDaaCBg\u0001\u0004\u0011\b\u0002CBu\u0007\u001b\u0004\raa;\u0002\u001fQ\u0014\u0018M\\:g_Jl\u0017\r^5p]N\u0004bAa(\u0003&\u000e5\b\u0007BBx\u0007g\u0004baa6\u0004^\u000eE\bcA>\u0004t\u0012Y1Q_Bt\u0003\u0003\u0005\tQ!\u0001\u007f\u0005\ryFe\r\u0005\b\u0007s\u0004A\u0011BB~\u0003A\t7/U;fef|\u0005/\u001a:bi&|g.\u0006\u0003\u0004~\u0012\u001dACBB\u0000\t\u0013!i\u0001\u0005\u0004\u0003~\u0011\u0005AQA\u0005\u0005\t\u0007\u0011yHA\u000fTG\u0006d\u0017\rR1uCN#(/Z1n#V,'/_(qKJ\fG/[8o!\rYHq\u0001\u0003\u0007{\u000e](\u0019\u0001@\t\u000fY\u001c9\u00101\u0001\u0005\fA!1\b\u001fC\u0003\u0011!\u0011Ila>A\u0002\u0011=\u0001#\u0002*\u0005\u0012\u0011U\u0011b\u0001C\n'\n1q\n\u001d;j_:\u0004bAa(\u0003&\n\u0005\u0007b\u0002C\r\u0001\u0011EC1D\u0001\u0016cV\fG.\u001b4z#V,'/_(qKJ\fG/[8o)\u0019!i\u0002b\t\u0005.A!!Q\u0010C\u0010\u0013\u0011!\tCa \u0003\u001dE+XM]=Pa\u0016\u0014\u0018\r^5p]\"AAQ\u0005C\f\u0001\u0004!9#\u0001\u0006jI\u0016tG/\u001b4jKJ\u00042\u0001\tC\u0015\u0013\r!Y#\t\u0002\u0011\u001f\nTWm\u0019;JI\u0016tG/\u001b4jKJD\u0001\u0002b\f\u0005\u0018\u0001\u0007AQD\u0001\u000fcV,'/_(qKJ\fG/[8o\u0011\u001d\tY\u0006\u0001C!\tg)B\u0001\"\u000e\u0005@QA\u0011\u0011\rC\u001c\ts!\t\u0005\u0003\u0005\u0002j\u0011E\u0002\u0019AA6\u0011\u001d1H\u0011\u0007a\u0001\tw\u0001Ba\u000f=\u0005>A\u00191\u0010b\u0010\u0005\ru$\tD1\u0001\u007f\u0011!\u0011I\f\"\rA\u0002\tm\u0006f\u0001\u0001\u0005FA!Aq\tC&\u001b\t!IEC\u0002\u0002>2IA\u0001\"\u0014\u0005J\tA\u0011J\u001c;fe:\fGnB\u0004\u0005R\tA\t\u0001b\u0015\u00025M#(/Z1n)\u0006\u0014G.Z#om&\u0014xN\\7f]RLU\u000e\u001d7\u0011\u0007\u0011$)F\u0002\u0004\u0002\u0005!\u0005AqK\n\u0005\t+\"I\u0006E\u0002S\t7J1\u0001\"\u0018T\u0005\u0019\te.\u001f*fM\"9\u0011\r\"\u0016\u0005\u0002\u0011\u0005DC\u0001C*\u0011!!)\u0007\"\u0016\u0005\u0002\u0011\u001d\u0014AB2sK\u0006$X\rF\u0004d\tS\"i\u0007b\u001e\t\u000f\u0011-D1\ra\u0001u\u0005!R\r_3dkRLwN\\#om&\u0014xN\\7f]RD\u0001\u0002b\u001c\u0005d\u0001\u0007A\u0011O\u0001\tg\u0016$H/\u001b8hgB\u0019Q\u0007b\u001d\n\u0007\u0011U\u0004BA\nF]ZL'o\u001c8nK:$8+\u001a;uS:<7\u000fC\u0004\u0005z\u0011\r\u0004\u0019\u0001\u001b\u0002\u0017Q\f'\r\\3D_:4\u0017n\u001a\u0005\t\t{\")\u0006\"\u0003\u0005\u0000\u0005qAn\\8lkB,\u00050Z2vi>\u0014Hc\u0002'\u0005\u0002\u0012\u0015E\u0011\u0012\u0005\b\t\u0007#Y\b1\u0001Y\u0003-\u0019G.Y:t\u0019>\fG-\u001a:\t\u0011\u0011\u001dE1\u0010a\u0001\u0003W\n!#\u001a=fGV$xN]%eK:$\u0018NZ5fe\"9A1\u000eC>\u0001\u0004Q\u0004")
public class StreamTableEnvironmentImpl
extends TableEnvironmentImpl
implements StreamTableEnvironment {
    private final CatalogManager catalogManager;
    private final FunctionCatalog functionCatalog;
    private final StreamExecutionEnvironment scalaExecutionEnvironment;
    private final Planner planner;

    public static StreamTableEnvironmentImpl create(StreamExecutionEnvironment streamExecutionEnvironment, EnvironmentSettings environmentSettings, TableConfig tableConfig) {
        return StreamTableEnvironmentImpl$.MODULE$.create(streamExecutionEnvironment, environmentSettings, tableConfig);
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), null, null, ChangelogMode.insertOnly());
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, ChangelogMode.insertOnly());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), null, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, ChangelogMode.all());
    }

    @Override
    public Table fromChangelogStream(org.apache.flink.streaming.api.scala.DataStream<Row> dataStream, Schema schema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        return this.fromStreamInternal(dataStream.javaStream(), schema, null, changelogMode);
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        this.createTemporaryView(path, this.fromStreamInternal(dataStream.javaStream(), null, path, ChangelogMode.insertOnly()));
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Schema schema) {
        Preconditions.checkNotNull(dataStream, (String)"Data stream must not be null.");
        Preconditions.checkNotNull((Object)schema, (String)"Schema must not be null.");
        this.createTemporaryView(path, this.fromStreamInternal(dataStream.javaStream(), schema, path, ChangelogMode.insertOnly()));
    }

    private <T> Table fromStreamInternal(DataStream<T> dataStream, @Nullable Schema schema, @Nullable String viewPath, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        if (dataStream.getExecutionEnvironment() != this.scalaExecutionEnvironment.getJavaEnv()) {
            throw new ValidationException("The DataStream's StreamExecutionEnvironment must be identical to the one that has been passed to the StreamTableEnvironment during instantiation.");
        }
        CatalogManager catalogManager = this.getCatalogManager();
        SchemaResolver schemaResolver = catalogManager.getSchemaResolver();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        UnresolvedIdentifier unresolvedIdentifier = viewPath != null ? this.getParser().parseIdentifier(viewPath) : UnresolvedIdentifier.of(new StringBuilder(31).append("Unregistered_DataStream_Source_").append(dataStream.getId()).toString());
        ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        SchemaTranslator.ConsumingResult schemaTranslationResult = SchemaTranslator.createConsumingResult(catalogManager.getDataTypeFactory(), dataStream.getType(), schema);
        ResolvedSchema resolvedSchema = schemaTranslationResult.getSchema().resolve(schemaResolver);
        ScalaExternalQueryOperation<T> scanOperation = new ScalaExternalQueryOperation<T>(objectIdentifier, dataStream, schemaTranslationResult.getPhysicalDataType(), schemaTranslationResult.isTopLevelRecord(), changelogMode, resolvedSchema);
        List<String> projections = schemaTranslationResult.getProjections();
        if (projections == null) {
            return this.createTable(scanOperation);
        }
        QueryOperation projectOperation = operationTreeBuilder.project(Arrays.asList((Object[])new Expression[]{package$.MODULE$.array2ArrayConstructor(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projections).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiExpressionUtils.unresolvedRef(x$1), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UnresolvedReferenceExpression.class)))}), scanOperation);
        return this.createTable(projectOperation);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toDataStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        DataType sourceType = table.getResolvedSchema().toSourceRowDataType();
        return this.toDataStream(table, sourceType);
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toDataStream(Table table, Class<T> targetClass) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetClass, (String)"Target class must not be null.");
        Class<T> clazz = targetClass;
        Class<Row> clazz2 = Row.class;
        if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
            return this.toDataStream(table);
        }
        return this.toDataStream(table, DataTypes.of(targetClass));
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toDataStream(Table table, AbstractDataType<?> targetDataType) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull(targetDataType, (String)"Target data type must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult(this.catalogManager.getDataTypeFactory(), table.getResolvedSchema(), targetDataType);
        return this.toStreamInternal(table, schemaTranslationResult, ChangelogMode.insertOnly());
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult(table.getResolvedSchema(), null);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table, Schema targetSchema) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult(table.getResolvedSchema(), targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, null);
    }

    @Override
    public org.apache.flink.streaming.api.scala.DataStream<Row> toChangelogStream(Table table, Schema targetSchema, ChangelogMode changelogMode) {
        Preconditions.checkNotNull((Object)table, (String)"Table must not be null.");
        Preconditions.checkNotNull((Object)targetSchema, (String)"Target schema must not be null.");
        Preconditions.checkNotNull((Object)changelogMode, (String)"Changelog mode must not be null.");
        SchemaTranslator.ProducingResult schemaTranslationResult = SchemaTranslator.createProducingResult(table.getResolvedSchema(), targetSchema);
        return this.toStreamInternal(table, schemaTranslationResult, changelogMode);
    }

    private <T> org.apache.flink.streaming.api.scala.DataStream<T> toStreamInternal(Table table, SchemaTranslator.ProducingResult schemaTranslationResult, @Nullable ChangelogMode changelogMode) {
        QueryOperation queryOperation;
        CatalogManager catalogManager = this.getCatalogManager();
        SchemaResolver schemaResolver = catalogManager.getSchemaResolver();
        OperationTreeBuilder operationTreeBuilder = this.getOperationTreeBuilder();
        Optional<List<String>> optionalProjections = schemaTranslationResult.getProjections();
        if (optionalProjections.isPresent()) {
            List<String> projections = optionalProjections.get();
            queryOperation = operationTreeBuilder.project((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projections).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiExpressionUtils.unresolvedRef(x$1), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Buffer$.MODULE$.canBuildFrom())).asJava(), table.getQueryOperation());
        } else {
            queryOperation = table.getQueryOperation();
        }
        QueryOperation projectOperation = queryOperation;
        ResolvedSchema resolvedSchema = schemaResolver.resolve(schemaTranslationResult.getSchema());
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(new StringBuilder(29).append("Unregistered_DataStream_Sink_").append(ExternalModifyOperation.getUniqueId()).toString());
        ObjectIdentifier objectIdentifier = catalogManager.qualifyIdentifier(unresolvedIdentifier);
        ExternalModifyOperation modifyOperation = new ExternalModifyOperation(objectIdentifier, projectOperation, resolvedSchema, changelogMode, schemaTranslationResult.getPhysicalDataType().orElse(resolvedSchema.toPhysicalRowDataType()));
        return this.toStreamInternal(table, modifyOperation);
    }

    private <T> org.apache.flink.streaming.api.scala.DataStream<T> toStreamInternal(Table table, ModifyOperation modifyOperation) {
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment javaExecutionEnvironment = this.scalaExecutionEnvironment.getJavaEnv();
        List<Transformation<?>> transformations = this.planner.translate(Collections.singletonList(modifyOperation));
        Transformation<T> streamTransformation = this.getTransformation(table, transformations);
        javaExecutionEnvironment.addOperator(streamTransformation);
        javaExecutionEnvironment.configure((ReadableConfig)this.tableConfig.getConfiguration());
        return new org.apache.flink.streaming.api.scala.DataStream(new DataStream(javaExecutionEnvironment, streamTransformation));
    }

    @Override
    public StreamStatementSet createStatementSet() {
        return new StreamStatementSetImpl(this);
    }

    public void attachAsDataStream(List<ModifyOperation> modifyOperations) {
        org.apache.flink.streaming.api.environment.StreamExecutionEnvironment javaEnv = this.scalaExecutionEnvironment.getJavaEnv();
        Buffer transformations = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.translate(modifyOperations)).asScala();
        transformations.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            javaEnv.addOperator(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public <T> Table fromDataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        ScalaDataStreamQueryOperation<T> queryOperation = this.asQueryOperation(dataStream, (Option<List<Expression>>)new Some(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)fields.toList()).asJava()));
        return this.createTable(queryOperation);
    }

    @Override
    public <T> void registerDataStream(String name, org.apache.flink.streaming.api.scala.DataStream<T> dataStream) {
        this.registerTable(name, this.fromDataStream(dataStream));
    }

    @Override
    public <T> void registerDataStream(String name, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        this.registerTable(name, this.fromDataStream(dataStream, fields));
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<T> toAppendStream(Table table, TypeInformation<T> evidence$1) {
        TypeInformation<T> returnType = evidence$1;
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(returnType), OutputConversionModifyOperation.UpdateMode.APPEND);
        return this.toStreamInternal(table, modifyOperation);
    }

    @Override
    public <T> org.apache.flink.streaming.api.scala.DataStream<Tuple2<Object, T>> toRetractStream(Table table, TypeInformation<T> evidence$2) {
        CaseClassTypeInfo returnType = new CaseClassTypeInfo<Tuple2<Object, T>>(null, evidence$2){

            public /* synthetic */ TypeInformation[] protected$types($anon$2 x$1) {
                return x$1.types;
            }

            public TypeSerializer<Tuple2<Object, T>> createSerializer(ExecutionConfig executionConfig) {
                TypeSerializer[] fieldSerializers = new TypeSerializer[this.getArity()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.getArity()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    fieldSerializers$1[i] = this.protected$types(this)[i].createSerializer(executionConfig);
                });
                ScalaCaseClassSerializer<Tuple2<Object, T>> unused = new ScalaCaseClassSerializer<Tuple2<Object, T>>(this, fieldSerializers){

                    public Tuple2<Object, T> createInstance(Object[] fields) {
                        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)fields[0])), fields[1]);
                    }
                };
                return new ScalaCaseClassSerializer(this.getTypeClass(), fieldSerializers);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createSerializer$1(org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl$$anon$2 org.apache.flink.api.common.ExecutionConfig org.apache.flink.api.common.typeutils.TypeSerializer[] int )}, serializedLambda);
            }
        };
        OutputConversionModifyOperation modifyOperation = new OutputConversionModifyOperation(table.getQueryOperation(), TypeConversions.fromLegacyInfoToDataType(returnType), OutputConversionModifyOperation.UpdateMode.RETRACT);
        return this.toStreamInternal(table, modifyOperation);
    }

    @Override
    public <T> void registerFunction(String name, TableFunction<T> tf, TypeInformation<T> evidence$3) {
        TypeInformation<T> typeInfo = UserDefinedFunctionHelper.getReturnTypeOfTableFunction(tf, (TypeInformation)Predef$.MODULE$.implicitly(evidence$3));
        this.functionCatalog.registerTempSystemTableFunction(name, tf, typeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, AggregateFunction<T, ACC> f, TypeInformation<T> evidence$4, TypeInformation<ACC> evidence$5) {
        TypeInformation<T> typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$4));
        TypeInformation<ACC> accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$5));
        this.functionCatalog.registerTempSystemAggregateFunction(name, f, typeInfo, accTypeInfo);
    }

    @Override
    public <T, ACC> void registerFunction(String name, TableAggregateFunction<T, ACC> f, TypeInformation<T> evidence$6, TypeInformation<ACC> evidence$7) {
        TypeInformation<T> typeInfo = UserDefinedFunctionHelper.getReturnTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$6));
        TypeInformation<ACC> accTypeInfo = UserDefinedFunctionHelper.getAccumulatorTypeOfAggregateFunction(f, (TypeInformation)Predef$.MODULE$.implicitly(evidence$7));
        this.functionCatalog.registerTempSystemAggregateFunction(name, f, typeInfo, accTypeInfo);
    }

    @Override
    public void validateTableSource(TableSource<?> tableSource) {
        super.validateTableSource(tableSource);
        if (TableSourceValidation.hasRowtimeAttribute(tableSource)) {
            TimeCharacteristic timeCharacteristic = this.scalaExecutionEnvironment.getStreamTimeCharacteristic();
            TimeCharacteristic timeCharacteristic2 = TimeCharacteristic.EventTime;
            if (timeCharacteristic == null ? timeCharacteristic2 != null : !timeCharacteristic.equals(timeCharacteristic2)) {
                throw new TableException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s}", this.scalaExecutionEnvironment.getStreamTimeCharacteristic()));
            }
        }
    }

    private <T> Transformation<T> getTransformation(Table table, List<Transformation<?>> transformations) {
        if (transformations.size() != 1) {
            throw new TableException(String.format("Expected a single transformation for query: %s\n Got: %s", table.getQueryOperation().asSummaryString(), transformations));
        }
        return transformations.get(0);
    }

    private <T> ScalaDataStreamQueryOperation<T> asQueryOperation(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Option<List<Expression>> fields) {
        TypeInformation streamType = dataStream.javaStream().getType();
        FieldInfoUtils.TypeInfoSchema typeInfoSchema = (FieldInfoUtils.TypeInfoSchema)fields.map((Function1 & Serializable & scala.Serializable)f -> {
            void var3_3;
            FieldInfoUtils.TypeInfoSchema fieldsInfo = FieldInfoUtils.getFieldsInfo(streamType, (Expression[])f.toArray((Object[])new Expression[0]));
            if (fieldsInfo.isRowtimeDefined() && $this.scalaExecutionEnvironment.getStreamTimeCharacteristic() != TimeCharacteristic.EventTime) {
                throw new ValidationException(String.format("A rowtime attribute requires an EventTime time characteristic in stream environment. But is: %s", $this.scalaExecutionEnvironment.getStreamTimeCharacteristic()));
            }
            return var3_3;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> FieldInfoUtils.getFieldsInfo(streamType));
        return new ScalaDataStreamQueryOperation(dataStream.javaStream(), typeInfoSchema.getIndices(), typeInfoSchema.toResolvedSchema());
    }

    @Override
    public QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        ScalaDataStreamQueryOperation scalaDataStreamQueryOperation;
        ScalaDataStreamQueryOperation scalaDataStreamQueryOperation2 = queryOperation;
        if (scalaDataStreamQueryOperation2 instanceof ScalaDataStreamQueryOperation) {
            ScalaDataStreamQueryOperation scalaDataStreamQueryOperation3 = scalaDataStreamQueryOperation2;
            scalaDataStreamQueryOperation = new ScalaDataStreamQueryOperation(identifier, scalaDataStreamQueryOperation3.getDataStream(), scalaDataStreamQueryOperation3.getFieldIndices(), scalaDataStreamQueryOperation3.getResolvedSchema());
        } else {
            scalaDataStreamQueryOperation = queryOperation;
        }
        return scalaDataStreamQueryOperation;
    }

    @Override
    public <T> void createTemporaryView(String path, org.apache.flink.streaming.api.scala.DataStream<T> dataStream, Seq<Expression> fields) {
        this.createTemporaryView(path, this.fromDataStream(dataStream, fields));
    }

    public StreamTableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, FunctionCatalog functionCatalog, TableConfig config, StreamExecutionEnvironment scalaExecutionEnvironment, Planner planner, Executor executor, boolean isStreaming, ClassLoader userClassLoader) {
        this.catalogManager = catalogManager;
        this.functionCatalog = functionCatalog;
        this.scalaExecutionEnvironment = scalaExecutionEnvironment;
        this.planner = planner;
        super(catalogManager, moduleManager, config, executor, functionCatalog, planner, isStreaming, userClassLoader);
    }
}

