/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.UnresolvedDataType;
import org.apache.flink.table.types.extraction.DataTypeExtractor;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.UnresolvedUserDefinedType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeDuplicator;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.table.types.utils.TypeInfoDataTypeConverter;

@Internal
final class DataTypeFactoryImpl
implements DataTypeFactory {
    private final LogicalTypeResolver resolver = new LogicalTypeResolver();
    private final ClassLoader classLoader;
    private final Supplier<ExecutionConfig> executionConfig;

    DataTypeFactoryImpl(ClassLoader classLoader, ReadableConfig config, @Nullable ExecutionConfig executionConfig) {
        this.classLoader = classLoader;
        this.executionConfig = DataTypeFactoryImpl.createSerializerExecutionConfig(classLoader, config, executionConfig);
    }

    @Override
    public DataType createDataType(AbstractDataType<?> abstractDataType) {
        if (abstractDataType instanceof DataType) {
            return (DataType)abstractDataType;
        }
        if (abstractDataType instanceof UnresolvedDataType) {
            return ((UnresolvedDataType)abstractDataType).toDataType(this);
        }
        throw new ValidationException("Unsupported abstract data type.");
    }

    @Override
    public DataType createDataType(String name) {
        LogicalType parsedType = LogicalTypeParser.parse(name, this.classLoader);
        LogicalType resolvedType = parsedType.accept(this.resolver);
        return TypeConversions.fromLogicalToDataType(resolvedType);
    }

    @Override
    public DataType createDataType(UnresolvedIdentifier identifier) {
        if (!identifier.getDatabaseName().isPresent()) {
            return this.createDataType(identifier.getObjectName());
        }
        LogicalType resolvedType = this.resolveType(identifier);
        return TypeConversions.fromLogicalToDataType(resolvedType);
    }

    @Override
    public <T> DataType createDataType(Class<T> clazz) {
        return DataTypeExtractor.extractFromType(this, clazz);
    }

    @Override
    public <T> DataType createDataType(TypeInformation<T> typeInfo) {
        return TypeInfoDataTypeConverter.toDataType(this, typeInfo);
    }

    @Override
    public <T> DataType createRawDataType(Class<T> clazz) {
        return DataTypes.RAW(clazz, new KryoSerializer(clazz, this.executionConfig.get()));
    }

    @Override
    public <T> DataType createRawDataType(TypeInformation<T> typeInfo) {
        return DataTypes.RAW(typeInfo.getTypeClass(), typeInfo.createSerializer(this.executionConfig.get()));
    }

    private static Supplier<ExecutionConfig> createSerializerExecutionConfig(ClassLoader classLoader, ReadableConfig config, ExecutionConfig executionConfig) {
        return () -> {
            ExecutionConfig newExecutionConfig = new ExecutionConfig();
            if (executionConfig != null) {
                if (executionConfig.isForceKryoEnabled()) {
                    newExecutionConfig.enableForceKryo();
                }
                if (executionConfig.isForceAvroEnabled()) {
                    newExecutionConfig.enableForceAvro();
                }
                executionConfig.getDefaultKryoSerializers().forEach((c, s) -> newExecutionConfig.addDefaultKryoSerializer(c, s.getSerializer()));
                executionConfig.getDefaultKryoSerializerClasses().forEach((arg_0, arg_1) -> ((ExecutionConfig)newExecutionConfig).addDefaultKryoSerializer(arg_0, arg_1));
                executionConfig.getRegisteredKryoTypes().forEach(arg_0 -> ((ExecutionConfig)newExecutionConfig).registerKryoType(arg_0));
                executionConfig.getRegisteredTypesWithKryoSerializerClasses().forEach((arg_0, arg_1) -> ((ExecutionConfig)newExecutionConfig).registerTypeWithKryoSerializer(arg_0, arg_1));
                executionConfig.getRegisteredTypesWithKryoSerializers().forEach((c, s) -> newExecutionConfig.registerTypeWithKryoSerializer(c, s.getSerializer()));
            }
            newExecutionConfig.configure(config, classLoader);
            return newExecutionConfig;
        };
    }

    private LogicalType resolveType(UnresolvedIdentifier identifier) {
        assert (identifier != null);
        throw new TableException("User-defined types are not supported yet.");
    }

    private class LogicalTypeResolver
    extends LogicalTypeDuplicator {
        private LogicalTypeResolver() {
        }

        @Override
        protected LogicalType defaultMethod(LogicalType logicalType) {
            if (LogicalTypeChecks.hasRoot(logicalType, LogicalTypeRoot.UNRESOLVED)) {
                UnresolvedUserDefinedType unresolvedType = (UnresolvedUserDefinedType)logicalType;
                return DataTypeFactoryImpl.this.resolveType(unresolvedType.getUnresolvedIdentifier()).copy(unresolvedType.isNullable());
            }
            return logicalType;
        }
    }
}

