/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.ColumnarArrayData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.vector.ColumnVector;

public final class ColumnarMapData
implements MapData {
    private final ColumnVector keyColumnVector;
    private final ColumnVector valueColumnVector;
    private final int offset;
    private final int numElements;

    public ColumnarMapData(ColumnVector keyColumnVector, ColumnVector valueColumnVector, int offset, int numElements) {
        this.keyColumnVector = keyColumnVector;
        this.valueColumnVector = valueColumnVector;
        this.offset = offset;
        this.numElements = numElements;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public ArrayData keyArray() {
        return new ColumnarArrayData(this.keyColumnVector, this.offset, this.numElements);
    }

    @Override
    public ArrayData valueArray() {
        return new ColumnarArrayData(this.valueColumnVector, this.offset, this.numElements);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("ColumnarMapData do not support equals, please compare fields one by one!");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("ColumnarMapData do not support hashCode, please hash fields one by one!");
    }
}

