/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.writer;

import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.writer.AbstractBinaryWriter;
import org.apache.flink.types.RowKind;

@Internal
public final class BinaryRowWriter
extends AbstractBinaryWriter {
    private final int nullBitsSizeInBytes;
    private final BinaryRowData row;
    private final int fixedSize;

    public BinaryRowWriter(BinaryRowData row) {
        this(row, 0);
    }

    public BinaryRowWriter(BinaryRowData row, int initialSize) {
        this.nullBitsSizeInBytes = BinaryRowData.calculateBitSetWidthInBytes(row.getArity());
        this.cursor = this.fixedSize = row.getFixedLengthPartSize();
        this.segment = MemorySegmentFactory.wrap((byte[])new byte[this.fixedSize + initialSize]);
        this.row = row;
        this.row.pointTo(this.segment, 0, this.segment.size());
    }

    @Override
    public void reset() {
        this.cursor = this.fixedSize;
        for (int i = 0; i < this.nullBitsSizeInBytes; i += 8) {
            this.segment.putLong(i, 0L);
        }
    }

    @Override
    public void setNullAt(int pos) {
        this.setNullBit(pos);
        this.segment.putLong(this.getFieldOffset(pos), 0L);
    }

    @Override
    public void setNullBit(int pos) {
        BinarySegmentUtils.bitSet(this.segment, 0, pos + 8);
    }

    public void writeRowKind(RowKind kind) {
        this.segment.put(0, kind.toByteValue());
    }

    @Override
    public void writeBoolean(int pos, boolean value) {
        this.segment.putBoolean(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeByte(int pos, byte value) {
        this.segment.put(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeShort(int pos, short value) {
        this.segment.putShort(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeInt(int pos, int value) {
        this.segment.putInt(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeLong(int pos, long value) {
        this.segment.putLong(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeFloat(int pos, float value) {
        this.segment.putFloat(this.getFieldOffset(pos), value);
    }

    @Override
    public void writeDouble(int pos, double value) {
        this.segment.putDouble(this.getFieldOffset(pos), value);
    }

    @Override
    public void complete() {
        this.row.setTotalSize(this.cursor);
    }

    @Override
    public int getFieldOffset(int pos) {
        return this.nullBitsSizeInBytes + 8 * pos;
    }

    @Override
    public void setOffsetAndSize(int pos, int offset, long size) {
        long offsetAndSize = (long)offset << 32 | size;
        this.segment.putLong(this.getFieldOffset(pos), offsetAndSize);
    }

    @Override
    public void afterGrow() {
        this.row.pointTo(this.segment, 0, this.segment.size());
    }
}

