/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.expressions.resolver.LocalOverWindow;
import org.apache.flink.table.expressions.resolver.SqlExpressionResolver;
import org.apache.flink.table.expressions.resolver.lookups.FieldReferenceLookup;
import org.apache.flink.table.expressions.resolver.lookups.TableReferenceLookup;
import org.apache.flink.table.expressions.resolver.rules.ResolverRule;
import org.apache.flink.table.expressions.resolver.rules.ResolverRules;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public class ExpressionResolver {
    private static final VerifyResolutionVisitor VERIFY_RESOLUTION_VISITOR = new VerifyResolutionVisitor();
    private final ReadableConfig config;
    private final FieldReferenceLookup fieldLookup;
    private final TableReferenceLookup tableLookup;
    private final FunctionLookup functionLookup;
    private final DataTypeFactory typeFactory;
    private final SqlExpressionResolver sqlExpressionResolver;
    private final PostResolverFactory postResolverFactory = new PostResolverFactory();
    private final Map<String, LocalReferenceExpression> localReferences;
    @Nullable
    private final DataType outputDataType;
    private final Map<Expression, LocalOverWindow> localOverWindows;
    private final boolean isGroupedAggregation;

    public static List<ResolverRule> getExpandingResolverRules() {
        return Arrays.asList(ResolverRules.UNWRAP_API_EXPRESSION, ResolverRules.LOOKUP_CALL_BY_NAME, ResolverRules.FLATTEN_STAR_REFERENCE, ResolverRules.EXPAND_COLUMN_FUNCTIONS);
    }

    public static List<ResolverRule> getAllResolverRules() {
        return Arrays.asList(ResolverRules.UNWRAP_API_EXPRESSION, ResolverRules.LOOKUP_CALL_BY_NAME, ResolverRules.FLATTEN_STAR_REFERENCE, ResolverRules.EXPAND_COLUMN_FUNCTIONS, ResolverRules.OVER_WINDOWS, ResolverRules.FIELD_RESOLVE, ResolverRules.QUALIFY_BUILT_IN_FUNCTIONS, ResolverRules.RESOLVE_SQL_CALL, ResolverRules.RESOLVE_CALL_BY_ARGUMENTS);
    }

    private ExpressionResolver(TableConfig config, TableReferenceLookup tableLookup, FunctionLookup functionLookup, DataTypeFactory typeFactory, SqlExpressionResolver sqlExpressionResolver, FieldReferenceLookup fieldLookup, List<OverWindow> localOverWindows, List<LocalReferenceExpression> localReferences, @Nullable DataType outputDataType, boolean isGroupedAggregation) {
        this.config = ((TableConfig)Preconditions.checkNotNull((Object)config)).getConfiguration();
        this.tableLookup = (TableReferenceLookup)Preconditions.checkNotNull((Object)tableLookup);
        this.fieldLookup = (FieldReferenceLookup)Preconditions.checkNotNull((Object)fieldLookup);
        this.functionLookup = (FunctionLookup)Preconditions.checkNotNull((Object)functionLookup);
        this.typeFactory = (DataTypeFactory)Preconditions.checkNotNull((Object)typeFactory);
        this.sqlExpressionResolver = (SqlExpressionResolver)Preconditions.checkNotNull((Object)sqlExpressionResolver);
        this.localReferences = localReferences.stream().collect(Collectors.toMap(LocalReferenceExpression::getName, Function.identity(), (u, v) -> {
            throw new IllegalStateException("Duplicate local reference: " + u);
        }, LinkedHashMap::new));
        this.outputDataType = outputDataType;
        this.localOverWindows = this.prepareOverWindows(localOverWindows);
        this.isGroupedAggregation = isGroupedAggregation;
    }

    public static ExpressionResolverBuilder resolverFor(TableConfig config, TableReferenceLookup tableCatalog, FunctionLookup functionLookup, DataTypeFactory typeFactory, SqlExpressionResolver sqlExpressionResolver, QueryOperation ... inputs) {
        return new ExpressionResolverBuilder(inputs, config, tableCatalog, functionLookup, typeFactory, sqlExpressionResolver);
    }

    public List<ResolvedExpression> resolve(List<Expression> expressions) {
        Function<List<Expression>, List<Expression>> resolveFunction = this.concatenateRules(ExpressionResolver.getAllResolverRules());
        List<Expression> resolvedExpressions = resolveFunction.apply(expressions);
        return resolvedExpressions.stream().map(e -> e.accept(VERIFY_RESOLUTION_VISITOR)).collect(Collectors.toList());
    }

    public List<Expression> resolveExpanding(List<Expression> expressions) {
        Function<List<Expression>, List<Expression>> resolveFunction = this.concatenateRules(ExpressionResolver.getExpandingResolverRules());
        return resolveFunction.apply(expressions);
    }

    public PostResolverFactory postResolverFactory() {
        return this.postResolverFactory;
    }

    private Function<List<Expression>, List<Expression>> concatenateRules(List<ResolverRule> rules) {
        return rules.stream().reduce(Function.identity(), (function, resolverRule) -> function.andThen(exprs -> resolverRule.apply((List<Expression>)exprs, new ExpressionResolverContext())), Function::andThen);
    }

    private Map<Expression, LocalOverWindow> prepareOverWindows(List<OverWindow> overWindows) {
        return overWindows.stream().map(this::resolveOverWindow).collect(Collectors.toMap(LocalOverWindow::getAlias, Function.identity()));
    }

    private List<Expression> prepareExpressions(List<Expression> expressions) {
        return expressions.stream().flatMap(e -> this.resolveExpanding(Collections.singletonList(e)).stream()).map(this::resolveFieldsInSingleExpression).collect(Collectors.toList());
    }

    private Expression resolveFieldsInSingleExpression(Expression expression) {
        List<Expression> expressions = ResolverRules.FIELD_RESOLVE.apply(Collections.singletonList(expression), new ExpressionResolverContext());
        if (expressions.size() != 1) {
            throw new TableException("Expected a single expression as a result. Got: " + expressions);
        }
        return expressions.get(0);
    }

    private LocalOverWindow resolveOverWindow(OverWindow overWindow) {
        return new LocalOverWindow(overWindow.getAlias(), this.prepareExpressions(overWindow.getPartitioning()), this.resolveFieldsInSingleExpression(overWindow.getOrder()), this.resolveFieldsInSingleExpression(overWindow.getPreceding()), overWindow.getFollowing().map(this::resolveFieldsInSingleExpression).orElse(null));
    }

    public static class ExpressionResolverBuilder {
        private final TableConfig config;
        private final List<QueryOperation> queryOperations;
        private final TableReferenceLookup tableCatalog;
        private final FunctionLookup functionLookup;
        private final DataTypeFactory typeFactory;
        private final SqlExpressionResolver sqlExpressionResolver;
        private List<OverWindow> logicalOverWindows = new ArrayList<OverWindow>();
        private List<LocalReferenceExpression> localReferences = new ArrayList<LocalReferenceExpression>();
        @Nullable
        private DataType outputDataType;
        private boolean isGroupedAggregation;

        private ExpressionResolverBuilder(QueryOperation[] queryOperations, TableConfig config, TableReferenceLookup tableCatalog, FunctionLookup functionLookup, DataTypeFactory typeFactory, SqlExpressionResolver sqlExpressionResolver) {
            this.config = config;
            this.queryOperations = Arrays.asList(queryOperations);
            this.tableCatalog = tableCatalog;
            this.functionLookup = functionLookup;
            this.typeFactory = typeFactory;
            this.sqlExpressionResolver = sqlExpressionResolver;
        }

        public ExpressionResolverBuilder withOverWindows(List<OverWindow> windows) {
            this.logicalOverWindows = (List)Preconditions.checkNotNull(windows);
            return this;
        }

        public ExpressionResolverBuilder withLocalReferences(LocalReferenceExpression ... localReferences) {
            this.localReferences = Arrays.asList(localReferences);
            return this;
        }

        public ExpressionResolverBuilder withOutputDataType(@Nullable DataType outputDataType) {
            this.outputDataType = outputDataType;
            return this;
        }

        public ExpressionResolverBuilder withGroupedAggregation(boolean isGroupedAggregation) {
            this.isGroupedAggregation = isGroupedAggregation;
            return this;
        }

        public ExpressionResolver build() {
            return new ExpressionResolver(this.config, this.tableCatalog, this.functionLookup, this.typeFactory, this.sqlExpressionResolver, new FieldReferenceLookup(this.queryOperations), this.logicalOverWindows, this.localReferences, this.outputDataType, this.isGroupedAggregation);
        }
    }

    public class PostResolverFactory {
        public CallExpression as(ResolvedExpression expression, String alias) {
            FunctionLookup.Result lookupOfAs = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(BuiltInFunctionDefinitions.AS);
            return new CallExpression(lookupOfAs.getFunctionIdentifier(), lookupOfAs.getFunctionDefinition(), Arrays.asList(expression, ApiExpressionUtils.valueLiteral(alias)), expression.getOutputDataType());
        }

        public CallExpression cast(ResolvedExpression expression, DataType dataType) {
            FunctionLookup.Result lookupOfCast = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(BuiltInFunctionDefinitions.CAST);
            return new CallExpression(lookupOfCast.getFunctionIdentifier(), lookupOfCast.getFunctionDefinition(), Arrays.asList(expression, ApiExpressionUtils.typeLiteral(dataType)), dataType);
        }

        public CallExpression row(DataType dataType, ResolvedExpression ... expression) {
            FunctionLookup.Result lookupOfRow = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(BuiltInFunctionDefinitions.ROW);
            return new CallExpression(lookupOfRow.getFunctionIdentifier(), lookupOfRow.getFunctionDefinition(), Arrays.asList(expression), dataType);
        }

        public CallExpression array(DataType dataType, ResolvedExpression ... expression) {
            FunctionLookup.Result lookupOfArray = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(BuiltInFunctionDefinitions.ARRAY);
            return new CallExpression(lookupOfArray.getFunctionIdentifier(), lookupOfArray.getFunctionDefinition(), Arrays.asList(expression), dataType);
        }

        public CallExpression map(DataType dataType, ResolvedExpression ... expression) {
            FunctionLookup.Result lookupOfArray = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(BuiltInFunctionDefinitions.MAP);
            return new CallExpression(lookupOfArray.getFunctionIdentifier(), lookupOfArray.getFunctionDefinition(), Arrays.asList(expression), dataType);
        }

        public CallExpression wrappingCall(BuiltInFunctionDefinition definition, ResolvedExpression expression) {
            FunctionLookup.Result lookupOfDefinition = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(definition);
            return new CallExpression(lookupOfDefinition.getFunctionIdentifier(), lookupOfDefinition.getFunctionDefinition(), Collections.singletonList(expression), expression.getOutputDataType());
        }

        public CallExpression get(ResolvedExpression composite, ValueLiteralExpression key, DataType dataType) {
            FunctionLookup.Result lookupOfGet = ExpressionResolver.this.functionLookup.lookupBuiltInFunction(BuiltInFunctionDefinitions.GET);
            return new CallExpression(lookupOfGet.getFunctionIdentifier(), lookupOfGet.getFunctionDefinition(), Arrays.asList(composite, key), dataType);
        }
    }

    private class ExpressionResolverContext
    implements ResolverRule.ResolutionContext {
        private ExpressionResolverContext() {
        }

        @Override
        public ReadableConfig configuration() {
            return ExpressionResolver.this.config;
        }

        @Override
        public FieldReferenceLookup referenceLookup() {
            return ExpressionResolver.this.fieldLookup;
        }

        @Override
        public TableReferenceLookup tableLookup() {
            return ExpressionResolver.this.tableLookup;
        }

        @Override
        public FunctionLookup functionLookup() {
            return ExpressionResolver.this.functionLookup;
        }

        @Override
        public DataTypeFactory typeFactory() {
            return ExpressionResolver.this.typeFactory;
        }

        @Override
        public SqlExpressionResolver sqlExpressionResolver() {
            return ExpressionResolver.this.sqlExpressionResolver;
        }

        @Override
        public PostResolverFactory postResolutionFactory() {
            return ExpressionResolver.this.postResolverFactory;
        }

        @Override
        public Optional<LocalReferenceExpression> getLocalReference(String alias) {
            return Optional.ofNullable(ExpressionResolver.this.localReferences.get(alias));
        }

        @Override
        public List<LocalReferenceExpression> getLocalReferences() {
            return new ArrayList<LocalReferenceExpression>(ExpressionResolver.this.localReferences.values());
        }

        @Override
        public Optional<DataType> getOutputDataType() {
            return Optional.ofNullable(ExpressionResolver.this.outputDataType);
        }

        @Override
        public Optional<LocalOverWindow> getOverWindow(Expression alias) {
            return Optional.ofNullable(ExpressionResolver.this.localOverWindows.get(alias));
        }

        @Override
        public boolean isGroupedAggregation() {
            return ExpressionResolver.this.isGroupedAggregation;
        }
    }

    private static class VerifyResolutionVisitor
    extends ApiExpressionDefaultVisitor<ResolvedExpression> {
        private VerifyResolutionVisitor() {
        }

        @Override
        public ResolvedExpression visit(CallExpression call) {
            call.getChildren().forEach(c -> c.accept(this));
            return call;
        }

        @Override
        protected ResolvedExpression defaultMethod(Expression expression) {
            if (expression instanceof ResolvedExpression) {
                return (ResolvedExpression)expression;
            }
            throw new TableException("All expressions should have been resolved at this stage. Unexpected expression: " + expression);
        }
    }
}

