/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.IOException;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.table.filesystem.stream.compact.CompactContext;
import org.apache.flink.table.filesystem.stream.compact.CompactWriter;
import org.apache.flink.util.function.SupplierWithException;

public class CompactBucketWriter<T>
implements CompactWriter<T> {
    private final BucketWriter<T, String> bucketWriter;
    private final InProgressFileWriter<T, String> writer;

    private CompactBucketWriter(BucketWriter<T, String> bucketWriter, InProgressFileWriter<T, String> writer) {
        this.bucketWriter = bucketWriter;
        this.writer = writer;
    }

    @Override
    public void write(T record) throws IOException {
        this.writer.write(record, 0L);
    }

    @Override
    public void commit() throws IOException {
        this.bucketWriter.recoverPendingFile(this.writer.closeForCommit()).commit();
    }

    public static <T> CompactWriter.Factory<T> factory(SupplierWithException<BucketWriter<T, String>, IOException> factory) {
        return new Factory<T>(factory);
    }

    private static class Factory<T>
    implements CompactWriter.Factory<T> {
        private final SupplierWithException<BucketWriter<T, String>, IOException> factory;
        private BucketWriter<T, String> bucketWriter;

        public Factory(SupplierWithException<BucketWriter<T, String>, IOException> factory) {
            this.factory = factory;
        }

        @Override
        public CompactWriter<T> create(CompactContext context) throws IOException {
            if (this.bucketWriter == null) {
                this.bucketWriter = (BucketWriter)this.factory.get();
            }
            return new CompactBucketWriter(this.bucketWriter, this.bucketWriter.openNewInProgressFile(context.getPartition(), context.getPath(), 0L));
        }
    }
}

