/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.flink.table.planner.catalog.CatalogSchemaTable;
import org.apache.flink.table.planner.catalog.FlinkSchema;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.utils.CatalogTableStatisticsConverter;

class DatabaseCalciteSchema
extends FlinkSchema {
    private final String catalogName;
    private final String databaseName;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;

    public DatabaseCalciteSchema(String catalogName, String databaseName, CatalogManager catalog, boolean isStreamingMode) {
        this.databaseName = databaseName;
        this.catalogName = catalogName;
        this.catalogManager = catalog;
        this.isStreamingMode = isStreamingMode;
    }

    @Override
    public Table getTable(String tableName) {
        ObjectIdentifier identifier = ObjectIdentifier.of(this.catalogName, this.databaseName, tableName);
        return this.catalogManager.getTable(identifier).map(lookupResult -> new CatalogSchemaTable(identifier, (CatalogManager.TableLookupResult)lookupResult, this.getStatistic((CatalogManager.TableLookupResult)lookupResult, identifier), this.isStreamingMode)).orElse(null);
    }

    private FlinkStatistic getStatistic(CatalogManager.TableLookupResult lookupResult, ObjectIdentifier identifier) {
        ResolvedCatalogBaseTable<?> resolvedBaseTable = lookupResult.getResolvedTable();
        switch (resolvedBaseTable.getTableKind()) {
            case TABLE: {
                return FlinkStatistic.builder().tableStats(this.extractTableStats(lookupResult, identifier)).uniqueKeys((UniqueConstraint)resolvedBaseTable.getResolvedSchema().getPrimaryKey().orElse(null)).build();
            }
        }
        return FlinkStatistic.UNKNOWN();
    }

    private TableStats extractTableStats(CatalogManager.TableLookupResult lookupResult, ObjectIdentifier identifier) {
        if (lookupResult.isTemporary()) {
            return TableStats.UNKNOWN;
        }
        Catalog catalog = lookupResult.getCatalog().orElseThrow(IllegalStateException::new);
        ObjectPath tablePath = identifier.toObjectPath();
        try {
            CatalogTableStatistics tableStatistics = catalog.getTableStatistics(tablePath);
            CatalogColumnStatistics columnStatistics = catalog.getTableColumnStatistics(tablePath);
            return CatalogTableStatisticsConverter.convertToTableStats(tableStatistics, columnStatistics);
        }
        catch (TableNotExistException e) {
            throw new ValidationException(String.format("Could not get statistic for table: [%s, %s, %s]", identifier.getCatalogName(), tablePath.getDatabaseName(), tablePath.getObjectName()), e);
        }
    }

    @Override
    public Set<String> getTableNames() {
        return this.catalogManager.listTables(this.catalogName, this.databaseName);
    }

    @Override
    public Schema getSubSchema(String s) {
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }
}

