/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class ProjectionCodeGenerator$ {
    public static ProjectionCodeGenerator$ MODULE$;

    static {
        new ProjectionCodeGenerator$();
    }

    public GeneratedExpression generateProjectionExpression(CodeGeneratorContext ctx, RowType inType, RowType outType, int[] inputMapping, Class<? extends RowData> outClass, String inputTerm, String outRecordTerm, String outRecordWriterTerm, boolean reusedOutRecord) {
        ExprCodeGenerator exprGenerator = new ExprCodeGenerator(ctx, false).bindInput(inType, inputTerm, (Option<int[]>)Option$.MODULE$.apply((Object)inputMapping));
        GeneratedExpression[] accessExprs = (GeneratedExpression[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(inputMapping)).map((Function1 & Serializable & scala.Serializable)idx -> GenerateUtils$.MODULE$.generateFieldAccess(ctx, inType, inputTerm, BoxesRunTime.unboxToInt((Object)idx)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        GeneratedExpression expression = exprGenerator.generateResultExpression((Seq<GeneratedExpression>)Predef$.MODULE$.wrapRefArray((Object[])accessExprs), outType, outClass, outRecordTerm, (Option<String>)Option$.MODULE$.apply((Object)outRecordWriterTerm), reusedOutRecord, exprGenerator.generateResultExpression$default$7());
        String initCode = GenerateUtils$.MODULE$.generateRecordStatement(outType, outClass, outRecordTerm, (Option<String>)new Some((Object)outRecordWriterTerm), ctx);
        String outRowInitCode = reusedOutRecord ? GeneratedExpression$.MODULE$.NO_CODE() : initCode;
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(31).append("\n         |").append(outRowInitCode).append("\n         |").append(expression.code()).append("\n        ").toString())).stripMargin();
        return new GeneratedExpression(outRecordTerm, GeneratedExpression$.MODULE$.NEVER_NULL(), code, outType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public GeneratedProjection generateProjection(CodeGeneratorContext ctx, String name, RowType inType, RowType outType, int[] inputMapping, Class<? extends RowData> outClass, String inputTerm, String outRecordTerm, String outRecordWriterTerm, boolean reusedOutRecord) {
        String className = CodeGenUtils$.MODULE$.newName(name);
        Class<Projection> baseClass = Projection.class;
        GeneratedExpression expression = this.generateProjectionExpression(ctx, inType, outType, inputMapping, outClass, inputTerm, outRecordTerm, outRecordWriterTerm, reusedOutRecord);
        String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(318).append("\n         |public class ").append(className).append(" implements ").append(baseClass.getCanonicalName()).append("<").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(", ").append(outClass.getCanonicalName()).append("> {\n         |\n         |  ").append(ctx.reuseMemberCode()).append("\n         |\n         |  public ").append(className).append("(Object[] references) throws Exception {\n         |    ").append(ctx.reuseInitCode()).append("\n         |  }\n         |\n         |  @Override\n         |  public ").append(outClass.getCanonicalName()).append(" apply(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" ").append(inputTerm).append(") {\n         |    ").append(ctx.reuseLocalVariableCode(ctx.reuseLocalVariableCode$default$1())).append("\n         |    ").append(expression.code()).append("\n         |    return ").append(expression.resultTerm()).append(";\n         |  }\n         |}\n        ").toString())).stripMargin();
        return new GeneratedProjection(className, code, (Object[])ctx.references().toArray(ClassTag$.MODULE$.AnyRef()), ctx.tableConfig().getConfiguration());
    }

    public GeneratedProjection generateProjection(CodeGeneratorContext ctx, String name, RowType inputType, RowType outputType, int[] inputMapping) {
        CodeGeneratorContext x$1 = ctx;
        String x$2 = name;
        RowType x$3 = inputType;
        RowType x$4 = outputType;
        int[] x$5 = inputMapping;
        String x$6 = CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
        Class<? extends RowData> x$7 = this.generateProjection$default$6();
        String x$8 = this.generateProjection$default$8();
        String x$9 = this.generateProjection$default$9();
        boolean x$10 = this.generateProjection$default$10();
        return this.generateProjection(x$1, x$2, x$3, x$4, x$5, x$7, x$6, x$8, x$9, x$10);
    }

    public Class<? extends RowData> generateProjection$default$6() {
        return BinaryRowData.class;
    }

    public String generateProjection$default$7() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    public String generateProjection$default$8() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_TERM();
    }

    public String generateProjection$default$9() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_WRITER_TERM();
    }

    public boolean generateProjection$default$10() {
        return true;
    }

    public Class<? extends RowData> generateProjectionExpression$default$5() {
        return BinaryRowData.class;
    }

    public String generateProjectionExpression$default$6() {
        return CodeGenUtils$.MODULE$.DEFAULT_INPUT1_TERM();
    }

    public String generateProjectionExpression$default$7() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_TERM();
    }

    public String generateProjectionExpression$default$8() {
        return CodeGenUtils$.MODULE$.DEFAULT_OUT_RECORD_WRITER_TERM();
    }

    public boolean generateProjectionExpression$default$9() {
        return true;
    }

    private ProjectionCodeGenerator$() {
        MODULE$ = this;
    }
}

