/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.abilities.SupportsWritingMetadata;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.sink.OutputConversionOperator;
import org.apache.flink.table.runtime.typeutils.ExternalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
final class ExternalDynamicSink
implements DynamicTableSink,
SupportsWritingMetadata {
    private static final String ROWTIME_METADATA_KEY = "rowtime";
    private static final DataType ROWTIME_METADATA_DATA_TYPE = (DataType)DataTypes.TIMESTAMP_LTZ(3).notNull();
    @Nullable
    private final ChangelogMode changelogMode;
    private final DataType physicalDataType;
    private boolean consumeRowtimeMetadata;

    ExternalDynamicSink(@Nullable ChangelogMode changelogMode, DataType physicalDataType) {
        this.changelogMode = changelogMode;
        this.physicalDataType = physicalDataType;
    }

    @Override
    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        if (this.changelogMode == null) {
            return requestedMode;
        }
        return this.changelogMode;
    }

    @Override
    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        DynamicTableSink.DataStructureConverter physicalConverter = context.createDataStructureConverter(this.physicalDataType);
        return transformationContext -> {
            Transformation<RowData> input = transformationContext.getInputTransformation();
            LogicalType physicalType = this.physicalDataType.getLogicalType();
            RowData.FieldGetter atomicFieldGetter = LogicalTypeChecks.isCompositeType(physicalType) ? null : RowData.createFieldGetter(physicalType, 0);
            return new OneInputTransformation(input, this.generateOperatorName(), (OneInputStreamOperator)new OutputConversionOperator(atomicFieldGetter, physicalConverter, transformationContext.getRowtimeIndex(), this.consumeRowtimeMetadata), ExternalTypeInfo.of(this.physicalDataType), input.getParallelism());
        };
    }

    private String generateOperatorName() {
        return String.format("TableToDataSteam(type=%s, rowtime=%s)", this.physicalDataType.toString(), this.consumeRowtimeMetadata);
    }

    @Override
    public DynamicTableSink copy() {
        return new ExternalDynamicSink(this.changelogMode, this.physicalDataType);
    }

    @Override
    public String asSummaryString() {
        return this.generateOperatorName();
    }

    @Override
    public Map<String, DataType> listWritableMetadata() {
        return Collections.singletonMap(ROWTIME_METADATA_KEY, ROWTIME_METADATA_DATA_TYPE);
    }

    @Override
    public void applyWritableMetadata(List<String> metadataKeys, DataType consumedDataType) {
        this.consumeRowtimeMetadata = metadataKeys.contains(ROWTIME_METADATA_KEY);
    }
}

