/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.connectors;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.transformations.WithBoundedness;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

@Internal
public interface TransformationScanProvider
extends ScanTableSource.ScanRuntimeProvider {
    public static TransformationScanProvider of(final Transformation<RowData> transformation) {
        Preconditions.checkNotNull(transformation, (String)"Transformation must not be null.");
        return new TransformationScanProvider(){

            @Override
            public Transformation<RowData> createTransformation() {
                return transformation;
            }

            @Override
            public boolean isBounded() {
                return !this.isUnboundedSource(transformation) && transformation.getTransitivePredecessors().stream().noneMatch(this::isUnboundedSource);
            }

            private boolean isUnboundedSource(Transformation<?> transformation2) {
                return transformation2 instanceof WithBoundedness && ((WithBoundedness)transformation2).getBoundedness() != Boundedness.BOUNDED;
            }
        };
    }

    public Transformation<RowData> createTransformation();
}

