/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.processor.DeadlockBreakupProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodePlanDumper;
import org.apache.flink.table.planner.plan.optimize.BatchCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001=\u0011ABQ1uG\"\u0004F.\u00198oKJT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005AQ\r_3dkR|'\u000f\u0005\u0002\u001835\t\u0001D\u0003\u0002\u0004\r%\u0011!\u0004\u0007\u0002\t\u000bb,7-\u001e;pe\"AA\u0004\u0001B\u0001B\u0003%Q$\u0001\u0004d_:4\u0017n\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\t1!\u00199j\u0013\t\u0011sDA\u0006UC\ndWmQ8oM&<\u0007\"\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003\u001d\u0019\u0017\r^1m_\u001eL!AK\u0014\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eL!\u0001\n\n\t\u00135\u0002!\u0011!Q\u0001\n9\n\u0014AD2bi\u0006dwnZ'b]\u0006<WM\u001d\t\u0003M=J!\u0001M\u0014\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe&\u0011QF\u0005\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bU2t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u000b3\u0001\u00041\u0002\"\u0002\u000f3\u0001\u0004i\u0002\"\u0002\u00133\u0001\u0004)\u0003\"B\u00173\u0001\u0004q\u0003\"B\u001e\u0001\t#b\u0014\u0001D4fiR\u0013\u0018-\u001b;EK\u001a\u001cX#A\u001f\u0011\u0007y\n5)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0015\t%O]1za\t!e\nE\u0002F\u00152k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001\u001d7b]*\u0011\u0011JC\u0001\bG\u0006d7-\u001b;f\u0013\tYeIA\u0006SK2$&/Y5u\t\u00164\u0007CA'O\u0019\u0001!\u0011b\u0014\u001e\u0002\u0002\u0003\u0005)\u0011\u0001)\u0003\u0007}#\u0013'\u0005\u0002R)B\u0011aHU\u0005\u0003'~\u0012qAT8uQ&tw\r\u0005\u0002F+&\u0011aK\u0012\u0002\t%\u0016dGK]1ji\")\u0001\f\u0001C)3\u0006aq-\u001a;PaRLW.\u001b>feV\t!\f\u0005\u0002\\?6\tAL\u0003\u0002^=\u0006Aq\u000e\u001d;j[&TXM\u0003\u0002H\t%\u0011\u0001\r\u0018\u0002\n\u001fB$\u0018.\\5{KJDQA\u0019\u0001\u0005R\r\f!dZ3u\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5Qe>\u001cWm]:peN,\u0012\u0001\u001a\t\u0004K6\u0004hB\u00014l\u001d\t9'.D\u0001i\u0015\tIg\"\u0001\u0004=e>|GOP\u0005\u0002\u0001&\u0011AnP\u0001\ba\u0006\u001c7.Y4f\u0013\tqwNA\u0002TKFT!\u0001\\ \u0011\u0005EDX\"\u0001:\u000b\u0005M$\u0018!\u00039s_\u000e,7o]8s\u0015\t)h/\u0001\u0003fq\u0016\u001c'BA<_\u0003\u0015qw\u000eZ3t\u0013\tI(O\u0001\fFq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b)s_\u000e,7o]8s\u0011\u0015Y\b\u0001\"\u0015}\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tGcA?\u0002*A)a0a\u0002\u0002\f5\tqP\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B;uS2T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013y(\u0001\u0002'jgR\u0004D!!\u0004\u0002\u001eA1\u0011qBA\f\u00037i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0004I\u0006<'B\u0001\u0011\t\u0013\u0011\tI\"!\u0005\u0003\u001dQ\u0013\u0018M\\:g_Jl\u0017\r^5p]B\u0019Q*!\b\u0005\u0017\u0005}!0!A\u0001\u0002\u000b\u0005\u0011\u0011\u0005\u0002\u0004?\u0012\u0012\u0014cA)\u0002$A\u0019a(!\n\n\u0007\u0005\u001drHA\u0002B]fDq!a\u000b{\u0001\u0004\ti#A\u0005fq\u0016\u001cwI]1qQB!\u0011qFA\u0019\u001b\u0005!\u0018bAA\u001ai\niQ\t_3d\u001d>$Wm\u0012:ba\"Dq!a\u000e\u0001\t\u0003\nI$A\u0004fqBd\u0017-\u001b8\u0015\r\u0005m\u00121JA.!\u0011\ti$!\u0012\u000f\t\u0005}\u0012\u0011\t\t\u0003O~J1!a\u0011@\u0003\u0019\u0001&/\u001a3fM&!\u0011qIA%\u0005\u0019\u0019FO]5oO*\u0019\u00111I \t\u0011\u00055\u0013Q\u0007a\u0001\u0003\u001f\n!b\u001c9fe\u0006$\u0018n\u001c8t!\u0015q\u0018qAA)!\u0011\t\u0019&a\u0016\u000e\u0005\u0005U#bAA'\r%!\u0011\u0011LA+\u0005%y\u0005/\u001a:bi&|g\u000e\u0003\u0005\u0002^\u0005U\u0002\u0019AA0\u00031)\u0007\u0010\u001e:b\t\u0016$\u0018-\u001b7t!\u0015q\u0014\u0011MA3\u0013\r\t\u0019g\u0010\u0002\u000byI,\u0007/Z1uK\u0012t\u0004c\u0001\u0010\u0002h%\u0019\u0011\u0011N\u0010\u0003\u001b\u0015C\b\u000f\\1j]\u0012+G/Y5m\u0011\u001d\ti\u0007\u0001C\u0005\u0003_\n!c\u0019:fCR,G)^7nsBc\u0017M\u001c8feR\tQ\u0007C\u0004\u0002t\u0001!\t%!\u001e\u0002\u001f\u0015D\b\u000f\\1j]*\u001bxN\u001c)mC:$b!a\u000f\u0002x\u0005m\u0004\u0002CA=\u0003c\u0002\r!a\u000f\u0002\u0011)\u001cxN\u001c)mC:D\u0001\"!\u0018\u0002r\u0001\u0007\u0011q\f\u0005\b\u0003\u007f\u0002A\u0011IAA\u0003\u00012\u0018\r\\5eCR,\u0017I\u001c3Pm\u0016\u0014(/\u001b3f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005\u0005\r\u0005c\u0001 \u0002\u0006&\u0019\u0011qQ \u0003\tUs\u0017\u000e\u001e")
public class BatchPlanner
extends PlannerBase {
    private final Executor executor;
    private final TableConfig config;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE});
    }

    @Override
    public Optimizer getOptimizer() {
        return new BatchCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors() {
        ArrayList<ExecNodeGraphProcessor> processors = new ArrayList<ExecNodeGraphProcessor>();
        processors.add(new DeadlockBreakupProcessor());
        Object object = this.getTableConfig().getConfiguration().getBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED) ? BoxesRunTime.boxToBoolean((boolean)processors.add(new MultipleInputNodeCreationProcessor(false))) : BoxedUnit.UNIT;
        return JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(processors);
    }

    @Override
    public List<Transformation<?>> translateToPlan(ExecNodeGraph execGraph) {
        this.validateAndOverrideConfiguration();
        BatchPlanner planner = this.createDummyPlanner();
        Buffer transformations = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(execGraph.getRootNodes()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ExecNode execNode = x0$1;
            if (!(execNode instanceof BatchExecNode)) {
                throw new TableException("Cannot generate BoundedStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            BatchExecNode batchExecNode = (BatchExecNode)execNode;
            Transformation transformation = batchExecNode.translateToPlan(planner);
            return transformation;
        }, Buffer$.MODULE$.canBuildFrom());
        this.cleanupInternalConfigurations();
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(transformations);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "operations should not be empty");
        this.validateAndOverrideConfiguration();
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(operations).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            RelNode relNode;
            Operation operation = x0$2;
            if (operation instanceof QueryOperation) {
                RelNode relNode2;
                QueryOperation queryOperation = (QueryOperation)operation;
                RelNode relNode3 = this.getRelBuilder().queryOperation(queryOperation).build();
                RelNode relNode4 = relNode3;
                if (relNode4 instanceof LogicalTableModify) {
                    LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                    List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                    Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0 & Serializable & scala.Serializable)() -> "the length of qualified name should be 3.");
                    CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of(qualifiedName.get(0), qualifiedName.get(1), qualifiedName.get(2)), new PlannerQueryOperation(logicalTableModify.getInput()));
                    relNode2 = this.translateToRel(modifyOperation);
                } else {
                    relNode2 = relNode3;
                }
                relNode = relNode2;
            } else if (operation instanceof ModifyOperation) {
                ModifyOperation modifyOperation = (ModifyOperation)operation;
                relNode = this.translateToRel(modifyOperation);
            } else {
                throw new TableException(new java.lang.StringBuilder(23).append("Unsupported operation: ").append(operation.getClass().getCanonicalName()).toString());
            }
            return relNode;
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        StreamGraph streamGraph = (StreamGraph)this.executor.createPipeline(transformations, (ReadableConfig)this.config.getConfiguration(), null);
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes.foreach((Function1 & Serializable & scala.Serializable)sink -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)sink, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Physical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        optimizedRelNodes.foreach((Function1 & Serializable & scala.Serializable)rel -> {
            sb.append(FlinkRelOptUtil$.MODULE$.toString((RelNode)rel, explainLevel, FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
            return sb.append(System.lineSeparator());
        });
        sb.append("== Optimized Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(ExecNodePlanDumper.dagToString(execGraph));
        if (extraDetails.contains((Object)ExplainDetail.JSON_EXECUTION_PLAN)) {
            sb.append(System.lineSeparator());
            sb.append("== Physical Execution Plan ==");
            sb.append(System.lineSeparator());
            boxedUnit = sb.append(streamGraph.getStreamingPlanAsJSON());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    private BatchPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        DefaultExecutor executor = new DefaultExecutor(dummyExecEnv);
        return new BatchPlanner(executor, this.config, super.functionCatalog(), super.catalogManager());
    }

    public String explainJsonPlan(String jsonPlan, Seq<ExplainDetail> extraDetails) {
        throw new TableException("This method is not supported for batch planner now.");
    }

    @Override
    public void validateAndOverrideConfiguration() {
        RuntimeExecutionMode runtimeMode;
        super.validateAndOverrideConfiguration();
        RuntimeExecutionMode runtimeExecutionMode = runtimeMode = (RuntimeExecutionMode)this.getConfiguration().get(ExecutionOptions.RUNTIME_MODE);
        RuntimeExecutionMode runtimeExecutionMode2 = RuntimeExecutionMode.BATCH;
        if (runtimeExecutionMode == null ? runtimeExecutionMode2 != null : !runtimeExecutionMode.equals(runtimeExecutionMode2)) {
            throw new IllegalArgumentException("Mismatch between configured runtime mode and actual runtime mode. Currently, the 'execution.runtime-mode' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
        }
    }

    @Override
    public String explainJsonPlan(String jsonPlan, ExplainDetail[] extraDetails) {
        return this.explainJsonPlan(jsonPlan, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    @Override
    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public BatchPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.executor = executor;
        this.config = config;
        super(executor, config, functionCatalog, catalogManager, false);
    }
}

