/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.calcite.jdbc.CalciteSchemaBuilder;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.PlannerType;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.ExternalModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.OutputConversionModifyOperation;
import org.apache.flink.table.operations.UnregisteredSinkModifyOperation;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.catalog.CatalogManagerCalciteSchema;
import org.apache.flink.table.planner.connectors.DynamicSinkUtils;
import org.apache.flink.table.planner.delegation.DefaultExecutor;
import org.apache.flink.table.planner.delegation.ParserFactory;
import org.apache.flink.table.planner.delegation.PlannerConfiguration;
import org.apache.flink.table.planner.delegation.PlannerContext;
import org.apache.flink.table.planner.expressions.PlannerTypeInferenceUtilImpl;
import org.apache.flink.table.planner.hint.FlinkHints;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalLegacySink$;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraphGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ExecNodeGraphProcessor;
import org.apache.flink.table.planner.plan.nodes.exec.processor.ProcessorContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.reuse.SubplanReuser$;
import org.apache.flink.table.planner.plan.utils.SameRelObjectShuttle;
import org.apache.flink.table.planner.sinks.DataStreamTableSink;
import org.apache.flink.table.planner.sinks.TableSinkUtils$;
import org.apache.flink.table.planner.utils.InternalConfigOptions;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.LegacyTypeInfoDataTypeConverter;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\rec!B\u0001\u0003\u0003\u0003y!a\u0003)mC:tWM\u001d\"bg\u0016T!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001AA\u0002CA\t\u0017\u001b\u0005\u0011\"BA\n\u0015\u0003\u0011a\u0017M\\4\u000b\u0003U\tAA[1wC&\u0011qC\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005eYR\"\u0001\u000e\u000b\u0005\r1\u0011B\u0001\u000f\u001b\u0005\u001d\u0001F.\u00198oKJD\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\tKb,7-\u001e;peB\u0011\u0011\u0004I\u0005\u0003Ci\u0011\u0001\"\u0012=fGV$xN\u001d\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511m\u001c8gS\u001e\u0004\"!\n\u0015\u000e\u0003\u0019R!a\n\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002*M\tYA+\u00192mK\u000e{gNZ5h\u0011!Y\u0003A!b\u0001\n\u0003a\u0013a\u00044v]\u000e$\u0018n\u001c8DCR\fGn\\4\u0016\u00035\u0002\"AL\u0019\u000e\u0003=R!\u0001\r\u0004\u0002\u000f\r\fG/\u00197pO&\u0011!g\f\u0002\u0010\rVt7\r^5p]\u000e\u000bG/\u00197pO\"AA\u0007\u0001B\u0001B\u0003%Q&\u0001\tgk:\u001cG/[8o\u0007\u0006$\u0018\r\\8hA!Aa\u0007\u0001BC\u0002\u0013\u0005q'\u0001\bdCR\fGn\\4NC:\fw-\u001a:\u0016\u0003a\u0002\"AL\u001d\n\u0005iz#AD\"bi\u0006dwnZ'b]\u0006<WM\u001d\u0005\ty\u0001\u0011\t\u0011)A\u0005q\u0005y1-\u0019;bY><W*\u00198bO\u0016\u0014\b\u0005\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0003=I7o\u0015;sK\u0006l\u0017N\\4N_\u0012,\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%a\u0002\"p_2,\u0017M\u001c\u0005\u0006\r\u0002!\taR\u0001\u0007y%t\u0017\u000e\u001e \u0015\r!S5\nT'O!\tI\u0005!D\u0001\u0003\u0011\u0015qR\t1\u0001 \u0011\u0015\u0019S\t1\u0001%\u0011\u0015YS\t1\u0001.\u0011\u00151T\t1\u00019\u0011\u0015qT\t1\u0001@\u0011%\u0001\u0006\u00011AA\u0002\u0013%\u0011+\u0001\u0004qCJ\u001cXM]\u000b\u0002%B\u0011\u0011dU\u0005\u0003)j\u0011a\u0001U1sg\u0016\u0014\b\"\u0003,\u0001\u0001\u0004\u0005\r\u0011\"\u0003X\u0003)\u0001\u0018M]:fe~#S-\u001d\u000b\u00031n\u0003\"\u0001Q-\n\u0005i\u000b%\u0001B+oSRDq\u0001X+\u0002\u0002\u0003\u0007!+A\u0002yIEB\u0011B\u0018\u0001A\u0002\u0003\u0005\u000b\u0015\u0002*\u0002\u000fA\f'o]3sA!9\u0001\r\u0001a\u0001\n\u0013\t\u0017AD2veJ,g\u000e\u001e#jC2,7\r^\u000b\u0002EB\u0011QeY\u0005\u0003I\u001a\u0012!bU9m\t&\fG.Z2u\u0011\u001d1\u0007\u00011A\u0005\n\u001d\f!cY;se\u0016tG\u000fR5bY\u0016\u001cGo\u0018\u0013fcR\u0011\u0001\f\u001b\u0005\b9\u0016\f\t\u00111\u0001c\u0011\u0019Q\u0007\u0001)Q\u0005E\u0006y1-\u001e:sK:$H)[1mK\u000e$\b\u0005C\u0004m\u0001\t\u0007I\u0011B7\u0002)Ad\u0017M\u001c8fe\u000e{gNZ5hkJ\fG/[8o+\u0005q\u0007CA8s\u001b\u0005\u0001(BA9\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u00111\u000f\u001d\u0002\u000f%\u0016\fG-\u00192mK\u000e{gNZ5h\u0011\u0019)\b\u0001)A\u0005]\u0006)\u0002\u000f\\1o]\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0003\u0002C<\u0001\u0005\u0004%\t\u0001\u0003=\u0002\u001dAd\u0017M\u001c8fe\u000e{g\u000e^3yiV\t\u0011\u0010\u0005\u0002Ju&\u00111P\u0001\u0002\u000f!2\fgN\\3s\u0007>tG/\u001a=u\u0011\u0019i\b\u0001)A\u0005s\u0006y\u0001\u000f\\1o]\u0016\u00148i\u001c8uKb$\b\u0005\u000b\u0002}\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006!\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI!a\u0001\u0003#YK7/\u001b2mK\u001a{'\u000fV3ti&tw\r\u0003\u0005\u0002\u000e\u0001!\t\u0001CA\b\u000359W\r\u001e*fY\n+\u0018\u000e\u001c3feV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0003\u0002\u000f\r\fGnY5uK&!\u00111DA\u000b\u0005=1E.\u001b8l%\u0016d')^5mI\u0016\u0014\b\u0002CA\u0010\u0001\u0011\u0005\u0001\"!\t\u0002%\r\u0014X-\u0019;f\r2Lgn\u001b)mC:tWM]\u000b\u0003\u0003G\u0001B!a\u0005\u0002&%!\u0011qEA\u000b\u0005A1E.\u001b8l!2\fgN\\3s\u00136\u0004H\u000eK\u0002\u0002\u001e}D\u0001\"!\f\u0001\t\u0003A\u0011qF\u0001\u000fO\u0016$H+\u001f9f\r\u0006\u001cGo\u001c:z+\t\t\t\u0004\u0005\u0003\u0002\u0014\u0005M\u0012\u0002BA\u001b\u0003+\u0011\u0001C\u00127j].$\u0016\u0010]3GC\u000e$xN]=\t\u000f\u0005e\u0002A\"\u0005\u0002<\u0005aq-\u001a;Ue\u0006LG\u000fR3ggV\u0011\u0011Q\b\t\u0006\u0001\u0006}\u00121I\u0005\u0004\u0003\u0003\n%!B!se\u0006L\b\u0007BA#\u0003/\u0002b!a\u0012\u0002P\u0005MSBAA%\u0015\u0011\tY%!\u0014\u0002\tAd\u0017M\u001c\u0006\u0004\u0003/Q\u0011\u0002BA)\u0003\u0013\u00121BU3m)J\f\u0017\u000e\u001e#fMB!\u0011QKA,\u0019\u0001!A\"!\u0017\u00028\u0005\u0005\t\u0011!B\u0001\u00037\u00121a\u0018\u00132#\u0011\ti&a\u0019\u0011\u0007\u0001\u000by&C\u0002\u0002b\u0005\u0013qAT8uQ&tw\r\u0005\u0003\u0002H\u0005\u0015\u0014\u0002BA4\u0003\u0013\u0012\u0001BU3m)J\f\u0017\u000e\u001e\u0005\b\u0003W\u0002a\u0011CA7\u000319W\r^(qi&l\u0017N_3s+\t\ty\u0007\u0005\u0003\u0002r\u0005eTBAA:\u0015\u0011\t)(a\u001e\u0002\u0011=\u0004H/[7ju\u0016T1!a\u0013\u0005\u0013\u0011\tY(a\u001d\u0003\u0013=\u0003H/[7ju\u0016\u0014\bbBA@\u0001\u0011\u0005\u0011\u0011Q\u0001\u000fO\u0016$H+\u00192mK\u000e{gNZ5h+\u0005!\u0003bBAC\u0001\u0011\u0005\u0011qQ\u0001\u0010O\u0016$h\t\\5oW\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0012\t\u0005\u0003'\tY)\u0003\u0003\u0002\u000e\u0006U!\u0001\u0004$mS:\\7i\u001c8uKb$\bBBAI\u0001\u0011\u0005Q.\u0001\thKR\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"A\u0011Q\u0013\u0001\u0005\u0002!\t9*\u0001\u0006hKR,\u00050Z2F]Z,\"!!'\u0011\t\u0005m\u0015qU\u0007\u0003\u0003;SA!a(\u0002\"\u0006YQM\u001c<je>tW.\u001a8u\u0015\r9\u00131\u0015\u0006\u0004\u0003KC\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\tI+!(\u00035M#(/Z1n\u000bb,7-\u001e;j_:,eN^5s_:lWM\u001c;)\u0011\u0005M\u0015QVAZ\u0003;\u00042\u0001QAX\u0013\r\t\t,\u0011\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017'C\u0012\u00026\u0006-\u00171[Ag!\u0011\t9,!2\u000f\t\u0005e\u0016\u0011\u0019\t\u0004\u0003w\u000bUBAA_\u0015\r\tyLD\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\r\u0017)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u000f\fIM\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0007\f\u0015\u0002BAg\u0003\u001f\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAAi\u0003\u0006QA-\u001a9sK\u000e\fG/\u001a32\u0013\r\n).a6\u0002Z\u0006Egb\u0001!\u0002X&\u0019\u0011\u0011[!2\u000b\t\u0002\u0015)a7\u0003\u000bM\u001c\u0017\r\\12\u0013\r\n),a8\u0002d\u0006\u0005\u0018\u0002BAq\u0003\u001f\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014'C\u0012\u0002V\u0006]\u0017Q]Aic\u0015\u0011\u0003)QAn\u0011\u0019\tI\u000f\u0001C\u0001#\u0006y1M]3bi\u0016tUm\u001e)beN,'\u000fC\u0004\u0002n\u0002!\t%a<\u0002\u0013\u001d,G\u000fU1sg\u0016\u0014H#\u0001*\t\u000f\u0005M\b\u0001\"\u0011\u0002v\u0006IAO]1og2\fG/\u001a\u000b\u0005\u0003o\u0014\t\u0003\u0005\u0004\u0002z\u0006}(1A\u0007\u0003\u0003wT1!!@\u0015\u0003\u0011)H/\u001b7\n\t\t\u0005\u00111 \u0002\u0005\u0019&\u001cH\u000f\r\u0003\u0003\u0006\tU\u0001C\u0002B\u0004\u0005\u001f\u0011\u0019\"\u0004\u0002\u0003\n)!!1\u0002B\u0007\u0003\r!\u0017m\u001a\u0006\u0003O!IAA!\u0005\u0003\n\tqAK]1og\u001a|'/\\1uS>t\u0007\u0003BA+\u0005+!ABa\u0006\u0002r\u0006\u0005\t\u0011!B\u0001\u00053\u00111a\u0018\u00133#\u0011\tiFa\u0007\u0011\u0007\u0001\u0013i\"C\u0002\u0003 \u0005\u00131!\u00118z\u0011!\u0011\u0019#!=A\u0002\t\u0015\u0012\u0001E7pI&4\u0017p\u00149fe\u0006$\u0018n\u001c8t!\u0019\tI0a@\u0003(A!!\u0011\u0006B\u0018\u001b\t\u0011YCC\u0002\u0003.\u0019\t!b\u001c9fe\u0006$\u0018n\u001c8t\u0013\u0011\u0011\tDa\u000b\u0003\u001f5{G-\u001b4z\u001fB,'/\u0019;j_:D\u0001B!\u000e\u0001\t\u0003A!qG\u0001\u000fiJ\fgn\u001d7bi\u0016$vNU3m)\u0011\u0011ID!\u0012\u0011\t\tm\"\u0011I\u0007\u0003\u0005{QAAa\u0010\u0002N\u0005\u0019!/\u001a7\n\t\t\r#Q\b\u0002\b%\u0016dgj\u001c3f\u0011!\u00119Ea\rA\u0002\t\u001d\u0012aD7pI&4\u0017p\u00149fe\u0006$\u0018n\u001c8)\u0007\tMr\u0010\u0003\u0005\u0002v\u0001!\t\u0001\u0003B')\u0011\u0011yE!\u0019\u0011\r\tE#1\fB\u001d\u001d\u0011\u0011\u0019Fa\u0016\u000f\t\u0005m&QK\u0005\u0002\u0005&\u0019!\u0011L!\u0002\u000fA\f7m[1hK&!!Q\fB0\u0005\r\u0019V-\u001d\u0006\u0004\u00053\n\u0005\u0002\u0003B2\u0005\u0017\u0002\rAa\u0014\u0002\u0011I,GNT8eKND3Aa\u0013\u0000\u0011!\t)\b\u0001C\u0001\u0011\t%D\u0003\u0002B\u001d\u0005WB\u0001B!\u001c\u0003h\u0001\u0007!\u0011H\u0001\be\u0016dgj\u001c3fQ\r\u00119g \u0005\t\u0005g\u0002A\u0011\u0001\u0005\u0003v\u0005ABO]1og2\fG/\u001a+p\u000bb,7MT8eK\u001e\u0013\u0018\r\u001d5\u0015\t\t]$q\u0011\t\u0005\u0005s\u0012\u0019)\u0004\u0002\u0003|)!!Q\u0010B@\u0003\u0011)\u00070Z2\u000b\t\t\u0005\u0015qO\u0001\u0006]>$Wm]\u0005\u0005\u0005\u000b\u0013YHA\u0007Fq\u0016\u001cgj\u001c3f\u000fJ\f\u0007\u000f\u001b\u0005\t\u0005\u0013\u0013\t\b1\u0001\u0003P\u0005\tr\u000e\u001d;j[&TX\r\u001a*fY:{G-Z:)\u0007\tEt\u0010C\u0004\u0003\u0010\u00021\tB!%\u00025\u001d,G/\u0012=fG:{G-Z$sCBD\u0007K]8dKN\u001cxN]:\u0016\u0005\tM\u0005C\u0002B)\u00057\u0012)\n\u0005\u0003\u0003\u0018\nuUB\u0001BM\u0015\u0011\u0011YJa\u001f\u0002\u0013A\u0014xnY3tg>\u0014\u0018\u0002\u0002BP\u00053\u0013a#\u0012=fG:{G-Z$sCBD\u0007K]8dKN\u001cxN\u001d\u0005\b\u0005G\u0003a\u0011\u0003BS\u0003=!(/\u00198tY\u0006$X\rV8QY\u0006tG\u0003\u0002BT\u0005g\u0003b!!?\u0002\u0000\n%\u0006\u0007\u0002BV\u0005_\u0003bAa\u0002\u0003\u0010\t5\u0006\u0003BA+\u0005_#AB!-\u0003\"\u0006\u0005\t\u0011!B\u0001\u00053\u00111a\u0018\u00135\u0011!\u0011)L!)A\u0002\t]\u0014!C3yK\u000e<%/\u00199i\u0011\u001d\u0011I\f\u0001C\u0005\u0005w\u000bAbZ3u)\u0006\u0014G.Z*j].$bA!0\u0003P\ne\u0007#\u0002!\u0003@\n\r\u0017b\u0001Ba\u0003\n1q\n\u001d;j_:\u0004r\u0001\u0011Bc\u0005\u0013\u0014Y\"C\u0002\u0003H\u0006\u0013a\u0001V;qY\u0016\u0014\u0004c\u0001\u0018\u0003L&\u0019!QZ\u0018\u0003)I+7o\u001c7wK\u0012\u001c\u0015\r^1m_\u001e$\u0016M\u00197f\u0011!\u0011\tNa.A\u0002\tM\u0017\u0001E8cU\u0016\u001cG/\u00133f]RLg-[3s!\rq#Q[\u0005\u0004\u0005/|#\u0001E(cU\u0016\u001cG/\u00133f]RLg-[3s\u0011!\u0011YNa.A\u0002\tu\u0017A\u00043z]\u0006l\u0017nY(qi&|gn\u001d\t\t\u0005?\u001490!.\u00026:!!\u0011\u001dB{\u001d\u0011\u0011\u0019Oa=\u000f\t\t\u0015(\u0011\u001f\b\u0005\u0005O\u0014yO\u0004\u0003\u0003j\n5h\u0002BA^\u0005WL\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\r\u0011I\u0006B\u0005\u0005\u0005s\u0014YP\u0001\u0003K\u001b\u0006\u0004(b\u0001B-\t!9!q \u0001\u0005\n\r\u0005\u0011\u0001G5t\u0019\u0016<\u0017mY=D_:tWm\u0019;pe>\u0003H/[8ogR9qha\u0001\u0004\u0006\r=\u0001\u0002\u0003Bi\u0005{\u0004\rAa5\t\u0011\r\u001d!Q a\u0001\u0007\u0013\tAbY1uC2|w\rV1cY\u0016\u00042ALB\u0006\u0013\r\u0019ia\f\u0002\r\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a\u0005\b\u0007#\u0011i\u00101\u0001@\u0003-I7\u000fV3na>\u0014\u0018M]=\t\u000f\rU\u0001\u0001\"\u0011\u0004\u0018\u0005Yq-\u001a;Kg>t\u0007\u000b\\1o)\u0011\t)l!\u0007\t\u0011\t\r21\u0003a\u0001\u0005KAqa!\b\u0001\t\u0003\u001ay\"A\tue\u0006t7\u000f\\1uK*\u001bxN\u001c)mC:$Ba!\t\u0004.A1\u0011\u0011`A\u0000\u0007G\u0001Da!\n\u0004*A1!q\u0001B\b\u0007O\u0001B!!\u0016\u0004*\u0011a11FB\u000e\u0003\u0003\u0005\tQ!\u0001\u0003\u001a\t\u0019q\fJ\u001b\t\u0011\r=21\u0004a\u0001\u0003k\u000b\u0001B[:p]Bc\u0017M\u001c\u0005\b\u0007g\u0001A\u0011CB\u001b\u0003I\u0019'/Z1uKN+'\u000fZ3D_:$X\r\u001f;\u0016\u0005\r]\u0002\u0003BB\u001d\u0007\u007fi!aa\u000f\u000b\t\ru\"1P\u0001\u0006g\u0016\u0014H-Z\u0005\u0005\u0007\u0003\u001aYD\u0001\u0007TKJ$WmQ8oi\u0016DH\u000fC\u0004\u0004F\u0001!Iaa\u0012\u0002\u001d\u001d,Go\u00117bgNdu.\u00193feV\u00111\u0011\n\t\u0004#\r-\u0013bAB'%\tY1\t\\1tg2{\u0017\rZ3s\u0011\u001d\u0019\t\u0006\u0001C\t\u0007'\n\u0001E^1mS\u0012\fG/Z!oI>3XM\u001d:jI\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]R\t\u0001\fC\u0004\u0004X\u0001!\tba\u0015\u0002;\rdW-\u00198va&sG/\u001a:oC2\u001cuN\u001c4jOV\u0014\u0018\r^5p]N\u0004")
public abstract class PlannerBase
implements Planner {
    private final Executor executor;
    private final TableConfig config;
    private final FunctionCatalog functionCatalog;
    private final CatalogManager catalogManager;
    private final boolean isStreamingMode;
    private Parser parser;
    private SqlDialect currentDialect;
    private final ReadableConfig plannerConfiguration;
    @VisibleForTesting
    private final PlannerContext plannerContext;

    public FunctionCatalog functionCatalog() {
        return this.functionCatalog;
    }

    public CatalogManager catalogManager() {
        return this.catalogManager;
    }

    private Parser parser() {
        return this.parser;
    }

    private void parser_$eq(Parser x$1) {
        this.parser = x$1;
    }

    private SqlDialect currentDialect() {
        return this.currentDialect;
    }

    private void currentDialect_$eq(SqlDialect x$1) {
        this.currentDialect = x$1;
    }

    private ReadableConfig plannerConfiguration() {
        return this.plannerConfiguration;
    }

    public PlannerContext plannerContext() {
        return this.plannerContext;
    }

    public FlinkRelBuilder getRelBuilder() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createRelBuilder(currentCatalogName, currentDatabase);
    }

    @VisibleForTesting
    public FlinkPlannerImpl createFlinkPlanner() {
        String currentCatalogName = this.catalogManager().getCurrentCatalog();
        String currentDatabase = this.catalogManager().getCurrentDatabase();
        return this.plannerContext().createFlinkPlanner(currentCatalogName, currentDatabase);
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.plannerContext().getTypeFactory();
    }

    public abstract RelTraitDef<? extends RelTrait>[] getTraitDefs();

    public abstract Optimizer getOptimizer();

    public TableConfig getTableConfig() {
        return this.config;
    }

    public FlinkContext getFlinkContext() {
        return this.plannerContext().getFlinkContext();
    }

    public ReadableConfig getConfiguration() {
        return this.plannerConfiguration();
    }

    public StreamExecutionEnvironment getExecEnv() {
        return ((DefaultExecutor)this.executor).getExecutionEnvironment();
    }

    public Parser createNewParser() {
        String factoryIdentifier = this.getTableConfig().getSqlDialect().name().toLowerCase();
        ParserFactory parserFactory = FactoryUtil.discoverFactory(Thread.currentThread().getContextClassLoader(), ParserFactory.class, factoryIdentifier);
        ParserFactory.DefaultParserContext context = new ParserFactory.DefaultParserContext(this.catalogManager(), this.plannerContext());
        return parserFactory.create(context);
    }

    @Override
    public Parser getParser() {
        block1: {
            block0: {
                if (this.parser() == null) break block0;
                SqlDialect sqlDialect = this.getTableConfig().getSqlDialect();
                SqlDialect sqlDialect2 = this.currentDialect();
                if (!(sqlDialect == null ? sqlDialect2 != null : !((Object)((Object)sqlDialect)).equals((Object)sqlDialect2))) break block1;
            }
            this.parser_$eq(this.createNewParser());
            this.currentDialect_$eq(this.getTableConfig().getSqlDialect());
        }
        return this.parser();
    }

    @Override
    public List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        this.validateAndOverrideConfiguration();
        if (modifyOperations.isEmpty()) {
            return JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)List$.MODULE$.empty());
        }
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return transformations;
    }

    @VisibleForTesting
    public RelNode translateToRel(ModifyOperation modifyOperation) {
        RelNode relNode;
        DataTypeFactory dataTypeFactory = this.catalogManager().getDataTypeFactory();
        ModifyOperation modifyOperation2 = modifyOperation;
        if (modifyOperation2 instanceof UnregisteredSinkModifyOperation) {
            UnregisteredSinkModifyOperation unregisteredSinkModifyOperation = (UnregisteredSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(unregisteredSinkModifyOperation.getChild()).build();
            TableSchema sinkSchema = unregisteredSinkModifyOperation.getSink().getTableSchema();
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
            relNode = LogicalLegacySink$.MODULE$.create(query, unregisteredSinkModifyOperation.getSink(), "UnregisteredSink", ConnectorCatalogTable.sink(unregisteredSinkModifyOperation.getSink(), !this.isStreamingMode), LogicalLegacySink$.MODULE$.create$default$5());
        } else if (modifyOperation2 instanceof CollectModifyOperation) {
            CollectModifyOperation collectModifyOperation = (CollectModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertCollectToRel(this.getRelBuilder(), input, collectModifyOperation, this.getTableConfig().getConfiguration());
        } else if (modifyOperation2 instanceof CatalogSinkModifyOperation) {
            RelNode sinkRel;
            Map<String, String> dynamicOptions;
            CatalogSinkModifyOperation catalogSinkModifyOperation = (CatalogSinkModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            ObjectIdentifier identifier = catalogSinkModifyOperation.getTableIdentifier();
            Option option = this.getTableSink(identifier, dynamicOptions = catalogSinkModifyOperation.getDynamicOptions()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                    Object sink = tuple2._2();
                    if (sink instanceof TableSink) {
                        TableSink tableSink = (TableSink)sink;
                        RowType queryLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
                        TableSinkUtils$.MODULE$.validateLogicalPhysicalTypesCompatible(table, tableSink, queryLogicalType);
                        TableSinkUtils$.MODULE$.validateTableSink(catalogSinkModifyOperation, identifier, tableSink, (Seq<String>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(table.getPartitionKeys()));
                        RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, table.getResolvedSchema(), catalogSinkModifyOperation.getTableIdentifier(), dataTypeFactory, this.getTypeFactory());
                        ArrayList<RelHint> hints = new ArrayList<RelHint>();
                        Object object = !dynamicOptions.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)hints.add(RelHint.builder("OPTIONS").hintOptions(dynamicOptions).build())) : BoxedUnit.UNIT;
                        return LogicalLegacySink$.MODULE$.create(query, hints, tableSink, identifier.toString(), table, (scala.collection.immutable.Map<String, String>)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(catalogSinkModifyOperation.getStaticPartitions()).toMap(Predef$.MODULE$.$conforms()));
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                ResolvedCatalogTable table = (ResolvedCatalogTable)tuple2._1();
                Object sink = tuple2._2();
                if (!(sink instanceof DynamicTableSink)) throw new MatchError((Object)tuple2);
                DynamicTableSink dynamicTableSink = (DynamicTableSink)sink;
                return DynamicSinkUtils.convertSinkToRel(this.getRelBuilder(), input, catalogSinkModifyOperation, dynamicTableSink, table);
            });
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new TableException(new StringBuilder(21).append("Sink ").append(catalogSinkModifyOperation.getTableIdentifier()).append(" does not exists").toString());
                }
                throw new MatchError((Object)option);
            }
            Some some = (Some)option;
            RelNode relNode2 = sinkRel = (RelNode)some.value();
            relNode = relNode2;
        } else if (modifyOperation2 instanceof ExternalModifyOperation) {
            ExternalModifyOperation externalModifyOperation = (ExternalModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(modifyOperation.getChild()).build();
            relNode = DynamicSinkUtils.convertExternalToRel(this.getRelBuilder(), input, externalModifyOperation);
        } else if (modifyOperation2 instanceof OutputConversionModifyOperation) {
            Tuple2.mcZZ.sp sp2;
            OutputConversionModifyOperation outputConversionModifyOperation = (OutputConversionModifyOperation)modifyOperation2;
            RelNode input = this.getRelBuilder().queryOperation(outputConversionModifyOperation.getChild()).build();
            OutputConversionModifyOperation.UpdateMode updateMode = outputConversionModifyOperation.getUpdateMode();
            if (((Object)((Object)OutputConversionModifyOperation.UpdateMode.RETRACT)).equals((Object)updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(true, true);
            } else if (((Object)((Object)OutputConversionModifyOperation.UpdateMode.APPEND)).equals((Object)updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, false);
            } else if (((Object)((Object)OutputConversionModifyOperation.UpdateMode.UPSERT)).equals((Object)updateMode)) {
                sp2 = new Tuple2.mcZZ.sp(false, true);
            } else {
                throw new MatchError((Object)updateMode);
            }
            Tuple2.mcZZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            boolean needUpdateBefore = sp3._1$mcZ$sp();
            boolean withChangeFlag = sp3._2$mcZ$sp();
            Tuple2.mcZZ.sp sp4 = new Tuple2.mcZZ.sp(needUpdateBefore, withChangeFlag);
            Tuple2.mcZZ.sp sp5 = sp4;
            boolean needUpdateBefore2 = sp5._1$mcZ$sp();
            boolean withChangeFlag2 = sp5._2$mcZ$sp();
            TypeInformation<?> typeInfo = LegacyTypeInfoDataTypeConverter.toLegacyTypeInfo(outputConversionModifyOperation.getType());
            RowType inputLogicalType = FlinkTypeFactory$.MODULE$.toLogicalRowType(input.getRowType());
            TableSchema sinkPhysicalSchema = TableSinkUtils$.MODULE$.inferSinkPhysicalSchema(outputConversionModifyOperation.getType(), inputLogicalType, withChangeFlag2);
            RelNode query = DynamicSinkUtils.validateSchemaAndApplyImplicitCast(input, this.catalogManager().getSchemaResolver().resolve(sinkPhysicalSchema.toSchema()), null, dataTypeFactory, this.getTypeFactory());
            DataStreamTableSink tableSink = new DataStreamTableSink(FlinkTypeFactory$.MODULE$.toTableSchema(query.getRowType()), typeInfo, needUpdateBefore2, withChangeFlag2);
            relNode = LogicalLegacySink$.MODULE$.create(query, tableSink, "DataStreamTableSink", ConnectorCatalogTable.sink(tableSink, !this.isStreamingMode), LogicalLegacySink$.MODULE$.create$default$5());
        } else {
            throw new TableException(new StringBuilder(29).append("Unsupported ModifyOperation: ").append(modifyOperation).toString());
        }
        return relNode;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public Seq<RelNode> optimize(Seq<RelNode> relNodes) {
        void var2_2;
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize(relNodes);
        Predef$.MODULE$.require(optimizedRelNodes.size() == relNodes.size());
        return var2_2;
    }

    @VisibleForTesting
    public RelNode optimize(RelNode relNode) {
        Seq<RelNode> optimizedRelNodes = this.getOptimizer().optimize((Seq<RelNode>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelNode[]{relNode}))));
        Predef$.MODULE$.require(optimizedRelNodes.size() == 1);
        return (RelNode)optimizedRelNodes.head();
    }

    @VisibleForTesting
    public ExecNodeGraph translateToExecNodeGraph(Seq<RelNode> optimizedRelNodes) {
        Seq nonPhysicalRel = (Seq)optimizedRelNodes.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$1(x$2)));
        if (nonPhysicalRel.nonEmpty()) {
            throw new TableException(new StringBuilder(54).append("The expected optimized plan is FlinkPhysicalRel plan, ").append(new StringBuilder(21).append("actual plan is ").append(nonPhysicalRel.head().getClass().getSimpleName()).append(" plan.").toString()).toString());
        }
        Predef$.MODULE$.require(optimizedRelNodes.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PlannerBase.$anonfun$translateToExecNodeGraph$2(x$3))));
        SameRelObjectShuttle shuttle = new SameRelObjectShuttle();
        Seq relsWithoutSameObj = (Seq)optimizedRelNodes.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.accept(shuttle), Seq$.MODULE$.canBuildFrom());
        Seq<RelNode> reusedPlan = SubplanReuser$.MODULE$.reuseDuplicatedSubplan((Seq<RelNode>)relsWithoutSameObj, this.config);
        ExecNodeGraphGenerator generator = new ExecNodeGraphGenerator();
        ExecNodeGraph execGraph = generator.generate(JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)reusedPlan.map((Function1 & Serializable & scala.Serializable)x$5 -> (FlinkPhysicalRel)x$5, Seq$.MODULE$.canBuildFrom())));
        ProcessorContext context = new ProcessorContext(this);
        Seq<ExecNodeGraphProcessor> processors = this.getExecNodeGraphProcessors();
        return (ExecNodeGraph)processors.foldLeft((Object)execGraph, (Function2 & Serializable & scala.Serializable)(graph, processor) -> processor.process((ExecNodeGraph)graph, context));
    }

    public abstract Seq<ExecNodeGraphProcessor> getExecNodeGraphProcessors();

    public abstract List<Transformation<?>> translateToPlan(ExecNodeGraph var1);

    private Option<Tuple2<ResolvedCatalogTable, Object>> getTableSink(ObjectIdentifier objectIdentifier, Map<String, String> dynamicOptions) {
        None$ none$;
        Option<CatalogManager.TableLookupResult> optionalLookupResult = JavaScalaConversionUtil$.MODULE$.toScala(this.catalogManager().getTable(objectIdentifier));
        if (optionalLookupResult.isEmpty()) {
            return None$.MODULE$;
        }
        CatalogManager.TableLookupResult lookupResult = (CatalogManager.TableLookupResult)optionalLookupResult.get();
        CatalogBaseTable catalogBaseTable = lookupResult.getTable();
        if (catalogBaseTable instanceof ConnectorCatalogTable) {
            None$ none$2;
            ConnectorCatalogTable connectorCatalogTable = (ConnectorCatalogTable)catalogBaseTable;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            Option option = JavaScalaConversionUtil$.MODULE$.toScala(connectorCatalogTable.getTableSink());
            if (option instanceof Some) {
                Some some = (Some)option;
                TableSink sink = (TableSink)some.value();
                none$2 = new Some((Object)new Tuple2((Object)resolvedTable, (Object)sink));
            } else if (None$.MODULE$.equals(option)) {
                none$2 = None$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            none$ = none$2;
        } else if (catalogBaseTable instanceof CatalogTable) {
            Option option;
            ResolvedCatalogTable resolvedTable = (ResolvedCatalogTable)lookupResult.getResolvedTable();
            ResolvedCatalogTable tableToFind = JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(dynamicOptions).nonEmpty() ? resolvedTable.copy((Map)FlinkHints.mergeTableOptions(dynamicOptions, resolvedTable.getOptions())) : resolvedTable;
            Optional<Catalog> catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            boolean isTemporary = lookupResult.isTemporary();
            if (this.isLegacyConnectorOptions(objectIdentifier, resolvedTable.getOrigin(), isTemporary)) {
                TableSink tableSink = TableFactoryUtil.findAndCreateTableSink(catalog.orElse(null), objectIdentifier, tableToFind.getOrigin(), (ReadableConfig)this.getTableConfig().getConfiguration(), this.isStreamingMode, isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, tableSink));
            } else {
                DynamicTableSink tableSink = FactoryUtil.createTableSink(catalog.orElse(null), objectIdentifier, tableToFind, (ReadableConfig)this.getTableConfig().getConfiguration(), this.getClassLoader(), isTemporary);
                option = Option$.MODULE$.apply((Object)new Tuple2((Object)resolvedTable, (Object)tableSink));
            }
            none$ = option;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private boolean isLegacyConnectorOptions(ObjectIdentifier objectIdentifier, CatalogTable catalogTable, boolean isTemporary) {
        boolean bl;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(catalogTable.getOptions());
        if (properties.containsKey("connector.type")) {
            bl = true;
        } else {
            Optional<Catalog> catalog = this.catalogManager().getCatalog(objectIdentifier.getCatalogName());
            try {
                TableFactoryUtil.findAndCreateTableSink(catalog.orElse(null), objectIdentifier, catalogTable, (ReadableConfig)this.getTableConfig().getConfiguration(), this.isStreamingMode, isTemporary);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public String getJsonPlan(List<ModifyOperation> modifyOperations) {
        if (!this.isStreamingMode) {
            throw new TableException("Only streaming mode is supported now.");
        }
        this.validateAndOverrideConfiguration();
        Buffer relNodes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(modifyOperations).map((Function1 & Serializable & scala.Serializable)modifyOperation -> this.translateToRel((ModifyOperation)modifyOperation), Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)relNodes);
        ExecNodeGraph execGraph = this.translateToExecNodeGraph(optimizedRelNodes);
        String jsonPlan = ExecNodeGraph.createJsonPlan(execGraph, this.createSerdeContext());
        this.cleanupInternalConfigurations();
        return jsonPlan;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Transformation<?>> translateJsonPlan(String jsonPlan) {
        void var3_3;
        if (!this.isStreamingMode) {
            throw new TableException("Only streaming mode is supported now.");
        }
        this.validateAndOverrideConfiguration();
        ExecNodeGraph execGraph = ExecNodeGraph.createExecNodeGraph(jsonPlan, this.createSerdeContext());
        List<Transformation<?>> transformations = this.translateToPlan(execGraph);
        this.cleanupInternalConfigurations();
        return var3_3;
    }

    public SerdeContext createSerdeContext() {
        FlinkPlannerImpl planner = this.createFlinkPlanner();
        return new SerdeContext((FlinkContext)planner.config().getContext(), this.getClassLoader(), this.plannerContext().getTypeFactory(), planner.operatorTable());
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public void validateAndOverrideConfiguration() {
        block1: {
            Configuration configuration = this.config.getConfiguration();
            if (!((Enum)configuration.get(TableConfigOptions.TABLE_PLANNER)).equals((Object)PlannerType.BLINK)) {
                throw new IllegalArgumentException("Mismatch between configured planner and actual planner. Currently, the 'table.planner' can only be set when instantiating the table environment. Subsequent changes are not supported. Please instantiate a new TableEnvironment if necessary.");
            }
            Long epochTime = Predef$.MODULE$.long2Long(System.currentTimeMillis());
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME, (Object)epochTime);
            Long localTime = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(epochTime) + (long)TimeZone.getTimeZone(this.config.getLocalTimeZone()).getOffset(Predef$.MODULE$.Long2long(epochTime)));
            configuration.set(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME, (Object)localTime);
            this.getExecEnv().configure((ReadableConfig)configuration, Thread.currentThread().getContextClassLoader());
            int defaultParallelism = this.getTableConfig().getConfiguration().getInteger(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM);
            if (defaultParallelism <= 0) break block1;
            this.getExecEnv().getConfig().setParallelism(defaultParallelism);
        }
    }

    public void cleanupInternalConfigurations() {
        Configuration configuration = this.config.getConfiguration();
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_EPOCH_TIME);
        configuration.removeConfig(InternalConfigOptions.TABLE_QUERY_START_LOCAL_TIME);
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$1(RelNode x$2) {
        return x$2 instanceof FlinkPhysicalRel;
    }

    public static final /* synthetic */ boolean $anonfun$translateToExecNodeGraph$2(RelNode x$3) {
        return x$3 instanceof FlinkPhysicalRel;
    }

    public PlannerBase(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager, boolean isStreamingMode) {
        this.executor = executor;
        this.config = config;
        this.functionCatalog = functionCatalog;
        this.catalogManager = catalogManager;
        this.isStreamingMode = isStreamingMode;
        functionCatalog.setPlannerTypeInferenceUtil(PlannerTypeInferenceUtilImpl.INSTANCE);
        this.currentDialect = this.getTableConfig().getSqlDialect();
        this.plannerConfiguration = new PlannerConfiguration((ReadableConfig)config.getConfiguration(), executor.getConfiguration());
        this.plannerContext = new PlannerContext(!isStreamingMode, config, functionCatalog, catalogManager, CalciteSchemaBuilder.asRootSchema(new CatalogManagerCalciteSchema(catalogManager, isStreamingMode)), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getTraitDefs())).toList()));
    }
}

