/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.functions.aggregate.BuiltInAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;

@Internal
public final class FirstValueWithRetractAggFunction<T>
extends BuiltInAggregateFunction<T, FirstValueWithRetractAccumulator<T>> {
    private transient DataType valueDataType;

    public FirstValueWithRetractAggFunction(LogicalType valueType) {
        this.valueDataType = DataTypeUtils.toInternalDataType(valueType);
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return Collections.singletonList(this.valueDataType);
    }

    @Override
    public DataType getAccumulatorDataType() {
        return DataTypes.STRUCTURED(FirstValueWithRetractAccumulator.class, DataTypes.FIELD("firstValue", (DataType)this.valueDataType.nullable()), DataTypes.FIELD("firstOrder", DataTypes.BIGINT()), DataTypes.FIELD("valueToOrderMap", MapView.newMapViewDataType((DataType)this.valueDataType.notNull(), (DataType)DataTypes.ARRAY(DataTypes.BIGINT()).bridgedTo(List.class))), DataTypes.FIELD("orderToValueMap", MapView.newMapViewDataType(DataTypes.BIGINT(), (DataType)DataTypes.ARRAY((DataType)this.valueDataType.notNull()).bridgedTo(List.class))));
    }

    @Override
    public DataType getOutputDataType() {
        return this.valueDataType;
    }

    @Override
    public FirstValueWithRetractAccumulator<T> createAccumulator() {
        FirstValueWithRetractAccumulator acc = new FirstValueWithRetractAccumulator();
        acc.firstValue = null;
        acc.firstOrder = null;
        acc.valueToOrderMap = new MapView();
        acc.orderToValueMap = new MapView();
        return acc;
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, Object value) throws Exception {
        if (value != null) {
            Object v = value;
            Long order = System.currentTimeMillis();
            List<Long> orderList = acc.valueToOrderMap.get(v);
            if (orderList == null) {
                orderList = new ArrayList<Long>();
            }
            orderList.add(order);
            acc.valueToOrderMap.put(v, orderList);
            this.accumulate(acc, v, order);
        }
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, Object value, Long order) throws Exception {
        if (value != null) {
            List valueList;
            Object v = value;
            Long prevOrder = acc.firstOrder;
            if (prevOrder == null || prevOrder > order) {
                acc.firstValue = v;
                acc.firstOrder = order;
            }
            if ((valueList = acc.orderToValueMap.get(order)) == null) {
                valueList = new ArrayList();
            }
            valueList.add(v);
            acc.orderToValueMap.put(order, valueList);
        }
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, StringData value) throws Exception {
        if (value != null) {
            this.accumulate(acc, (Object)((BinaryStringData)value).copy());
        }
    }

    public void accumulate(FirstValueWithRetractAccumulator<T> acc, StringData value, Long order) throws Exception {
        if (value != null) {
            this.accumulate(acc, (Object)((BinaryStringData)value).copy(), order);
        }
    }

    public void retract(FirstValueWithRetractAccumulator<T> acc, Object value) throws Exception {
        Object v;
        List<Long> orderList;
        if (value != null && (orderList = acc.valueToOrderMap.get(v = value)) != null && orderList.size() > 0) {
            Long order = orderList.get(0);
            orderList.remove(0);
            if (orderList.isEmpty()) {
                acc.valueToOrderMap.remove(v);
            } else {
                acc.valueToOrderMap.put(v, orderList);
            }
            this.retract(acc, v, order);
        }
    }

    public void retract(FirstValueWithRetractAccumulator<T> acc, Object value, Long order) throws Exception {
        if (value != null) {
            Object v = value;
            List valueList = acc.orderToValueMap.get(order);
            if (valueList == null) {
                return;
            }
            int index = valueList.indexOf(v);
            if (index >= 0) {
                valueList.remove(index);
                if (valueList.isEmpty()) {
                    acc.orderToValueMap.remove(order);
                } else {
                    acc.orderToValueMap.put(order, valueList);
                }
            }
            if (v.equals(acc.firstValue)) {
                Long startKey = acc.firstOrder;
                Iterator<Long> iter = acc.orderToValueMap.keys().iterator();
                Long nextKey = Long.MAX_VALUE;
                while (iter.hasNext()) {
                    Long key = iter.next();
                    if (key < startKey || key >= nextKey) continue;
                    nextKey = key;
                }
                if (nextKey != Long.MAX_VALUE) {
                    acc.firstValue = acc.orderToValueMap.get(nextKey).get(0);
                    acc.firstOrder = nextKey;
                } else {
                    acc.firstValue = null;
                    acc.firstOrder = null;
                }
            }
        }
    }

    public void resetAccumulator(FirstValueWithRetractAccumulator<T> acc) {
        acc.firstValue = null;
        acc.firstOrder = null;
        acc.valueToOrderMap.clear();
        acc.orderToValueMap.clear();
    }

    @Override
    public T getValue(FirstValueWithRetractAccumulator<T> acc) {
        return acc.firstValue;
    }

    public static class FirstValueWithRetractAccumulator<T> {
        public T firstValue;
        public Long firstOrder;
        public MapView<T, List<Long>> valueToOrderMap;
        public MapView<Long, List<T>> orderToValueMap;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FirstValueWithRetractAccumulator)) {
                return false;
            }
            FirstValueWithRetractAccumulator that = (FirstValueWithRetractAccumulator)o;
            return Objects.equals(this.firstValue, that.firstValue) && Objects.equals(this.firstOrder, that.firstOrder) && Objects.equals(this.valueToOrderMap, that.valueToOrderMap) && Objects.equals(this.orderToValueMap, that.orderToValueMap);
        }

        public int hashCode() {
            return Objects.hash(this.firstValue, this.firstOrder, this.valueToOrderMap, this.orderToValueMap);
        }
    }
}

