/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class IncrSumWithRetractAggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef("sum");
    private UnresolvedReferenceExpression count = ApiExpressionUtils.unresolvedRef("count");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[0];
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType(), DataTypes.BIGINT()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType()), ExpressionBuilder.literal(0L)};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.or(ExpressionBuilder.isNull(this.operand(0)), ExpressionBuilder.lessThan(this.operand(0), this.zeroLiteral())), this.sum, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.sum), this.operand(0), ExpressionBuilder.plus(this.sum, this.operand(0)))), ExpressionBuilder.ifThenElse(ExpressionBuilder.or(ExpressionBuilder.isNull(this.operand(0)), ExpressionBuilder.lessThan(this.operand(0), ExpressionBuilder.literal(0L))), this.count, ExpressionBuilder.plus(this.count, ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] retractExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.or(ExpressionBuilder.isNull(this.operand(0)), ExpressionBuilder.lessThan(this.operand(0), this.zeroLiteral())), this.sum, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.sum), ExpressionBuilder.minus(this.zeroLiteral(), this.operand(0)), ExpressionBuilder.minus(this.sum, this.operand(0)))), ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.operand(0)), this.count, ExpressionBuilder.minus(this.count, ExpressionBuilder.literal(1L)))};
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.mergeOperand(this.sum)), this.sum, ExpressionBuilder.ifThenElse(ExpressionBuilder.isNull(this.sum), this.mergeOperand(this.sum), ExpressionBuilder.plus(this.sum, this.mergeOperand(this.sum)))), ExpressionBuilder.plus(this.count, this.mergeOperand(this.count))};
    }

    @Override
    public Expression getValueExpression() {
        return ExpressionBuilder.ifThenElse(ExpressionBuilder.equalTo(this.count, ExpressionBuilder.literal(0L)), ExpressionBuilder.nullOf(this.getResultType()), this.sum);
    }

    protected abstract Expression zeroLiteral();

    public static class DecimalIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        private DecimalType decimalType;

        public DecimalIncrSumWithRetractAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType(this.decimalType);
            return DataTypes.DECIMAL(sumType.getPrecision(), sumType.getScale());
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }

    public static class DoubleIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0.0);
        }
    }

    public static class FloatIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(Float.valueOf(0.0f));
        }
    }

    public static class LongIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0L);
        }
    }

    public static class ShortIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((short)0);
        }
    }

    public static class ByteIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal((byte)0);
        }
    }

    public static class IntIncrSumWithRetractAggFunction
    extends IncrSumWithRetractAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }

        @Override
        protected Expression zeroLiteral() {
            return ExpressionBuilder.literal(0);
        }
    }
}

