/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.calcite.rex.RexLiteral;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.planner.plan.utils.LookupJoinUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class LookupCallContext
extends AbstractSqlCallContext {
    private final Map<Integer, LookupJoinUtil.LookupKey> lookupKeys;
    private final int[] lookupKeyOrder;
    private final List<DataType> argumentDataTypes;
    private final DataType outputDataType;

    public LookupCallContext(DataTypeFactory dataTypeFactory, UserDefinedFunction function, final LogicalType inputType, Map<Integer, LookupJoinUtil.LookupKey> lookupKeys, final int[] lookupKeyOrder, LogicalType lookupType) {
        super(dataTypeFactory, function, function.functionIdentifier(), false);
        this.lookupKeys = lookupKeys;
        this.lookupKeyOrder = lookupKeyOrder;
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int index) {
                LogicalType keyType;
                LookupJoinUtil.LookupKey key = LookupCallContext.this.getKey(index);
                if (key instanceof LookupJoinUtil.ConstantLookupKey) {
                    keyType = ((LookupJoinUtil.ConstantLookupKey)key).sourceType;
                } else if (key instanceof LookupJoinUtil.FieldRefLookupKey) {
                    keyType = LogicalTypeChecks.getFieldTypes(inputType).get(((LookupJoinUtil.FieldRefLookupKey)key).index);
                } else {
                    throw new IllegalArgumentException();
                }
                return TypeConversions.fromLogicalToDataType(keyType);
            }

            @Override
            public int size() {
                return lookupKeyOrder.length;
            }
        };
        this.outputDataType = TypeConversions.fromLogicalToDataType(lookupType);
    }

    @Override
    public boolean isArgumentLiteral(int pos) {
        return this.getKey(pos) instanceof LookupJoinUtil.ConstantLookupKey;
    }

    @Override
    public boolean isArgumentNull(int pos) {
        LookupJoinUtil.ConstantLookupKey key = (LookupJoinUtil.ConstantLookupKey)this.getKey(pos);
        return key.literal.isNull();
    }

    @Override
    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        try {
            LookupJoinUtil.ConstantLookupKey key = (LookupJoinUtil.ConstantLookupKey)this.getKey(pos);
            RexLiteral literal = key.literal;
            return Optional.ofNullable(LookupCallContext.getLiteralValueAs(literal::getValueAs, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    @Override
    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    @Override
    public Optional<DataType> getOutputDataType() {
        return Optional.of(this.outputDataType);
    }

    private LookupJoinUtil.LookupKey getKey(int pos) {
        int index = this.lookupKeyOrder[pos];
        return this.lookupKeys.get(index);
    }
}

