/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.abilities.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsFilterPushDown;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.resolver.ExpressionResolver;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpecBase;
import org.apache.flink.table.planner.plan.utils.RexNodeToExpressionConverter;
import org.apache.flink.util.Preconditions;
import scala.Option;

@JsonTypeName(value="FilterPushDown")
public class FilterPushDownSpec
extends SourceAbilitySpecBase {
    public static final String FIELD_NAME_PREDICATES = "predicates";
    @JsonProperty(value="predicates")
    private final List<RexNode> predicates;

    @JsonCreator
    public FilterPushDownSpec(@JsonProperty(value="predicates") List<RexNode> predicates) {
        this.predicates = new ArrayList<RexNode>((Collection)Preconditions.checkNotNull(predicates));
    }

    @Override
    public void apply(DynamicTableSource tableSource, SourceAbilityContext context) {
        SupportsFilterPushDown.Result result = FilterPushDownSpec.apply(this.predicates, tableSource, context);
        if (result.getAcceptedFilters().size() != this.predicates.size()) {
            throw new TableException("All predicates should be accepted here.");
        }
    }

    public static SupportsFilterPushDown.Result apply(List<RexNode> predicates, DynamicTableSource tableSource, SourceAbilityContext context) {
        if (tableSource instanceof SupportsFilterPushDown) {
            RexNodeToExpressionConverter converter = new RexNodeToExpressionConverter(new RexBuilder(FlinkTypeFactory.INSTANCE()), context.getSourceRowType().getFieldNames().toArray(new String[0]), context.getFunctionCatalog(), context.getCatalogManager(), TimeZone.getTimeZone(context.getTableConfig().getLocalTimeZone()));
            List<Expression> filters = predicates.stream().map(p -> {
                Option<ResolvedExpression> expr = p.accept(converter);
                if (expr.isDefined()) {
                    return (ResolvedExpression)expr.get();
                }
                throw new TableException(String.format("%s can not be converted to Expression, please make sure %s can accept %s.", p.toString(), tableSource.getClass().getSimpleName(), p.toString()));
            }).collect(Collectors.toList());
            ExpressionResolver resolver = ExpressionResolver.resolverFor(context.getTableConfig(), name -> Optional.empty(), context.getFunctionCatalog().asLookup(str -> {
                throw new TableException("We should not need to lookup any expressions at this point");
            }), context.getCatalogManager().getDataTypeFactory(), (sqlExpression, inputRowType, outputType) -> {
                throw new TableException("SQL expression parsing is not supported at this location.");
            }, new QueryOperation[0]).build();
            return ((SupportsFilterPushDown)((Object)tableSource)).applyFilters(resolver.resolve(filters));
        }
        throw new TableException(String.format("%s does not support SupportsFilterPushDown.", tableSource.getClass().getName()));
    }
}

