/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.MultipleTransformationTranslator;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.utils.ScanUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecBoundedStreamScan
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData>,
MultipleTransformationTranslator<RowData> {
    private final DataStream<?> dataStream;
    private final DataType sourceType;
    private final int[] fieldIndexes;
    private final List<String> qualifiedName;

    public BatchExecBoundedStreamScan(DataStream<?> dataStream, DataType sourceType, int[] fieldIndexes, List<String> qualifiedName, RowType outputType, String description) {
        super(Collections.emptyList(), outputType, description);
        this.dataStream = dataStream;
        this.sourceType = sourceType;
        this.fieldIndexes = fieldIndexes;
        this.qualifiedName = qualifiedName;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        Transformation sourceTransform = this.dataStream.getTransformation();
        if (this.needInternalConversion()) {
            return ScanUtil.convertToInternalRow(new CodeGeneratorContext(planner.getTableConfig()), (Transformation<Object>)sourceTransform, this.fieldIndexes, this.sourceType, (RowType)this.getOutputType(), this.qualifiedName, JavaScalaConversionUtil.toScala(Optional.empty()), "", "");
        }
        return sourceTransform;
    }

    private boolean needInternalConversion() {
        return ScanUtil.hasTimeAttributeField(this.fieldIndexes) || ScanUtil.needsConversion(this.sourceType);
    }

    public DataStream<?> getDataStream() {
        return this.dataStream;
    }
}

