/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.utils.SortUtil;
import org.apache.flink.table.runtime.operators.sort.RankOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecRank
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    private final int[] partitionFields;
    private final int[] sortFields;
    private final long rankStart;
    private final long rankEnd;
    private final boolean outputRankNumber;

    public BatchExecRank(int[] partitionFields, int[] sortFields, long rankStart, long rankEnd, boolean outputRankNumber, InputProperty inputProperty, RowType outputType, String description) {
        super(Collections.singletonList(inputProperty), outputType, description);
        this.partitionFields = partitionFields;
        this.sortFields = sortFields;
        this.rankStart = rankStart;
        this.rankEnd = rankEnd;
        this.outputRankNumber = outputRankNumber;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputType = (RowType)inputEdge.getOutputType();
        RankOperator operator = new RankOperator(ComparatorCodeGenerator.gen(planner.getTableConfig(), "PartitionByComparator", inputType, SortUtil.getAscendingSortSpec(this.partitionFields)), ComparatorCodeGenerator.gen(planner.getTableConfig(), "OrderByComparator", inputType, SortUtil.getAscendingSortSpec(this.sortFields)), this.rankStart, this.rankEnd, this.outputRankNumber);
        return new OneInputTransformation(inputTransform, this.getDescription(), (StreamOperatorFactory)SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((RowType)this.getOutputType()), inputTransform.getParallelism());
    }
}

