/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.sort.SortOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecSort
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    private final SortSpec sortSpec;

    public BatchExecSort(SortSpec sortSpec, InputProperty inputProperty, RowType outputType, String description) {
        super(Collections.singletonList(inputProperty), outputType, description);
        this.sortSpec = sortSpec;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        TableConfig config = planner.getTableConfig();
        RowType inputType = (RowType)inputEdge.getOutputType();
        SortCodeGenerator codeGen = new SortCodeGenerator(config, inputType, this.sortSpec);
        SortOperator operator = new SortOperator(codeGen.generateNormalizedKeyComputer("BatchExecSortComputer"), codeGen.generateRecordComparator("BatchExecSortComparator"));
        long sortMemory = ((MemorySize)config.getConfiguration().get(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_SORT_MEMORY)).getBytes();
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.getDescription(), SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((RowType)this.getOutputType()), inputTransform.getParallelism(), sortMemory);
    }
}

