/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.common;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.CorrelateCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.SingleTransformationTranslator;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.join.FlinkJoinType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class CommonExecCorrelate
extends ExecNodeBase<RowData>
implements SingleTransformationTranslator<RowData> {
    public static final String FIELD_NAME_JOIN_TYPE = "joinType";
    public static final String FIELD_NAME_FUNCTION_CALL = "functionCall";
    public static final String FIELD_NAME_CONDITION = "condition";
    @JsonProperty(value="joinType")
    private final FlinkJoinType joinType;
    @JsonProperty(value="functionCall")
    private final RexCall invocation;
    @JsonProperty(value="condition")
    @Nullable
    private final RexNode condition;
    @JsonIgnore
    private final Class<?> operatorBaseClass;
    @JsonIgnore
    private final boolean retainHeader;

    public CommonExecCorrelate(FlinkJoinType joinType, RexCall invocation, @Nullable RexNode condition, Class<?> operatorBaseClass, boolean retainHeader, int id, List<InputProperty> inputProperties, RowType outputType, String description) {
        super(id, inputProperties, outputType, description);
        Preconditions.checkArgument((inputProperties.size() == 1 ? 1 : 0) != 0);
        this.joinType = (FlinkJoinType)((Object)Preconditions.checkNotNull((Object)((Object)joinType)));
        this.invocation = (RexCall)Preconditions.checkNotNull((Object)invocation);
        this.condition = condition;
        this.operatorBaseClass = (Class)Preconditions.checkNotNull(operatorBaseClass);
        this.retainHeader = retainHeader;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        CodeGeneratorContext ctx = new CodeGeneratorContext(planner.getTableConfig()).setOperatorBaseClass(this.operatorBaseClass);
        return CorrelateCodeGenerator.generateCorrelateTransformation(planner.getTableConfig(), ctx, inputTransform, (RowType)inputEdge.getOutputType(), this.invocation, JavaScalaConversionUtil.toScala(Optional.ofNullable(this.condition)), (RowType)this.getOutputType(), this.joinType, inputTransform.getParallelism(), this.retainHeader, this.getClass().getSimpleName(), this.getDescription());
    }
}

