/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlAggFunction;
import org.apache.flink.table.planner.functions.utils.AggSqlFunction;
import org.apache.flink.table.utils.EncodingUtils;

public class AggregateCallJsonSerializer
extends StdSerializer<AggregateCall> {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_KIND = "kind";
    public static final String FIELD_NAME_TYPE = "type";
    public static final String FIELD_NAME_NAME = "name";
    public static final String FIELD_NAME_AGG_FUNCTION = "aggFunction";
    public static final String FIELD_NAME_INSTANCE = "instance";
    public static final String FIELD_NAME_SYNTAX = "syntax";
    public static final String FIELD_NAME_DISPLAY_NAME = "displayName";
    public static final String FIELD_NAME_FUNCTION_KIND = "functionKind";
    public static final String FIELD_NAME_BRIDGING = "bridging";
    public static final String FIELD_NAME_BUILT_IN = "builtIn";
    public static final String FIELD_NAME_REQUIRES_OVER = "requiresOver";
    public static final String FIELD_NAME_ARG_LIST = "argList";
    public static final String FIELD_NAME_FILTER_ARG = "filterArg";
    public static final String FIELD_NAME_DISTINCT = "distinct";
    public static final String FIELD_NAME_APPROXIMATE = "approximate";
    public static final String FIELD_NAME_IGNORE_NULLS = "ignoreNulls";

    public AggregateCallJsonSerializer() {
        super(AggregateCall.class);
    }

    public void serialize(AggregateCall aggCall, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(FIELD_NAME_NAME, aggCall.getName());
        this.serialize(aggCall.getAggregation(), jsonGenerator);
        jsonGenerator.writeFieldName(FIELD_NAME_ARG_LIST);
        jsonGenerator.writeStartArray();
        for (int arg : aggCall.getArgList()) {
            jsonGenerator.writeNumber(arg);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeNumberField(FIELD_NAME_FILTER_ARG, aggCall.filterArg);
        jsonGenerator.writeBooleanField(FIELD_NAME_DISTINCT, aggCall.isDistinct());
        jsonGenerator.writeBooleanField(FIELD_NAME_APPROXIMATE, aggCall.isApproximate());
        jsonGenerator.writeBooleanField(FIELD_NAME_IGNORE_NULLS, aggCall.ignoreNulls());
        jsonGenerator.writeObjectField(FIELD_NAME_TYPE, (Object)aggCall.getType());
        jsonGenerator.writeEndObject();
    }

    private void serialize(SqlAggFunction operator, JsonGenerator gen) throws IOException {
        gen.writeFieldName(FIELD_NAME_AGG_FUNCTION);
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_NAME, operator.getName());
        gen.writeStringField(FIELD_NAME_KIND, operator.kind.name());
        gen.writeStringField(FIELD_NAME_SYNTAX, operator.getSyntax().name());
        if (operator instanceof AggSqlFunction) {
            AggSqlFunction aggSqlFunc = (AggSqlFunction)operator;
            gen.writeStringField(FIELD_NAME_DISPLAY_NAME, aggSqlFunc.displayName());
            gen.writeStringField(FIELD_NAME_FUNCTION_KIND, FunctionKind.AGGREGATE.name());
            gen.writeBooleanField(FIELD_NAME_REQUIRES_OVER, aggSqlFunc.requiresOver());
            gen.writeStringField(FIELD_NAME_INSTANCE, EncodingUtils.encodeObjectToString(aggSqlFunc.aggregateFunction()));
        } else if (operator instanceof BridgingSqlAggFunction) {
            BridgingSqlAggFunction bridgingSqlAggFunc = (BridgingSqlAggFunction)operator;
            FunctionDefinition functionDefinition = bridgingSqlAggFunc.getDefinition();
            if (functionDefinition instanceof BuiltInFunctionDefinition) {
                gen.writeBooleanField(FIELD_NAME_BUILT_IN, true);
            } else {
                assert (functionDefinition.getKind() == FunctionKind.AGGREGATE);
                gen.writeStringField(FIELD_NAME_FUNCTION_KIND, FunctionKind.AGGREGATE.name());
                gen.writeStringField(FIELD_NAME_INSTANCE, EncodingUtils.encodeObjectToString(functionDefinition));
                gen.writeBooleanField(FIELD_NAME_BRIDGING, true);
            }
        }
        gen.writeEndObject();
    }
}

