/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.runtime.FlatLists;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Sarg;
import org.apache.flink.calcite.shaded.com.google.common.collect.Range;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.utils.ScalarSqlFunction;
import org.apache.flink.table.utils.EncodingUtils;

public class RexNodeJsonSerializer
extends StdSerializer<RexNode> {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_KIND = "kind";
    public static final String FIELD_NAME_VALUE = "value";
    public static final String FIELD_NAME_TYPE = "type";
    public static final String FIELD_NAME_NAME = "name";
    public static final String FIELD_NAME_INPUT_INDEX = "inputIndex";
    public static final String FIELD_NAME_ALPHA = "alpha";
    public static final String FIELD_NAME_CLASS = "class";
    public static final String FIELD_NAME_EXPR = "expr";
    public static final String FIELD_NAME_CORREL = "correl";
    public static final String FIELD_NAME_OPERATOR = "operator";
    public static final String FIELD_NAME_OPERANDS = "operands";
    public static final String FIELD_NAME_SYNTAX = "syntax";
    public static final String FIELD_NAME_DISPLAY_NAME = "displayName";
    public static final String FIELD_NAME_FUNCTION_KIND = "functionKind";
    public static final String FIELD_NAME_INSTANCE = "instance";
    public static final String FIELD_NAME_BRIDGING = "bridging";
    public static final String FIELD_NAME_BUILT_IN = "builtIn";
    public static final String FIELD_NAME_SARG = "sarg";
    public static final String FIELD_NAME_RANGES = "ranges";
    public static final String FIELD_NAME_BOUND_LOWER = "lower";
    public static final String FIELD_NAME_BOUND_UPPER = "upper";
    public static final String FIELD_NAME_BOUND_TYPE = "boundType";
    public static final String FIELD_NAME_CONTAINS_NULL = "containsNull";
    public static final String SQL_KIND_PATTERN_INPUT_REF = "PATTERN_INPUT_REF";
    public static final String SQL_KIND_INPUT_REF = "INPUT_REF";
    public static final String SQL_KIND_LITERAL = "LITERAL";
    public static final String SQL_KIND_FIELD_ACCESS = "FIELD_ACCESS";
    public static final String SQL_KIND_CORREL_VARIABLE = "CORREL_VARIABLE";
    public static final String SQL_KIND_REX_CALL = "REX_CALL";

    public RexNodeJsonSerializer() {
        super(RexNode.class);
    }

    public void serialize(RexNode rexNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        switch (rexNode.getKind()) {
            case INPUT_REF: 
            case TABLE_INPUT_REF: {
                this.serialize((RexInputRef)rexNode, jsonGenerator);
                break;
            }
            case LITERAL: {
                this.serialize((RexLiteral)rexNode, jsonGenerator);
                break;
            }
            case FIELD_ACCESS: {
                this.serialize((RexFieldAccess)rexNode, jsonGenerator);
                break;
            }
            case CORREL_VARIABLE: {
                this.serialize((RexCorrelVariable)rexNode, jsonGenerator);
                break;
            }
            case PATTERN_INPUT_REF: {
                this.serialize((RexPatternFieldRef)rexNode, jsonGenerator);
                break;
            }
            default: {
                if (rexNode instanceof RexCall) {
                    this.serialize((RexCall)rexNode, jsonGenerator);
                    break;
                }
                throw new TableException("Unknown RexNode: " + rexNode);
            }
        }
    }

    private void serialize(RexPatternFieldRef inputRef, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, SQL_KIND_PATTERN_INPUT_REF);
        gen.writeStringField(FIELD_NAME_ALPHA, inputRef.getAlpha());
        gen.writeNumberField(FIELD_NAME_INPUT_INDEX, inputRef.getIndex());
        gen.writeObjectField(FIELD_NAME_TYPE, (Object)inputRef.getType());
        gen.writeEndObject();
    }

    private void serialize(RexInputRef inputRef, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, SQL_KIND_INPUT_REF);
        gen.writeNumberField(FIELD_NAME_INPUT_INDEX, inputRef.getIndex());
        gen.writeObjectField(FIELD_NAME_TYPE, (Object)inputRef.getType());
        gen.writeEndObject();
    }

    private void serialize(RexLiteral literal, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, SQL_KIND_LITERAL);
        Comparable value = literal.getValueAs(Comparable.class);
        this.serialize(value, literal.getTypeName(), literal.getType().getSqlTypeName(), gen);
        gen.writeObjectField(FIELD_NAME_TYPE, (Object)literal.getType());
        gen.writeEndObject();
    }

    private void serialize(Comparable<?> value, SqlTypeName literalTypeName, SqlTypeName elementTypeName, JsonGenerator gen) throws IOException {
        if (value == null) {
            gen.writeNullField(FIELD_NAME_VALUE);
            return;
        }
        switch (literalTypeName) {
            case BOOLEAN: {
                gen.writeBooleanField(FIELD_NAME_VALUE, ((Boolean)value).booleanValue());
                break;
            }
            case TINYINT: {
                gen.writeNumberField(FIELD_NAME_VALUE, (short)((BigDecimal)value).byteValue());
                break;
            }
            case SMALLINT: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).shortValue());
                break;
            }
            case INTEGER: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).intValue());
                break;
            }
            case BIGINT: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).longValue());
                break;
            }
            case DOUBLE: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).doubleValue());
                break;
            }
            case FLOAT: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).floatValue());
                break;
            }
            case DECIMAL: 
            case REAL: {
                gen.writeStringField(FIELD_NAME_VALUE, value.toString());
                break;
            }
            case BINARY: 
            case VARBINARY: {
                gen.writeStringField(FIELD_NAME_VALUE, ((ByteString)value).toBase64String());
                break;
            }
            case CHAR: 
            case VARCHAR: {
                gen.writeStringField(FIELD_NAME_VALUE, ((NlsString)value).getValue());
                break;
            }
            case DATE: 
            case TIME: 
            case TIME_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                gen.writeStringField(FIELD_NAME_VALUE, value.toString());
                break;
            }
            case INTERVAL_YEAR: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_MONTH: 
            case INTERVAL_DAY: 
            case INTERVAL_DAY_HOUR: 
            case INTERVAL_DAY_MINUTE: 
            case INTERVAL_DAY_SECOND: 
            case INTERVAL_HOUR: 
            case INTERVAL_HOUR_MINUTE: 
            case INTERVAL_HOUR_SECOND: 
            case INTERVAL_MINUTE: 
            case INTERVAL_MINUTE_SECOND: 
            case INTERVAL_SECOND: {
                gen.writeNumberField(FIELD_NAME_VALUE, ((BigDecimal)value).longValue());
                break;
            }
            case SYMBOL: {
                gen.writeStringField(FIELD_NAME_VALUE, ((Enum)((Object)value)).name());
                gen.writeStringField(FIELD_NAME_CLASS, value.getClass().getName());
                break;
            }
            case SARG: {
                this.serialize((Sarg)value, elementTypeName, gen);
                break;
            }
            case ROW: 
            case MULTISET: {
                gen.writeFieldName(FIELD_NAME_VALUE);
                gen.writeStartArray();
                for (RexLiteral v : (FlatLists.ComparableList)value) {
                    this.serialize(v, gen);
                }
                gen.writeEndArray();
                break;
            }
            default: {
                throw new TableException("Unknown value: " + value + ", type: " + (Object)((Object)literalTypeName));
            }
        }
    }

    private void serialize(Sarg<?> value, SqlTypeName sqlTypeName, JsonGenerator gen) throws IOException {
        gen.writeFieldName(FIELD_NAME_SARG);
        gen.writeStartObject();
        gen.writeFieldName(FIELD_NAME_RANGES);
        gen.writeStartArray();
        for (Range range : value.rangeSet.asRanges()) {
            gen.writeStartObject();
            if (range.hasLowerBound()) {
                gen.writeFieldName(FIELD_NAME_BOUND_LOWER);
                gen.writeStartObject();
                this.serialize((Comparable<?>)range.lowerEndpoint(), sqlTypeName, sqlTypeName, gen);
                gen.writeStringField(FIELD_NAME_BOUND_TYPE, range.lowerBoundType().name());
                gen.writeEndObject();
            }
            if (range.hasUpperBound()) {
                gen.writeFieldName(FIELD_NAME_BOUND_UPPER);
                gen.writeStartObject();
                this.serialize((Comparable<?>)range.upperEndpoint(), sqlTypeName, sqlTypeName, gen);
                gen.writeStringField(FIELD_NAME_BOUND_TYPE, range.upperBoundType().name());
                gen.writeEndObject();
            }
            gen.writeEndObject();
        }
        gen.writeEndArray();
        gen.writeBooleanField(FIELD_NAME_CONTAINS_NULL, value.containsNull);
        gen.writeEndObject();
    }

    private void serialize(RexFieldAccess fieldAccess, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, SQL_KIND_FIELD_ACCESS);
        gen.writeStringField(FIELD_NAME_NAME, fieldAccess.getField().getName());
        gen.writeObjectField(FIELD_NAME_EXPR, (Object)fieldAccess.getReferenceExpr());
        gen.writeEndObject();
    }

    private void serialize(RexCorrelVariable variable, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, SQL_KIND_CORREL_VARIABLE);
        gen.writeStringField(FIELD_NAME_CORREL, variable.getName());
        gen.writeObjectField(FIELD_NAME_TYPE, (Object)variable.getType());
        gen.writeEndObject();
    }

    private void serialize(RexCall call, JsonGenerator gen) throws IOException {
        if (!call.getClass().isAssignableFrom(RexCall.class)) {
            throw new TableException("Unknown RexCall: " + call);
        }
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_KIND, SQL_KIND_REX_CALL);
        this.serialize(call.getOperator(), gen);
        gen.writeFieldName(FIELD_NAME_OPERANDS);
        gen.writeStartArray();
        for (RexNode operand : call.getOperands()) {
            gen.writeObject((Object)operand);
        }
        gen.writeEndArray();
        gen.writeObjectField(FIELD_NAME_TYPE, (Object)call.getType());
        gen.writeEndObject();
    }

    private void serialize(SqlOperator operator, JsonGenerator gen) throws IOException {
        gen.writeFieldName(FIELD_NAME_OPERATOR);
        gen.writeStartObject();
        gen.writeStringField(FIELD_NAME_NAME, operator.getName());
        gen.writeStringField(FIELD_NAME_KIND, operator.kind.name());
        gen.writeStringField(FIELD_NAME_SYNTAX, operator.getSyntax().name());
        if (operator instanceof ScalarSqlFunction) {
            ScalarSqlFunction scalarSqlFunc = (ScalarSqlFunction)operator;
            gen.writeStringField(FIELD_NAME_DISPLAY_NAME, scalarSqlFunc.displayName());
            gen.writeStringField(FIELD_NAME_FUNCTION_KIND, FunctionKind.SCALAR.name());
            gen.writeStringField(FIELD_NAME_INSTANCE, EncodingUtils.encodeObjectToString(scalarSqlFunc.scalarFunction()));
        } else if (operator instanceof BridgingSqlFunction) {
            BridgingSqlFunction bridgingSqlFunc = (BridgingSqlFunction)operator;
            FunctionDefinition functionDefinition = bridgingSqlFunc.getDefinition();
            if (functionDefinition instanceof BuiltInFunctionDefinition) {
                gen.writeBooleanField(FIELD_NAME_BUILT_IN, true);
            } else {
                gen.writeStringField(FIELD_NAME_FUNCTION_KIND, functionDefinition.getKind().name());
                gen.writeStringField(FIELD_NAME_INSTANCE, EncodingUtils.encodeObjectToString(functionDefinition));
                gen.writeBooleanField(FIELD_NAME_BRIDGING, true);
            }
        }
        gen.writeEndObject();
    }
}

